/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.odb.model.AcceptMarketplaceRegistrationRequest;
import software.amazon.awssdk.services.odb.model.AcceptMarketplaceRegistrationResponse;
import software.amazon.awssdk.services.odb.model.CreateCloudAutonomousVmClusterRequest;
import software.amazon.awssdk.services.odb.model.CreateCloudAutonomousVmClusterResponse;
import software.amazon.awssdk.services.odb.model.CreateCloudExadataInfrastructureRequest;
import software.amazon.awssdk.services.odb.model.CreateCloudExadataInfrastructureResponse;
import software.amazon.awssdk.services.odb.model.CreateCloudVmClusterRequest;
import software.amazon.awssdk.services.odb.model.CreateCloudVmClusterResponse;
import software.amazon.awssdk.services.odb.model.CreateOdbNetworkRequest;
import software.amazon.awssdk.services.odb.model.CreateOdbNetworkResponse;
import software.amazon.awssdk.services.odb.model.CreateOdbPeeringConnectionRequest;
import software.amazon.awssdk.services.odb.model.CreateOdbPeeringConnectionResponse;
import software.amazon.awssdk.services.odb.model.DeleteCloudAutonomousVmClusterRequest;
import software.amazon.awssdk.services.odb.model.DeleteCloudAutonomousVmClusterResponse;
import software.amazon.awssdk.services.odb.model.DeleteCloudExadataInfrastructureRequest;
import software.amazon.awssdk.services.odb.model.DeleteCloudExadataInfrastructureResponse;
import software.amazon.awssdk.services.odb.model.DeleteCloudVmClusterRequest;
import software.amazon.awssdk.services.odb.model.DeleteCloudVmClusterResponse;
import software.amazon.awssdk.services.odb.model.DeleteOdbNetworkRequest;
import software.amazon.awssdk.services.odb.model.DeleteOdbNetworkResponse;
import software.amazon.awssdk.services.odb.model.DeleteOdbPeeringConnectionRequest;
import software.amazon.awssdk.services.odb.model.DeleteOdbPeeringConnectionResponse;
import software.amazon.awssdk.services.odb.model.GetCloudAutonomousVmClusterRequest;
import software.amazon.awssdk.services.odb.model.GetCloudAutonomousVmClusterResponse;
import software.amazon.awssdk.services.odb.model.GetCloudExadataInfrastructureRequest;
import software.amazon.awssdk.services.odb.model.GetCloudExadataInfrastructureResponse;
import software.amazon.awssdk.services.odb.model.GetCloudExadataInfrastructureUnallocatedResourcesRequest;
import software.amazon.awssdk.services.odb.model.GetCloudExadataInfrastructureUnallocatedResourcesResponse;
import software.amazon.awssdk.services.odb.model.GetCloudVmClusterRequest;
import software.amazon.awssdk.services.odb.model.GetCloudVmClusterResponse;
import software.amazon.awssdk.services.odb.model.GetDbNodeRequest;
import software.amazon.awssdk.services.odb.model.GetDbNodeResponse;
import software.amazon.awssdk.services.odb.model.GetDbServerRequest;
import software.amazon.awssdk.services.odb.model.GetDbServerResponse;
import software.amazon.awssdk.services.odb.model.GetOciOnboardingStatusRequest;
import software.amazon.awssdk.services.odb.model.GetOciOnboardingStatusResponse;
import software.amazon.awssdk.services.odb.model.GetOdbNetworkRequest;
import software.amazon.awssdk.services.odb.model.GetOdbNetworkResponse;
import software.amazon.awssdk.services.odb.model.GetOdbPeeringConnectionRequest;
import software.amazon.awssdk.services.odb.model.GetOdbPeeringConnectionResponse;
import software.amazon.awssdk.services.odb.model.InitializeServiceRequest;
import software.amazon.awssdk.services.odb.model.InitializeServiceResponse;
import software.amazon.awssdk.services.odb.model.ListAutonomousVirtualMachinesRequest;
import software.amazon.awssdk.services.odb.model.ListAutonomousVirtualMachinesResponse;
import software.amazon.awssdk.services.odb.model.ListCloudAutonomousVmClustersRequest;
import software.amazon.awssdk.services.odb.model.ListCloudAutonomousVmClustersResponse;
import software.amazon.awssdk.services.odb.model.ListCloudExadataInfrastructuresRequest;
import software.amazon.awssdk.services.odb.model.ListCloudExadataInfrastructuresResponse;
import software.amazon.awssdk.services.odb.model.ListCloudVmClustersRequest;
import software.amazon.awssdk.services.odb.model.ListCloudVmClustersResponse;
import software.amazon.awssdk.services.odb.model.ListDbNodesRequest;
import software.amazon.awssdk.services.odb.model.ListDbNodesResponse;
import software.amazon.awssdk.services.odb.model.ListDbServersRequest;
import software.amazon.awssdk.services.odb.model.ListDbServersResponse;
import software.amazon.awssdk.services.odb.model.ListDbSystemShapesRequest;
import software.amazon.awssdk.services.odb.model.ListDbSystemShapesResponse;
import software.amazon.awssdk.services.odb.model.ListGiVersionsRequest;
import software.amazon.awssdk.services.odb.model.ListGiVersionsResponse;
import software.amazon.awssdk.services.odb.model.ListOdbNetworksRequest;
import software.amazon.awssdk.services.odb.model.ListOdbNetworksResponse;
import software.amazon.awssdk.services.odb.model.ListOdbPeeringConnectionsRequest;
import software.amazon.awssdk.services.odb.model.ListOdbPeeringConnectionsResponse;
import software.amazon.awssdk.services.odb.model.ListSystemVersionsRequest;
import software.amazon.awssdk.services.odb.model.ListSystemVersionsResponse;
import software.amazon.awssdk.services.odb.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.odb.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.odb.model.RebootDbNodeRequest;
import software.amazon.awssdk.services.odb.model.RebootDbNodeResponse;
import software.amazon.awssdk.services.odb.model.StartDbNodeRequest;
import software.amazon.awssdk.services.odb.model.StartDbNodeResponse;
import software.amazon.awssdk.services.odb.model.StopDbNodeRequest;
import software.amazon.awssdk.services.odb.model.StopDbNodeResponse;
import software.amazon.awssdk.services.odb.model.TagResourceRequest;
import software.amazon.awssdk.services.odb.model.TagResourceResponse;
import software.amazon.awssdk.services.odb.model.UntagResourceRequest;
import software.amazon.awssdk.services.odb.model.UntagResourceResponse;
import software.amazon.awssdk.services.odb.model.UpdateCloudExadataInfrastructureRequest;
import software.amazon.awssdk.services.odb.model.UpdateCloudExadataInfrastructureResponse;
import software.amazon.awssdk.services.odb.model.UpdateOdbNetworkRequest;
import software.amazon.awssdk.services.odb.model.UpdateOdbNetworkResponse;
import software.amazon.awssdk.services.odb.model.UpdateOdbPeeringConnectionRequest;
import software.amazon.awssdk.services.odb.model.UpdateOdbPeeringConnectionResponse;
import software.amazon.awssdk.services.odb.paginators.ListAutonomousVirtualMachinesPublisher;
import software.amazon.awssdk.services.odb.paginators.ListCloudAutonomousVmClustersPublisher;
import software.amazon.awssdk.services.odb.paginators.ListCloudExadataInfrastructuresPublisher;
import software.amazon.awssdk.services.odb.paginators.ListCloudVmClustersPublisher;
import software.amazon.awssdk.services.odb.paginators.ListDbNodesPublisher;
import software.amazon.awssdk.services.odb.paginators.ListDbServersPublisher;
import software.amazon.awssdk.services.odb.paginators.ListDbSystemShapesPublisher;
import software.amazon.awssdk.services.odb.paginators.ListGiVersionsPublisher;
import software.amazon.awssdk.services.odb.paginators.ListOdbNetworksPublisher;
import software.amazon.awssdk.services.odb.paginators.ListOdbPeeringConnectionsPublisher;
import software.amazon.awssdk.services.odb.paginators.ListSystemVersionsPublisher;

/**
 * Service client for accessing odb asynchronously. This can be created using the static {@link #builder()} method.The
 * asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient} supported in the
 * SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in some cases such
 * as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * Oracle Database@Amazon Web Services is an offering that enables you to access Oracle Exadata infrastructure managed
 * by Oracle Cloud Infrastructure (OCI) inside Amazon Web Services data centers. You can migrate your Oracle Exadata
 * workloads, establish low-latency connectivity with applications running on Amazon Web Services, and integrate with
 * Amazon Web Services services. For example, you can run application servers in a Virtual Private Cloud (VPC) and
 * access an Oracle Exadata system running in Oracle Database@Amazon Web Services. You can get started with Oracle
 * Database@Amazon Web Services by using the familiar Amazon Web Services Management Console, APIs, or CLI.
 * </p>
 * <p>
 * This interface reference for Oracle Database@Amazon Web Services contains documentation for a programming or command
 * line interface that you can use to manage Oracle Database@Amazon Web Services. Oracle Database@Amazon Web Services is
 * asynchronous, which means that some interfaces might require techniques such as polling or callback functions to
 * determine when a command has been applied. The reference structure is as follows.
 * </p>
 * <p>
 * <b>Oracle Database@Amazon Web Services API Reference</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * For the alphabetical list of API actions, see <a
 * href="https://docs.aws.amazon.com/odb/latest/APIReference/API_Operations.html">API Actions</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * For the alphabetical list of data types, see <a
 * href="https://docs.aws.amazon.com/odb/latest/APIReference/API_Types.html">Data Types</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * For a list of common query parameters, see <a
 * href="https://docs.aws.amazon.com/odb/latest/APIReference/CommonParameters.html">Common Parameters</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * For descriptions of the error codes, see <a
 * href="https://docs.aws.amazon.com/odb/latest/APIReference/CommonErrors.html">Common Errors</a>.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface OdbAsyncClient extends AwsClient {
    String SERVICE_NAME = "odb";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "odb";

    /**
     * <p>
     * Registers the Amazon Web Services Marketplace token for your Amazon Web Services account to activate your Oracle
     * Database@Amazon Web Services subscription.
     * </p>
     *
     * @param acceptMarketplaceRegistrationRequest
     * @return A Java Future containing the result of the AcceptMarketplaceRegistration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.AcceptMarketplaceRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/AcceptMarketplaceRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptMarketplaceRegistrationResponse> acceptMarketplaceRegistration(
            AcceptMarketplaceRegistrationRequest acceptMarketplaceRegistrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers the Amazon Web Services Marketplace token for your Amazon Web Services account to activate your Oracle
     * Database@Amazon Web Services subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptMarketplaceRegistrationRequest.Builder}
     * avoiding the need to create one manually via {@link AcceptMarketplaceRegistrationRequest#builder()}
     * </p>
     *
     * @param acceptMarketplaceRegistrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.AcceptMarketplaceRegistrationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AcceptMarketplaceRegistration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.AcceptMarketplaceRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/AcceptMarketplaceRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptMarketplaceRegistrationResponse> acceptMarketplaceRegistration(
            Consumer<AcceptMarketplaceRegistrationRequest.Builder> acceptMarketplaceRegistrationRequest) {
        return acceptMarketplaceRegistration(AcceptMarketplaceRegistrationRequest.builder()
                .applyMutation(acceptMarketplaceRegistrationRequest).build());
    }

    /**
     * <p>
     * Creates a new Autonomous VM cluster in the specified Exadata infrastructure.
     * </p>
     *
     * @param createCloudAutonomousVmClusterRequest
     * @return A Java Future containing the result of the CreateCloudAutonomousVmCluster operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the service quota.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.CreateCloudAutonomousVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/CreateCloudAutonomousVmCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCloudAutonomousVmClusterResponse> createCloudAutonomousVmCluster(
            CreateCloudAutonomousVmClusterRequest createCloudAutonomousVmClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Autonomous VM cluster in the specified Exadata infrastructure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCloudAutonomousVmClusterRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCloudAutonomousVmClusterRequest#builder()}
     * </p>
     *
     * @param createCloudAutonomousVmClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.CreateCloudAutonomousVmClusterRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateCloudAutonomousVmCluster operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the service quota.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.CreateCloudAutonomousVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/CreateCloudAutonomousVmCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCloudAutonomousVmClusterResponse> createCloudAutonomousVmCluster(
            Consumer<CreateCloudAutonomousVmClusterRequest.Builder> createCloudAutonomousVmClusterRequest) {
        return createCloudAutonomousVmCluster(CreateCloudAutonomousVmClusterRequest.builder()
                .applyMutation(createCloudAutonomousVmClusterRequest).build());
    }

    /**
     * <p>
     * Creates an Exadata infrastructure.
     * </p>
     *
     * @param createCloudExadataInfrastructureRequest
     * @return A Java Future containing the result of the CreateCloudExadataInfrastructure operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the service quota.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.CreateCloudExadataInfrastructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/CreateCloudExadataInfrastructure"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCloudExadataInfrastructureResponse> createCloudExadataInfrastructure(
            CreateCloudExadataInfrastructureRequest createCloudExadataInfrastructureRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Exadata infrastructure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCloudExadataInfrastructureRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCloudExadataInfrastructureRequest#builder()}
     * </p>
     *
     * @param createCloudExadataInfrastructureRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.CreateCloudExadataInfrastructureRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateCloudExadataInfrastructure operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the service quota.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.CreateCloudExadataInfrastructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/CreateCloudExadataInfrastructure"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCloudExadataInfrastructureResponse> createCloudExadataInfrastructure(
            Consumer<CreateCloudExadataInfrastructureRequest.Builder> createCloudExadataInfrastructureRequest) {
        return createCloudExadataInfrastructure(CreateCloudExadataInfrastructureRequest.builder()
                .applyMutation(createCloudExadataInfrastructureRequest).build());
    }

    /**
     * <p>
     * Creates a VM cluster on the specified Exadata infrastructure.
     * </p>
     *
     * @param createCloudVmClusterRequest
     * @return A Java Future containing the result of the CreateCloudVmCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the service quota.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.CreateCloudVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/CreateCloudVmCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateCloudVmClusterResponse> createCloudVmCluster(
            CreateCloudVmClusterRequest createCloudVmClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a VM cluster on the specified Exadata infrastructure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCloudVmClusterRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCloudVmClusterRequest#builder()}
     * </p>
     *
     * @param createCloudVmClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.CreateCloudVmClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateCloudVmCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the service quota.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.CreateCloudVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/CreateCloudVmCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateCloudVmClusterResponse> createCloudVmCluster(
            Consumer<CreateCloudVmClusterRequest.Builder> createCloudVmClusterRequest) {
        return createCloudVmCluster(CreateCloudVmClusterRequest.builder().applyMutation(createCloudVmClusterRequest).build());
    }

    /**
     * <p>
     * Creates an ODB network.
     * </p>
     *
     * @param createOdbNetworkRequest
     * @return A Java Future containing the result of the CreateOdbNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the service quota.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.CreateOdbNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/CreateOdbNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateOdbNetworkResponse> createOdbNetwork(CreateOdbNetworkRequest createOdbNetworkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an ODB network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOdbNetworkRequest.Builder} avoiding the need
     * to create one manually via {@link CreateOdbNetworkRequest#builder()}
     * </p>
     *
     * @param createOdbNetworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.CreateOdbNetworkRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateOdbNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the service quota.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.CreateOdbNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/CreateOdbNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateOdbNetworkResponse> createOdbNetwork(
            Consumer<CreateOdbNetworkRequest.Builder> createOdbNetworkRequest) {
        return createOdbNetwork(CreateOdbNetworkRequest.builder().applyMutation(createOdbNetworkRequest).build());
    }

    /**
     * <p>
     * Creates a peering connection between an ODB network and a VPC.
     * </p>
     * <p>
     * A peering connection enables private connectivity between the networks for application-tier communication.
     * </p>
     *
     * @param createOdbPeeringConnectionRequest
     * @return A Java Future containing the result of the CreateOdbPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.CreateOdbPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/CreateOdbPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateOdbPeeringConnectionResponse> createOdbPeeringConnection(
            CreateOdbPeeringConnectionRequest createOdbPeeringConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a peering connection between an ODB network and a VPC.
     * </p>
     * <p>
     * A peering connection enables private connectivity between the networks for application-tier communication.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOdbPeeringConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateOdbPeeringConnectionRequest#builder()}
     * </p>
     *
     * @param createOdbPeeringConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.CreateOdbPeeringConnectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateOdbPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.CreateOdbPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/CreateOdbPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateOdbPeeringConnectionResponse> createOdbPeeringConnection(
            Consumer<CreateOdbPeeringConnectionRequest.Builder> createOdbPeeringConnectionRequest) {
        return createOdbPeeringConnection(CreateOdbPeeringConnectionRequest.builder()
                .applyMutation(createOdbPeeringConnectionRequest).build());
    }

    /**
     * <p>
     * Deletes an Autonomous VM cluster.
     * </p>
     *
     * @param deleteCloudAutonomousVmClusterRequest
     * @return A Java Future containing the result of the DeleteCloudAutonomousVmCluster operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.DeleteCloudAutonomousVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DeleteCloudAutonomousVmCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCloudAutonomousVmClusterResponse> deleteCloudAutonomousVmCluster(
            DeleteCloudAutonomousVmClusterRequest deleteCloudAutonomousVmClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Autonomous VM cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCloudAutonomousVmClusterRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCloudAutonomousVmClusterRequest#builder()}
     * </p>
     *
     * @param deleteCloudAutonomousVmClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.DeleteCloudAutonomousVmClusterRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteCloudAutonomousVmCluster operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.DeleteCloudAutonomousVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DeleteCloudAutonomousVmCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCloudAutonomousVmClusterResponse> deleteCloudAutonomousVmCluster(
            Consumer<DeleteCloudAutonomousVmClusterRequest.Builder> deleteCloudAutonomousVmClusterRequest) {
        return deleteCloudAutonomousVmCluster(DeleteCloudAutonomousVmClusterRequest.builder()
                .applyMutation(deleteCloudAutonomousVmClusterRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Exadata infrastructure. Before you use this operation, make sure to delete all of the VM
     * clusters that are hosted on this Exadata infrastructure.
     * </p>
     *
     * @param deleteCloudExadataInfrastructureRequest
     * @return A Java Future containing the result of the DeleteCloudExadataInfrastructure operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.DeleteCloudExadataInfrastructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DeleteCloudExadataInfrastructure"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCloudExadataInfrastructureResponse> deleteCloudExadataInfrastructure(
            DeleteCloudExadataInfrastructureRequest deleteCloudExadataInfrastructureRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Exadata infrastructure. Before you use this operation, make sure to delete all of the VM
     * clusters that are hosted on this Exadata infrastructure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCloudExadataInfrastructureRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCloudExadataInfrastructureRequest#builder()}
     * </p>
     *
     * @param deleteCloudExadataInfrastructureRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.DeleteCloudExadataInfrastructureRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteCloudExadataInfrastructure operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.DeleteCloudExadataInfrastructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DeleteCloudExadataInfrastructure"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCloudExadataInfrastructureResponse> deleteCloudExadataInfrastructure(
            Consumer<DeleteCloudExadataInfrastructureRequest.Builder> deleteCloudExadataInfrastructureRequest) {
        return deleteCloudExadataInfrastructure(DeleteCloudExadataInfrastructureRequest.builder()
                .applyMutation(deleteCloudExadataInfrastructureRequest).build());
    }

    /**
     * <p>
     * Deletes the specified VM cluster.
     * </p>
     *
     * @param deleteCloudVmClusterRequest
     * @return A Java Future containing the result of the DeleteCloudVmCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.DeleteCloudVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DeleteCloudVmCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteCloudVmClusterResponse> deleteCloudVmCluster(
            DeleteCloudVmClusterRequest deleteCloudVmClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified VM cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCloudVmClusterRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCloudVmClusterRequest#builder()}
     * </p>
     *
     * @param deleteCloudVmClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.DeleteCloudVmClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteCloudVmCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.DeleteCloudVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DeleteCloudVmCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteCloudVmClusterResponse> deleteCloudVmCluster(
            Consumer<DeleteCloudVmClusterRequest.Builder> deleteCloudVmClusterRequest) {
        return deleteCloudVmCluster(DeleteCloudVmClusterRequest.builder().applyMutation(deleteCloudVmClusterRequest).build());
    }

    /**
     * <p>
     * Deletes the specified ODB network.
     * </p>
     *
     * @param deleteOdbNetworkRequest
     * @return A Java Future containing the result of the DeleteOdbNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.DeleteOdbNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DeleteOdbNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteOdbNetworkResponse> deleteOdbNetwork(DeleteOdbNetworkRequest deleteOdbNetworkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified ODB network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOdbNetworkRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteOdbNetworkRequest#builder()}
     * </p>
     *
     * @param deleteOdbNetworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.DeleteOdbNetworkRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteOdbNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.DeleteOdbNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DeleteOdbNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteOdbNetworkResponse> deleteOdbNetwork(
            Consumer<DeleteOdbNetworkRequest.Builder> deleteOdbNetworkRequest) {
        return deleteOdbNetwork(DeleteOdbNetworkRequest.builder().applyMutation(deleteOdbNetworkRequest).build());
    }

    /**
     * <p>
     * Deletes an ODB peering connection.
     * </p>
     * <p>
     * When you delete an ODB peering connection, the underlying VPC peering connection is also deleted.
     * </p>
     *
     * @param deleteOdbPeeringConnectionRequest
     * @return A Java Future containing the result of the DeleteOdbPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.DeleteOdbPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DeleteOdbPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOdbPeeringConnectionResponse> deleteOdbPeeringConnection(
            DeleteOdbPeeringConnectionRequest deleteOdbPeeringConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an ODB peering connection.
     * </p>
     * <p>
     * When you delete an ODB peering connection, the underlying VPC peering connection is also deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOdbPeeringConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteOdbPeeringConnectionRequest#builder()}
     * </p>
     *
     * @param deleteOdbPeeringConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.DeleteOdbPeeringConnectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteOdbPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.DeleteOdbPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DeleteOdbPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOdbPeeringConnectionResponse> deleteOdbPeeringConnection(
            Consumer<DeleteOdbPeeringConnectionRequest.Builder> deleteOdbPeeringConnectionRequest) {
        return deleteOdbPeeringConnection(DeleteOdbPeeringConnectionRequest.builder()
                .applyMutation(deleteOdbPeeringConnectionRequest).build());
    }

    /**
     * <p>
     * Gets information about a specific Autonomous VM cluster.
     * </p>
     *
     * @param getCloudAutonomousVmClusterRequest
     * @return A Java Future containing the result of the GetCloudAutonomousVmCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.GetCloudAutonomousVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetCloudAutonomousVmCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCloudAutonomousVmClusterResponse> getCloudAutonomousVmCluster(
            GetCloudAutonomousVmClusterRequest getCloudAutonomousVmClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specific Autonomous VM cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCloudAutonomousVmClusterRequest.Builder}
     * avoiding the need to create one manually via {@link GetCloudAutonomousVmClusterRequest#builder()}
     * </p>
     *
     * @param getCloudAutonomousVmClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.GetCloudAutonomousVmClusterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCloudAutonomousVmCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.GetCloudAutonomousVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetCloudAutonomousVmCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCloudAutonomousVmClusterResponse> getCloudAutonomousVmCluster(
            Consumer<GetCloudAutonomousVmClusterRequest.Builder> getCloudAutonomousVmClusterRequest) {
        return getCloudAutonomousVmCluster(GetCloudAutonomousVmClusterRequest.builder()
                .applyMutation(getCloudAutonomousVmClusterRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified Exadata infrastructure.
     * </p>
     *
     * @param getCloudExadataInfrastructureRequest
     * @return A Java Future containing the result of the GetCloudExadataInfrastructure operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.GetCloudExadataInfrastructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetCloudExadataInfrastructure"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCloudExadataInfrastructureResponse> getCloudExadataInfrastructure(
            GetCloudExadataInfrastructureRequest getCloudExadataInfrastructureRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified Exadata infrastructure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCloudExadataInfrastructureRequest.Builder}
     * avoiding the need to create one manually via {@link GetCloudExadataInfrastructureRequest#builder()}
     * </p>
     *
     * @param getCloudExadataInfrastructureRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.GetCloudExadataInfrastructureRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCloudExadataInfrastructure operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.GetCloudExadataInfrastructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetCloudExadataInfrastructure"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCloudExadataInfrastructureResponse> getCloudExadataInfrastructure(
            Consumer<GetCloudExadataInfrastructureRequest.Builder> getCloudExadataInfrastructureRequest) {
        return getCloudExadataInfrastructure(GetCloudExadataInfrastructureRequest.builder()
                .applyMutation(getCloudExadataInfrastructureRequest).build());
    }

    /**
     * <p>
     * Retrieves information about unallocated resources in a specified Cloud Exadata Infrastructure.
     * </p>
     *
     * @param getCloudExadataInfrastructureUnallocatedResourcesRequest
     * @return A Java Future containing the result of the GetCloudExadataInfrastructureUnallocatedResources operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.GetCloudExadataInfrastructureUnallocatedResources
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetCloudExadataInfrastructureUnallocatedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCloudExadataInfrastructureUnallocatedResourcesResponse> getCloudExadataInfrastructureUnallocatedResources(
            GetCloudExadataInfrastructureUnallocatedResourcesRequest getCloudExadataInfrastructureUnallocatedResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about unallocated resources in a specified Cloud Exadata Infrastructure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetCloudExadataInfrastructureUnallocatedResourcesRequest.Builder} avoiding the need to create one manually
     * via {@link GetCloudExadataInfrastructureUnallocatedResourcesRequest#builder()}
     * </p>
     *
     * @param getCloudExadataInfrastructureUnallocatedResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.GetCloudExadataInfrastructureUnallocatedResourcesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetCloudExadataInfrastructureUnallocatedResources operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.GetCloudExadataInfrastructureUnallocatedResources
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetCloudExadataInfrastructureUnallocatedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCloudExadataInfrastructureUnallocatedResourcesResponse> getCloudExadataInfrastructureUnallocatedResources(
            Consumer<GetCloudExadataInfrastructureUnallocatedResourcesRequest.Builder> getCloudExadataInfrastructureUnallocatedResourcesRequest) {
        return getCloudExadataInfrastructureUnallocatedResources(GetCloudExadataInfrastructureUnallocatedResourcesRequest
                .builder().applyMutation(getCloudExadataInfrastructureUnallocatedResourcesRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified VM cluster.
     * </p>
     *
     * @param getCloudVmClusterRequest
     * @return A Java Future containing the result of the GetCloudVmCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.GetCloudVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetCloudVmCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCloudVmClusterResponse> getCloudVmCluster(GetCloudVmClusterRequest getCloudVmClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified VM cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCloudVmClusterRequest.Builder} avoiding the need
     * to create one manually via {@link GetCloudVmClusterRequest#builder()}
     * </p>
     *
     * @param getCloudVmClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.GetCloudVmClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetCloudVmCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.GetCloudVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetCloudVmCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCloudVmClusterResponse> getCloudVmCluster(
            Consumer<GetCloudVmClusterRequest.Builder> getCloudVmClusterRequest) {
        return getCloudVmCluster(GetCloudVmClusterRequest.builder().applyMutation(getCloudVmClusterRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified DB node.
     * </p>
     *
     * @param getDbNodeRequest
     * @return A Java Future containing the result of the GetDbNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.GetDbNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetDbNode" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDbNodeResponse> getDbNode(GetDbNodeRequest getDbNodeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified DB node.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDbNodeRequest.Builder} avoiding the need to
     * create one manually via {@link GetDbNodeRequest#builder()}
     * </p>
     *
     * @param getDbNodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.GetDbNodeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDbNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.GetDbNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetDbNode" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDbNodeResponse> getDbNode(Consumer<GetDbNodeRequest.Builder> getDbNodeRequest) {
        return getDbNode(GetDbNodeRequest.builder().applyMutation(getDbNodeRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified database server.
     * </p>
     *
     * @param getDbServerRequest
     * @return A Java Future containing the result of the GetDbServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.GetDbServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetDbServer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDbServerResponse> getDbServer(GetDbServerRequest getDbServerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified database server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDbServerRequest.Builder} avoiding the need to
     * create one manually via {@link GetDbServerRequest#builder()}
     * </p>
     *
     * @param getDbServerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.GetDbServerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDbServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.GetDbServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetDbServer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDbServerResponse> getDbServer(Consumer<GetDbServerRequest.Builder> getDbServerRequest) {
        return getDbServer(GetDbServerRequest.builder().applyMutation(getDbServerRequest).build());
    }

    /**
     * <p>
     * Returns the tenancy activation link and onboarding status for your Amazon Web Services account.
     * </p>
     *
     * @param getOciOnboardingStatusRequest
     * @return A Java Future containing the result of the GetOciOnboardingStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.GetOciOnboardingStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetOciOnboardingStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetOciOnboardingStatusResponse> getOciOnboardingStatus(
            GetOciOnboardingStatusRequest getOciOnboardingStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the tenancy activation link and onboarding status for your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOciOnboardingStatusRequest.Builder} avoiding the
     * need to create one manually via {@link GetOciOnboardingStatusRequest#builder()}
     * </p>
     *
     * @param getOciOnboardingStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.GetOciOnboardingStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetOciOnboardingStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.GetOciOnboardingStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetOciOnboardingStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetOciOnboardingStatusResponse> getOciOnboardingStatus(
            Consumer<GetOciOnboardingStatusRequest.Builder> getOciOnboardingStatusRequest) {
        return getOciOnboardingStatus(GetOciOnboardingStatusRequest.builder().applyMutation(getOciOnboardingStatusRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about the specified ODB network.
     * </p>
     *
     * @param getOdbNetworkRequest
     * @return A Java Future containing the result of the GetOdbNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.GetOdbNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetOdbNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetOdbNetworkResponse> getOdbNetwork(GetOdbNetworkRequest getOdbNetworkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified ODB network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOdbNetworkRequest.Builder} avoiding the need to
     * create one manually via {@link GetOdbNetworkRequest#builder()}
     * </p>
     *
     * @param getOdbNetworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.GetOdbNetworkRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetOdbNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.GetOdbNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetOdbNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetOdbNetworkResponse> getOdbNetwork(Consumer<GetOdbNetworkRequest.Builder> getOdbNetworkRequest) {
        return getOdbNetwork(GetOdbNetworkRequest.builder().applyMutation(getOdbNetworkRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an ODB peering connection.
     * </p>
     *
     * @param getOdbPeeringConnectionRequest
     * @return A Java Future containing the result of the GetOdbPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.GetOdbPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetOdbPeeringConnection" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetOdbPeeringConnectionResponse> getOdbPeeringConnection(
            GetOdbPeeringConnectionRequest getOdbPeeringConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an ODB peering connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOdbPeeringConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link GetOdbPeeringConnectionRequest#builder()}
     * </p>
     *
     * @param getOdbPeeringConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.GetOdbPeeringConnectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetOdbPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.GetOdbPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetOdbPeeringConnection" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetOdbPeeringConnectionResponse> getOdbPeeringConnection(
            Consumer<GetOdbPeeringConnectionRequest.Builder> getOdbPeeringConnectionRequest) {
        return getOdbPeeringConnection(GetOdbPeeringConnectionRequest.builder().applyMutation(getOdbPeeringConnectionRequest)
                .build());
    }

    /**
     * <p>
     * Initializes the ODB service for the first time in an account.
     * </p>
     *
     * @param initializeServiceRequest
     * @return A Java Future containing the result of the InitializeService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.InitializeService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/InitializeService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<InitializeServiceResponse> initializeService(InitializeServiceRequest initializeServiceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initializes the ODB service for the first time in an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InitializeServiceRequest.Builder} avoiding the need
     * to create one manually via {@link InitializeServiceRequest#builder()}
     * </p>
     *
     * @param initializeServiceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.InitializeServiceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the InitializeService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.InitializeService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/InitializeService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<InitializeServiceResponse> initializeService(
            Consumer<InitializeServiceRequest.Builder> initializeServiceRequest) {
        return initializeService(InitializeServiceRequest.builder().applyMutation(initializeServiceRequest).build());
    }

    /**
     * <p>
     * Lists all Autonomous VMs in an Autonomous VM cluster.
     * </p>
     *
     * @param listAutonomousVirtualMachinesRequest
     * @return A Java Future containing the result of the ListAutonomousVirtualMachines operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListAutonomousVirtualMachines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListAutonomousVirtualMachines"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAutonomousVirtualMachinesResponse> listAutonomousVirtualMachines(
            ListAutonomousVirtualMachinesRequest listAutonomousVirtualMachinesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Autonomous VMs in an Autonomous VM cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAutonomousVirtualMachinesRequest.Builder}
     * avoiding the need to create one manually via {@link ListAutonomousVirtualMachinesRequest#builder()}
     * </p>
     *
     * @param listAutonomousVirtualMachinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListAutonomousVirtualMachinesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAutonomousVirtualMachines operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListAutonomousVirtualMachines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListAutonomousVirtualMachines"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAutonomousVirtualMachinesResponse> listAutonomousVirtualMachines(
            Consumer<ListAutonomousVirtualMachinesRequest.Builder> listAutonomousVirtualMachinesRequest) {
        return listAutonomousVirtualMachines(ListAutonomousVirtualMachinesRequest.builder()
                .applyMutation(listAutonomousVirtualMachinesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAutonomousVirtualMachines(software.amazon.awssdk.services.odb.model.ListAutonomousVirtualMachinesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListAutonomousVirtualMachinesPublisher publisher = client.listAutonomousVirtualMachinesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListAutonomousVirtualMachinesPublisher publisher = client.listAutonomousVirtualMachinesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.odb.model.ListAutonomousVirtualMachinesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.odb.model.ListAutonomousVirtualMachinesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAutonomousVirtualMachines(software.amazon.awssdk.services.odb.model.ListAutonomousVirtualMachinesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAutonomousVirtualMachinesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListAutonomousVirtualMachines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListAutonomousVirtualMachines"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAutonomousVirtualMachinesPublisher listAutonomousVirtualMachinesPaginator(
            ListAutonomousVirtualMachinesRequest listAutonomousVirtualMachinesRequest) {
        return new ListAutonomousVirtualMachinesPublisher(this, listAutonomousVirtualMachinesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAutonomousVirtualMachines(software.amazon.awssdk.services.odb.model.ListAutonomousVirtualMachinesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListAutonomousVirtualMachinesPublisher publisher = client.listAutonomousVirtualMachinesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListAutonomousVirtualMachinesPublisher publisher = client.listAutonomousVirtualMachinesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.odb.model.ListAutonomousVirtualMachinesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.odb.model.ListAutonomousVirtualMachinesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAutonomousVirtualMachines(software.amazon.awssdk.services.odb.model.ListAutonomousVirtualMachinesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAutonomousVirtualMachinesRequest.Builder}
     * avoiding the need to create one manually via {@link ListAutonomousVirtualMachinesRequest#builder()}
     * </p>
     *
     * @param listAutonomousVirtualMachinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListAutonomousVirtualMachinesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListAutonomousVirtualMachines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListAutonomousVirtualMachines"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAutonomousVirtualMachinesPublisher listAutonomousVirtualMachinesPaginator(
            Consumer<ListAutonomousVirtualMachinesRequest.Builder> listAutonomousVirtualMachinesRequest) {
        return listAutonomousVirtualMachinesPaginator(ListAutonomousVirtualMachinesRequest.builder()
                .applyMutation(listAutonomousVirtualMachinesRequest).build());
    }

    /**
     * <p>
     * Lists all Autonomous VM clusters in a specified Cloud Exadata infrastructure.
     * </p>
     *
     * @param listCloudAutonomousVmClustersRequest
     * @return A Java Future containing the result of the ListCloudAutonomousVmClusters operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListCloudAutonomousVmClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListCloudAutonomousVmClusters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCloudAutonomousVmClustersResponse> listCloudAutonomousVmClusters(
            ListCloudAutonomousVmClustersRequest listCloudAutonomousVmClustersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Autonomous VM clusters in a specified Cloud Exadata infrastructure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCloudAutonomousVmClustersRequest.Builder}
     * avoiding the need to create one manually via {@link ListCloudAutonomousVmClustersRequest#builder()}
     * </p>
     *
     * @param listCloudAutonomousVmClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListCloudAutonomousVmClustersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListCloudAutonomousVmClusters operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListCloudAutonomousVmClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListCloudAutonomousVmClusters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCloudAutonomousVmClustersResponse> listCloudAutonomousVmClusters(
            Consumer<ListCloudAutonomousVmClustersRequest.Builder> listCloudAutonomousVmClustersRequest) {
        return listCloudAutonomousVmClusters(ListCloudAutonomousVmClustersRequest.builder()
                .applyMutation(listCloudAutonomousVmClustersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCloudAutonomousVmClusters(software.amazon.awssdk.services.odb.model.ListCloudAutonomousVmClustersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListCloudAutonomousVmClustersPublisher publisher = client.listCloudAutonomousVmClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListCloudAutonomousVmClustersPublisher publisher = client.listCloudAutonomousVmClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.odb.model.ListCloudAutonomousVmClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.odb.model.ListCloudAutonomousVmClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCloudAutonomousVmClusters(software.amazon.awssdk.services.odb.model.ListCloudAutonomousVmClustersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCloudAutonomousVmClustersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListCloudAutonomousVmClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListCloudAutonomousVmClusters"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudAutonomousVmClustersPublisher listCloudAutonomousVmClustersPaginator(
            ListCloudAutonomousVmClustersRequest listCloudAutonomousVmClustersRequest) {
        return new ListCloudAutonomousVmClustersPublisher(this, listCloudAutonomousVmClustersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCloudAutonomousVmClusters(software.amazon.awssdk.services.odb.model.ListCloudAutonomousVmClustersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListCloudAutonomousVmClustersPublisher publisher = client.listCloudAutonomousVmClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListCloudAutonomousVmClustersPublisher publisher = client.listCloudAutonomousVmClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.odb.model.ListCloudAutonomousVmClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.odb.model.ListCloudAutonomousVmClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCloudAutonomousVmClusters(software.amazon.awssdk.services.odb.model.ListCloudAutonomousVmClustersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCloudAutonomousVmClustersRequest.Builder}
     * avoiding the need to create one manually via {@link ListCloudAutonomousVmClustersRequest#builder()}
     * </p>
     *
     * @param listCloudAutonomousVmClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListCloudAutonomousVmClustersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListCloudAutonomousVmClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListCloudAutonomousVmClusters"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudAutonomousVmClustersPublisher listCloudAutonomousVmClustersPaginator(
            Consumer<ListCloudAutonomousVmClustersRequest.Builder> listCloudAutonomousVmClustersRequest) {
        return listCloudAutonomousVmClustersPaginator(ListCloudAutonomousVmClustersRequest.builder()
                .applyMutation(listCloudAutonomousVmClustersRequest).build());
    }

    /**
     * <p>
     * Returns information about the Exadata infrastructures owned by your Amazon Web Services account.
     * </p>
     *
     * @param listCloudExadataInfrastructuresRequest
     * @return A Java Future containing the result of the ListCloudExadataInfrastructures operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListCloudExadataInfrastructures
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListCloudExadataInfrastructures"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCloudExadataInfrastructuresResponse> listCloudExadataInfrastructures(
            ListCloudExadataInfrastructuresRequest listCloudExadataInfrastructuresRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the Exadata infrastructures owned by your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCloudExadataInfrastructuresRequest.Builder}
     * avoiding the need to create one manually via {@link ListCloudExadataInfrastructuresRequest#builder()}
     * </p>
     *
     * @param listCloudExadataInfrastructuresRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListCloudExadataInfrastructuresRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListCloudExadataInfrastructures operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListCloudExadataInfrastructures
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListCloudExadataInfrastructures"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCloudExadataInfrastructuresResponse> listCloudExadataInfrastructures(
            Consumer<ListCloudExadataInfrastructuresRequest.Builder> listCloudExadataInfrastructuresRequest) {
        return listCloudExadataInfrastructures(ListCloudExadataInfrastructuresRequest.builder()
                .applyMutation(listCloudExadataInfrastructuresRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCloudExadataInfrastructures(software.amazon.awssdk.services.odb.model.ListCloudExadataInfrastructuresRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListCloudExadataInfrastructuresPublisher publisher = client.listCloudExadataInfrastructuresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListCloudExadataInfrastructuresPublisher publisher = client.listCloudExadataInfrastructuresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.odb.model.ListCloudExadataInfrastructuresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.odb.model.ListCloudExadataInfrastructuresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCloudExadataInfrastructures(software.amazon.awssdk.services.odb.model.ListCloudExadataInfrastructuresRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCloudExadataInfrastructuresRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListCloudExadataInfrastructures
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListCloudExadataInfrastructures"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudExadataInfrastructuresPublisher listCloudExadataInfrastructuresPaginator(
            ListCloudExadataInfrastructuresRequest listCloudExadataInfrastructuresRequest) {
        return new ListCloudExadataInfrastructuresPublisher(this, listCloudExadataInfrastructuresRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCloudExadataInfrastructures(software.amazon.awssdk.services.odb.model.ListCloudExadataInfrastructuresRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListCloudExadataInfrastructuresPublisher publisher = client.listCloudExadataInfrastructuresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListCloudExadataInfrastructuresPublisher publisher = client.listCloudExadataInfrastructuresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.odb.model.ListCloudExadataInfrastructuresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.odb.model.ListCloudExadataInfrastructuresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCloudExadataInfrastructures(software.amazon.awssdk.services.odb.model.ListCloudExadataInfrastructuresRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCloudExadataInfrastructuresRequest.Builder}
     * avoiding the need to create one manually via {@link ListCloudExadataInfrastructuresRequest#builder()}
     * </p>
     *
     * @param listCloudExadataInfrastructuresRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListCloudExadataInfrastructuresRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListCloudExadataInfrastructures
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListCloudExadataInfrastructures"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudExadataInfrastructuresPublisher listCloudExadataInfrastructuresPaginator(
            Consumer<ListCloudExadataInfrastructuresRequest.Builder> listCloudExadataInfrastructuresRequest) {
        return listCloudExadataInfrastructuresPaginator(ListCloudExadataInfrastructuresRequest.builder()
                .applyMutation(listCloudExadataInfrastructuresRequest).build());
    }

    /**
     * <p>
     * Returns information about the VM clusters owned by your Amazon Web Services account or only the ones on the
     * specified Exadata infrastructure.
     * </p>
     *
     * @param listCloudVmClustersRequest
     * @return A Java Future containing the result of the ListCloudVmClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListCloudVmClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListCloudVmClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCloudVmClustersResponse> listCloudVmClusters(
            ListCloudVmClustersRequest listCloudVmClustersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the VM clusters owned by your Amazon Web Services account or only the ones on the
     * specified Exadata infrastructure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCloudVmClustersRequest.Builder} avoiding the
     * need to create one manually via {@link ListCloudVmClustersRequest#builder()}
     * </p>
     *
     * @param listCloudVmClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListCloudVmClustersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListCloudVmClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListCloudVmClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListCloudVmClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCloudVmClustersResponse> listCloudVmClusters(
            Consumer<ListCloudVmClustersRequest.Builder> listCloudVmClustersRequest) {
        return listCloudVmClusters(ListCloudVmClustersRequest.builder().applyMutation(listCloudVmClustersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCloudVmClusters(software.amazon.awssdk.services.odb.model.ListCloudVmClustersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListCloudVmClustersPublisher publisher = client.listCloudVmClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListCloudVmClustersPublisher publisher = client.listCloudVmClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.odb.model.ListCloudVmClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.odb.model.ListCloudVmClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCloudVmClusters(software.amazon.awssdk.services.odb.model.ListCloudVmClustersRequest)} operation.</b>
     * </p>
     *
     * @param listCloudVmClustersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListCloudVmClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListCloudVmClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCloudVmClustersPublisher listCloudVmClustersPaginator(ListCloudVmClustersRequest listCloudVmClustersRequest) {
        return new ListCloudVmClustersPublisher(this, listCloudVmClustersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCloudVmClusters(software.amazon.awssdk.services.odb.model.ListCloudVmClustersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListCloudVmClustersPublisher publisher = client.listCloudVmClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListCloudVmClustersPublisher publisher = client.listCloudVmClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.odb.model.ListCloudVmClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.odb.model.ListCloudVmClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCloudVmClusters(software.amazon.awssdk.services.odb.model.ListCloudVmClustersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCloudVmClustersRequest.Builder} avoiding the
     * need to create one manually via {@link ListCloudVmClustersRequest#builder()}
     * </p>
     *
     * @param listCloudVmClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListCloudVmClustersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListCloudVmClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListCloudVmClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCloudVmClustersPublisher listCloudVmClustersPaginator(
            Consumer<ListCloudVmClustersRequest.Builder> listCloudVmClustersRequest) {
        return listCloudVmClustersPaginator(ListCloudVmClustersRequest.builder().applyMutation(listCloudVmClustersRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about the DB nodes for the specified VM cluster.
     * </p>
     *
     * @param listDbNodesRequest
     * @return A Java Future containing the result of the ListDbNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListDbNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListDbNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDbNodesResponse> listDbNodes(ListDbNodesRequest listDbNodesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the DB nodes for the specified VM cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDbNodesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDbNodesRequest#builder()}
     * </p>
     *
     * @param listDbNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListDbNodesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDbNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListDbNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListDbNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDbNodesResponse> listDbNodes(Consumer<ListDbNodesRequest.Builder> listDbNodesRequest) {
        return listDbNodes(ListDbNodesRequest.builder().applyMutation(listDbNodesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listDbNodes(software.amazon.awssdk.services.odb.model.ListDbNodesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListDbNodesPublisher publisher = client.listDbNodesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListDbNodesPublisher publisher = client.listDbNodesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.odb.model.ListDbNodesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.odb.model.ListDbNodesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDbNodes(software.amazon.awssdk.services.odb.model.ListDbNodesRequest)} operation.</b>
     * </p>
     *
     * @param listDbNodesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListDbNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListDbNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDbNodesPublisher listDbNodesPaginator(ListDbNodesRequest listDbNodesRequest) {
        return new ListDbNodesPublisher(this, listDbNodesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listDbNodes(software.amazon.awssdk.services.odb.model.ListDbNodesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListDbNodesPublisher publisher = client.listDbNodesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListDbNodesPublisher publisher = client.listDbNodesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.odb.model.ListDbNodesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.odb.model.ListDbNodesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDbNodes(software.amazon.awssdk.services.odb.model.ListDbNodesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDbNodesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDbNodesRequest#builder()}
     * </p>
     *
     * @param listDbNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListDbNodesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListDbNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListDbNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDbNodesPublisher listDbNodesPaginator(Consumer<ListDbNodesRequest.Builder> listDbNodesRequest) {
        return listDbNodesPaginator(ListDbNodesRequest.builder().applyMutation(listDbNodesRequest).build());
    }

    /**
     * <p>
     * Returns information about the database servers that belong to the specified Exadata infrastructure.
     * </p>
     *
     * @param listDbServersRequest
     * @return A Java Future containing the result of the ListDbServers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListDbServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListDbServers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDbServersResponse> listDbServers(ListDbServersRequest listDbServersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the database servers that belong to the specified Exadata infrastructure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDbServersRequest.Builder} avoiding the need to
     * create one manually via {@link ListDbServersRequest#builder()}
     * </p>
     *
     * @param listDbServersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListDbServersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDbServers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListDbServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListDbServers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDbServersResponse> listDbServers(Consumer<ListDbServersRequest.Builder> listDbServersRequest) {
        return listDbServers(ListDbServersRequest.builder().applyMutation(listDbServersRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listDbServers(software.amazon.awssdk.services.odb.model.ListDbServersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListDbServersPublisher publisher = client.listDbServersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListDbServersPublisher publisher = client.listDbServersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.odb.model.ListDbServersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.odb.model.ListDbServersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDbServers(software.amazon.awssdk.services.odb.model.ListDbServersRequest)} operation.</b>
     * </p>
     *
     * @param listDbServersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListDbServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListDbServers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDbServersPublisher listDbServersPaginator(ListDbServersRequest listDbServersRequest) {
        return new ListDbServersPublisher(this, listDbServersRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listDbServers(software.amazon.awssdk.services.odb.model.ListDbServersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListDbServersPublisher publisher = client.listDbServersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListDbServersPublisher publisher = client.listDbServersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.odb.model.ListDbServersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.odb.model.ListDbServersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDbServers(software.amazon.awssdk.services.odb.model.ListDbServersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDbServersRequest.Builder} avoiding the need to
     * create one manually via {@link ListDbServersRequest#builder()}
     * </p>
     *
     * @param listDbServersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListDbServersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListDbServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListDbServers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDbServersPublisher listDbServersPaginator(Consumer<ListDbServersRequest.Builder> listDbServersRequest) {
        return listDbServersPaginator(ListDbServersRequest.builder().applyMutation(listDbServersRequest).build());
    }

    /**
     * <p>
     * Returns information about the shapes that are available for an Exadata infrastructure.
     * </p>
     *
     * @param listDbSystemShapesRequest
     * @return A Java Future containing the result of the ListDbSystemShapes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListDbSystemShapes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListDbSystemShapes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDbSystemShapesResponse> listDbSystemShapes(ListDbSystemShapesRequest listDbSystemShapesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the shapes that are available for an Exadata infrastructure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDbSystemShapesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDbSystemShapesRequest#builder()}
     * </p>
     *
     * @param listDbSystemShapesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListDbSystemShapesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDbSystemShapes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListDbSystemShapes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListDbSystemShapes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDbSystemShapesResponse> listDbSystemShapes(
            Consumer<ListDbSystemShapesRequest.Builder> listDbSystemShapesRequest) {
        return listDbSystemShapes(ListDbSystemShapesRequest.builder().applyMutation(listDbSystemShapesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDbSystemShapes(software.amazon.awssdk.services.odb.model.ListDbSystemShapesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListDbSystemShapesPublisher publisher = client.listDbSystemShapesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListDbSystemShapesPublisher publisher = client.listDbSystemShapesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.odb.model.ListDbSystemShapesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.odb.model.ListDbSystemShapesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDbSystemShapes(software.amazon.awssdk.services.odb.model.ListDbSystemShapesRequest)} operation.</b>
     * </p>
     *
     * @param listDbSystemShapesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListDbSystemShapes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListDbSystemShapes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDbSystemShapesPublisher listDbSystemShapesPaginator(ListDbSystemShapesRequest listDbSystemShapesRequest) {
        return new ListDbSystemShapesPublisher(this, listDbSystemShapesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDbSystemShapes(software.amazon.awssdk.services.odb.model.ListDbSystemShapesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListDbSystemShapesPublisher publisher = client.listDbSystemShapesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListDbSystemShapesPublisher publisher = client.listDbSystemShapesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.odb.model.ListDbSystemShapesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.odb.model.ListDbSystemShapesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDbSystemShapes(software.amazon.awssdk.services.odb.model.ListDbSystemShapesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDbSystemShapesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDbSystemShapesRequest#builder()}
     * </p>
     *
     * @param listDbSystemShapesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListDbSystemShapesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListDbSystemShapes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListDbSystemShapes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDbSystemShapesPublisher listDbSystemShapesPaginator(
            Consumer<ListDbSystemShapesRequest.Builder> listDbSystemShapesRequest) {
        return listDbSystemShapesPaginator(ListDbSystemShapesRequest.builder().applyMutation(listDbSystemShapesRequest).build());
    }

    /**
     * <p>
     * Returns information about Oracle Grid Infrastructure (GI) software versions that are available for a VM cluster
     * for the specified shape.
     * </p>
     *
     * @param listGiVersionsRequest
     * @return A Java Future containing the result of the ListGiVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListGiVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListGiVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGiVersionsResponse> listGiVersions(ListGiVersionsRequest listGiVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about Oracle Grid Infrastructure (GI) software versions that are available for a VM cluster
     * for the specified shape.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGiVersionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGiVersionsRequest#builder()}
     * </p>
     *
     * @param listGiVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListGiVersionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListGiVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListGiVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListGiVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGiVersionsResponse> listGiVersions(Consumer<ListGiVersionsRequest.Builder> listGiVersionsRequest) {
        return listGiVersions(ListGiVersionsRequest.builder().applyMutation(listGiVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listGiVersions(software.amazon.awssdk.services.odb.model.ListGiVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListGiVersionsPublisher publisher = client.listGiVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListGiVersionsPublisher publisher = client.listGiVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.odb.model.ListGiVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.odb.model.ListGiVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGiVersions(software.amazon.awssdk.services.odb.model.ListGiVersionsRequest)} operation.</b>
     * </p>
     *
     * @param listGiVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListGiVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListGiVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGiVersionsPublisher listGiVersionsPaginator(ListGiVersionsRequest listGiVersionsRequest) {
        return new ListGiVersionsPublisher(this, listGiVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listGiVersions(software.amazon.awssdk.services.odb.model.ListGiVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListGiVersionsPublisher publisher = client.listGiVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListGiVersionsPublisher publisher = client.listGiVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.odb.model.ListGiVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.odb.model.ListGiVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGiVersions(software.amazon.awssdk.services.odb.model.ListGiVersionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGiVersionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGiVersionsRequest#builder()}
     * </p>
     *
     * @param listGiVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListGiVersionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListGiVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListGiVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGiVersionsPublisher listGiVersionsPaginator(Consumer<ListGiVersionsRequest.Builder> listGiVersionsRequest) {
        return listGiVersionsPaginator(ListGiVersionsRequest.builder().applyMutation(listGiVersionsRequest).build());
    }

    /**
     * <p>
     * Returns information about the ODB networks owned by your Amazon Web Services account.
     * </p>
     *
     * @param listOdbNetworksRequest
     * @return A Java Future containing the result of the ListOdbNetworks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListOdbNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListOdbNetworks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListOdbNetworksResponse> listOdbNetworks(ListOdbNetworksRequest listOdbNetworksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the ODB networks owned by your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOdbNetworksRequest.Builder} avoiding the need
     * to create one manually via {@link ListOdbNetworksRequest#builder()}
     * </p>
     *
     * @param listOdbNetworksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListOdbNetworksRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListOdbNetworks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListOdbNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListOdbNetworks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListOdbNetworksResponse> listOdbNetworks(
            Consumer<ListOdbNetworksRequest.Builder> listOdbNetworksRequest) {
        return listOdbNetworks(ListOdbNetworksRequest.builder().applyMutation(listOdbNetworksRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listOdbNetworks(software.amazon.awssdk.services.odb.model.ListOdbNetworksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListOdbNetworksPublisher publisher = client.listOdbNetworksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListOdbNetworksPublisher publisher = client.listOdbNetworksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.odb.model.ListOdbNetworksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.odb.model.ListOdbNetworksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOdbNetworks(software.amazon.awssdk.services.odb.model.ListOdbNetworksRequest)} operation.</b>
     * </p>
     *
     * @param listOdbNetworksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListOdbNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListOdbNetworks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOdbNetworksPublisher listOdbNetworksPaginator(ListOdbNetworksRequest listOdbNetworksRequest) {
        return new ListOdbNetworksPublisher(this, listOdbNetworksRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listOdbNetworks(software.amazon.awssdk.services.odb.model.ListOdbNetworksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListOdbNetworksPublisher publisher = client.listOdbNetworksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListOdbNetworksPublisher publisher = client.listOdbNetworksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.odb.model.ListOdbNetworksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.odb.model.ListOdbNetworksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOdbNetworks(software.amazon.awssdk.services.odb.model.ListOdbNetworksRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOdbNetworksRequest.Builder} avoiding the need
     * to create one manually via {@link ListOdbNetworksRequest#builder()}
     * </p>
     *
     * @param listOdbNetworksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListOdbNetworksRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListOdbNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListOdbNetworks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOdbNetworksPublisher listOdbNetworksPaginator(Consumer<ListOdbNetworksRequest.Builder> listOdbNetworksRequest) {
        return listOdbNetworksPaginator(ListOdbNetworksRequest.builder().applyMutation(listOdbNetworksRequest).build());
    }

    /**
     * <p>
     * Lists all ODB peering connections or those associated with a specific ODB network.
     * </p>
     *
     * @param listOdbPeeringConnectionsRequest
     * @return A Java Future containing the result of the ListOdbPeeringConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListOdbPeeringConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListOdbPeeringConnections" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListOdbPeeringConnectionsResponse> listOdbPeeringConnections(
            ListOdbPeeringConnectionsRequest listOdbPeeringConnectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all ODB peering connections or those associated with a specific ODB network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOdbPeeringConnectionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListOdbPeeringConnectionsRequest#builder()}
     * </p>
     *
     * @param listOdbPeeringConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListOdbPeeringConnectionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListOdbPeeringConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListOdbPeeringConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListOdbPeeringConnections" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListOdbPeeringConnectionsResponse> listOdbPeeringConnections(
            Consumer<ListOdbPeeringConnectionsRequest.Builder> listOdbPeeringConnectionsRequest) {
        return listOdbPeeringConnections(ListOdbPeeringConnectionsRequest.builder()
                .applyMutation(listOdbPeeringConnectionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOdbPeeringConnections(software.amazon.awssdk.services.odb.model.ListOdbPeeringConnectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListOdbPeeringConnectionsPublisher publisher = client.listOdbPeeringConnectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListOdbPeeringConnectionsPublisher publisher = client.listOdbPeeringConnectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.odb.model.ListOdbPeeringConnectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.odb.model.ListOdbPeeringConnectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOdbPeeringConnections(software.amazon.awssdk.services.odb.model.ListOdbPeeringConnectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOdbPeeringConnectionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListOdbPeeringConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListOdbPeeringConnections" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOdbPeeringConnectionsPublisher listOdbPeeringConnectionsPaginator(
            ListOdbPeeringConnectionsRequest listOdbPeeringConnectionsRequest) {
        return new ListOdbPeeringConnectionsPublisher(this, listOdbPeeringConnectionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOdbPeeringConnections(software.amazon.awssdk.services.odb.model.ListOdbPeeringConnectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListOdbPeeringConnectionsPublisher publisher = client.listOdbPeeringConnectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListOdbPeeringConnectionsPublisher publisher = client.listOdbPeeringConnectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.odb.model.ListOdbPeeringConnectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.odb.model.ListOdbPeeringConnectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOdbPeeringConnections(software.amazon.awssdk.services.odb.model.ListOdbPeeringConnectionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOdbPeeringConnectionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListOdbPeeringConnectionsRequest#builder()}
     * </p>
     *
     * @param listOdbPeeringConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListOdbPeeringConnectionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListOdbPeeringConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListOdbPeeringConnections" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOdbPeeringConnectionsPublisher listOdbPeeringConnectionsPaginator(
            Consumer<ListOdbPeeringConnectionsRequest.Builder> listOdbPeeringConnectionsRequest) {
        return listOdbPeeringConnectionsPaginator(ListOdbPeeringConnectionsRequest.builder()
                .applyMutation(listOdbPeeringConnectionsRequest).build());
    }

    /**
     * <p>
     * Returns information about the system versions that are available for a VM cluster for the specified
     * <code>giVersion</code> and <code>shape</code>.
     * </p>
     *
     * @param listSystemVersionsRequest
     * @return A Java Future containing the result of the ListSystemVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListSystemVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListSystemVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSystemVersionsResponse> listSystemVersions(ListSystemVersionsRequest listSystemVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the system versions that are available for a VM cluster for the specified
     * <code>giVersion</code> and <code>shape</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSystemVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSystemVersionsRequest#builder()}
     * </p>
     *
     * @param listSystemVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListSystemVersionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListSystemVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListSystemVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListSystemVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSystemVersionsResponse> listSystemVersions(
            Consumer<ListSystemVersionsRequest.Builder> listSystemVersionsRequest) {
        return listSystemVersions(ListSystemVersionsRequest.builder().applyMutation(listSystemVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSystemVersions(software.amazon.awssdk.services.odb.model.ListSystemVersionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListSystemVersionsPublisher publisher = client.listSystemVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListSystemVersionsPublisher publisher = client.listSystemVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.odb.model.ListSystemVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.odb.model.ListSystemVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSystemVersions(software.amazon.awssdk.services.odb.model.ListSystemVersionsRequest)} operation.</b>
     * </p>
     *
     * @param listSystemVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListSystemVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListSystemVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSystemVersionsPublisher listSystemVersionsPaginator(ListSystemVersionsRequest listSystemVersionsRequest) {
        return new ListSystemVersionsPublisher(this, listSystemVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSystemVersions(software.amazon.awssdk.services.odb.model.ListSystemVersionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListSystemVersionsPublisher publisher = client.listSystemVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListSystemVersionsPublisher publisher = client.listSystemVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.odb.model.ListSystemVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.odb.model.ListSystemVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSystemVersions(software.amazon.awssdk.services.odb.model.ListSystemVersionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSystemVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSystemVersionsRequest#builder()}
     * </p>
     *
     * @param listSystemVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListSystemVersionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListSystemVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListSystemVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSystemVersionsPublisher listSystemVersionsPaginator(
            Consumer<ListSystemVersionsRequest.Builder> listSystemVersionsRequest) {
        return listSystemVersionsPaginator(ListSystemVersionsRequest.builder().applyMutation(listSystemVersionsRequest).build());
    }

    /**
     * <p>
     * Returns information about the tags applied to this resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the tags applied to this resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListTagsForResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Reboots the specified DB node in a VM cluster.
     * </p>
     *
     * @param rebootDbNodeRequest
     * @return A Java Future containing the result of the RebootDbNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.RebootDbNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/RebootDbNode" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RebootDbNodeResponse> rebootDbNode(RebootDbNodeRequest rebootDbNodeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reboots the specified DB node in a VM cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RebootDbNodeRequest.Builder} avoiding the need to
     * create one manually via {@link RebootDbNodeRequest#builder()}
     * </p>
     *
     * @param rebootDbNodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.RebootDbNodeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the RebootDbNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.RebootDbNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/RebootDbNode" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RebootDbNodeResponse> rebootDbNode(Consumer<RebootDbNodeRequest.Builder> rebootDbNodeRequest) {
        return rebootDbNode(RebootDbNodeRequest.builder().applyMutation(rebootDbNodeRequest).build());
    }

    /**
     * <p>
     * Starts the specified DB node in a VM cluster.
     * </p>
     *
     * @param startDbNodeRequest
     * @return A Java Future containing the result of the StartDbNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.StartDbNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/StartDbNode" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartDbNodeResponse> startDbNode(StartDbNodeRequest startDbNodeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the specified DB node in a VM cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDbNodeRequest.Builder} avoiding the need to
     * create one manually via {@link StartDbNodeRequest#builder()}
     * </p>
     *
     * @param startDbNodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.StartDbNodeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartDbNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.StartDbNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/StartDbNode" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartDbNodeResponse> startDbNode(Consumer<StartDbNodeRequest.Builder> startDbNodeRequest) {
        return startDbNode(StartDbNodeRequest.builder().applyMutation(startDbNodeRequest).build());
    }

    /**
     * <p>
     * Stops the specified DB node in a VM cluster.
     * </p>
     *
     * @param stopDbNodeRequest
     * @return A Java Future containing the result of the StopDbNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.StopDbNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/StopDbNode" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopDbNodeResponse> stopDbNode(StopDbNodeRequest stopDbNodeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the specified DB node in a VM cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopDbNodeRequest.Builder} avoiding the need to
     * create one manually via {@link StopDbNodeRequest#builder()}
     * </p>
     *
     * @param stopDbNodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.StopDbNodeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StopDbNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.StopDbNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/StopDbNode" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopDbNodeResponse> stopDbNode(Consumer<StopDbNodeRequest.Builder> stopDbNodeRequest) {
        return stopDbNode(StopDbNodeRequest.builder().applyMutation(stopDbNodeRequest).build());
    }

    /**
     * <p>
     * Applies tags to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException You have exceeded the service quota.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies tags to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException You have exceeded the service quota.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the properties of an Exadata infrastructure resource.
     * </p>
     *
     * @param updateCloudExadataInfrastructureRequest
     * @return A Java Future containing the result of the UpdateCloudExadataInfrastructure operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.UpdateCloudExadataInfrastructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/UpdateCloudExadataInfrastructure"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCloudExadataInfrastructureResponse> updateCloudExadataInfrastructure(
            UpdateCloudExadataInfrastructureRequest updateCloudExadataInfrastructureRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the properties of an Exadata infrastructure resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCloudExadataInfrastructureRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCloudExadataInfrastructureRequest#builder()}
     * </p>
     *
     * @param updateCloudExadataInfrastructureRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.UpdateCloudExadataInfrastructureRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateCloudExadataInfrastructure operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.UpdateCloudExadataInfrastructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/UpdateCloudExadataInfrastructure"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCloudExadataInfrastructureResponse> updateCloudExadataInfrastructure(
            Consumer<UpdateCloudExadataInfrastructureRequest.Builder> updateCloudExadataInfrastructureRequest) {
        return updateCloudExadataInfrastructure(UpdateCloudExadataInfrastructureRequest.builder()
                .applyMutation(updateCloudExadataInfrastructureRequest).build());
    }

    /**
     * <p>
     * Updates properties of a specified ODB network.
     * </p>
     *
     * @param updateOdbNetworkRequest
     * @return A Java Future containing the result of the UpdateOdbNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.UpdateOdbNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/UpdateOdbNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateOdbNetworkResponse> updateOdbNetwork(UpdateOdbNetworkRequest updateOdbNetworkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates properties of a specified ODB network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateOdbNetworkRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateOdbNetworkRequest#builder()}
     * </p>
     *
     * @param updateOdbNetworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.UpdateOdbNetworkRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateOdbNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.UpdateOdbNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/UpdateOdbNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateOdbNetworkResponse> updateOdbNetwork(
            Consumer<UpdateOdbNetworkRequest.Builder> updateOdbNetworkRequest) {
        return updateOdbNetwork(UpdateOdbNetworkRequest.builder().applyMutation(updateOdbNetworkRequest).build());
    }

    /**
     * <p>
     * Modifies the settings of an Oracle Database@Amazon Web Services peering connection. You can update the display
     * name and add or remove CIDR blocks from the peering connection.
     * </p>
     *
     * @param updateOdbPeeringConnectionRequest
     * @return A Java Future containing the result of the UpdateOdbPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.UpdateOdbPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/UpdateOdbPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateOdbPeeringConnectionResponse> updateOdbPeeringConnection(
            UpdateOdbPeeringConnectionRequest updateOdbPeeringConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the settings of an Oracle Database@Amazon Web Services peering connection. You can update the display
     * name and add or remove CIDR blocks from the peering connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateOdbPeeringConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateOdbPeeringConnectionRequest#builder()}
     * </p>
     *
     * @param updateOdbPeeringConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.UpdateOdbPeeringConnectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateOdbPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.UpdateOdbPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/UpdateOdbPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateOdbPeeringConnectionResponse> updateOdbPeeringConnection(
            Consumer<UpdateOdbPeeringConnectionRequest.Builder> updateOdbPeeringConnectionRequest) {
        return updateOdbPeeringConnection(UpdateOdbPeeringConnectionRequest.builder()
                .applyMutation(updateOdbPeeringConnectionRequest).build());
    }

    @Override
    default OdbServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link OdbAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static OdbAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link OdbAsyncClient}.
     */
    static OdbAsyncClientBuilder builder() {
        return new DefaultOdbAsyncClientBuilder();
    }
}
