/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Resource details of an Autonomous VM cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudAutonomousVmClusterResourceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudAutonomousVmClusterResourceDetails.Builder, CloudAutonomousVmClusterResourceDetails> {
    private static final SdkField<String> CLOUD_AUTONOMOUS_VM_CLUSTER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("cloudAutonomousVmClusterId")
            .getter(getter(CloudAutonomousVmClusterResourceDetails::cloudAutonomousVmClusterId))
            .setter(setter(Builder::cloudAutonomousVmClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudAutonomousVmClusterId").build())
            .build();

    private static final SdkField<Double> UNALLOCATED_ADB_STORAGE_IN_T_BS_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("unallocatedAdbStorageInTBs")
            .getter(getter(CloudAutonomousVmClusterResourceDetails::unallocatedAdbStorageInTBs))
            .setter(setter(Builder::unallocatedAdbStorageInTBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unallocatedAdbStorageInTBs").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_AUTONOMOUS_VM_CLUSTER_ID_FIELD, UNALLOCATED_ADB_STORAGE_IN_T_BS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String cloudAutonomousVmClusterId;

    private final Double unallocatedAdbStorageInTBs;

    private CloudAutonomousVmClusterResourceDetails(BuilderImpl builder) {
        this.cloudAutonomousVmClusterId = builder.cloudAutonomousVmClusterId;
        this.unallocatedAdbStorageInTBs = builder.unallocatedAdbStorageInTBs;
    }

    /**
     * <p>
     * The unique identifier of the Autonomous VM cluster.
     * </p>
     * 
     * @return The unique identifier of the Autonomous VM cluster.
     */
    public final String cloudAutonomousVmClusterId() {
        return cloudAutonomousVmClusterId;
    }

    /**
     * <p>
     * The amount of unallocated Autonomous Database storage in the Autonomous VM cluster, in terabytes.
     * </p>
     * 
     * @return The amount of unallocated Autonomous Database storage in the Autonomous VM cluster, in terabytes.
     */
    public final Double unallocatedAdbStorageInTBs() {
        return unallocatedAdbStorageInTBs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudAutonomousVmClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(unallocatedAdbStorageInTBs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudAutonomousVmClusterResourceDetails)) {
            return false;
        }
        CloudAutonomousVmClusterResourceDetails other = (CloudAutonomousVmClusterResourceDetails) obj;
        return Objects.equals(cloudAutonomousVmClusterId(), other.cloudAutonomousVmClusterId())
                && Objects.equals(unallocatedAdbStorageInTBs(), other.unallocatedAdbStorageInTBs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudAutonomousVmClusterResourceDetails")
                .add("CloudAutonomousVmClusterId", cloudAutonomousVmClusterId())
                .add("UnallocatedAdbStorageInTBs", unallocatedAdbStorageInTBs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudAutonomousVmClusterId":
            return Optional.ofNullable(clazz.cast(cloudAutonomousVmClusterId()));
        case "unallocatedAdbStorageInTBs":
            return Optional.ofNullable(clazz.cast(unallocatedAdbStorageInTBs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cloudAutonomousVmClusterId", CLOUD_AUTONOMOUS_VM_CLUSTER_ID_FIELD);
        map.put("unallocatedAdbStorageInTBs", UNALLOCATED_ADB_STORAGE_IN_T_BS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CloudAutonomousVmClusterResourceDetails, T> g) {
        return obj -> g.apply((CloudAutonomousVmClusterResourceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudAutonomousVmClusterResourceDetails> {
        /**
         * <p>
         * The unique identifier of the Autonomous VM cluster.
         * </p>
         * 
         * @param cloudAutonomousVmClusterId
         *        The unique identifier of the Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudAutonomousVmClusterId(String cloudAutonomousVmClusterId);

        /**
         * <p>
         * The amount of unallocated Autonomous Database storage in the Autonomous VM cluster, in terabytes.
         * </p>
         * 
         * @param unallocatedAdbStorageInTBs
         *        The amount of unallocated Autonomous Database storage in the Autonomous VM cluster, in terabytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unallocatedAdbStorageInTBs(Double unallocatedAdbStorageInTBs);
    }

    static final class BuilderImpl implements Builder {
        private String cloudAutonomousVmClusterId;

        private Double unallocatedAdbStorageInTBs;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudAutonomousVmClusterResourceDetails model) {
            cloudAutonomousVmClusterId(model.cloudAutonomousVmClusterId);
            unallocatedAdbStorageInTBs(model.unallocatedAdbStorageInTBs);
        }

        public final String getCloudAutonomousVmClusterId() {
            return cloudAutonomousVmClusterId;
        }

        public final void setCloudAutonomousVmClusterId(String cloudAutonomousVmClusterId) {
            this.cloudAutonomousVmClusterId = cloudAutonomousVmClusterId;
        }

        @Override
        public final Builder cloudAutonomousVmClusterId(String cloudAutonomousVmClusterId) {
            this.cloudAutonomousVmClusterId = cloudAutonomousVmClusterId;
            return this;
        }

        public final Double getUnallocatedAdbStorageInTBs() {
            return unallocatedAdbStorageInTBs;
        }

        public final void setUnallocatedAdbStorageInTBs(Double unallocatedAdbStorageInTBs) {
            this.unallocatedAdbStorageInTBs = unallocatedAdbStorageInTBs;
        }

        @Override
        public final Builder unallocatedAdbStorageInTBs(Double unallocatedAdbStorageInTBs) {
            this.unallocatedAdbStorageInTBs = unallocatedAdbStorageInTBs;
            return this;
        }

        @Override
        public CloudAutonomousVmClusterResourceDetails build() {
            return new CloudAutonomousVmClusterResourceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
