/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCloudExadataInfrastructureRequest extends OdbRequest implements
        ToCopyableBuilder<CreateCloudExadataInfrastructureRequest.Builder, CreateCloudExadataInfrastructureRequest> {
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(CreateCloudExadataInfrastructureRequest::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> SHAPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("shape")
            .getter(getter(CreateCloudExadataInfrastructureRequest::shape)).setter(setter(Builder::shape))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shape").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZone").getter(getter(CreateCloudExadataInfrastructureRequest::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZoneId").getter(getter(CreateCloudExadataInfrastructureRequest::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneId").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateCloudExadataInfrastructureRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> COMPUTE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("computeCount").getter(getter(CreateCloudExadataInfrastructureRequest::computeCount))
            .setter(setter(Builder::computeCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeCount").build()).build();

    private static final SdkField<List<CustomerContact>> CUSTOMER_CONTACTS_TO_SEND_TO_OCI_FIELD = SdkField
            .<List<CustomerContact>> builder(MarshallingType.LIST)
            .memberName("customerContactsToSendToOCI")
            .getter(getter(CreateCloudExadataInfrastructureRequest::customerContactsToSendToOCI))
            .setter(setter(Builder::customerContactsToSendToOCI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerContactsToSendToOCI")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomerContact> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomerContact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MaintenanceWindow> MAINTENANCE_WINDOW_FIELD = SdkField
            .<MaintenanceWindow> builder(MarshallingType.SDK_POJO).memberName("maintenanceWindow")
            .getter(getter(CreateCloudExadataInfrastructureRequest::maintenanceWindow))
            .setter(setter(Builder::maintenanceWindow)).constructor(MaintenanceWindow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceWindow").build()).build();

    private static final SdkField<Integer> STORAGE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("storageCount").getter(getter(CreateCloudExadataInfrastructureRequest::storageCount))
            .setter(setter(Builder::storageCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageCount").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateCloudExadataInfrastructureRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DATABASE_SERVER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseServerType").getter(getter(CreateCloudExadataInfrastructureRequest::databaseServerType))
            .setter(setter(Builder::databaseServerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseServerType").build())
            .build();

    private static final SdkField<String> STORAGE_SERVER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storageServerType").getter(getter(CreateCloudExadataInfrastructureRequest::storageServerType))
            .setter(setter(Builder::storageServerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageServerType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_NAME_FIELD,
            SHAPE_FIELD, AVAILABILITY_ZONE_FIELD, AVAILABILITY_ZONE_ID_FIELD, TAGS_FIELD, COMPUTE_COUNT_FIELD,
            CUSTOMER_CONTACTS_TO_SEND_TO_OCI_FIELD, MAINTENANCE_WINDOW_FIELD, STORAGE_COUNT_FIELD, CLIENT_TOKEN_FIELD,
            DATABASE_SERVER_TYPE_FIELD, STORAGE_SERVER_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String displayName;

    private final String shape;

    private final String availabilityZone;

    private final String availabilityZoneId;

    private final Map<String, String> tags;

    private final Integer computeCount;

    private final List<CustomerContact> customerContactsToSendToOCI;

    private final MaintenanceWindow maintenanceWindow;

    private final Integer storageCount;

    private final String clientToken;

    private final String databaseServerType;

    private final String storageServerType;

    private CreateCloudExadataInfrastructureRequest(BuilderImpl builder) {
        super(builder);
        this.displayName = builder.displayName;
        this.shape = builder.shape;
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.tags = builder.tags;
        this.computeCount = builder.computeCount;
        this.customerContactsToSendToOCI = builder.customerContactsToSendToOCI;
        this.maintenanceWindow = builder.maintenanceWindow;
        this.storageCount = builder.storageCount;
        this.clientToken = builder.clientToken;
        this.databaseServerType = builder.databaseServerType;
        this.storageServerType = builder.storageServerType;
    }

    /**
     * <p>
     * A user-friendly name for the Exadata infrastructure.
     * </p>
     * 
     * @return A user-friendly name for the Exadata infrastructure.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The model name of the Exadata infrastructure. For the list of valid model names, use the
     * <code>ListDbSystemShapes</code> operation.
     * </p>
     * 
     * @return The model name of the Exadata infrastructure. For the list of valid model names, use the
     *         <code>ListDbSystemShapes</code> operation.
     */
    public final String shape() {
        return shape;
    }

    /**
     * <p>
     * The name of the Availability Zone (AZ) where the Exadata infrastructure is located.
     * </p>
     * <p>
     * This operation requires that you specify a value for either <code>availabilityZone</code> or
     * <code>availabilityZoneId</code>.
     * </p>
     * <p>
     * Example: <code>us-east-1a</code>
     * </p>
     * 
     * @return The name of the Availability Zone (AZ) where the Exadata infrastructure is located.</p>
     *         <p>
     *         This operation requires that you specify a value for either <code>availabilityZone</code> or
     *         <code>availabilityZoneId</code>.
     *         </p>
     *         <p>
     *         Example: <code>us-east-1a</code>
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The AZ ID of the AZ where the Exadata infrastructure is located.
     * </p>
     * <p>
     * This operation requires that you specify a value for either <code>availabilityZone</code> or
     * <code>availabilityZoneId</code>.
     * </p>
     * <p>
     * Example: <code>use1-az1</code>
     * </p>
     * 
     * @return The AZ ID of the AZ where the Exadata infrastructure is located.</p>
     *         <p>
     *         This operation requires that you specify a value for either <code>availabilityZone</code> or
     *         <code>availabilityZoneId</code>.
     *         </p>
     *         <p>
     *         Example: <code>use1-az1</code>
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The list of resource tags to apply to the Exadata infrastructure.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The list of resource tags to apply to the Exadata infrastructure.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The number of database servers for the Exadata infrastructure. Valid values for this parameter depend on the
     * shape. To get information about the minimum and maximum values, use the <code>ListDbSystemShapes</code>
     * operation.
     * </p>
     * 
     * @return The number of database servers for the Exadata infrastructure. Valid values for this parameter depend on
     *         the shape. To get information about the minimum and maximum values, use the
     *         <code>ListDbSystemShapes</code> operation.
     */
    public final Integer computeCount() {
        return computeCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomerContactsToSendToOCI property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCustomerContactsToSendToOCI() {
        return customerContactsToSendToOCI != null && !(customerContactsToSendToOCI instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The email addresses of contacts to receive notification from Oracle about maintenance updates for the Exadata
     * infrastructure.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomerContactsToSendToOCI} method.
     * </p>
     * 
     * @return The email addresses of contacts to receive notification from Oracle about maintenance updates for the
     *         Exadata infrastructure.
     */
    public final List<CustomerContact> customerContactsToSendToOCI() {
        return customerContactsToSendToOCI;
    }

    /**
     * <p>
     * The maintenance window configuration for the Exadata Cloud infrastructure.
     * </p>
     * <p>
     * This allows you to define when maintenance operations such as patching and updates can be performed on the
     * infrastructure.
     * </p>
     * 
     * @return The maintenance window configuration for the Exadata Cloud infrastructure.</p>
     *         <p>
     *         This allows you to define when maintenance operations such as patching and updates can be performed on
     *         the infrastructure.
     */
    public final MaintenanceWindow maintenanceWindow() {
        return maintenanceWindow;
    }

    /**
     * <p>
     * The number of storage servers to activate for this Exadata infrastructure. Valid values for this parameter depend
     * on the shape. To get information about the minimum and maximum values, use the <code>ListDbSystemShapes</code>
     * operation.
     * </p>
     * 
     * @return The number of storage servers to activate for this Exadata infrastructure. Valid values for this
     *         parameter depend on the shape. To get information about the minimum and maximum values, use the
     *         <code>ListDbSystemShapes</code> operation.
     */
    public final Integer storageCount() {
        return storageCount;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't
     * specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the
     * request to ensure idempotency. The client token is valid for up to 24 hours after it's first used.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you
     *         don't specify a client token, the Amazon Web Services SDK automatically generates a client token and uses
     *         it for the request to ensure idempotency. The client token is valid for up to 24 hours after it's first
     *         used.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The database server model type of the Exadata infrastructure. For the list of valid model names, use the
     * <code>ListDbSystemShapes</code> operation.
     * </p>
     * 
     * @return The database server model type of the Exadata infrastructure. For the list of valid model names, use the
     *         <code>ListDbSystemShapes</code> operation.
     */
    public final String databaseServerType() {
        return databaseServerType;
    }

    /**
     * <p>
     * The storage server model type of the Exadata infrastructure. For the list of valid model names, use the
     * <code>ListDbSystemShapes</code> operation.
     * </p>
     * 
     * @return The storage server model type of the Exadata infrastructure. For the list of valid model names, use the
     *         <code>ListDbSystemShapes</code> operation.
     */
    public final String storageServerType() {
        return storageServerType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(shape());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(computeCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomerContactsToSendToOCI() ? customerContactsToSendToOCI() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(storageCount());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(databaseServerType());
        hashCode = 31 * hashCode + Objects.hashCode(storageServerType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCloudExadataInfrastructureRequest)) {
            return false;
        }
        CreateCloudExadataInfrastructureRequest other = (CreateCloudExadataInfrastructureRequest) obj;
        return Objects.equals(displayName(), other.displayName()) && Objects.equals(shape(), other.shape())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(computeCount(), other.computeCount())
                && hasCustomerContactsToSendToOCI() == other.hasCustomerContactsToSendToOCI()
                && Objects.equals(customerContactsToSendToOCI(), other.customerContactsToSendToOCI())
                && Objects.equals(maintenanceWindow(), other.maintenanceWindow())
                && Objects.equals(storageCount(), other.storageCount()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(databaseServerType(), other.databaseServerType())
                && Objects.equals(storageServerType(), other.storageServerType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCloudExadataInfrastructureRequest").add("DisplayName", displayName())
                .add("Shape", shape()).add("AvailabilityZone", availabilityZone())
                .add("AvailabilityZoneId", availabilityZoneId()).add("Tags", hasTags() ? tags() : null)
                .add("ComputeCount", computeCount())
                .add("CustomerContactsToSendToOCI", hasCustomerContactsToSendToOCI() ? customerContactsToSendToOCI() : null)
                .add("MaintenanceWindow", maintenanceWindow()).add("StorageCount", storageCount())
                .add("ClientToken", clientToken()).add("DatabaseServerType", databaseServerType())
                .add("StorageServerType", storageServerType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "shape":
            return Optional.ofNullable(clazz.cast(shape()));
        case "availabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "availabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "computeCount":
            return Optional.ofNullable(clazz.cast(computeCount()));
        case "customerContactsToSendToOCI":
            return Optional.ofNullable(clazz.cast(customerContactsToSendToOCI()));
        case "maintenanceWindow":
            return Optional.ofNullable(clazz.cast(maintenanceWindow()));
        case "storageCount":
            return Optional.ofNullable(clazz.cast(storageCount()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "databaseServerType":
            return Optional.ofNullable(clazz.cast(databaseServerType()));
        case "storageServerType":
            return Optional.ofNullable(clazz.cast(storageServerType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("shape", SHAPE_FIELD);
        map.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("availabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("computeCount", COMPUTE_COUNT_FIELD);
        map.put("customerContactsToSendToOCI", CUSTOMER_CONTACTS_TO_SEND_TO_OCI_FIELD);
        map.put("maintenanceWindow", MAINTENANCE_WINDOW_FIELD);
        map.put("storageCount", STORAGE_COUNT_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("databaseServerType", DATABASE_SERVER_TYPE_FIELD);
        map.put("storageServerType", STORAGE_SERVER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCloudExadataInfrastructureRequest, T> g) {
        return obj -> g.apply((CreateCloudExadataInfrastructureRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OdbRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCloudExadataInfrastructureRequest> {
        /**
         * <p>
         * A user-friendly name for the Exadata infrastructure.
         * </p>
         * 
         * @param displayName
         *        A user-friendly name for the Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The model name of the Exadata infrastructure. For the list of valid model names, use the
         * <code>ListDbSystemShapes</code> operation.
         * </p>
         * 
         * @param shape
         *        The model name of the Exadata infrastructure. For the list of valid model names, use the
         *        <code>ListDbSystemShapes</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shape(String shape);

        /**
         * <p>
         * The name of the Availability Zone (AZ) where the Exadata infrastructure is located.
         * </p>
         * <p>
         * This operation requires that you specify a value for either <code>availabilityZone</code> or
         * <code>availabilityZoneId</code>.
         * </p>
         * <p>
         * Example: <code>us-east-1a</code>
         * </p>
         * 
         * @param availabilityZone
         *        The name of the Availability Zone (AZ) where the Exadata infrastructure is located.</p>
         *        <p>
         *        This operation requires that you specify a value for either <code>availabilityZone</code> or
         *        <code>availabilityZoneId</code>.
         *        </p>
         *        <p>
         *        Example: <code>us-east-1a</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The AZ ID of the AZ where the Exadata infrastructure is located.
         * </p>
         * <p>
         * This operation requires that you specify a value for either <code>availabilityZone</code> or
         * <code>availabilityZoneId</code>.
         * </p>
         * <p>
         * Example: <code>use1-az1</code>
         * </p>
         * 
         * @param availabilityZoneId
         *        The AZ ID of the AZ where the Exadata infrastructure is located.</p>
         *        <p>
         *        This operation requires that you specify a value for either <code>availabilityZone</code> or
         *        <code>availabilityZoneId</code>.
         *        </p>
         *        <p>
         *        Example: <code>use1-az1</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * The list of resource tags to apply to the Exadata infrastructure.
         * </p>
         * 
         * @param tags
         *        The list of resource tags to apply to the Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The number of database servers for the Exadata infrastructure. Valid values for this parameter depend on the
         * shape. To get information about the minimum and maximum values, use the <code>ListDbSystemShapes</code>
         * operation.
         * </p>
         * 
         * @param computeCount
         *        The number of database servers for the Exadata infrastructure. Valid values for this parameter depend
         *        on the shape. To get information about the minimum and maximum values, use the
         *        <code>ListDbSystemShapes</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeCount(Integer computeCount);

        /**
         * <p>
         * The email addresses of contacts to receive notification from Oracle about maintenance updates for the Exadata
         * infrastructure.
         * </p>
         * 
         * @param customerContactsToSendToOCI
         *        The email addresses of contacts to receive notification from Oracle about maintenance updates for the
         *        Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerContactsToSendToOCI(Collection<CustomerContact> customerContactsToSendToOCI);

        /**
         * <p>
         * The email addresses of contacts to receive notification from Oracle about maintenance updates for the Exadata
         * infrastructure.
         * </p>
         * 
         * @param customerContactsToSendToOCI
         *        The email addresses of contacts to receive notification from Oracle about maintenance updates for the
         *        Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerContactsToSendToOCI(CustomerContact... customerContactsToSendToOCI);

        /**
         * <p>
         * The email addresses of contacts to receive notification from Oracle about maintenance updates for the Exadata
         * infrastructure.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.odb.model.CustomerContact.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.odb.model.CustomerContact#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.odb.model.CustomerContact.Builder#build()} is called immediately and
         * its result is passed to {@link #customerContactsToSendToOCI(List<CustomerContact>)}.
         * 
         * @param customerContactsToSendToOCI
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.odb.model.CustomerContact.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerContactsToSendToOCI(java.util.Collection<CustomerContact>)
         */
        Builder customerContactsToSendToOCI(Consumer<CustomerContact.Builder>... customerContactsToSendToOCI);

        /**
         * <p>
         * The maintenance window configuration for the Exadata Cloud infrastructure.
         * </p>
         * <p>
         * This allows you to define when maintenance operations such as patching and updates can be performed on the
         * infrastructure.
         * </p>
         * 
         * @param maintenanceWindow
         *        The maintenance window configuration for the Exadata Cloud infrastructure.</p>
         *        <p>
         *        This allows you to define when maintenance operations such as patching and updates can be performed on
         *        the infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceWindow(MaintenanceWindow maintenanceWindow);

        /**
         * <p>
         * The maintenance window configuration for the Exadata Cloud infrastructure.
         * </p>
         * <p>
         * This allows you to define when maintenance operations such as patching and updates can be performed on the
         * infrastructure.
         * </p>
         * This is a convenience method that creates an instance of the {@link MaintenanceWindow.Builder} avoiding the
         * need to create one manually via {@link MaintenanceWindow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MaintenanceWindow.Builder#build()} is called immediately and its
         * result is passed to {@link #maintenanceWindow(MaintenanceWindow)}.
         * 
         * @param maintenanceWindow
         *        a consumer that will call methods on {@link MaintenanceWindow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenanceWindow(MaintenanceWindow)
         */
        default Builder maintenanceWindow(Consumer<MaintenanceWindow.Builder> maintenanceWindow) {
            return maintenanceWindow(MaintenanceWindow.builder().applyMutation(maintenanceWindow).build());
        }

        /**
         * <p>
         * The number of storage servers to activate for this Exadata infrastructure. Valid values for this parameter
         * depend on the shape. To get information about the minimum and maximum values, use the
         * <code>ListDbSystemShapes</code> operation.
         * </p>
         * 
         * @param storageCount
         *        The number of storage servers to activate for this Exadata infrastructure. Valid values for this
         *        parameter depend on the shape. To get information about the minimum and maximum values, use the
         *        <code>ListDbSystemShapes</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageCount(Integer storageCount);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't
         * specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for
         * the request to ensure idempotency. The client token is valid for up to 24 hours after it's first used.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you
         *        don't specify a client token, the Amazon Web Services SDK automatically generates a client token and
         *        uses it for the request to ensure idempotency. The client token is valid for up to 24 hours after it's
         *        first used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The database server model type of the Exadata infrastructure. For the list of valid model names, use the
         * <code>ListDbSystemShapes</code> operation.
         * </p>
         * 
         * @param databaseServerType
         *        The database server model type of the Exadata infrastructure. For the list of valid model names, use
         *        the <code>ListDbSystemShapes</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseServerType(String databaseServerType);

        /**
         * <p>
         * The storage server model type of the Exadata infrastructure. For the list of valid model names, use the
         * <code>ListDbSystemShapes</code> operation.
         * </p>
         * 
         * @param storageServerType
         *        The storage server model type of the Exadata infrastructure. For the list of valid model names, use
         *        the <code>ListDbSystemShapes</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageServerType(String storageServerType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OdbRequest.BuilderImpl implements Builder {
        private String displayName;

        private String shape;

        private String availabilityZone;

        private String availabilityZoneId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Integer computeCount;

        private List<CustomerContact> customerContactsToSendToOCI = DefaultSdkAutoConstructList.getInstance();

        private MaintenanceWindow maintenanceWindow;

        private Integer storageCount;

        private String clientToken;

        private String databaseServerType;

        private String storageServerType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCloudExadataInfrastructureRequest model) {
            super(model);
            displayName(model.displayName);
            shape(model.shape);
            availabilityZone(model.availabilityZone);
            availabilityZoneId(model.availabilityZoneId);
            tags(model.tags);
            computeCount(model.computeCount);
            customerContactsToSendToOCI(model.customerContactsToSendToOCI);
            maintenanceWindow(model.maintenanceWindow);
            storageCount(model.storageCount);
            clientToken(model.clientToken);
            databaseServerType(model.databaseServerType);
            storageServerType(model.storageServerType);
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getShape() {
            return shape;
        }

        public final void setShape(String shape) {
            this.shape = shape;
        }

        @Override
        public final Builder shape(String shape) {
            this.shape = shape;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
            return this;
        }

        public final Integer getComputeCount() {
            return computeCount;
        }

        public final void setComputeCount(Integer computeCount) {
            this.computeCount = computeCount;
        }

        @Override
        public final Builder computeCount(Integer computeCount) {
            this.computeCount = computeCount;
            return this;
        }

        public final List<CustomerContact.Builder> getCustomerContactsToSendToOCI() {
            List<CustomerContact.Builder> result = CustomerContactsCopier.copyToBuilder(this.customerContactsToSendToOCI);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomerContactsToSendToOCI(Collection<CustomerContact.BuilderImpl> customerContactsToSendToOCI) {
            this.customerContactsToSendToOCI = CustomerContactsCopier.copyFromBuilder(customerContactsToSendToOCI);
        }

        @Override
        public final Builder customerContactsToSendToOCI(Collection<CustomerContact> customerContactsToSendToOCI) {
            this.customerContactsToSendToOCI = CustomerContactsCopier.copy(customerContactsToSendToOCI);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerContactsToSendToOCI(CustomerContact... customerContactsToSendToOCI) {
            customerContactsToSendToOCI(Arrays.asList(customerContactsToSendToOCI));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerContactsToSendToOCI(Consumer<CustomerContact.Builder>... customerContactsToSendToOCI) {
            customerContactsToSendToOCI(Stream.of(customerContactsToSendToOCI)
                    .map(c -> CustomerContact.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final MaintenanceWindow.Builder getMaintenanceWindow() {
            return maintenanceWindow != null ? maintenanceWindow.toBuilder() : null;
        }

        public final void setMaintenanceWindow(MaintenanceWindow.BuilderImpl maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow != null ? maintenanceWindow.build() : null;
        }

        @Override
        public final Builder maintenanceWindow(MaintenanceWindow maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            return this;
        }

        public final Integer getStorageCount() {
            return storageCount;
        }

        public final void setStorageCount(Integer storageCount) {
            this.storageCount = storageCount;
        }

        @Override
        public final Builder storageCount(Integer storageCount) {
            this.storageCount = storageCount;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDatabaseServerType() {
            return databaseServerType;
        }

        public final void setDatabaseServerType(String databaseServerType) {
            this.databaseServerType = databaseServerType;
        }

        @Override
        public final Builder databaseServerType(String databaseServerType) {
            this.databaseServerType = databaseServerType;
            return this;
        }

        public final String getStorageServerType() {
            return storageServerType;
        }

        public final void setStorageServerType(String storageServerType) {
            this.storageServerType = storageServerType;
        }

        @Override
        public final Builder storageServerType(String storageServerType) {
            this.storageServerType = storageServerType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCloudExadataInfrastructureRequest build() {
            return new CreateCloudExadataInfrastructureRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
