/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCloudExadataInfrastructureResponse extends OdbResponse implements
        ToCopyableBuilder<GetCloudExadataInfrastructureResponse.Builder, GetCloudExadataInfrastructureResponse> {
    private static final SdkField<CloudExadataInfrastructure> CLOUD_EXADATA_INFRASTRUCTURE_FIELD = SdkField
            .<CloudExadataInfrastructure> builder(MarshallingType.SDK_POJO)
            .memberName("cloudExadataInfrastructure")
            .getter(getter(GetCloudExadataInfrastructureResponse::cloudExadataInfrastructure))
            .setter(setter(Builder::cloudExadataInfrastructure))
            .constructor(CloudExadataInfrastructure::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudExadataInfrastructure").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CLOUD_EXADATA_INFRASTRUCTURE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final CloudExadataInfrastructure cloudExadataInfrastructure;

    private GetCloudExadataInfrastructureResponse(BuilderImpl builder) {
        super(builder);
        this.cloudExadataInfrastructure = builder.cloudExadataInfrastructure;
    }

    /**
     * <p>
     * The Exadata infrastructure.
     * </p>
     * 
     * @return The Exadata infrastructure.
     */
    public final CloudExadataInfrastructure cloudExadataInfrastructure() {
        return cloudExadataInfrastructure;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cloudExadataInfrastructure());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCloudExadataInfrastructureResponse)) {
            return false;
        }
        GetCloudExadataInfrastructureResponse other = (GetCloudExadataInfrastructureResponse) obj;
        return Objects.equals(cloudExadataInfrastructure(), other.cloudExadataInfrastructure());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCloudExadataInfrastructureResponse")
                .add("CloudExadataInfrastructure", cloudExadataInfrastructure()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudExadataInfrastructure":
            return Optional.ofNullable(clazz.cast(cloudExadataInfrastructure()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cloudExadataInfrastructure", CLOUD_EXADATA_INFRASTRUCTURE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCloudExadataInfrastructureResponse, T> g) {
        return obj -> g.apply((GetCloudExadataInfrastructureResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OdbResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCloudExadataInfrastructureResponse> {
        /**
         * <p>
         * The Exadata infrastructure.
         * </p>
         * 
         * @param cloudExadataInfrastructure
         *        The Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudExadataInfrastructure(CloudExadataInfrastructure cloudExadataInfrastructure);

        /**
         * <p>
         * The Exadata infrastructure.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudExadataInfrastructure.Builder}
         * avoiding the need to create one manually via {@link CloudExadataInfrastructure#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudExadataInfrastructure.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudExadataInfrastructure(CloudExadataInfrastructure)}.
         * 
         * @param cloudExadataInfrastructure
         *        a consumer that will call methods on {@link CloudExadataInfrastructure.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudExadataInfrastructure(CloudExadataInfrastructure)
         */
        default Builder cloudExadataInfrastructure(Consumer<CloudExadataInfrastructure.Builder> cloudExadataInfrastructure) {
            return cloudExadataInfrastructure(CloudExadataInfrastructure.builder().applyMutation(cloudExadataInfrastructure)
                    .build());
        }
    }

    static final class BuilderImpl extends OdbResponse.BuilderImpl implements Builder {
        private CloudExadataInfrastructure cloudExadataInfrastructure;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCloudExadataInfrastructureResponse model) {
            super(model);
            cloudExadataInfrastructure(model.cloudExadataInfrastructure);
        }

        public final CloudExadataInfrastructure.Builder getCloudExadataInfrastructure() {
            return cloudExadataInfrastructure != null ? cloudExadataInfrastructure.toBuilder() : null;
        }

        public final void setCloudExadataInfrastructure(CloudExadataInfrastructure.BuilderImpl cloudExadataInfrastructure) {
            this.cloudExadataInfrastructure = cloudExadataInfrastructure != null ? cloudExadataInfrastructure.build() : null;
        }

        @Override
        public final Builder cloudExadataInfrastructure(CloudExadataInfrastructure cloudExadataInfrastructure) {
            this.cloudExadataInfrastructure = cloudExadataInfrastructure;
            return this;
        }

        @Override
        public GetCloudExadataInfrastructureResponse build() {
            return new GetCloudExadataInfrastructureResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
