/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOdbNetworksResponse extends OdbResponse implements
        ToCopyableBuilder<ListOdbNetworksResponse.Builder, ListOdbNetworksResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListOdbNetworksResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<OdbNetworkSummary>> ODB_NETWORKS_FIELD = SdkField
            .<List<OdbNetworkSummary>> builder(MarshallingType.LIST)
            .memberName("odbNetworks")
            .getter(getter(ListOdbNetworksResponse::odbNetworks))
            .setter(setter(Builder::odbNetworks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("odbNetworks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OdbNetworkSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(OdbNetworkSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            ODB_NETWORKS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<OdbNetworkSummary> odbNetworks;

    private ListOdbNetworksResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.odbNetworks = builder.odbNetworks;
    }

    /**
     * <p>
     * The token to include in another request to get the next page of items. This value is <code>null</code> when there
     * are no more items to return.
     * </p>
     * 
     * @return The token to include in another request to get the next page of items. This value is <code>null</code>
     *         when there are no more items to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the OdbNetworks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOdbNetworks() {
        return odbNetworks != null && !(odbNetworks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of ODB networks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOdbNetworks} method.
     * </p>
     * 
     * @return The list of ODB networks.
     */
    public final List<OdbNetworkSummary> odbNetworks() {
        return odbNetworks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasOdbNetworks() ? odbNetworks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOdbNetworksResponse)) {
            return false;
        }
        ListOdbNetworksResponse other = (ListOdbNetworksResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasOdbNetworks() == other.hasOdbNetworks()
                && Objects.equals(odbNetworks(), other.odbNetworks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListOdbNetworksResponse").add("NextToken", nextToken())
                .add("OdbNetworks", hasOdbNetworks() ? odbNetworks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "odbNetworks":
            return Optional.ofNullable(clazz.cast(odbNetworks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("odbNetworks", ODB_NETWORKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListOdbNetworksResponse, T> g) {
        return obj -> g.apply((ListOdbNetworksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OdbResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListOdbNetworksResponse> {
        /**
         * <p>
         * The token to include in another request to get the next page of items. This value is <code>null</code> when
         * there are no more items to return.
         * </p>
         * 
         * @param nextToken
         *        The token to include in another request to get the next page of items. This value is <code>null</code>
         *        when there are no more items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of ODB networks.
         * </p>
         * 
         * @param odbNetworks
         *        The list of ODB networks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder odbNetworks(Collection<OdbNetworkSummary> odbNetworks);

        /**
         * <p>
         * The list of ODB networks.
         * </p>
         * 
         * @param odbNetworks
         *        The list of ODB networks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder odbNetworks(OdbNetworkSummary... odbNetworks);

        /**
         * <p>
         * The list of ODB networks.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.odb.model.OdbNetworkSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.odb.model.OdbNetworkSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.odb.model.OdbNetworkSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #odbNetworks(List<OdbNetworkSummary>)}.
         * 
         * @param odbNetworks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.odb.model.OdbNetworkSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #odbNetworks(java.util.Collection<OdbNetworkSummary>)
         */
        Builder odbNetworks(Consumer<OdbNetworkSummary.Builder>... odbNetworks);
    }

    static final class BuilderImpl extends OdbResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<OdbNetworkSummary> odbNetworks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListOdbNetworksResponse model) {
            super(model);
            nextToken(model.nextToken);
            odbNetworks(model.odbNetworks);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<OdbNetworkSummary.Builder> getOdbNetworks() {
            List<OdbNetworkSummary.Builder> result = OdbNetworkListCopier.copyToBuilder(this.odbNetworks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOdbNetworks(Collection<OdbNetworkSummary.BuilderImpl> odbNetworks) {
            this.odbNetworks = OdbNetworkListCopier.copyFromBuilder(odbNetworks);
        }

        @Override
        public final Builder odbNetworks(Collection<OdbNetworkSummary> odbNetworks) {
            this.odbNetworks = OdbNetworkListCopier.copy(odbNetworks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder odbNetworks(OdbNetworkSummary... odbNetworks) {
            odbNetworks(Arrays.asList(odbNetworks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder odbNetworks(Consumer<OdbNetworkSummary.Builder>... odbNetworks) {
            odbNetworks(Stream.of(odbNetworks).map(c -> OdbNetworkSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListOdbNetworksResponse build() {
            return new ListOdbNetworksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
