/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSystemVersionsRequest extends OdbRequest implements
        ToCopyableBuilder<ListSystemVersionsRequest.Builder, ListSystemVersionsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListSystemVersionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSystemVersionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> GI_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("giVersion").getter(getter(ListSystemVersionsRequest::giVersion)).setter(setter(Builder::giVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("giVersion").build()).build();

    private static final SdkField<String> SHAPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("shape")
            .getter(getter(ListSystemVersionsRequest::shape)).setter(setter(Builder::shape))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shape").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, GI_VERSION_FIELD, SHAPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer maxResults;

    private final String nextToken;

    private final String giVersion;

    private final String shape;

    private ListSystemVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.giVersion = builder.giVersion;
        this.shape = builder.shape;
    }

    /**
     * <p>
     * The maximum number of items to return for this request. To get the next page of items, make another request with
     * the token returned in the output.
     * </p>
     * <p>
     * Default: <code>10</code>
     * </p>
     * 
     * @return The maximum number of items to return for this request. To get the next page of items, make another
     *         request with the token returned in the output.</p>
     *         <p>
     *         Default: <code>10</code>
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token returned from a previous paginated request. Pagination continues from the end of the items returned by
     * the previous request.
     * </p>
     * 
     * @return The token returned from a previous paginated request. Pagination continues from the end of the items
     *         returned by the previous request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The software version of the Exadata Grid Infrastructure (GI).
     * </p>
     * 
     * @return The software version of the Exadata Grid Infrastructure (GI).
     */
    public final String giVersion() {
        return giVersion;
    }

    /**
     * <p>
     * The Exadata hardware system model.
     * </p>
     * 
     * @return The Exadata hardware system model.
     */
    public final String shape() {
        return shape;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(giVersion());
        hashCode = 31 * hashCode + Objects.hashCode(shape());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSystemVersionsRequest)) {
            return false;
        }
        ListSystemVersionsRequest other = (ListSystemVersionsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(giVersion(), other.giVersion()) && Objects.equals(shape(), other.shape());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSystemVersionsRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("GiVersion", giVersion()).add("Shape", shape()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "giVersion":
            return Optional.ofNullable(clazz.cast(giVersion()));
        case "shape":
            return Optional.ofNullable(clazz.cast(shape()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("giVersion", GI_VERSION_FIELD);
        map.put("shape", SHAPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSystemVersionsRequest, T> g) {
        return obj -> g.apply((ListSystemVersionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OdbRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListSystemVersionsRequest> {
        /**
         * <p>
         * The maximum number of items to return for this request. To get the next page of items, make another request
         * with the token returned in the output.
         * </p>
         * <p>
         * Default: <code>10</code>
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this request. To get the next page of items, make another
         *        request with the token returned in the output.</p>
         *        <p>
         *        Default: <code>10</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token returned from a previous paginated request. Pagination continues from the end of the items returned
         * by the previous request.
         * </p>
         * 
         * @param nextToken
         *        The token returned from a previous paginated request. Pagination continues from the end of the items
         *        returned by the previous request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The software version of the Exadata Grid Infrastructure (GI).
         * </p>
         * 
         * @param giVersion
         *        The software version of the Exadata Grid Infrastructure (GI).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder giVersion(String giVersion);

        /**
         * <p>
         * The Exadata hardware system model.
         * </p>
         * 
         * @param shape
         *        The Exadata hardware system model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shape(String shape);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OdbRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String giVersion;

        private String shape;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSystemVersionsRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            giVersion(model.giVersion);
            shape(model.shape);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getGiVersion() {
            return giVersion;
        }

        public final void setGiVersion(String giVersion) {
            this.giVersion = giVersion;
        }

        @Override
        public final Builder giVersion(String giVersion) {
            this.giVersion = giVersion;
            return this;
        }

        public final String getShape() {
            return shape;
        }

        public final void setShape(String shape) {
            this.shape = shape;
        }

        @Override
        public final Builder shape(String shape) {
            this.shape = shape;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSystemVersionsRequest build() {
            return new ListSystemVersionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
