/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public enum OciOnboardingStatus {
    NOT_STARTED("NOT_STARTED"),

    PENDING_LINK_GENERATION("PENDING_LINK_GENERATION"),

    PENDING_CUSTOMER_ACTION("PENDING_CUSTOMER_ACTION"),

    PENDING_INITIALIZATION("PENDING_INITIALIZATION"),

    ACTIVATING("ACTIVATING"),

    ACTIVE_IN_HOME_REGION("ACTIVE_IN_HOME_REGION"),

    ACTIVE("ACTIVE"),

    ACTIVE_LIMITED("ACTIVE_LIMITED"),

    FAILED("FAILED"),

    PUBLIC_OFFER_UNSUPPORTED("PUBLIC_OFFER_UNSUPPORTED"),

    SUSPENDED("SUSPENDED"),

    CANCELED("CANCELED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OciOnboardingStatus> VALUE_MAP = EnumUtils.uniqueIndex(OciOnboardingStatus.class,
            OciOnboardingStatus::toString);

    private final String value;

    private OciOnboardingStatus(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return OciOnboardingStatus corresponding to the value
     */
    public static OciOnboardingStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link OciOnboardingStatus}s
     */
    public static Set<OciOnboardingStatus> knownValues() {
        Set<OciOnboardingStatus> knownValues = EnumSet.allOf(OciOnboardingStatus.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
