/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateOdbPeeringConnectionRequest extends OdbRequest implements
        ToCopyableBuilder<UpdateOdbPeeringConnectionRequest.Builder, UpdateOdbPeeringConnectionRequest> {
    private static final SdkField<String> ODB_PEERING_CONNECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("odbPeeringConnectionId").getter(getter(UpdateOdbPeeringConnectionRequest::odbPeeringConnectionId))
            .setter(setter(Builder::odbPeeringConnectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("odbPeeringConnectionId").build())
            .build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(UpdateOdbPeeringConnectionRequest::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<List<String>> PEER_NETWORK_CIDRS_TO_BE_ADDED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("peerNetworkCidrsToBeAdded")
            .getter(getter(UpdateOdbPeeringConnectionRequest::peerNetworkCidrsToBeAdded))
            .setter(setter(Builder::peerNetworkCidrsToBeAdded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("peerNetworkCidrsToBeAdded").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PEER_NETWORK_CIDRS_TO_BE_REMOVED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("peerNetworkCidrsToBeRemoved")
            .getter(getter(UpdateOdbPeeringConnectionRequest::peerNetworkCidrsToBeRemoved))
            .setter(setter(Builder::peerNetworkCidrsToBeRemoved))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("peerNetworkCidrsToBeRemoved")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ODB_PEERING_CONNECTION_ID_FIELD, DISPLAY_NAME_FIELD, PEER_NETWORK_CIDRS_TO_BE_ADDED_FIELD,
            PEER_NETWORK_CIDRS_TO_BE_REMOVED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String odbPeeringConnectionId;

    private final String displayName;

    private final List<String> peerNetworkCidrsToBeAdded;

    private final List<String> peerNetworkCidrsToBeRemoved;

    private UpdateOdbPeeringConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.odbPeeringConnectionId = builder.odbPeeringConnectionId;
        this.displayName = builder.displayName;
        this.peerNetworkCidrsToBeAdded = builder.peerNetworkCidrsToBeAdded;
        this.peerNetworkCidrsToBeRemoved = builder.peerNetworkCidrsToBeRemoved;
    }

    /**
     * <p>
     * The identifier of the Oracle Database@Amazon Web Services peering connection to update.
     * </p>
     * 
     * @return The identifier of the Oracle Database@Amazon Web Services peering connection to update.
     */
    public final String odbPeeringConnectionId() {
        return odbPeeringConnectionId;
    }

    /**
     * <p>
     * A new display name for the peering connection.
     * </p>
     * 
     * @return A new display name for the peering connection.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * For responses, this returns true if the service returned a value for the PeerNetworkCidrsToBeAdded property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPeerNetworkCidrsToBeAdded() {
        return peerNetworkCidrsToBeAdded != null && !(peerNetworkCidrsToBeAdded instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of CIDR blocks to add to the peering connection. These CIDR blocks define the IP address ranges that can
     * communicate through the peering connection. The CIDR blocks must not overlap with existing CIDR blocks in the
     * Oracle Database@Amazon Web Services network.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPeerNetworkCidrsToBeAdded} method.
     * </p>
     * 
     * @return A list of CIDR blocks to add to the peering connection. These CIDR blocks define the IP address ranges
     *         that can communicate through the peering connection. The CIDR blocks must not overlap with existing CIDR
     *         blocks in the Oracle Database@Amazon Web Services network.
     */
    public final List<String> peerNetworkCidrsToBeAdded() {
        return peerNetworkCidrsToBeAdded;
    }

    /**
     * For responses, this returns true if the service returned a value for the PeerNetworkCidrsToBeRemoved property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPeerNetworkCidrsToBeRemoved() {
        return peerNetworkCidrsToBeRemoved != null && !(peerNetworkCidrsToBeRemoved instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of CIDR blocks to remove from the peering connection. The CIDR blocks must currently exist in the peering
     * connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPeerNetworkCidrsToBeRemoved} method.
     * </p>
     * 
     * @return A list of CIDR blocks to remove from the peering connection. The CIDR blocks must currently exist in the
     *         peering connection.
     */
    public final List<String> peerNetworkCidrsToBeRemoved() {
        return peerNetworkCidrsToBeRemoved;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(odbPeeringConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(hasPeerNetworkCidrsToBeAdded() ? peerNetworkCidrsToBeAdded() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPeerNetworkCidrsToBeRemoved() ? peerNetworkCidrsToBeRemoved() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOdbPeeringConnectionRequest)) {
            return false;
        }
        UpdateOdbPeeringConnectionRequest other = (UpdateOdbPeeringConnectionRequest) obj;
        return Objects.equals(odbPeeringConnectionId(), other.odbPeeringConnectionId())
                && Objects.equals(displayName(), other.displayName())
                && hasPeerNetworkCidrsToBeAdded() == other.hasPeerNetworkCidrsToBeAdded()
                && Objects.equals(peerNetworkCidrsToBeAdded(), other.peerNetworkCidrsToBeAdded())
                && hasPeerNetworkCidrsToBeRemoved() == other.hasPeerNetworkCidrsToBeRemoved()
                && Objects.equals(peerNetworkCidrsToBeRemoved(), other.peerNetworkCidrsToBeRemoved());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateOdbPeeringConnectionRequest").add("OdbPeeringConnectionId", odbPeeringConnectionId())
                .add("DisplayName", displayName())
                .add("PeerNetworkCidrsToBeAdded", hasPeerNetworkCidrsToBeAdded() ? peerNetworkCidrsToBeAdded() : null)
                .add("PeerNetworkCidrsToBeRemoved", hasPeerNetworkCidrsToBeRemoved() ? peerNetworkCidrsToBeRemoved() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "odbPeeringConnectionId":
            return Optional.ofNullable(clazz.cast(odbPeeringConnectionId()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "peerNetworkCidrsToBeAdded":
            return Optional.ofNullable(clazz.cast(peerNetworkCidrsToBeAdded()));
        case "peerNetworkCidrsToBeRemoved":
            return Optional.ofNullable(clazz.cast(peerNetworkCidrsToBeRemoved()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("odbPeeringConnectionId", ODB_PEERING_CONNECTION_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("peerNetworkCidrsToBeAdded", PEER_NETWORK_CIDRS_TO_BE_ADDED_FIELD);
        map.put("peerNetworkCidrsToBeRemoved", PEER_NETWORK_CIDRS_TO_BE_REMOVED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateOdbPeeringConnectionRequest, T> g) {
        return obj -> g.apply((UpdateOdbPeeringConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OdbRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateOdbPeeringConnectionRequest> {
        /**
         * <p>
         * The identifier of the Oracle Database@Amazon Web Services peering connection to update.
         * </p>
         * 
         * @param odbPeeringConnectionId
         *        The identifier of the Oracle Database@Amazon Web Services peering connection to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder odbPeeringConnectionId(String odbPeeringConnectionId);

        /**
         * <p>
         * A new display name for the peering connection.
         * </p>
         * 
         * @param displayName
         *        A new display name for the peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * A list of CIDR blocks to add to the peering connection. These CIDR blocks define the IP address ranges that
         * can communicate through the peering connection. The CIDR blocks must not overlap with existing CIDR blocks in
         * the Oracle Database@Amazon Web Services network.
         * </p>
         * 
         * @param peerNetworkCidrsToBeAdded
         *        A list of CIDR blocks to add to the peering connection. These CIDR blocks define the IP address ranges
         *        that can communicate through the peering connection. The CIDR blocks must not overlap with existing
         *        CIDR blocks in the Oracle Database@Amazon Web Services network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerNetworkCidrsToBeAdded(Collection<String> peerNetworkCidrsToBeAdded);

        /**
         * <p>
         * A list of CIDR blocks to add to the peering connection. These CIDR blocks define the IP address ranges that
         * can communicate through the peering connection. The CIDR blocks must not overlap with existing CIDR blocks in
         * the Oracle Database@Amazon Web Services network.
         * </p>
         * 
         * @param peerNetworkCidrsToBeAdded
         *        A list of CIDR blocks to add to the peering connection. These CIDR blocks define the IP address ranges
         *        that can communicate through the peering connection. The CIDR blocks must not overlap with existing
         *        CIDR blocks in the Oracle Database@Amazon Web Services network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerNetworkCidrsToBeAdded(String... peerNetworkCidrsToBeAdded);

        /**
         * <p>
         * A list of CIDR blocks to remove from the peering connection. The CIDR blocks must currently exist in the
         * peering connection.
         * </p>
         * 
         * @param peerNetworkCidrsToBeRemoved
         *        A list of CIDR blocks to remove from the peering connection. The CIDR blocks must currently exist in
         *        the peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerNetworkCidrsToBeRemoved(Collection<String> peerNetworkCidrsToBeRemoved);

        /**
         * <p>
         * A list of CIDR blocks to remove from the peering connection. The CIDR blocks must currently exist in the
         * peering connection.
         * </p>
         * 
         * @param peerNetworkCidrsToBeRemoved
         *        A list of CIDR blocks to remove from the peering connection. The CIDR blocks must currently exist in
         *        the peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerNetworkCidrsToBeRemoved(String... peerNetworkCidrsToBeRemoved);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OdbRequest.BuilderImpl implements Builder {
        private String odbPeeringConnectionId;

        private String displayName;

        private List<String> peerNetworkCidrsToBeAdded = DefaultSdkAutoConstructList.getInstance();

        private List<String> peerNetworkCidrsToBeRemoved = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOdbPeeringConnectionRequest model) {
            super(model);
            odbPeeringConnectionId(model.odbPeeringConnectionId);
            displayName(model.displayName);
            peerNetworkCidrsToBeAdded(model.peerNetworkCidrsToBeAdded);
            peerNetworkCidrsToBeRemoved(model.peerNetworkCidrsToBeRemoved);
        }

        public final String getOdbPeeringConnectionId() {
            return odbPeeringConnectionId;
        }

        public final void setOdbPeeringConnectionId(String odbPeeringConnectionId) {
            this.odbPeeringConnectionId = odbPeeringConnectionId;
        }

        @Override
        public final Builder odbPeeringConnectionId(String odbPeeringConnectionId) {
            this.odbPeeringConnectionId = odbPeeringConnectionId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Collection<String> getPeerNetworkCidrsToBeAdded() {
            if (peerNetworkCidrsToBeAdded instanceof SdkAutoConstructList) {
                return null;
            }
            return peerNetworkCidrsToBeAdded;
        }

        public final void setPeerNetworkCidrsToBeAdded(Collection<String> peerNetworkCidrsToBeAdded) {
            this.peerNetworkCidrsToBeAdded = PeeredCidrListCopier.copy(peerNetworkCidrsToBeAdded);
        }

        @Override
        public final Builder peerNetworkCidrsToBeAdded(Collection<String> peerNetworkCidrsToBeAdded) {
            this.peerNetworkCidrsToBeAdded = PeeredCidrListCopier.copy(peerNetworkCidrsToBeAdded);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder peerNetworkCidrsToBeAdded(String... peerNetworkCidrsToBeAdded) {
            peerNetworkCidrsToBeAdded(Arrays.asList(peerNetworkCidrsToBeAdded));
            return this;
        }

        public final Collection<String> getPeerNetworkCidrsToBeRemoved() {
            if (peerNetworkCidrsToBeRemoved instanceof SdkAutoConstructList) {
                return null;
            }
            return peerNetworkCidrsToBeRemoved;
        }

        public final void setPeerNetworkCidrsToBeRemoved(Collection<String> peerNetworkCidrsToBeRemoved) {
            this.peerNetworkCidrsToBeRemoved = PeeredCidrListCopier.copy(peerNetworkCidrsToBeRemoved);
        }

        @Override
        public final Builder peerNetworkCidrsToBeRemoved(Collection<String> peerNetworkCidrsToBeRemoved) {
            this.peerNetworkCidrsToBeRemoved = PeeredCidrListCopier.copy(peerNetworkCidrsToBeRemoved);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder peerNetworkCidrsToBeRemoved(String... peerNetworkCidrsToBeRemoved) {
            peerNetworkCidrsToBeRemoved(Arrays.asList(peerNetworkCidrsToBeRemoved));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateOdbPeeringConnectionRequest build() {
            return new UpdateOdbPeeringConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
