/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetReferenceImportJobResponse extends OmicsResponse implements
        ToCopyableBuilder<GetReferenceImportJobResponse.Builder, GetReferenceImportJobResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetReferenceImportJobResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> REFERENCE_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("referenceStoreId").getter(getter(GetReferenceImportJobResponse::referenceStoreId))
            .setter(setter(Builder::referenceStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceStoreId").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(GetReferenceImportJobResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetReferenceImportJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(GetReferenceImportJobResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(GetReferenceImportJobResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("completionTime")
            .getter(getter(GetReferenceImportJobResponse::completionTime))
            .setter(setter(Builder::completionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completionTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<List<ImportReferenceSourceItem>> SOURCES_FIELD = SdkField
            .<List<ImportReferenceSourceItem>> builder(MarshallingType.LIST)
            .memberName("sources")
            .getter(getter(GetReferenceImportJobResponse::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImportReferenceSourceItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImportReferenceSourceItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            REFERENCE_STORE_ID_FIELD, ROLE_ARN_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, CREATION_TIME_FIELD,
            COMPLETION_TIME_FIELD, SOURCES_FIELD));

    private final String id;

    private final String referenceStoreId;

    private final String roleArn;

    private final String status;

    private final String statusMessage;

    private final Instant creationTime;

    private final Instant completionTime;

    private final List<ImportReferenceSourceItem> sources;

    private GetReferenceImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.referenceStoreId = builder.referenceStoreId;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.creationTime = builder.creationTime;
        this.completionTime = builder.completionTime;
        this.sources = builder.sources;
    }

    /**
     * <p>
     * The job's ID.
     * </p>
     * 
     * @return The job's ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The job's reference store ID.
     * </p>
     * 
     * @return The job's reference store ID.
     */
    public final String referenceStoreId() {
        return referenceStoreId;
    }

    /**
     * <p>
     * The job's service role ARN.
     * </p>
     * 
     * @return The job's service role ARN.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The job's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReferenceImportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The job's status.
     * @see ReferenceImportJobStatus
     */
    public final ReferenceImportJobStatus status() {
        return ReferenceImportJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The job's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReferenceImportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The job's status.
     * @see ReferenceImportJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The job's status message.
     * </p>
     * 
     * @return The job's status message.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * When the job was created.
     * </p>
     * 
     * @return When the job was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * When the job completed.
     * </p>
     * 
     * @return When the job completed.
     */
    public final Instant completionTime() {
        return completionTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The job's source files.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSources} method.
     * </p>
     * 
     * @return The job's source files.
     */
    public final List<ImportReferenceSourceItem> sources() {
        return sources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(referenceStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReferenceImportJobResponse)) {
            return false;
        }
        GetReferenceImportJobResponse other = (GetReferenceImportJobResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(referenceStoreId(), other.referenceStoreId())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(completionTime(), other.completionTime()) && hasSources() == other.hasSources()
                && Objects.equals(sources(), other.sources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetReferenceImportJobResponse").add("Id", id()).add("ReferenceStoreId", referenceStoreId())
                .add("RoleArn", roleArn()).add("Status", statusAsString()).add("StatusMessage", statusMessage())
                .add("CreationTime", creationTime()).add("CompletionTime", completionTime())
                .add("Sources", hasSources() ? sources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "referenceStoreId":
            return Optional.ofNullable(clazz.cast(referenceStoreId()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "completionTime":
            return Optional.ofNullable(clazz.cast(completionTime()));
        case "sources":
            return Optional.ofNullable(clazz.cast(sources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReferenceImportJobResponse, T> g) {
        return obj -> g.apply((GetReferenceImportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetReferenceImportJobResponse> {
        /**
         * <p>
         * The job's ID.
         * </p>
         * 
         * @param id
         *        The job's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The job's reference store ID.
         * </p>
         * 
         * @param referenceStoreId
         *        The job's reference store ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceStoreId(String referenceStoreId);

        /**
         * <p>
         * The job's service role ARN.
         * </p>
         * 
         * @param roleArn
         *        The job's service role ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The job's status.
         * </p>
         * 
         * @param status
         *        The job's status.
         * @see ReferenceImportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReferenceImportJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The job's status.
         * </p>
         * 
         * @param status
         *        The job's status.
         * @see ReferenceImportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReferenceImportJobStatus
         */
        Builder status(ReferenceImportJobStatus status);

        /**
         * <p>
         * The job's status message.
         * </p>
         * 
         * @param statusMessage
         *        The job's status message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * When the job was created.
         * </p>
         * 
         * @param creationTime
         *        When the job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * When the job completed.
         * </p>
         * 
         * @param completionTime
         *        When the job completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTime(Instant completionTime);

        /**
         * <p>
         * The job's source files.
         * </p>
         * 
         * @param sources
         *        The job's source files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<ImportReferenceSourceItem> sources);

        /**
         * <p>
         * The job's source files.
         * </p>
         * 
         * @param sources
         *        The job's source files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(ImportReferenceSourceItem... sources);

        /**
         * <p>
         * The job's source files.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.omics.model.ImportReferenceSourceItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.omics.model.ImportReferenceSourceItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.omics.model.ImportReferenceSourceItem.Builder#build()} is called
         * immediately and its result is passed to {@link #sources(List<ImportReferenceSourceItem>)}.
         * 
         * @param sources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.omics.model.ImportReferenceSourceItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(java.util.Collection<ImportReferenceSourceItem>)
         */
        Builder sources(Consumer<ImportReferenceSourceItem.Builder>... sources);
    }

    static final class BuilderImpl extends OmicsResponse.BuilderImpl implements Builder {
        private String id;

        private String referenceStoreId;

        private String roleArn;

        private String status;

        private String statusMessage;

        private Instant creationTime;

        private Instant completionTime;

        private List<ImportReferenceSourceItem> sources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetReferenceImportJobResponse model) {
            super(model);
            id(model.id);
            referenceStoreId(model.referenceStoreId);
            roleArn(model.roleArn);
            status(model.status);
            statusMessage(model.statusMessage);
            creationTime(model.creationTime);
            completionTime(model.completionTime);
            sources(model.sources);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getReferenceStoreId() {
            return referenceStoreId;
        }

        public final void setReferenceStoreId(String referenceStoreId) {
            this.referenceStoreId = referenceStoreId;
        }

        @Override
        public final Builder referenceStoreId(String referenceStoreId) {
            this.referenceStoreId = referenceStoreId;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReferenceImportJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final List<ImportReferenceSourceItem.Builder> getSources() {
            List<ImportReferenceSourceItem.Builder> result = ImportReferenceSourceListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<ImportReferenceSourceItem.BuilderImpl> sources) {
            this.sources = ImportReferenceSourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<ImportReferenceSourceItem> sources) {
            this.sources = ImportReferenceSourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(ImportReferenceSourceItem... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<ImportReferenceSourceItem.Builder>... sources) {
            sources(Stream.of(sources).map(c -> ImportReferenceSourceItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetReferenceImportJobResponse build() {
            return new GetReferenceImportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
