/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.omics.model.BatchDeleteReadSetRequest;
import software.amazon.awssdk.services.omics.model.BatchDeleteReadSetResponse;
import software.amazon.awssdk.services.omics.model.CancelAnnotationImportJobRequest;
import software.amazon.awssdk.services.omics.model.CancelAnnotationImportJobResponse;
import software.amazon.awssdk.services.omics.model.CancelRunRequest;
import software.amazon.awssdk.services.omics.model.CancelRunResponse;
import software.amazon.awssdk.services.omics.model.CancelVariantImportJobRequest;
import software.amazon.awssdk.services.omics.model.CancelVariantImportJobResponse;
import software.amazon.awssdk.services.omics.model.CreateAnnotationStoreRequest;
import software.amazon.awssdk.services.omics.model.CreateAnnotationStoreResponse;
import software.amazon.awssdk.services.omics.model.CreateReferenceStoreRequest;
import software.amazon.awssdk.services.omics.model.CreateReferenceStoreResponse;
import software.amazon.awssdk.services.omics.model.CreateRunGroupRequest;
import software.amazon.awssdk.services.omics.model.CreateRunGroupResponse;
import software.amazon.awssdk.services.omics.model.CreateSequenceStoreRequest;
import software.amazon.awssdk.services.omics.model.CreateSequenceStoreResponse;
import software.amazon.awssdk.services.omics.model.CreateVariantStoreRequest;
import software.amazon.awssdk.services.omics.model.CreateVariantStoreResponse;
import software.amazon.awssdk.services.omics.model.CreateWorkflowRequest;
import software.amazon.awssdk.services.omics.model.CreateWorkflowResponse;
import software.amazon.awssdk.services.omics.model.DeleteAnnotationStoreRequest;
import software.amazon.awssdk.services.omics.model.DeleteAnnotationStoreResponse;
import software.amazon.awssdk.services.omics.model.DeleteReferenceRequest;
import software.amazon.awssdk.services.omics.model.DeleteReferenceResponse;
import software.amazon.awssdk.services.omics.model.DeleteReferenceStoreRequest;
import software.amazon.awssdk.services.omics.model.DeleteReferenceStoreResponse;
import software.amazon.awssdk.services.omics.model.DeleteRunGroupRequest;
import software.amazon.awssdk.services.omics.model.DeleteRunGroupResponse;
import software.amazon.awssdk.services.omics.model.DeleteRunRequest;
import software.amazon.awssdk.services.omics.model.DeleteRunResponse;
import software.amazon.awssdk.services.omics.model.DeleteSequenceStoreRequest;
import software.amazon.awssdk.services.omics.model.DeleteSequenceStoreResponse;
import software.amazon.awssdk.services.omics.model.DeleteVariantStoreRequest;
import software.amazon.awssdk.services.omics.model.DeleteVariantStoreResponse;
import software.amazon.awssdk.services.omics.model.DeleteWorkflowRequest;
import software.amazon.awssdk.services.omics.model.DeleteWorkflowResponse;
import software.amazon.awssdk.services.omics.model.GetAnnotationImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetAnnotationImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreRequest;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetActivationJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetActivationJobResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetExportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetExportJobResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetMetadataRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetMetadataResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetResponse;
import software.amazon.awssdk.services.omics.model.GetReferenceImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReferenceImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetReferenceMetadataRequest;
import software.amazon.awssdk.services.omics.model.GetReferenceMetadataResponse;
import software.amazon.awssdk.services.omics.model.GetReferenceRequest;
import software.amazon.awssdk.services.omics.model.GetReferenceResponse;
import software.amazon.awssdk.services.omics.model.GetReferenceStoreRequest;
import software.amazon.awssdk.services.omics.model.GetReferenceStoreResponse;
import software.amazon.awssdk.services.omics.model.GetRunGroupRequest;
import software.amazon.awssdk.services.omics.model.GetRunGroupResponse;
import software.amazon.awssdk.services.omics.model.GetRunRequest;
import software.amazon.awssdk.services.omics.model.GetRunResponse;
import software.amazon.awssdk.services.omics.model.GetRunTaskRequest;
import software.amazon.awssdk.services.omics.model.GetRunTaskResponse;
import software.amazon.awssdk.services.omics.model.GetSequenceStoreRequest;
import software.amazon.awssdk.services.omics.model.GetSequenceStoreResponse;
import software.amazon.awssdk.services.omics.model.GetVariantImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetVariantImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetVariantStoreRequest;
import software.amazon.awssdk.services.omics.model.GetVariantStoreResponse;
import software.amazon.awssdk.services.omics.model.GetWorkflowRequest;
import software.amazon.awssdk.services.omics.model.GetWorkflowResponse;
import software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsResponse;
import software.amazon.awssdk.services.omics.model.ListAnnotationStoresRequest;
import software.amazon.awssdk.services.omics.model.ListAnnotationStoresResponse;
import software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsResponse;
import software.amazon.awssdk.services.omics.model.ListReadSetExportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetExportJobsResponse;
import software.amazon.awssdk.services.omics.model.ListReadSetImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetImportJobsResponse;
import software.amazon.awssdk.services.omics.model.ListReadSetsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetsResponse;
import software.amazon.awssdk.services.omics.model.ListReferenceImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReferenceImportJobsResponse;
import software.amazon.awssdk.services.omics.model.ListReferenceStoresRequest;
import software.amazon.awssdk.services.omics.model.ListReferenceStoresResponse;
import software.amazon.awssdk.services.omics.model.ListReferencesRequest;
import software.amazon.awssdk.services.omics.model.ListReferencesResponse;
import software.amazon.awssdk.services.omics.model.ListRunGroupsRequest;
import software.amazon.awssdk.services.omics.model.ListRunGroupsResponse;
import software.amazon.awssdk.services.omics.model.ListRunTasksRequest;
import software.amazon.awssdk.services.omics.model.ListRunTasksResponse;
import software.amazon.awssdk.services.omics.model.ListRunsRequest;
import software.amazon.awssdk.services.omics.model.ListRunsResponse;
import software.amazon.awssdk.services.omics.model.ListSequenceStoresRequest;
import software.amazon.awssdk.services.omics.model.ListSequenceStoresResponse;
import software.amazon.awssdk.services.omics.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.omics.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.omics.model.ListVariantImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListVariantImportJobsResponse;
import software.amazon.awssdk.services.omics.model.ListVariantStoresRequest;
import software.amazon.awssdk.services.omics.model.ListVariantStoresResponse;
import software.amazon.awssdk.services.omics.model.ListWorkflowsRequest;
import software.amazon.awssdk.services.omics.model.ListWorkflowsResponse;
import software.amazon.awssdk.services.omics.model.StartAnnotationImportJobRequest;
import software.amazon.awssdk.services.omics.model.StartAnnotationImportJobResponse;
import software.amazon.awssdk.services.omics.model.StartReadSetActivationJobRequest;
import software.amazon.awssdk.services.omics.model.StartReadSetActivationJobResponse;
import software.amazon.awssdk.services.omics.model.StartReadSetExportJobRequest;
import software.amazon.awssdk.services.omics.model.StartReadSetExportJobResponse;
import software.amazon.awssdk.services.omics.model.StartReadSetImportJobRequest;
import software.amazon.awssdk.services.omics.model.StartReadSetImportJobResponse;
import software.amazon.awssdk.services.omics.model.StartReferenceImportJobRequest;
import software.amazon.awssdk.services.omics.model.StartReferenceImportJobResponse;
import software.amazon.awssdk.services.omics.model.StartRunRequest;
import software.amazon.awssdk.services.omics.model.StartRunResponse;
import software.amazon.awssdk.services.omics.model.StartVariantImportJobRequest;
import software.amazon.awssdk.services.omics.model.StartVariantImportJobResponse;
import software.amazon.awssdk.services.omics.model.TagResourceRequest;
import software.amazon.awssdk.services.omics.model.TagResourceResponse;
import software.amazon.awssdk.services.omics.model.UntagResourceRequest;
import software.amazon.awssdk.services.omics.model.UntagResourceResponse;
import software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreRequest;
import software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreResponse;
import software.amazon.awssdk.services.omics.model.UpdateRunGroupRequest;
import software.amazon.awssdk.services.omics.model.UpdateRunGroupResponse;
import software.amazon.awssdk.services.omics.model.UpdateVariantStoreRequest;
import software.amazon.awssdk.services.omics.model.UpdateVariantStoreResponse;
import software.amazon.awssdk.services.omics.model.UpdateWorkflowRequest;
import software.amazon.awssdk.services.omics.model.UpdateWorkflowResponse;
import software.amazon.awssdk.services.omics.paginators.ListAnnotationImportJobsPublisher;
import software.amazon.awssdk.services.omics.paginators.ListAnnotationStoresPublisher;
import software.amazon.awssdk.services.omics.paginators.ListReadSetActivationJobsPublisher;
import software.amazon.awssdk.services.omics.paginators.ListReadSetExportJobsPublisher;
import software.amazon.awssdk.services.omics.paginators.ListReadSetImportJobsPublisher;
import software.amazon.awssdk.services.omics.paginators.ListReadSetsPublisher;
import software.amazon.awssdk.services.omics.paginators.ListReferenceImportJobsPublisher;
import software.amazon.awssdk.services.omics.paginators.ListReferenceStoresPublisher;
import software.amazon.awssdk.services.omics.paginators.ListReferencesPublisher;
import software.amazon.awssdk.services.omics.paginators.ListRunGroupsPublisher;
import software.amazon.awssdk.services.omics.paginators.ListRunTasksPublisher;
import software.amazon.awssdk.services.omics.paginators.ListRunsPublisher;
import software.amazon.awssdk.services.omics.paginators.ListSequenceStoresPublisher;
import software.amazon.awssdk.services.omics.paginators.ListVariantImportJobsPublisher;
import software.amazon.awssdk.services.omics.paginators.ListVariantStoresPublisher;
import software.amazon.awssdk.services.omics.paginators.ListWorkflowsPublisher;
import software.amazon.awssdk.services.omics.waiters.OmicsAsyncWaiter;

/**
 * Service client for accessing Amazon Omics asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * This is the <i>Amazon Omics API Reference</i>. For an introduction to the service, see <a
 * href="https://docs.aws.amazon.com/omics/latest/dev/">What is Amazon Omics?</a> in the <i>Amazon Omics Developer
 * Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface OmicsAsyncClient extends AwsClient {
    String SERVICE_NAME = "omics";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "omics";

    /**
     * <p>
     * Deletes one or more read sets.
     * </p>
     *
     * @param batchDeleteReadSetRequest
     * @return A Java Future containing the result of the BatchDeleteReadSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.BatchDeleteReadSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/BatchDeleteReadSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchDeleteReadSetResponse> batchDeleteReadSet(BatchDeleteReadSetRequest batchDeleteReadSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes one or more read sets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteReadSetRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDeleteReadSetRequest#builder()}
     * </p>
     *
     * @param batchDeleteReadSetRequest
     *        A {@link Consumer} that will call methods on {@link BatchDeleteReadSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchDeleteReadSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.BatchDeleteReadSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/BatchDeleteReadSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchDeleteReadSetResponse> batchDeleteReadSet(
            Consumer<BatchDeleteReadSetRequest.Builder> batchDeleteReadSetRequest) {
        return batchDeleteReadSet(BatchDeleteReadSetRequest.builder().applyMutation(batchDeleteReadSetRequest).build());
    }

    /**
     * <p>
     * Cancels an annotation import job.
     * </p>
     *
     * @param cancelAnnotationImportJobRequest
     * @return A Java Future containing the result of the CancelAnnotationImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CancelAnnotationImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CancelAnnotationImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelAnnotationImportJobResponse> cancelAnnotationImportJob(
            CancelAnnotationImportJobRequest cancelAnnotationImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an annotation import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelAnnotationImportJobRequest.Builder} avoiding
     * the need to create one manually via {@link CancelAnnotationImportJobRequest#builder()}
     * </p>
     *
     * @param cancelAnnotationImportJobRequest
     *        A {@link Consumer} that will call methods on {@link CancelAnnotationImportRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelAnnotationImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CancelAnnotationImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CancelAnnotationImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelAnnotationImportJobResponse> cancelAnnotationImportJob(
            Consumer<CancelAnnotationImportJobRequest.Builder> cancelAnnotationImportJobRequest) {
        return cancelAnnotationImportJob(CancelAnnotationImportJobRequest.builder()
                .applyMutation(cancelAnnotationImportJobRequest).build());
    }

    /**
     * <p>
     * Cancels a run.
     * </p>
     *
     * @param cancelRunRequest
     * @return A Java Future containing the result of the CancelRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CancelRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CancelRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelRunResponse> cancelRun(CancelRunRequest cancelRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelRunRequest.Builder} avoiding the need to
     * create one manually via {@link CancelRunRequest#builder()}
     * </p>
     *
     * @param cancelRunRequest
     *        A {@link Consumer} that will call methods on {@link CancelRunRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CancelRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CancelRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CancelRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelRunResponse> cancelRun(Consumer<CancelRunRequest.Builder> cancelRunRequest) {
        return cancelRun(CancelRunRequest.builder().applyMutation(cancelRunRequest).build());
    }

    /**
     * <p>
     * Cancels a variant import job.
     * </p>
     *
     * @param cancelVariantImportJobRequest
     * @return A Java Future containing the result of the CancelVariantImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CancelVariantImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CancelVariantImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelVariantImportJobResponse> cancelVariantImportJob(
            CancelVariantImportJobRequest cancelVariantImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a variant import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelVariantImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link CancelVariantImportJobRequest#builder()}
     * </p>
     *
     * @param cancelVariantImportJobRequest
     *        A {@link Consumer} that will call methods on {@link CancelVariantImportRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelVariantImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CancelVariantImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CancelVariantImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelVariantImportJobResponse> cancelVariantImportJob(
            Consumer<CancelVariantImportJobRequest.Builder> cancelVariantImportJobRequest) {
        return cancelVariantImportJob(CancelVariantImportJobRequest.builder().applyMutation(cancelVariantImportJobRequest)
                .build());
    }

    /**
     * <p>
     * Creates an annotation store.
     * </p>
     *
     * @param createAnnotationStoreRequest
     * @return A Java Future containing the result of the CreateAnnotationStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateAnnotationStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateAnnotationStore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAnnotationStoreResponse> createAnnotationStore(
            CreateAnnotationStoreRequest createAnnotationStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an annotation store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAnnotationStoreRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAnnotationStoreRequest#builder()}
     * </p>
     *
     * @param createAnnotationStoreRequest
     *        A {@link Consumer} that will call methods on {@link CreateAnnotationStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAnnotationStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateAnnotationStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateAnnotationStore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAnnotationStoreResponse> createAnnotationStore(
            Consumer<CreateAnnotationStoreRequest.Builder> createAnnotationStoreRequest) {
        return createAnnotationStore(CreateAnnotationStoreRequest.builder().applyMutation(createAnnotationStoreRequest).build());
    }

    /**
     * <p>
     * Creates a reference store.
     * </p>
     *
     * @param createReferenceStoreRequest
     * @return A Java Future containing the result of the CreateReferenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateReferenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateReferenceStore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateReferenceStoreResponse> createReferenceStore(
            CreateReferenceStoreRequest createReferenceStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a reference store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReferenceStoreRequest.Builder} avoiding the
     * need to create one manually via {@link CreateReferenceStoreRequest#builder()}
     * </p>
     *
     * @param createReferenceStoreRequest
     *        A {@link Consumer} that will call methods on {@link CreateReferenceStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateReferenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateReferenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateReferenceStore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateReferenceStoreResponse> createReferenceStore(
            Consumer<CreateReferenceStoreRequest.Builder> createReferenceStoreRequest) {
        return createReferenceStore(CreateReferenceStoreRequest.builder().applyMutation(createReferenceStoreRequest).build());
    }

    /**
     * <p>
     * Creates a run group.
     * </p>
     *
     * @param createRunGroupRequest
     * @return A Java Future containing the result of the CreateRunGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateRunGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateRunGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRunGroupResponse> createRunGroup(CreateRunGroupRequest createRunGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a run group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRunGroupRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRunGroupRequest#builder()}
     * </p>
     *
     * @param createRunGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateRunGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateRunGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateRunGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateRunGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRunGroupResponse> createRunGroup(Consumer<CreateRunGroupRequest.Builder> createRunGroupRequest) {
        return createRunGroup(CreateRunGroupRequest.builder().applyMutation(createRunGroupRequest).build());
    }

    /**
     * <p>
     * Creates a sequence store.
     * </p>
     *
     * @param createSequenceStoreRequest
     * @return A Java Future containing the result of the CreateSequenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateSequenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateSequenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSequenceStoreResponse> createSequenceStore(
            CreateSequenceStoreRequest createSequenceStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a sequence store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSequenceStoreRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSequenceStoreRequest#builder()}
     * </p>
     *
     * @param createSequenceStoreRequest
     *        A {@link Consumer} that will call methods on {@link CreateSequenceStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSequenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateSequenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateSequenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSequenceStoreResponse> createSequenceStore(
            Consumer<CreateSequenceStoreRequest.Builder> createSequenceStoreRequest) {
        return createSequenceStore(CreateSequenceStoreRequest.builder().applyMutation(createSequenceStoreRequest).build());
    }

    /**
     * <p>
     * Creates a variant store.
     * </p>
     *
     * @param createVariantStoreRequest
     * @return A Java Future containing the result of the CreateVariantStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateVariantStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateVariantStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateVariantStoreResponse> createVariantStore(CreateVariantStoreRequest createVariantStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a variant store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVariantStoreRequest.Builder} avoiding the
     * need to create one manually via {@link CreateVariantStoreRequest#builder()}
     * </p>
     *
     * @param createVariantStoreRequest
     *        A {@link Consumer} that will call methods on {@link CreateVariantStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateVariantStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateVariantStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateVariantStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateVariantStoreResponse> createVariantStore(
            Consumer<CreateVariantStoreRequest.Builder> createVariantStoreRequest) {
        return createVariantStore(CreateVariantStoreRequest.builder().applyMutation(createVariantStoreRequest).build());
    }

    /**
     * <p>
     * Creates a workflow.
     * </p>
     *
     * @param createWorkflowRequest
     * @return A Java Future containing the result of the CreateWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWorkflowResponse> createWorkflow(CreateWorkflowRequest createWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link CreateWorkflowRequest#builder()}
     * </p>
     *
     * @param createWorkflowRequest
     *        A {@link Consumer} that will call methods on {@link CreateWorkflowRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWorkflowResponse> createWorkflow(Consumer<CreateWorkflowRequest.Builder> createWorkflowRequest) {
        return createWorkflow(CreateWorkflowRequest.builder().applyMutation(createWorkflowRequest).build());
    }

    /**
     * <p>
     * Deletes an annotation store.
     * </p>
     *
     * @param deleteAnnotationStoreRequest
     * @return A Java Future containing the result of the DeleteAnnotationStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteAnnotationStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteAnnotationStore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAnnotationStoreResponse> deleteAnnotationStore(
            DeleteAnnotationStoreRequest deleteAnnotationStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an annotation store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAnnotationStoreRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAnnotationStoreRequest#builder()}
     * </p>
     *
     * @param deleteAnnotationStoreRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAnnotationStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAnnotationStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteAnnotationStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteAnnotationStore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAnnotationStoreResponse> deleteAnnotationStore(
            Consumer<DeleteAnnotationStoreRequest.Builder> deleteAnnotationStoreRequest) {
        return deleteAnnotationStore(DeleteAnnotationStoreRequest.builder().applyMutation(deleteAnnotationStoreRequest).build());
    }

    /**
     * <p>
     * Deletes a genome reference.
     * </p>
     *
     * @param deleteReferenceRequest
     * @return A Java Future containing the result of the DeleteReference operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteReference" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteReferenceResponse> deleteReference(DeleteReferenceRequest deleteReferenceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a genome reference.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReferenceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteReferenceRequest#builder()}
     * </p>
     *
     * @param deleteReferenceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteReferenceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteReference operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteReference" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteReferenceResponse> deleteReference(
            Consumer<DeleteReferenceRequest.Builder> deleteReferenceRequest) {
        return deleteReference(DeleteReferenceRequest.builder().applyMutation(deleteReferenceRequest).build());
    }

    /**
     * <p>
     * Deletes a genome reference store.
     * </p>
     *
     * @param deleteReferenceStoreRequest
     * @return A Java Future containing the result of the DeleteReferenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteReferenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteReferenceStore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteReferenceStoreResponse> deleteReferenceStore(
            DeleteReferenceStoreRequest deleteReferenceStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a genome reference store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReferenceStoreRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteReferenceStoreRequest#builder()}
     * </p>
     *
     * @param deleteReferenceStoreRequest
     *        A {@link Consumer} that will call methods on {@link DeleteReferenceStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteReferenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteReferenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteReferenceStore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteReferenceStoreResponse> deleteReferenceStore(
            Consumer<DeleteReferenceStoreRequest.Builder> deleteReferenceStoreRequest) {
        return deleteReferenceStore(DeleteReferenceStoreRequest.builder().applyMutation(deleteReferenceStoreRequest).build());
    }

    /**
     * <p>
     * Deletes a workflow run.
     * </p>
     *
     * @param deleteRunRequest
     * @return A Java Future containing the result of the DeleteRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRunResponse> deleteRun(DeleteRunRequest deleteRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a workflow run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRunRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRunRequest#builder()}
     * </p>
     *
     * @param deleteRunRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRunRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRunResponse> deleteRun(Consumer<DeleteRunRequest.Builder> deleteRunRequest) {
        return deleteRun(DeleteRunRequest.builder().applyMutation(deleteRunRequest).build());
    }

    /**
     * <p>
     * Deletes a workflow run group.
     * </p>
     *
     * @param deleteRunGroupRequest
     * @return A Java Future containing the result of the DeleteRunGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteRunGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteRunGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRunGroupResponse> deleteRunGroup(DeleteRunGroupRequest deleteRunGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a workflow run group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRunGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRunGroupRequest#builder()}
     * </p>
     *
     * @param deleteRunGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRunGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteRunGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteRunGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteRunGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRunGroupResponse> deleteRunGroup(Consumer<DeleteRunGroupRequest.Builder> deleteRunGroupRequest) {
        return deleteRunGroup(DeleteRunGroupRequest.builder().applyMutation(deleteRunGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a sequence store.
     * </p>
     *
     * @param deleteSequenceStoreRequest
     * @return A Java Future containing the result of the DeleteSequenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteSequenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteSequenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSequenceStoreResponse> deleteSequenceStore(
            DeleteSequenceStoreRequest deleteSequenceStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a sequence store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSequenceStoreRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSequenceStoreRequest#builder()}
     * </p>
     *
     * @param deleteSequenceStoreRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSequenceStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSequenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteSequenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteSequenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSequenceStoreResponse> deleteSequenceStore(
            Consumer<DeleteSequenceStoreRequest.Builder> deleteSequenceStoreRequest) {
        return deleteSequenceStore(DeleteSequenceStoreRequest.builder().applyMutation(deleteSequenceStoreRequest).build());
    }

    /**
     * <p>
     * Deletes a variant store.
     * </p>
     *
     * @param deleteVariantStoreRequest
     * @return A Java Future containing the result of the DeleteVariantStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteVariantStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteVariantStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteVariantStoreResponse> deleteVariantStore(DeleteVariantStoreRequest deleteVariantStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a variant store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVariantStoreRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteVariantStoreRequest#builder()}
     * </p>
     *
     * @param deleteVariantStoreRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVariantStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteVariantStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteVariantStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteVariantStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteVariantStoreResponse> deleteVariantStore(
            Consumer<DeleteVariantStoreRequest.Builder> deleteVariantStoreRequest) {
        return deleteVariantStore(DeleteVariantStoreRequest.builder().applyMutation(deleteVariantStoreRequest).build());
    }

    /**
     * <p>
     * Deletes a workflow.
     * </p>
     *
     * @param deleteWorkflowRequest
     * @return A Java Future containing the result of the DeleteWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWorkflowResponse> deleteWorkflow(DeleteWorkflowRequest deleteWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteWorkflowRequest#builder()}
     * </p>
     *
     * @param deleteWorkflowRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWorkflowRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWorkflowResponse> deleteWorkflow(Consumer<DeleteWorkflowRequest.Builder> deleteWorkflowRequest) {
        return deleteWorkflow(DeleteWorkflowRequest.builder().applyMutation(deleteWorkflowRequest).build());
    }

    /**
     * <p>
     * Gets information about an annotation import job.
     * </p>
     *
     * @param getAnnotationImportJobRequest
     * @return A Java Future containing the result of the GetAnnotationImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetAnnotationImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetAnnotationImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAnnotationImportJobResponse> getAnnotationImportJob(
            GetAnnotationImportJobRequest getAnnotationImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an annotation import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAnnotationImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link GetAnnotationImportJobRequest#builder()}
     * </p>
     *
     * @param getAnnotationImportJobRequest
     *        A {@link Consumer} that will call methods on {@link GetAnnotationImportRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAnnotationImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetAnnotationImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetAnnotationImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAnnotationImportJobResponse> getAnnotationImportJob(
            Consumer<GetAnnotationImportJobRequest.Builder> getAnnotationImportJobRequest) {
        return getAnnotationImportJob(GetAnnotationImportJobRequest.builder().applyMutation(getAnnotationImportJobRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about an annotation store.
     * </p>
     *
     * @param getAnnotationStoreRequest
     * @return A Java Future containing the result of the GetAnnotationStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetAnnotationStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetAnnotationStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAnnotationStoreResponse> getAnnotationStore(GetAnnotationStoreRequest getAnnotationStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an annotation store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAnnotationStoreRequest.Builder} avoiding the
     * need to create one manually via {@link GetAnnotationStoreRequest#builder()}
     * </p>
     *
     * @param getAnnotationStoreRequest
     *        A {@link Consumer} that will call methods on {@link GetAnnotationStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAnnotationStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetAnnotationStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetAnnotationStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAnnotationStoreResponse> getAnnotationStore(
            Consumer<GetAnnotationStoreRequest.Builder> getAnnotationStoreRequest) {
        return getAnnotationStore(GetAnnotationStoreRequest.builder().applyMutation(getAnnotationStoreRequest).build());
    }

    /**
     * <p>
     * Gets a file from a read set.
     * </p>
     *
     * @param getReadSetRequest
     * @param asyncResponseTransformer
     *        The response transformer for processing the streaming response in a non-blocking manner. See
     *        {@link AsyncResponseTransformer} for details on how this callback should be implemented and for links to
     *        precanned implementations for common scenarios like downloading to a file. The service documentation for
     *        the response content is as follows '
     *        <p>
     *        The read set file payload.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>RangeNotSatisfiableException The ranges specified in the request are not valid.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReadSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSet" target="_top">AWS API
     *      Documentation</a>
     */
    default <ReturnT> CompletableFuture<ReturnT> getReadSet(GetReadSetRequest getReadSetRequest,
            AsyncResponseTransformer<GetReadSetResponse, ReturnT> asyncResponseTransformer) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a file from a read set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReadSetRequest.Builder} avoiding the need to
     * create one manually via {@link GetReadSetRequest#builder()}
     * </p>
     *
     * @param getReadSetRequest
     *        A {@link Consumer} that will call methods on {@link GetReadSetRequest.Builder} to create a request.
     * @param asyncResponseTransformer
     *        The response transformer for processing the streaming response in a non-blocking manner. See
     *        {@link AsyncResponseTransformer} for details on how this callback should be implemented and for links to
     *        precanned implementations for common scenarios like downloading to a file. The service documentation for
     *        the response content is as follows '
     *        <p>
     *        The read set file payload.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>RangeNotSatisfiableException The ranges specified in the request are not valid.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReadSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSet" target="_top">AWS API
     *      Documentation</a>
     */
    default <ReturnT> CompletableFuture<ReturnT> getReadSet(Consumer<GetReadSetRequest.Builder> getReadSetRequest,
            AsyncResponseTransformer<GetReadSetResponse, ReturnT> asyncResponseTransformer) {
        return getReadSet(GetReadSetRequest.builder().applyMutation(getReadSetRequest).build(), asyncResponseTransformer);
    }

    /**
     * <p>
     * Gets a file from a read set.
     * </p>
     *
     * @param getReadSetRequest
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows '
     *        <p>
     *        The read set file payload.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>RangeNotSatisfiableException The ranges specified in the request are not valid.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReadSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReadSetResponse> getReadSet(GetReadSetRequest getReadSetRequest, Path destinationPath) {
        return getReadSet(getReadSetRequest, AsyncResponseTransformer.toFile(destinationPath));
    }

    /**
     * <p>
     * Gets a file from a read set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReadSetRequest.Builder} avoiding the need to
     * create one manually via {@link GetReadSetRequest#builder()}
     * </p>
     *
     * @param getReadSetRequest
     *        A {@link Consumer} that will call methods on {@link GetReadSetRequest.Builder} to create a request.
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows '
     *        <p>
     *        The read set file payload.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>RangeNotSatisfiableException The ranges specified in the request are not valid.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReadSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReadSetResponse> getReadSet(Consumer<GetReadSetRequest.Builder> getReadSetRequest,
            Path destinationPath) {
        return getReadSet(GetReadSetRequest.builder().applyMutation(getReadSetRequest).build(), destinationPath);
    }

    /**
     * <p>
     * Gets information about a read set activation job.
     * </p>
     *
     * @param getReadSetActivationJobRequest
     * @return A Java Future containing the result of the GetReadSetActivationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReadSetActivationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetActivationJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetReadSetActivationJobResponse> getReadSetActivationJob(
            GetReadSetActivationJobRequest getReadSetActivationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a read set activation job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReadSetActivationJobRequest.Builder} avoiding
     * the need to create one manually via {@link GetReadSetActivationJobRequest#builder()}
     * </p>
     *
     * @param getReadSetActivationJobRequest
     *        A {@link Consumer} that will call methods on {@link GetReadSetActivationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetReadSetActivationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReadSetActivationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetActivationJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetReadSetActivationJobResponse> getReadSetActivationJob(
            Consumer<GetReadSetActivationJobRequest.Builder> getReadSetActivationJobRequest) {
        return getReadSetActivationJob(GetReadSetActivationJobRequest.builder().applyMutation(getReadSetActivationJobRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about a read set export job.
     * </p>
     *
     * @param getReadSetExportJobRequest
     * @return A Java Future containing the result of the GetReadSetExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReadSetExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReadSetExportJobResponse> getReadSetExportJob(
            GetReadSetExportJobRequest getReadSetExportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a read set export job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReadSetExportJobRequest.Builder} avoiding the
     * need to create one manually via {@link GetReadSetExportJobRequest#builder()}
     * </p>
     *
     * @param getReadSetExportJobRequest
     *        A {@link Consumer} that will call methods on {@link GetReadSetExportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetReadSetExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReadSetExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReadSetExportJobResponse> getReadSetExportJob(
            Consumer<GetReadSetExportJobRequest.Builder> getReadSetExportJobRequest) {
        return getReadSetExportJob(GetReadSetExportJobRequest.builder().applyMutation(getReadSetExportJobRequest).build());
    }

    /**
     * <p>
     * Gets information about a read set import job.
     * </p>
     *
     * @param getReadSetImportJobRequest
     * @return A Java Future containing the result of the GetReadSetImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReadSetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReadSetImportJobResponse> getReadSetImportJob(
            GetReadSetImportJobRequest getReadSetImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a read set import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReadSetImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link GetReadSetImportJobRequest#builder()}
     * </p>
     *
     * @param getReadSetImportJobRequest
     *        A {@link Consumer} that will call methods on {@link GetReadSetImportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetReadSetImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReadSetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReadSetImportJobResponse> getReadSetImportJob(
            Consumer<GetReadSetImportJobRequest.Builder> getReadSetImportJobRequest) {
        return getReadSetImportJob(GetReadSetImportJobRequest.builder().applyMutation(getReadSetImportJobRequest).build());
    }

    /**
     * <p>
     * Gets details about a read set.
     * </p>
     *
     * @param getReadSetMetadataRequest
     * @return A Java Future containing the result of the GetReadSetMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReadSetMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReadSetMetadataResponse> getReadSetMetadata(GetReadSetMetadataRequest getReadSetMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about a read set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReadSetMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link GetReadSetMetadataRequest#builder()}
     * </p>
     *
     * @param getReadSetMetadataRequest
     *        A {@link Consumer} that will call methods on {@link GetReadSetMetadataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetReadSetMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReadSetMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReadSetMetadataResponse> getReadSetMetadata(
            Consumer<GetReadSetMetadataRequest.Builder> getReadSetMetadataRequest) {
        return getReadSetMetadata(GetReadSetMetadataRequest.builder().applyMutation(getReadSetMetadataRequest).build());
    }

    /**
     * <p>
     * Gets a reference file.
     * </p>
     *
     * @param getReferenceRequest
     * @param asyncResponseTransformer
     *        The response transformer for processing the streaming response in a non-blocking manner. See
     *        {@link AsyncResponseTransformer} for details on how this callback should be implemented and for links to
     *        precanned implementations for common scenarios like downloading to a file. The service documentation for
     *        the response content is as follows '
     *        <p>
     *        The reference file payload.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>RangeNotSatisfiableException The ranges specified in the request are not valid.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReference" target="_top">AWS API
     *      Documentation</a>
     */
    default <ReturnT> CompletableFuture<ReturnT> getReference(GetReferenceRequest getReferenceRequest,
            AsyncResponseTransformer<GetReferenceResponse, ReturnT> asyncResponseTransformer) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a reference file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReferenceRequest.Builder} avoiding the need to
     * create one manually via {@link GetReferenceRequest#builder()}
     * </p>
     *
     * @param getReferenceRequest
     *        A {@link Consumer} that will call methods on {@link GetReferenceRequest.Builder} to create a request.
     * @param asyncResponseTransformer
     *        The response transformer for processing the streaming response in a non-blocking manner. See
     *        {@link AsyncResponseTransformer} for details on how this callback should be implemented and for links to
     *        precanned implementations for common scenarios like downloading to a file. The service documentation for
     *        the response content is as follows '
     *        <p>
     *        The reference file payload.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>RangeNotSatisfiableException The ranges specified in the request are not valid.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReference" target="_top">AWS API
     *      Documentation</a>
     */
    default <ReturnT> CompletableFuture<ReturnT> getReference(Consumer<GetReferenceRequest.Builder> getReferenceRequest,
            AsyncResponseTransformer<GetReferenceResponse, ReturnT> asyncResponseTransformer) {
        return getReference(GetReferenceRequest.builder().applyMutation(getReferenceRequest).build(), asyncResponseTransformer);
    }

    /**
     * <p>
     * Gets a reference file.
     * </p>
     *
     * @param getReferenceRequest
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows '
     *        <p>
     *        The reference file payload.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>RangeNotSatisfiableException The ranges specified in the request are not valid.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReference" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReferenceResponse> getReference(GetReferenceRequest getReferenceRequest, Path destinationPath) {
        return getReference(getReferenceRequest, AsyncResponseTransformer.toFile(destinationPath));
    }

    /**
     * <p>
     * Gets a reference file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReferenceRequest.Builder} avoiding the need to
     * create one manually via {@link GetReferenceRequest#builder()}
     * </p>
     *
     * @param getReferenceRequest
     *        A {@link Consumer} that will call methods on {@link GetReferenceRequest.Builder} to create a request.
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows '
     *        <p>
     *        The reference file payload.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>RangeNotSatisfiableException The ranges specified in the request are not valid.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReference" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReferenceResponse> getReference(Consumer<GetReferenceRequest.Builder> getReferenceRequest,
            Path destinationPath) {
        return getReference(GetReferenceRequest.builder().applyMutation(getReferenceRequest).build(), destinationPath);
    }

    /**
     * <p>
     * Gets information about a reference import job.
     * </p>
     *
     * @param getReferenceImportJobRequest
     * @return A Java Future containing the result of the GetReferenceImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReferenceImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReferenceImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetReferenceImportJobResponse> getReferenceImportJob(
            GetReferenceImportJobRequest getReferenceImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a reference import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReferenceImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link GetReferenceImportJobRequest#builder()}
     * </p>
     *
     * @param getReferenceImportJobRequest
     *        A {@link Consumer} that will call methods on {@link GetReferenceImportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetReferenceImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReferenceImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReferenceImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetReferenceImportJobResponse> getReferenceImportJob(
            Consumer<GetReferenceImportJobRequest.Builder> getReferenceImportJobRequest) {
        return getReferenceImportJob(GetReferenceImportJobRequest.builder().applyMutation(getReferenceImportJobRequest).build());
    }

    /**
     * <p>
     * Gets information about a genome reference's metadata.
     * </p>
     *
     * @param getReferenceMetadataRequest
     * @return A Java Future containing the result of the GetReferenceMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReferenceMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReferenceMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetReferenceMetadataResponse> getReferenceMetadata(
            GetReferenceMetadataRequest getReferenceMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a genome reference's metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReferenceMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link GetReferenceMetadataRequest#builder()}
     * </p>
     *
     * @param getReferenceMetadataRequest
     *        A {@link Consumer} that will call methods on {@link GetReferenceMetadataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetReferenceMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReferenceMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReferenceMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetReferenceMetadataResponse> getReferenceMetadata(
            Consumer<GetReferenceMetadataRequest.Builder> getReferenceMetadataRequest) {
        return getReferenceMetadata(GetReferenceMetadataRequest.builder().applyMutation(getReferenceMetadataRequest).build());
    }

    /**
     * <p>
     * Gets information about a reference store.
     * </p>
     *
     * @param getReferenceStoreRequest
     * @return A Java Future containing the result of the GetReferenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReferenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReferenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReferenceStoreResponse> getReferenceStore(GetReferenceStoreRequest getReferenceStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a reference store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReferenceStoreRequest.Builder} avoiding the need
     * to create one manually via {@link GetReferenceStoreRequest#builder()}
     * </p>
     *
     * @param getReferenceStoreRequest
     *        A {@link Consumer} that will call methods on {@link GetReferenceStoreRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetReferenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReferenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReferenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReferenceStoreResponse> getReferenceStore(
            Consumer<GetReferenceStoreRequest.Builder> getReferenceStoreRequest) {
        return getReferenceStore(GetReferenceStoreRequest.builder().applyMutation(getReferenceStoreRequest).build());
    }

    /**
     * <p>
     * Gets information about a workflow run.
     * </p>
     *
     * @param getRunRequest
     * @return A Java Future containing the result of the GetRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRunResponse> getRun(GetRunRequest getRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a workflow run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRunRequest.Builder} avoiding the need to create
     * one manually via {@link GetRunRequest#builder()}
     * </p>
     *
     * @param getRunRequest
     *        A {@link Consumer} that will call methods on {@link GetRunRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRunResponse> getRun(Consumer<GetRunRequest.Builder> getRunRequest) {
        return getRun(GetRunRequest.builder().applyMutation(getRunRequest).build());
    }

    /**
     * <p>
     * Gets information about a workflow run group.
     * </p>
     *
     * @param getRunGroupRequest
     * @return A Java Future containing the result of the GetRunGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetRunGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetRunGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRunGroupResponse> getRunGroup(GetRunGroupRequest getRunGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a workflow run group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRunGroupRequest.Builder} avoiding the need to
     * create one manually via {@link GetRunGroupRequest#builder()}
     * </p>
     *
     * @param getRunGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetRunGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetRunGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetRunGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetRunGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRunGroupResponse> getRunGroup(Consumer<GetRunGroupRequest.Builder> getRunGroupRequest) {
        return getRunGroup(GetRunGroupRequest.builder().applyMutation(getRunGroupRequest).build());
    }

    /**
     * <p>
     * Gets information about a workflow run task.
     * </p>
     *
     * @param getRunTaskRequest
     * @return A Java Future containing the result of the GetRunTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetRunTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetRunTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRunTaskResponse> getRunTask(GetRunTaskRequest getRunTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a workflow run task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRunTaskRequest.Builder} avoiding the need to
     * create one manually via {@link GetRunTaskRequest#builder()}
     * </p>
     *
     * @param getRunTaskRequest
     *        A {@link Consumer} that will call methods on {@link GetRunTaskRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetRunTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetRunTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetRunTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRunTaskResponse> getRunTask(Consumer<GetRunTaskRequest.Builder> getRunTaskRequest) {
        return getRunTask(GetRunTaskRequest.builder().applyMutation(getRunTaskRequest).build());
    }

    /**
     * <p>
     * Gets information about a sequence store.
     * </p>
     *
     * @param getSequenceStoreRequest
     * @return A Java Future containing the result of the GetSequenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetSequenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetSequenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSequenceStoreResponse> getSequenceStore(GetSequenceStoreRequest getSequenceStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a sequence store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSequenceStoreRequest.Builder} avoiding the need
     * to create one manually via {@link GetSequenceStoreRequest#builder()}
     * </p>
     *
     * @param getSequenceStoreRequest
     *        A {@link Consumer} that will call methods on {@link GetSequenceStoreRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSequenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetSequenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetSequenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSequenceStoreResponse> getSequenceStore(
            Consumer<GetSequenceStoreRequest.Builder> getSequenceStoreRequest) {
        return getSequenceStore(GetSequenceStoreRequest.builder().applyMutation(getSequenceStoreRequest).build());
    }

    /**
     * <p>
     * Gets information about a variant import job.
     * </p>
     *
     * @param getVariantImportJobRequest
     * @return A Java Future containing the result of the GetVariantImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetVariantImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetVariantImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetVariantImportJobResponse> getVariantImportJob(
            GetVariantImportJobRequest getVariantImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a variant import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVariantImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link GetVariantImportJobRequest#builder()}
     * </p>
     *
     * @param getVariantImportJobRequest
     *        A {@link Consumer} that will call methods on {@link GetVariantImportRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetVariantImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetVariantImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetVariantImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetVariantImportJobResponse> getVariantImportJob(
            Consumer<GetVariantImportJobRequest.Builder> getVariantImportJobRequest) {
        return getVariantImportJob(GetVariantImportJobRequest.builder().applyMutation(getVariantImportJobRequest).build());
    }

    /**
     * <p>
     * Gets information about a variant store.
     * </p>
     *
     * @param getVariantStoreRequest
     * @return A Java Future containing the result of the GetVariantStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetVariantStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetVariantStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetVariantStoreResponse> getVariantStore(GetVariantStoreRequest getVariantStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a variant store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVariantStoreRequest.Builder} avoiding the need
     * to create one manually via {@link GetVariantStoreRequest#builder()}
     * </p>
     *
     * @param getVariantStoreRequest
     *        A {@link Consumer} that will call methods on {@link GetVariantStoreRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetVariantStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetVariantStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetVariantStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetVariantStoreResponse> getVariantStore(
            Consumer<GetVariantStoreRequest.Builder> getVariantStoreRequest) {
        return getVariantStore(GetVariantStoreRequest.builder().applyMutation(getVariantStoreRequest).build());
    }

    /**
     * <p>
     * Gets information about a workflow.
     * </p>
     *
     * @param getWorkflowRequest
     * @return A Java Future containing the result of the GetWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetWorkflowResponse> getWorkflow(GetWorkflowRequest getWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link GetWorkflowRequest#builder()}
     * </p>
     *
     * @param getWorkflowRequest
     *        A {@link Consumer} that will call methods on {@link GetWorkflowRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetWorkflowResponse> getWorkflow(Consumer<GetWorkflowRequest.Builder> getWorkflowRequest) {
        return getWorkflow(GetWorkflowRequest.builder().applyMutation(getWorkflowRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of annotation import jobs.
     * </p>
     *
     * @param listAnnotationImportJobsRequest
     * @return A Java Future containing the result of the ListAnnotationImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListAnnotationImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAnnotationImportJobsResponse> listAnnotationImportJobs(
            ListAnnotationImportJobsRequest listAnnotationImportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of annotation import jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnnotationImportJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAnnotationImportJobsRequest#builder()}
     * </p>
     *
     * @param listAnnotationImportJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListAnnotationImportJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAnnotationImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListAnnotationImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAnnotationImportJobsResponse> listAnnotationImportJobs(
            Consumer<ListAnnotationImportJobsRequest.Builder> listAnnotationImportJobsRequest) {
        return listAnnotationImportJobs(ListAnnotationImportJobsRequest.builder().applyMutation(listAnnotationImportJobsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of annotation import jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAnnotationImportJobs(software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListAnnotationImportJobsPublisher publisher = client.listAnnotationImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListAnnotationImportJobsPublisher publisher = client.listAnnotationImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnnotationImportJobs(software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAnnotationImportJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListAnnotationImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnnotationImportJobsPublisher listAnnotationImportJobsPaginator(
            ListAnnotationImportJobsRequest listAnnotationImportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of annotation import jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAnnotationImportJobs(software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListAnnotationImportJobsPublisher publisher = client.listAnnotationImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListAnnotationImportJobsPublisher publisher = client.listAnnotationImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnnotationImportJobs(software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnnotationImportJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAnnotationImportJobsRequest#builder()}
     * </p>
     *
     * @param listAnnotationImportJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListAnnotationImportJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListAnnotationImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnnotationImportJobsPublisher listAnnotationImportJobsPaginator(
            Consumer<ListAnnotationImportJobsRequest.Builder> listAnnotationImportJobsRequest) {
        return listAnnotationImportJobsPaginator(ListAnnotationImportJobsRequest.builder()
                .applyMutation(listAnnotationImportJobsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of annotation stores.
     * </p>
     *
     * @param listAnnotationStoresRequest
     * @return A Java Future containing the result of the ListAnnotationStores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListAnnotationStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationStores" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAnnotationStoresResponse> listAnnotationStores(
            ListAnnotationStoresRequest listAnnotationStoresRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of annotation stores.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnnotationStoresRequest.Builder} avoiding the
     * need to create one manually via {@link ListAnnotationStoresRequest#builder()}
     * </p>
     *
     * @param listAnnotationStoresRequest
     *        A {@link Consumer} that will call methods on {@link ListAnnotationStoresRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAnnotationStores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListAnnotationStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationStores" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAnnotationStoresResponse> listAnnotationStores(
            Consumer<ListAnnotationStoresRequest.Builder> listAnnotationStoresRequest) {
        return listAnnotationStores(ListAnnotationStoresRequest.builder().applyMutation(listAnnotationStoresRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of annotation stores.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAnnotationStores(software.amazon.awssdk.services.omics.model.ListAnnotationStoresRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListAnnotationStoresPublisher publisher = client.listAnnotationStoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListAnnotationStoresPublisher publisher = client.listAnnotationStoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListAnnotationStoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListAnnotationStoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnnotationStores(software.amazon.awssdk.services.omics.model.ListAnnotationStoresRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAnnotationStoresRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListAnnotationStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationStores" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAnnotationStoresPublisher listAnnotationStoresPaginator(ListAnnotationStoresRequest listAnnotationStoresRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of annotation stores.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAnnotationStores(software.amazon.awssdk.services.omics.model.ListAnnotationStoresRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListAnnotationStoresPublisher publisher = client.listAnnotationStoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListAnnotationStoresPublisher publisher = client.listAnnotationStoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListAnnotationStoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListAnnotationStoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnnotationStores(software.amazon.awssdk.services.omics.model.ListAnnotationStoresRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnnotationStoresRequest.Builder} avoiding the
     * need to create one manually via {@link ListAnnotationStoresRequest#builder()}
     * </p>
     *
     * @param listAnnotationStoresRequest
     *        A {@link Consumer} that will call methods on {@link ListAnnotationStoresRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListAnnotationStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationStores" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAnnotationStoresPublisher listAnnotationStoresPaginator(
            Consumer<ListAnnotationStoresRequest.Builder> listAnnotationStoresRequest) {
        return listAnnotationStoresPaginator(ListAnnotationStoresRequest.builder().applyMutation(listAnnotationStoresRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of read set activation jobs.
     * </p>
     *
     * @param listReadSetActivationJobsRequest
     * @return A Java Future containing the result of the ListReadSetActivationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetActivationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetActivationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReadSetActivationJobsResponse> listReadSetActivationJobs(
            ListReadSetActivationJobsRequest listReadSetActivationJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of read set activation jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReadSetActivationJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListReadSetActivationJobsRequest#builder()}
     * </p>
     *
     * @param listReadSetActivationJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListReadSetActivationJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListReadSetActivationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetActivationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetActivationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReadSetActivationJobsResponse> listReadSetActivationJobs(
            Consumer<ListReadSetActivationJobsRequest.Builder> listReadSetActivationJobsRequest) {
        return listReadSetActivationJobs(ListReadSetActivationJobsRequest.builder()
                .applyMutation(listReadSetActivationJobsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of read set activation jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listReadSetActivationJobs(software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetActivationJobsPublisher publisher = client.listReadSetActivationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetActivationJobsPublisher publisher = client.listReadSetActivationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReadSetActivationJobs(software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listReadSetActivationJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetActivationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetActivationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReadSetActivationJobsPublisher listReadSetActivationJobsPaginator(
            ListReadSetActivationJobsRequest listReadSetActivationJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of read set activation jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listReadSetActivationJobs(software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetActivationJobsPublisher publisher = client.listReadSetActivationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetActivationJobsPublisher publisher = client.listReadSetActivationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReadSetActivationJobs(software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReadSetActivationJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListReadSetActivationJobsRequest#builder()}
     * </p>
     *
     * @param listReadSetActivationJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListReadSetActivationJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetActivationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetActivationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReadSetActivationJobsPublisher listReadSetActivationJobsPaginator(
            Consumer<ListReadSetActivationJobsRequest.Builder> listReadSetActivationJobsRequest) {
        return listReadSetActivationJobsPaginator(ListReadSetActivationJobsRequest.builder()
                .applyMutation(listReadSetActivationJobsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of read set export jobs.
     * </p>
     *
     * @param listReadSetExportJobsRequest
     * @return A Java Future containing the result of the ListReadSetExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListReadSetExportJobsResponse> listReadSetExportJobs(
            ListReadSetExportJobsRequest listReadSetExportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of read set export jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReadSetExportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListReadSetExportJobsRequest#builder()}
     * </p>
     *
     * @param listReadSetExportJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListReadSetExportJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListReadSetExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListReadSetExportJobsResponse> listReadSetExportJobs(
            Consumer<ListReadSetExportJobsRequest.Builder> listReadSetExportJobsRequest) {
        return listReadSetExportJobs(ListReadSetExportJobsRequest.builder().applyMutation(listReadSetExportJobsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of read set export jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listReadSetExportJobs(software.amazon.awssdk.services.omics.model.ListReadSetExportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetExportJobsPublisher publisher = client.listReadSetExportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetExportJobsPublisher publisher = client.listReadSetExportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListReadSetExportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListReadSetExportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReadSetExportJobs(software.amazon.awssdk.services.omics.model.ListReadSetExportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listReadSetExportJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReadSetExportJobsPublisher listReadSetExportJobsPaginator(
            ListReadSetExportJobsRequest listReadSetExportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of read set export jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listReadSetExportJobs(software.amazon.awssdk.services.omics.model.ListReadSetExportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetExportJobsPublisher publisher = client.listReadSetExportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetExportJobsPublisher publisher = client.listReadSetExportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListReadSetExportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListReadSetExportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReadSetExportJobs(software.amazon.awssdk.services.omics.model.ListReadSetExportJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReadSetExportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListReadSetExportJobsRequest#builder()}
     * </p>
     *
     * @param listReadSetExportJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListReadSetExportJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReadSetExportJobsPublisher listReadSetExportJobsPaginator(
            Consumer<ListReadSetExportJobsRequest.Builder> listReadSetExportJobsRequest) {
        return listReadSetExportJobsPaginator(ListReadSetExportJobsRequest.builder().applyMutation(listReadSetExportJobsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of read set import jobs.
     * </p>
     *
     * @param listReadSetImportJobsRequest
     * @return A Java Future containing the result of the ListReadSetImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListReadSetImportJobsResponse> listReadSetImportJobs(
            ListReadSetImportJobsRequest listReadSetImportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of read set import jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReadSetImportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListReadSetImportJobsRequest#builder()}
     * </p>
     *
     * @param listReadSetImportJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListReadSetImportJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListReadSetImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListReadSetImportJobsResponse> listReadSetImportJobs(
            Consumer<ListReadSetImportJobsRequest.Builder> listReadSetImportJobsRequest) {
        return listReadSetImportJobs(ListReadSetImportJobsRequest.builder().applyMutation(listReadSetImportJobsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of read set import jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listReadSetImportJobs(software.amazon.awssdk.services.omics.model.ListReadSetImportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetImportJobsPublisher publisher = client.listReadSetImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetImportJobsPublisher publisher = client.listReadSetImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListReadSetImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListReadSetImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReadSetImportJobs(software.amazon.awssdk.services.omics.model.ListReadSetImportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listReadSetImportJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReadSetImportJobsPublisher listReadSetImportJobsPaginator(
            ListReadSetImportJobsRequest listReadSetImportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of read set import jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listReadSetImportJobs(software.amazon.awssdk.services.omics.model.ListReadSetImportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetImportJobsPublisher publisher = client.listReadSetImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetImportJobsPublisher publisher = client.listReadSetImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListReadSetImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListReadSetImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReadSetImportJobs(software.amazon.awssdk.services.omics.model.ListReadSetImportJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReadSetImportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListReadSetImportJobsRequest#builder()}
     * </p>
     *
     * @param listReadSetImportJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListReadSetImportJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReadSetImportJobsPublisher listReadSetImportJobsPaginator(
            Consumer<ListReadSetImportJobsRequest.Builder> listReadSetImportJobsRequest) {
        return listReadSetImportJobsPaginator(ListReadSetImportJobsRequest.builder().applyMutation(listReadSetImportJobsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of read sets.
     * </p>
     *
     * @param listReadSetsRequest
     * @return A Java Future containing the result of the ListReadSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReadSetsResponse> listReadSets(ListReadSetsRequest listReadSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of read sets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReadSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListReadSetsRequest#builder()}
     * </p>
     *
     * @param listReadSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListReadSetsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListReadSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReadSetsResponse> listReadSets(Consumer<ListReadSetsRequest.Builder> listReadSetsRequest) {
        return listReadSets(ListReadSetsRequest.builder().applyMutation(listReadSetsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of read sets.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listReadSets(software.amazon.awssdk.services.omics.model.ListReadSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetsPublisher publisher = client.listReadSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetsPublisher publisher = client.listReadSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListReadSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListReadSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReadSets(software.amazon.awssdk.services.omics.model.ListReadSetsRequest)} operation.</b>
     * </p>
     *
     * @param listReadSetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReadSetsPublisher listReadSetsPaginator(ListReadSetsRequest listReadSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of read sets.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listReadSets(software.amazon.awssdk.services.omics.model.ListReadSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetsPublisher publisher = client.listReadSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetsPublisher publisher = client.listReadSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListReadSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListReadSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReadSets(software.amazon.awssdk.services.omics.model.ListReadSetsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReadSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListReadSetsRequest#builder()}
     * </p>
     *
     * @param listReadSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListReadSetsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReadSetsPublisher listReadSetsPaginator(Consumer<ListReadSetsRequest.Builder> listReadSetsRequest) {
        return listReadSetsPaginator(ListReadSetsRequest.builder().applyMutation(listReadSetsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of reference import jobs.
     * </p>
     *
     * @param listReferenceImportJobsRequest
     * @return A Java Future containing the result of the ListReferenceImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReferenceImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferenceImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListReferenceImportJobsResponse> listReferenceImportJobs(
            ListReferenceImportJobsRequest listReferenceImportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of reference import jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReferenceImportJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListReferenceImportJobsRequest#builder()}
     * </p>
     *
     * @param listReferenceImportJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListReferenceImportJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListReferenceImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReferenceImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferenceImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListReferenceImportJobsResponse> listReferenceImportJobs(
            Consumer<ListReferenceImportJobsRequest.Builder> listReferenceImportJobsRequest) {
        return listReferenceImportJobs(ListReferenceImportJobsRequest.builder().applyMutation(listReferenceImportJobsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of reference import jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listReferenceImportJobs(software.amazon.awssdk.services.omics.model.ListReferenceImportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReferenceImportJobsPublisher publisher = client.listReferenceImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReferenceImportJobsPublisher publisher = client.listReferenceImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListReferenceImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListReferenceImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReferenceImportJobs(software.amazon.awssdk.services.omics.model.ListReferenceImportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listReferenceImportJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReferenceImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferenceImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReferenceImportJobsPublisher listReferenceImportJobsPaginator(
            ListReferenceImportJobsRequest listReferenceImportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of reference import jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listReferenceImportJobs(software.amazon.awssdk.services.omics.model.ListReferenceImportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReferenceImportJobsPublisher publisher = client.listReferenceImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReferenceImportJobsPublisher publisher = client.listReferenceImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListReferenceImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListReferenceImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReferenceImportJobs(software.amazon.awssdk.services.omics.model.ListReferenceImportJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReferenceImportJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListReferenceImportJobsRequest#builder()}
     * </p>
     *
     * @param listReferenceImportJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListReferenceImportJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReferenceImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferenceImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReferenceImportJobsPublisher listReferenceImportJobsPaginator(
            Consumer<ListReferenceImportJobsRequest.Builder> listReferenceImportJobsRequest) {
        return listReferenceImportJobsPaginator(ListReferenceImportJobsRequest.builder()
                .applyMutation(listReferenceImportJobsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of reference stores.
     * </p>
     *
     * @param listReferenceStoresRequest
     * @return A Java Future containing the result of the ListReferenceStores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReferenceStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferenceStores" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReferenceStoresResponse> listReferenceStores(
            ListReferenceStoresRequest listReferenceStoresRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of reference stores.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReferenceStoresRequest.Builder} avoiding the
     * need to create one manually via {@link ListReferenceStoresRequest#builder()}
     * </p>
     *
     * @param listReferenceStoresRequest
     *        A {@link Consumer} that will call methods on {@link ListReferenceStoresRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListReferenceStores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReferenceStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferenceStores" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReferenceStoresResponse> listReferenceStores(
            Consumer<ListReferenceStoresRequest.Builder> listReferenceStoresRequest) {
        return listReferenceStores(ListReferenceStoresRequest.builder().applyMutation(listReferenceStoresRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of reference stores.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listReferenceStores(software.amazon.awssdk.services.omics.model.ListReferenceStoresRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReferenceStoresPublisher publisher = client.listReferenceStoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReferenceStoresPublisher publisher = client.listReferenceStoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListReferenceStoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListReferenceStoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReferenceStores(software.amazon.awssdk.services.omics.model.ListReferenceStoresRequest)}
     * operation.</b>
     * </p>
     *
     * @param listReferenceStoresRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReferenceStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferenceStores" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReferenceStoresPublisher listReferenceStoresPaginator(ListReferenceStoresRequest listReferenceStoresRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of reference stores.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listReferenceStores(software.amazon.awssdk.services.omics.model.ListReferenceStoresRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReferenceStoresPublisher publisher = client.listReferenceStoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReferenceStoresPublisher publisher = client.listReferenceStoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListReferenceStoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListReferenceStoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReferenceStores(software.amazon.awssdk.services.omics.model.ListReferenceStoresRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReferenceStoresRequest.Builder} avoiding the
     * need to create one manually via {@link ListReferenceStoresRequest#builder()}
     * </p>
     *
     * @param listReferenceStoresRequest
     *        A {@link Consumer} that will call methods on {@link ListReferenceStoresRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReferenceStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferenceStores" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReferenceStoresPublisher listReferenceStoresPaginator(
            Consumer<ListReferenceStoresRequest.Builder> listReferenceStoresRequest) {
        return listReferenceStoresPaginator(ListReferenceStoresRequest.builder().applyMutation(listReferenceStoresRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of references.
     * </p>
     *
     * @param listReferencesRequest
     * @return A Java Future containing the result of the ListReferences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferences" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReferencesResponse> listReferences(ListReferencesRequest listReferencesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of references.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReferencesRequest.Builder} avoiding the need to
     * create one manually via {@link ListReferencesRequest#builder()}
     * </p>
     *
     * @param listReferencesRequest
     *        A {@link Consumer} that will call methods on {@link ListReferencesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListReferences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferences" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReferencesResponse> listReferences(Consumer<ListReferencesRequest.Builder> listReferencesRequest) {
        return listReferences(ListReferencesRequest.builder().applyMutation(listReferencesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of references.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listReferences(software.amazon.awssdk.services.omics.model.ListReferencesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReferencesPublisher publisher = client.listReferencesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReferencesPublisher publisher = client.listReferencesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListReferencesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListReferencesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReferences(software.amazon.awssdk.services.omics.model.ListReferencesRequest)} operation.</b>
     * </p>
     *
     * @param listReferencesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferences" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReferencesPublisher listReferencesPaginator(ListReferencesRequest listReferencesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of references.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listReferences(software.amazon.awssdk.services.omics.model.ListReferencesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReferencesPublisher publisher = client.listReferencesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReferencesPublisher publisher = client.listReferencesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListReferencesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListReferencesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReferences(software.amazon.awssdk.services.omics.model.ListReferencesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReferencesRequest.Builder} avoiding the need to
     * create one manually via {@link ListReferencesRequest#builder()}
     * </p>
     *
     * @param listReferencesRequest
     *        A {@link Consumer} that will call methods on {@link ListReferencesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferences" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReferencesPublisher listReferencesPaginator(Consumer<ListReferencesRequest.Builder> listReferencesRequest) {
        return listReferencesPaginator(ListReferencesRequest.builder().applyMutation(listReferencesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of run groups.
     * </p>
     *
     * @param listRunGroupsRequest
     * @return A Java Future containing the result of the ListRunGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRunGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRunGroupsResponse> listRunGroups(ListRunGroupsRequest listRunGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of run groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRunGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRunGroupsRequest#builder()}
     * </p>
     *
     * @param listRunGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListRunGroupsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListRunGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRunGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRunGroupsResponse> listRunGroups(Consumer<ListRunGroupsRequest.Builder> listRunGroupsRequest) {
        return listRunGroups(ListRunGroupsRequest.builder().applyMutation(listRunGroupsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of run groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRunGroups(software.amazon.awssdk.services.omics.model.ListRunGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListRunGroupsPublisher publisher = client.listRunGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListRunGroupsPublisher publisher = client.listRunGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListRunGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListRunGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRunGroups(software.amazon.awssdk.services.omics.model.ListRunGroupsRequest)} operation.</b>
     * </p>
     *
     * @param listRunGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRunGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRunGroupsPublisher listRunGroupsPaginator(ListRunGroupsRequest listRunGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of run groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRunGroups(software.amazon.awssdk.services.omics.model.ListRunGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListRunGroupsPublisher publisher = client.listRunGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListRunGroupsPublisher publisher = client.listRunGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListRunGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListRunGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRunGroups(software.amazon.awssdk.services.omics.model.ListRunGroupsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRunGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRunGroupsRequest#builder()}
     * </p>
     *
     * @param listRunGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListRunGroupsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRunGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRunGroupsPublisher listRunGroupsPaginator(Consumer<ListRunGroupsRequest.Builder> listRunGroupsRequest) {
        return listRunGroupsPaginator(ListRunGroupsRequest.builder().applyMutation(listRunGroupsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of tasks for a run.
     * </p>
     *
     * @param listRunTasksRequest
     * @return A Java Future containing the result of the ListRunTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRunTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRunTasksResponse> listRunTasks(ListRunTasksRequest listRunTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of tasks for a run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRunTasksRequest.Builder} avoiding the need to
     * create one manually via {@link ListRunTasksRequest#builder()}
     * </p>
     *
     * @param listRunTasksRequest
     *        A {@link Consumer} that will call methods on {@link ListRunTasksRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListRunTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRunTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRunTasksResponse> listRunTasks(Consumer<ListRunTasksRequest.Builder> listRunTasksRequest) {
        return listRunTasks(ListRunTasksRequest.builder().applyMutation(listRunTasksRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of tasks for a run.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRunTasks(software.amazon.awssdk.services.omics.model.ListRunTasksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListRunTasksPublisher publisher = client.listRunTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListRunTasksPublisher publisher = client.listRunTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListRunTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListRunTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRunTasks(software.amazon.awssdk.services.omics.model.ListRunTasksRequest)} operation.</b>
     * </p>
     *
     * @param listRunTasksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRunTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRunTasksPublisher listRunTasksPaginator(ListRunTasksRequest listRunTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of tasks for a run.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRunTasks(software.amazon.awssdk.services.omics.model.ListRunTasksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListRunTasksPublisher publisher = client.listRunTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListRunTasksPublisher publisher = client.listRunTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListRunTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListRunTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRunTasks(software.amazon.awssdk.services.omics.model.ListRunTasksRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRunTasksRequest.Builder} avoiding the need to
     * create one manually via {@link ListRunTasksRequest#builder()}
     * </p>
     *
     * @param listRunTasksRequest
     *        A {@link Consumer} that will call methods on {@link ListRunTasksRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRunTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRunTasksPublisher listRunTasksPaginator(Consumer<ListRunTasksRequest.Builder> listRunTasksRequest) {
        return listRunTasksPaginator(ListRunTasksRequest.builder().applyMutation(listRunTasksRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of runs.
     * </p>
     *
     * @param listRunsRequest
     * @return A Java Future containing the result of the ListRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRunsResponse> listRuns(ListRunsRequest listRunsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of runs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRunsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRunsRequest#builder()}
     * </p>
     *
     * @param listRunsRequest
     *        A {@link Consumer} that will call methods on {@link ListRunsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRunsResponse> listRuns(Consumer<ListRunsRequest.Builder> listRunsRequest) {
        return listRuns(ListRunsRequest.builder().applyMutation(listRunsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of runs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRuns(software.amazon.awssdk.services.omics.model.ListRunsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListRunsPublisher publisher = client.listRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListRunsPublisher publisher = client.listRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRuns(software.amazon.awssdk.services.omics.model.ListRunsRequest)} operation.</b>
     * </p>
     *
     * @param listRunsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRunsPublisher listRunsPaginator(ListRunsRequest listRunsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of runs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRuns(software.amazon.awssdk.services.omics.model.ListRunsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListRunsPublisher publisher = client.listRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListRunsPublisher publisher = client.listRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRuns(software.amazon.awssdk.services.omics.model.ListRunsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRunsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRunsRequest#builder()}
     * </p>
     *
     * @param listRunsRequest
     *        A {@link Consumer} that will call methods on {@link ListRunsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRunsPublisher listRunsPaginator(Consumer<ListRunsRequest.Builder> listRunsRequest) {
        return listRunsPaginator(ListRunsRequest.builder().applyMutation(listRunsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of sequence stores.
     * </p>
     *
     * @param listSequenceStoresRequest
     * @return A Java Future containing the result of the ListSequenceStores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListSequenceStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListSequenceStores" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSequenceStoresResponse> listSequenceStores(ListSequenceStoresRequest listSequenceStoresRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of sequence stores.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSequenceStoresRequest.Builder} avoiding the
     * need to create one manually via {@link ListSequenceStoresRequest#builder()}
     * </p>
     *
     * @param listSequenceStoresRequest
     *        A {@link Consumer} that will call methods on {@link ListSequenceStoresRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSequenceStores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListSequenceStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListSequenceStores" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSequenceStoresResponse> listSequenceStores(
            Consumer<ListSequenceStoresRequest.Builder> listSequenceStoresRequest) {
        return listSequenceStores(ListSequenceStoresRequest.builder().applyMutation(listSequenceStoresRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of sequence stores.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSequenceStores(software.amazon.awssdk.services.omics.model.ListSequenceStoresRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListSequenceStoresPublisher publisher = client.listSequenceStoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListSequenceStoresPublisher publisher = client.listSequenceStoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListSequenceStoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListSequenceStoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSequenceStores(software.amazon.awssdk.services.omics.model.ListSequenceStoresRequest)} operation.</b>
     * </p>
     *
     * @param listSequenceStoresRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListSequenceStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListSequenceStores" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSequenceStoresPublisher listSequenceStoresPaginator(ListSequenceStoresRequest listSequenceStoresRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of sequence stores.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSequenceStores(software.amazon.awssdk.services.omics.model.ListSequenceStoresRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListSequenceStoresPublisher publisher = client.listSequenceStoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListSequenceStoresPublisher publisher = client.listSequenceStoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListSequenceStoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListSequenceStoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSequenceStores(software.amazon.awssdk.services.omics.model.ListSequenceStoresRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSequenceStoresRequest.Builder} avoiding the
     * need to create one manually via {@link ListSequenceStoresRequest#builder()}
     * </p>
     *
     * @param listSequenceStoresRequest
     *        A {@link Consumer} that will call methods on {@link ListSequenceStoresRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListSequenceStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListSequenceStores" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSequenceStoresPublisher listSequenceStoresPaginator(
            Consumer<ListSequenceStoresRequest.Builder> listSequenceStoresRequest) {
        return listSequenceStoresPaginator(ListSequenceStoresRequest.builder().applyMutation(listSequenceStoresRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of variant import jobs.
     * </p>
     *
     * @param listVariantImportJobsRequest
     * @return A Java Future containing the result of the ListVariantImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListVariantImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListVariantImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListVariantImportJobsResponse> listVariantImportJobs(
            ListVariantImportJobsRequest listVariantImportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of variant import jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVariantImportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListVariantImportJobsRequest#builder()}
     * </p>
     *
     * @param listVariantImportJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListVariantImportJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListVariantImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListVariantImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListVariantImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListVariantImportJobsResponse> listVariantImportJobs(
            Consumer<ListVariantImportJobsRequest.Builder> listVariantImportJobsRequest) {
        return listVariantImportJobs(ListVariantImportJobsRequest.builder().applyMutation(listVariantImportJobsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of variant import jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVariantImportJobs(software.amazon.awssdk.services.omics.model.ListVariantImportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListVariantImportJobsPublisher publisher = client.listVariantImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListVariantImportJobsPublisher publisher = client.listVariantImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListVariantImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListVariantImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVariantImportJobs(software.amazon.awssdk.services.omics.model.ListVariantImportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVariantImportJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListVariantImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListVariantImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVariantImportJobsPublisher listVariantImportJobsPaginator(
            ListVariantImportJobsRequest listVariantImportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of variant import jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVariantImportJobs(software.amazon.awssdk.services.omics.model.ListVariantImportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListVariantImportJobsPublisher publisher = client.listVariantImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListVariantImportJobsPublisher publisher = client.listVariantImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListVariantImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListVariantImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVariantImportJobs(software.amazon.awssdk.services.omics.model.ListVariantImportJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVariantImportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListVariantImportJobsRequest#builder()}
     * </p>
     *
     * @param listVariantImportJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListVariantImportJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListVariantImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListVariantImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVariantImportJobsPublisher listVariantImportJobsPaginator(
            Consumer<ListVariantImportJobsRequest.Builder> listVariantImportJobsRequest) {
        return listVariantImportJobsPaginator(ListVariantImportJobsRequest.builder().applyMutation(listVariantImportJobsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of variant stores.
     * </p>
     *
     * @param listVariantStoresRequest
     * @return A Java Future containing the result of the ListVariantStores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListVariantStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListVariantStores" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListVariantStoresResponse> listVariantStores(ListVariantStoresRequest listVariantStoresRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of variant stores.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVariantStoresRequest.Builder} avoiding the need
     * to create one manually via {@link ListVariantStoresRequest#builder()}
     * </p>
     *
     * @param listVariantStoresRequest
     *        A {@link Consumer} that will call methods on {@link ListVariantStoresRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListVariantStores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListVariantStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListVariantStores" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListVariantStoresResponse> listVariantStores(
            Consumer<ListVariantStoresRequest.Builder> listVariantStoresRequest) {
        return listVariantStores(ListVariantStoresRequest.builder().applyMutation(listVariantStoresRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of variant stores.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVariantStores(software.amazon.awssdk.services.omics.model.ListVariantStoresRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListVariantStoresPublisher publisher = client.listVariantStoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListVariantStoresPublisher publisher = client.listVariantStoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListVariantStoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListVariantStoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVariantStores(software.amazon.awssdk.services.omics.model.ListVariantStoresRequest)} operation.</b>
     * </p>
     *
     * @param listVariantStoresRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListVariantStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListVariantStores" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVariantStoresPublisher listVariantStoresPaginator(ListVariantStoresRequest listVariantStoresRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of variant stores.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVariantStores(software.amazon.awssdk.services.omics.model.ListVariantStoresRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListVariantStoresPublisher publisher = client.listVariantStoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListVariantStoresPublisher publisher = client.listVariantStoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListVariantStoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListVariantStoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVariantStores(software.amazon.awssdk.services.omics.model.ListVariantStoresRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVariantStoresRequest.Builder} avoiding the need
     * to create one manually via {@link ListVariantStoresRequest#builder()}
     * </p>
     *
     * @param listVariantStoresRequest
     *        A {@link Consumer} that will call methods on {@link ListVariantStoresRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListVariantStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListVariantStores" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVariantStoresPublisher listVariantStoresPaginator(
            Consumer<ListVariantStoresRequest.Builder> listVariantStoresRequest) {
        return listVariantStoresPaginator(ListVariantStoresRequest.builder().applyMutation(listVariantStoresRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of workflows.
     * </p>
     *
     * @param listWorkflowsRequest
     * @return A Java Future containing the result of the ListWorkflows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListWorkflows" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListWorkflowsResponse> listWorkflows(ListWorkflowsRequest listWorkflowsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of workflows.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkflowsRequest#builder()}
     * </p>
     *
     * @param listWorkflowsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkflowsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListWorkflows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListWorkflows" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListWorkflowsResponse> listWorkflows(Consumer<ListWorkflowsRequest.Builder> listWorkflowsRequest) {
        return listWorkflows(ListWorkflowsRequest.builder().applyMutation(listWorkflowsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of workflows.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listWorkflows(software.amazon.awssdk.services.omics.model.ListWorkflowsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListWorkflowsPublisher publisher = client.listWorkflowsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListWorkflowsPublisher publisher = client.listWorkflowsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListWorkflowsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListWorkflowsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkflows(software.amazon.awssdk.services.omics.model.ListWorkflowsRequest)} operation.</b>
     * </p>
     *
     * @param listWorkflowsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListWorkflows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkflowsPublisher listWorkflowsPaginator(ListWorkflowsRequest listWorkflowsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of workflows.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listWorkflows(software.amazon.awssdk.services.omics.model.ListWorkflowsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListWorkflowsPublisher publisher = client.listWorkflowsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListWorkflowsPublisher publisher = client.listWorkflowsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListWorkflowsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListWorkflowsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkflows(software.amazon.awssdk.services.omics.model.ListWorkflowsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkflowsRequest#builder()}
     * </p>
     *
     * @param listWorkflowsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkflowsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListWorkflows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkflowsPublisher listWorkflowsPaginator(Consumer<ListWorkflowsRequest.Builder> listWorkflowsRequest) {
        return listWorkflowsPaginator(ListWorkflowsRequest.builder().applyMutation(listWorkflowsRequest).build());
    }

    /**
     * <p>
     * Starts an annotation import job.
     * </p>
     *
     * @param startAnnotationImportJobRequest
     * @return A Java Future containing the result of the StartAnnotationImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartAnnotationImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartAnnotationImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartAnnotationImportJobResponse> startAnnotationImportJob(
            StartAnnotationImportJobRequest startAnnotationImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an annotation import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartAnnotationImportJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartAnnotationImportJobRequest#builder()}
     * </p>
     *
     * @param startAnnotationImportJobRequest
     *        A {@link Consumer} that will call methods on {@link StartAnnotationImportRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartAnnotationImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartAnnotationImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartAnnotationImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartAnnotationImportJobResponse> startAnnotationImportJob(
            Consumer<StartAnnotationImportJobRequest.Builder> startAnnotationImportJobRequest) {
        return startAnnotationImportJob(StartAnnotationImportJobRequest.builder().applyMutation(startAnnotationImportJobRequest)
                .build());
    }

    /**
     * <p>
     * Activates an archived read set. To reduce storage charges, Amazon Omics archives unused read sets after 30 days.
     * </p>
     *
     * @param startReadSetActivationJobRequest
     * @return A Java Future containing the result of the StartReadSetActivationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartReadSetActivationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReadSetActivationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartReadSetActivationJobResponse> startReadSetActivationJob(
            StartReadSetActivationJobRequest startReadSetActivationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates an archived read set. To reduce storage charges, Amazon Omics archives unused read sets after 30 days.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartReadSetActivationJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartReadSetActivationJobRequest#builder()}
     * </p>
     *
     * @param startReadSetActivationJobRequest
     *        A {@link Consumer} that will call methods on {@link StartReadSetActivationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartReadSetActivationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartReadSetActivationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReadSetActivationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartReadSetActivationJobResponse> startReadSetActivationJob(
            Consumer<StartReadSetActivationJobRequest.Builder> startReadSetActivationJobRequest) {
        return startReadSetActivationJob(StartReadSetActivationJobRequest.builder()
                .applyMutation(startReadSetActivationJobRequest).build());
    }

    /**
     * <p>
     * Exports a read set to Amazon S3.
     * </p>
     *
     * @param startReadSetExportJobRequest
     * @return A Java Future containing the result of the StartReadSetExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartReadSetExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReadSetExportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartReadSetExportJobResponse> startReadSetExportJob(
            StartReadSetExportJobRequest startReadSetExportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports a read set to Amazon S3.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartReadSetExportJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartReadSetExportJobRequest#builder()}
     * </p>
     *
     * @param startReadSetExportJobRequest
     *        A {@link Consumer} that will call methods on {@link StartReadSetExportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartReadSetExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartReadSetExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReadSetExportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartReadSetExportJobResponse> startReadSetExportJob(
            Consumer<StartReadSetExportJobRequest.Builder> startReadSetExportJobRequest) {
        return startReadSetExportJob(StartReadSetExportJobRequest.builder().applyMutation(startReadSetExportJobRequest).build());
    }

    /**
     * <p>
     * Starts a read set import job.
     * </p>
     *
     * @param startReadSetImportJobRequest
     * @return A Java Future containing the result of the StartReadSetImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartReadSetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReadSetImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartReadSetImportJobResponse> startReadSetImportJob(
            StartReadSetImportJobRequest startReadSetImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a read set import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartReadSetImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartReadSetImportJobRequest#builder()}
     * </p>
     *
     * @param startReadSetImportJobRequest
     *        A {@link Consumer} that will call methods on {@link StartReadSetImportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartReadSetImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartReadSetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReadSetImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartReadSetImportJobResponse> startReadSetImportJob(
            Consumer<StartReadSetImportJobRequest.Builder> startReadSetImportJobRequest) {
        return startReadSetImportJob(StartReadSetImportJobRequest.builder().applyMutation(startReadSetImportJobRequest).build());
    }

    /**
     * <p>
     * Starts a reference import job.
     * </p>
     *
     * @param startReferenceImportJobRequest
     * @return A Java Future containing the result of the StartReferenceImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartReferenceImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReferenceImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartReferenceImportJobResponse> startReferenceImportJob(
            StartReferenceImportJobRequest startReferenceImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a reference import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartReferenceImportJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartReferenceImportJobRequest#builder()}
     * </p>
     *
     * @param startReferenceImportJobRequest
     *        A {@link Consumer} that will call methods on {@link StartReferenceImportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartReferenceImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartReferenceImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReferenceImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartReferenceImportJobResponse> startReferenceImportJob(
            Consumer<StartReferenceImportJobRequest.Builder> startReferenceImportJobRequest) {
        return startReferenceImportJob(StartReferenceImportJobRequest.builder().applyMutation(startReferenceImportJobRequest)
                .build());
    }

    /**
     * <p>
     * Starts a run.
     * </p>
     *
     * @param startRunRequest
     * @return A Java Future containing the result of the StartRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartRunResponse> startRun(StartRunRequest startRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartRunRequest.Builder} avoiding the need to
     * create one manually via {@link StartRunRequest#builder()}
     * </p>
     *
     * @param startRunRequest
     *        A {@link Consumer} that will call methods on {@link StartRunRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartRunResponse> startRun(Consumer<StartRunRequest.Builder> startRunRequest) {
        return startRun(StartRunRequest.builder().applyMutation(startRunRequest).build());
    }

    /**
     * <p>
     * Starts a variant import job.
     * </p>
     *
     * @param startVariantImportJobRequest
     * @return A Java Future containing the result of the StartVariantImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartVariantImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartVariantImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartVariantImportJobResponse> startVariantImportJob(
            StartVariantImportJobRequest startVariantImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a variant import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartVariantImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartVariantImportJobRequest#builder()}
     * </p>
     *
     * @param startVariantImportJobRequest
     *        A {@link Consumer} that will call methods on {@link StartVariantImportRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartVariantImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartVariantImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartVariantImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartVariantImportJobResponse> startVariantImportJob(
            Consumer<StartVariantImportJobRequest.Builder> startVariantImportJobRequest) {
        return startVariantImportJob(StartVariantImportJobRequest.builder().applyMutation(startVariantImportJobRequest).build());
    }

    /**
     * <p>
     * Tags a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tags a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an annotation store.
     * </p>
     *
     * @param updateAnnotationStoreRequest
     * @return A Java Future containing the result of the UpdateAnnotationStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateAnnotationStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateAnnotationStore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateAnnotationStoreResponse> updateAnnotationStore(
            UpdateAnnotationStoreRequest updateAnnotationStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an annotation store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAnnotationStoreRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAnnotationStoreRequest#builder()}
     * </p>
     *
     * @param updateAnnotationStoreRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAnnotationStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateAnnotationStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateAnnotationStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateAnnotationStore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateAnnotationStoreResponse> updateAnnotationStore(
            Consumer<UpdateAnnotationStoreRequest.Builder> updateAnnotationStoreRequest) {
        return updateAnnotationStore(UpdateAnnotationStoreRequest.builder().applyMutation(updateAnnotationStoreRequest).build());
    }

    /**
     * <p>
     * Updates a run group.
     * </p>
     *
     * @param updateRunGroupRequest
     * @return A Java Future containing the result of the UpdateRunGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateRunGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateRunGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateRunGroupResponse> updateRunGroup(UpdateRunGroupRequest updateRunGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a run group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRunGroupRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateRunGroupRequest#builder()}
     * </p>
     *
     * @param updateRunGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRunGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateRunGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateRunGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateRunGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateRunGroupResponse> updateRunGroup(Consumer<UpdateRunGroupRequest.Builder> updateRunGroupRequest) {
        return updateRunGroup(UpdateRunGroupRequest.builder().applyMutation(updateRunGroupRequest).build());
    }

    /**
     * <p>
     * Updates a variant store.
     * </p>
     *
     * @param updateVariantStoreRequest
     * @return A Java Future containing the result of the UpdateVariantStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateVariantStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateVariantStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateVariantStoreResponse> updateVariantStore(UpdateVariantStoreRequest updateVariantStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a variant store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVariantStoreRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateVariantStoreRequest#builder()}
     * </p>
     *
     * @param updateVariantStoreRequest
     *        A {@link Consumer} that will call methods on {@link UpdateVariantStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateVariantStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateVariantStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateVariantStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateVariantStoreResponse> updateVariantStore(
            Consumer<UpdateVariantStoreRequest.Builder> updateVariantStoreRequest) {
        return updateVariantStore(UpdateVariantStoreRequest.builder().applyMutation(updateVariantStoreRequest).build());
    }

    /**
     * <p>
     * Updates a workflow.
     * </p>
     *
     * @param updateWorkflowRequest
     * @return A Java Future containing the result of the UpdateWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateWorkflowResponse> updateWorkflow(UpdateWorkflowRequest updateWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateWorkflowRequest#builder()}
     * </p>
     *
     * @param updateWorkflowRequest
     *        A {@link Consumer} that will call methods on {@link UpdateWorkflowRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateWorkflowResponse> updateWorkflow(Consumer<UpdateWorkflowRequest.Builder> updateWorkflowRequest) {
        return updateWorkflow(UpdateWorkflowRequest.builder().applyMutation(updateWorkflowRequest).build());
    }

    /**
     * Create an instance of {@link OmicsAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link OmicsAsyncWaiter}
     */
    default OmicsAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    @Override
    default OmicsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link OmicsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static OmicsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link OmicsAsyncClient}.
     */
    static OmicsAsyncClientBuilder builder() {
        return new DefaultOmicsAsyncClientBuilder();
    }
}
