/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRunRequest extends OmicsRequest implements ToCopyableBuilder<GetRunRequest.Builder, GetRunRequest> {
    private static final SdkField<List<String>> EXPORT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("export")
            .getter(getter(GetRunRequest::exportAsStrings))
            .setter(setter(Builder::exportWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("export").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetRunRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_FIELD, ID_FIELD));

    private final List<String> export;

    private final String id;

    private GetRunRequest(BuilderImpl builder) {
        super(builder);
        this.export = builder.export;
        this.id = builder.id;
    }

    /**
     * <p>
     * The run's export format.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExport} method.
     * </p>
     * 
     * @return The run's export format.
     */
    public final List<RunExport> export() {
        return RunExportListCopier.copyStringToEnum(export);
    }

    /**
     * For responses, this returns true if the service returned a value for the Export property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasExport() {
        return export != null && !(export instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The run's export format.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExport} method.
     * </p>
     * 
     * @return The run's export format.
     */
    public final List<String> exportAsStrings() {
        return export;
    }

    /**
     * <p>
     * The run's ID.
     * </p>
     * 
     * @return The run's ID.
     */
    public final String id() {
        return id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasExport() ? exportAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(id());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRunRequest)) {
            return false;
        }
        GetRunRequest other = (GetRunRequest) obj;
        return hasExport() == other.hasExport() && Objects.equals(exportAsStrings(), other.exportAsStrings())
                && Objects.equals(id(), other.id());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRunRequest").add("Export", hasExport() ? exportAsStrings() : null).add("Id", id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "export":
            return Optional.ofNullable(clazz.cast(exportAsStrings()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRunRequest, T> g) {
        return obj -> g.apply((GetRunRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetRunRequest> {
        /**
         * <p>
         * The run's export format.
         * </p>
         * 
         * @param export
         *        The run's export format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportWithStrings(Collection<String> export);

        /**
         * <p>
         * The run's export format.
         * </p>
         * 
         * @param export
         *        The run's export format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportWithStrings(String... export);

        /**
         * <p>
         * The run's export format.
         * </p>
         * 
         * @param export
         *        The run's export format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder export(Collection<RunExport> export);

        /**
         * <p>
         * The run's export format.
         * </p>
         * 
         * @param export
         *        The run's export format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder export(RunExport... export);

        /**
         * <p>
         * The run's ID.
         * </p>
         * 
         * @param id
         *        The run's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private List<String> export = DefaultSdkAutoConstructList.getInstance();

        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRunRequest model) {
            super(model);
            exportWithStrings(model.export);
            id(model.id);
        }

        public final Collection<String> getExport() {
            if (export instanceof SdkAutoConstructList) {
                return null;
            }
            return export;
        }

        public final void setExport(Collection<String> export) {
            this.export = RunExportListCopier.copy(export);
        }

        @Override
        public final Builder exportWithStrings(Collection<String> export) {
            this.export = RunExportListCopier.copy(export);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportWithStrings(String... export) {
            exportWithStrings(Arrays.asList(export));
            return this;
        }

        @Override
        public final Builder export(Collection<RunExport> export) {
            this.export = RunExportListCopier.copyEnumToString(export);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder export(RunExport... export) {
            export(Arrays.asList(export));
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRunRequest build() {
            return new GetRunRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
