/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A workflow run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RunListItem implements SdkPojo, Serializable, ToCopyableBuilder<RunListItem.Builder, RunListItem> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(RunListItem::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(RunListItem::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(RunListItem::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(RunListItem::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("priority").getter(getter(RunListItem::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime")
            .getter(getter(RunListItem::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(RunListItem::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> STOP_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("stopTime")
            .getter(getter(RunListItem::stopTime))
            .setter(setter(Builder::stopTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Integer> STORAGE_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("storageCapacity").getter(getter(RunListItem::storageCapacity)).setter(setter(Builder::storageCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageCapacity").build()).build();

    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowId").getter(getter(RunListItem::workflowId)).setter(setter(Builder::workflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CREATION_TIME_FIELD, ID_FIELD, NAME_FIELD, PRIORITY_FIELD, START_TIME_FIELD, STATUS_FIELD, STOP_TIME_FIELD,
            STORAGE_CAPACITY_FIELD, WORKFLOW_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant creationTime;

    private final String id;

    private final String name;

    private final Integer priority;

    private final Instant startTime;

    private final String status;

    private final Instant stopTime;

    private final Integer storageCapacity;

    private final String workflowId;

    private RunListItem(BuilderImpl builder) {
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.id = builder.id;
        this.name = builder.name;
        this.priority = builder.priority;
        this.startTime = builder.startTime;
        this.status = builder.status;
        this.stopTime = builder.stopTime;
        this.storageCapacity = builder.storageCapacity;
        this.workflowId = builder.workflowId;
    }

    /**
     * <p>
     * The run's ARN.
     * </p>
     * 
     * @return The run's ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * When the run was created.
     * </p>
     * 
     * @return When the run was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The run's ID.
     * </p>
     * 
     * @return The run's ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The run's name.
     * </p>
     * 
     * @return The run's name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The run's priority.
     * </p>
     * 
     * @return The run's priority.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * When the run started.
     * </p>
     * 
     * @return When the run started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The run's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The run's status.
     * @see RunStatus
     */
    public final RunStatus status() {
        return RunStatus.fromValue(status);
    }

    /**
     * <p>
     * The run's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The run's status.
     * @see RunStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * When the run stopped.
     * </p>
     * 
     * @return When the run stopped.
     */
    public final Instant stopTime() {
        return stopTime;
    }

    /**
     * <p>
     * The run's storage capacity.
     * </p>
     * 
     * @return The run's storage capacity.
     */
    public final Integer storageCapacity() {
        return storageCapacity;
    }

    /**
     * <p>
     * The run's workflow ID.
     * </p>
     * 
     * @return The run's workflow ID.
     */
    public final String workflowId() {
        return workflowId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stopTime());
        hashCode = 31 * hashCode + Objects.hashCode(storageCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(workflowId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunListItem)) {
            return false;
        }
        RunListItem other = (RunListItem) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(priority(), other.priority()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(stopTime(), other.stopTime())
                && Objects.equals(storageCapacity(), other.storageCapacity()) && Objects.equals(workflowId(), other.workflowId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RunListItem").add("Arn", arn()).add("CreationTime", creationTime()).add("Id", id())
                .add("Name", name()).add("Priority", priority()).add("StartTime", startTime()).add("Status", statusAsString())
                .add("StopTime", stopTime()).add("StorageCapacity", storageCapacity()).add("WorkflowId", workflowId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "stopTime":
            return Optional.ofNullable(clazz.cast(stopTime()));
        case "storageCapacity":
            return Optional.ofNullable(clazz.cast(storageCapacity()));
        case "workflowId":
            return Optional.ofNullable(clazz.cast(workflowId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RunListItem, T> g) {
        return obj -> g.apply((RunListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RunListItem> {
        /**
         * <p>
         * The run's ARN.
         * </p>
         * 
         * @param arn
         *        The run's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * When the run was created.
         * </p>
         * 
         * @param creationTime
         *        When the run was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The run's ID.
         * </p>
         * 
         * @param id
         *        The run's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The run's name.
         * </p>
         * 
         * @param name
         *        The run's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The run's priority.
         * </p>
         * 
         * @param priority
         *        The run's priority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * When the run started.
         * </p>
         * 
         * @param startTime
         *        When the run started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The run's status.
         * </p>
         * 
         * @param status
         *        The run's status.
         * @see RunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The run's status.
         * </p>
         * 
         * @param status
         *        The run's status.
         * @see RunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunStatus
         */
        Builder status(RunStatus status);

        /**
         * <p>
         * When the run stopped.
         * </p>
         * 
         * @param stopTime
         *        When the run stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopTime(Instant stopTime);

        /**
         * <p>
         * The run's storage capacity.
         * </p>
         * 
         * @param storageCapacity
         *        The run's storage capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageCapacity(Integer storageCapacity);

        /**
         * <p>
         * The run's workflow ID.
         * </p>
         * 
         * @param workflowId
         *        The run's workflow ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant creationTime;

        private String id;

        private String name;

        private Integer priority;

        private Instant startTime;

        private String status;

        private Instant stopTime;

        private Integer storageCapacity;

        private String workflowId;

        private BuilderImpl() {
        }

        private BuilderImpl(RunListItem model) {
            arn(model.arn);
            creationTime(model.creationTime);
            id(model.id);
            name(model.name);
            priority(model.priority);
            startTime(model.startTime);
            status(model.status);
            stopTime(model.stopTime);
            storageCapacity(model.storageCapacity);
            workflowId(model.workflowId);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStopTime() {
            return stopTime;
        }

        public final void setStopTime(Instant stopTime) {
            this.stopTime = stopTime;
        }

        @Override
        public final Builder stopTime(Instant stopTime) {
            this.stopTime = stopTime;
            return this;
        }

        public final Integer getStorageCapacity() {
            return storageCapacity;
        }

        public final void setStorageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
        }

        @Override
        public final Builder storageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
            return this;
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        @Override
        public RunListItem build() {
            return new RunListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
