/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRunGroupRequest extends OmicsRequest implements
        ToCopyableBuilder<UpdateRunGroupRequest.Builder, UpdateRunGroupRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateRunGroupRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final SdkField<Integer> MAX_CPUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxCpus").getter(getter(UpdateRunGroupRequest::maxCpus)).setter(setter(Builder::maxCpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxCpus").build()).build();

    private static final SdkField<Integer> MAX_DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxDuration").getter(getter(UpdateRunGroupRequest::maxDuration)).setter(setter(Builder::maxDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxDuration").build()).build();

    private static final SdkField<Integer> MAX_RUNS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxRuns").getter(getter(UpdateRunGroupRequest::maxRuns)).setter(setter(Builder::maxRuns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxRuns").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateRunGroupRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, MAX_CPUS_FIELD,
            MAX_DURATION_FIELD, MAX_RUNS_FIELD, NAME_FIELD));

    private final String id;

    private final Integer maxCpus;

    private final Integer maxDuration;

    private final Integer maxRuns;

    private final String name;

    private UpdateRunGroupRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.maxCpus = builder.maxCpus;
        this.maxDuration = builder.maxDuration;
        this.maxRuns = builder.maxRuns;
        this.name = builder.name;
    }

    /**
     * <p>
     * The group's ID.
     * </p>
     * 
     * @return The group's ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The maximum number of CPUs to use.
     * </p>
     * 
     * @return The maximum number of CPUs to use.
     */
    public final Integer maxCpus() {
        return maxCpus;
    }

    /**
     * <p>
     * A maximum run time for the group in minutes.
     * </p>
     * 
     * @return A maximum run time for the group in minutes.
     */
    public final Integer maxDuration() {
        return maxDuration;
    }

    /**
     * <p>
     * The maximum number of concurrent runs for the group.
     * </p>
     * 
     * @return The maximum number of concurrent runs for the group.
     */
    public final Integer maxRuns() {
        return maxRuns;
    }

    /**
     * <p>
     * A name for the group.
     * </p>
     * 
     * @return A name for the group.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(maxCpus());
        hashCode = 31 * hashCode + Objects.hashCode(maxDuration());
        hashCode = 31 * hashCode + Objects.hashCode(maxRuns());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRunGroupRequest)) {
            return false;
        }
        UpdateRunGroupRequest other = (UpdateRunGroupRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(maxCpus(), other.maxCpus())
                && Objects.equals(maxDuration(), other.maxDuration()) && Objects.equals(maxRuns(), other.maxRuns())
                && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRunGroupRequest").add("Id", id()).add("MaxCpus", maxCpus())
                .add("MaxDuration", maxDuration()).add("MaxRuns", maxRuns()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "maxCpus":
            return Optional.ofNullable(clazz.cast(maxCpus()));
        case "maxDuration":
            return Optional.ofNullable(clazz.cast(maxDuration()));
        case "maxRuns":
            return Optional.ofNullable(clazz.cast(maxRuns()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRunGroupRequest, T> g) {
        return obj -> g.apply((UpdateRunGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRunGroupRequest> {
        /**
         * <p>
         * The group's ID.
         * </p>
         * 
         * @param id
         *        The group's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The maximum number of CPUs to use.
         * </p>
         * 
         * @param maxCpus
         *        The maximum number of CPUs to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCpus(Integer maxCpus);

        /**
         * <p>
         * A maximum run time for the group in minutes.
         * </p>
         * 
         * @param maxDuration
         *        A maximum run time for the group in minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxDuration(Integer maxDuration);

        /**
         * <p>
         * The maximum number of concurrent runs for the group.
         * </p>
         * 
         * @param maxRuns
         *        The maximum number of concurrent runs for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRuns(Integer maxRuns);

        /**
         * <p>
         * A name for the group.
         * </p>
         * 
         * @param name
         *        A name for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private String id;

        private Integer maxCpus;

        private Integer maxDuration;

        private Integer maxRuns;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRunGroupRequest model) {
            super(model);
            id(model.id);
            maxCpus(model.maxCpus);
            maxDuration(model.maxDuration);
            maxRuns(model.maxRuns);
            name(model.name);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Integer getMaxCpus() {
            return maxCpus;
        }

        public final void setMaxCpus(Integer maxCpus) {
            this.maxCpus = maxCpus;
        }

        @Override
        public final Builder maxCpus(Integer maxCpus) {
            this.maxCpus = maxCpus;
            return this;
        }

        public final Integer getMaxDuration() {
            return maxDuration;
        }

        public final void setMaxDuration(Integer maxDuration) {
            this.maxDuration = maxDuration;
        }

        @Override
        public final Builder maxDuration(Integer maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        public final Integer getMaxRuns() {
            return maxRuns;
        }

        public final void setMaxRuns(Integer maxRuns) {
            this.maxRuns = maxRuns;
        }

        @Override
        public final Builder maxRuns(Integer maxRuns) {
            this.maxRuns = maxRuns;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRunGroupRequest build() {
            return new UpdateRunGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
