/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An annotation import job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnnotationImportJobItem implements SdkPojo, Serializable,
        ToCopyableBuilder<AnnotationImportJobItem.Builder, AnnotationImportJobItem> {
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("completionTime")
            .getter(getter(AnnotationImportJobItem::completionTime))
            .setter(setter(Builder::completionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completionTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(AnnotationImportJobItem::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationName").getter(getter(AnnotationImportJobItem::destinationName))
            .setter(setter(Builder::destinationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationName").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AnnotationImportJobItem::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(AnnotationImportJobItem::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Boolean> RUN_LEFT_NORMALIZATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("runLeftNormalization").getter(getter(AnnotationImportJobItem::runLeftNormalization))
            .setter(setter(Builder::runLeftNormalization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runLeftNormalization").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AnnotationImportJobItem::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime")
            .getter(getter(AnnotationImportJobItem::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETION_TIME_FIELD,
            CREATION_TIME_FIELD, DESTINATION_NAME_FIELD, ID_FIELD, ROLE_ARN_FIELD, RUN_LEFT_NORMALIZATION_FIELD, STATUS_FIELD,
            UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant completionTime;

    private final Instant creationTime;

    private final String destinationName;

    private final String id;

    private final String roleArn;

    private final Boolean runLeftNormalization;

    private final String status;

    private final Instant updateTime;

    private AnnotationImportJobItem(BuilderImpl builder) {
        this.completionTime = builder.completionTime;
        this.creationTime = builder.creationTime;
        this.destinationName = builder.destinationName;
        this.id = builder.id;
        this.roleArn = builder.roleArn;
        this.runLeftNormalization = builder.runLeftNormalization;
        this.status = builder.status;
        this.updateTime = builder.updateTime;
    }

    /**
     * <p>
     * When the job completed.
     * </p>
     * 
     * @return When the job completed.
     */
    public final Instant completionTime() {
        return completionTime;
    }

    /**
     * <p>
     * When the job was created.
     * </p>
     * 
     * @return When the job was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The job's destination annotation store.
     * </p>
     * 
     * @return The job's destination annotation store.
     */
    public final String destinationName() {
        return destinationName;
    }

    /**
     * <p>
     * The job's ID.
     * </p>
     * 
     * @return The job's ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The job's service role ARN.
     * </p>
     * 
     * @return The job's service role ARN.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The job's left normalization setting.
     * </p>
     * 
     * @return The job's left normalization setting.
     */
    public final Boolean runLeftNormalization() {
        return runLeftNormalization;
    }

    /**
     * <p>
     * The job's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The job's status.
     * @see JobStatus
     */
    public final JobStatus status() {
        return JobStatus.fromValue(status);
    }

    /**
     * <p>
     * The job's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The job's status.
     * @see JobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * When the job was updated.
     * </p>
     * 
     * @return When the job was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(runLeftNormalization());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnnotationImportJobItem)) {
            return false;
        }
        AnnotationImportJobItem other = (AnnotationImportJobItem) obj;
        return Objects.equals(completionTime(), other.completionTime()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(destinationName(), other.destinationName()) && Objects.equals(id(), other.id())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(runLeftNormalization(), other.runLeftNormalization())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(updateTime(), other.updateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnnotationImportJobItem").add("CompletionTime", completionTime())
                .add("CreationTime", creationTime()).add("DestinationName", destinationName()).add("Id", id())
                .add("RoleArn", roleArn()).add("RunLeftNormalization", runLeftNormalization()).add("Status", statusAsString())
                .add("UpdateTime", updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "completionTime":
            return Optional.ofNullable(clazz.cast(completionTime()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "destinationName":
            return Optional.ofNullable(clazz.cast(destinationName()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "runLeftNormalization":
            return Optional.ofNullable(clazz.cast(runLeftNormalization()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnnotationImportJobItem, T> g) {
        return obj -> g.apply((AnnotationImportJobItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnnotationImportJobItem> {
        /**
         * <p>
         * When the job completed.
         * </p>
         * 
         * @param completionTime
         *        When the job completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTime(Instant completionTime);

        /**
         * <p>
         * When the job was created.
         * </p>
         * 
         * @param creationTime
         *        When the job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The job's destination annotation store.
         * </p>
         * 
         * @param destinationName
         *        The job's destination annotation store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationName(String destinationName);

        /**
         * <p>
         * The job's ID.
         * </p>
         * 
         * @param id
         *        The job's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The job's service role ARN.
         * </p>
         * 
         * @param roleArn
         *        The job's service role ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The job's left normalization setting.
         * </p>
         * 
         * @param runLeftNormalization
         *        The job's left normalization setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runLeftNormalization(Boolean runLeftNormalization);

        /**
         * <p>
         * The job's status.
         * </p>
         * 
         * @param status
         *        The job's status.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The job's status.
         * </p>
         * 
         * @param status
         *        The job's status.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(JobStatus status);

        /**
         * <p>
         * When the job was updated.
         * </p>
         * 
         * @param updateTime
         *        When the job was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl implements Builder {
        private Instant completionTime;

        private Instant creationTime;

        private String destinationName;

        private String id;

        private String roleArn;

        private Boolean runLeftNormalization;

        private String status;

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AnnotationImportJobItem model) {
            completionTime(model.completionTime);
            creationTime(model.creationTime);
            destinationName(model.destinationName);
            id(model.id);
            roleArn(model.roleArn);
            runLeftNormalization(model.runLeftNormalization);
            status(model.status);
            updateTime(model.updateTime);
        }

        public final Instant getCompletionTime() {
            return completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDestinationName() {
            return destinationName;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Boolean getRunLeftNormalization() {
            return runLeftNormalization;
        }

        public final void setRunLeftNormalization(Boolean runLeftNormalization) {
            this.runLeftNormalization = runLeftNormalization;
        }

        @Override
        public final Builder runLeftNormalization(Boolean runLeftNormalization) {
            this.runLeftNormalization = runLeftNormalization;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public AnnotationImportJobItem build() {
            return new AnnotationImportJobItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
