/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVariantStoreRequest extends OmicsRequest implements
        ToCopyableBuilder<CreateVariantStoreRequest.Builder, CreateVariantStoreRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateVariantStoreRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateVariantStoreRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<ReferenceItem> REFERENCE_FIELD = SdkField.<ReferenceItem> builder(MarshallingType.SDK_POJO)
            .memberName("reference").getter(getter(CreateVariantStoreRequest::reference)).setter(setter(Builder::reference))
            .constructor(ReferenceItem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reference").build()).build();

    private static final SdkField<SseConfig> SSE_CONFIG_FIELD = SdkField.<SseConfig> builder(MarshallingType.SDK_POJO)
            .memberName("sseConfig").getter(getter(CreateVariantStoreRequest::sseConfig)).setter(setter(Builder::sseConfig))
            .constructor(SseConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sseConfig").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateVariantStoreRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, NAME_FIELD,
            REFERENCE_FIELD, SSE_CONFIG_FIELD, TAGS_FIELD));

    private final String description;

    private final String name;

    private final ReferenceItem reference;

    private final SseConfig sseConfig;

    private final Map<String, String> tags;

    private CreateVariantStoreRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.name = builder.name;
        this.reference = builder.reference;
        this.sseConfig = builder.sseConfig;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A description for the store.
     * </p>
     * 
     * @return A description for the store.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A name for the store.
     * </p>
     * 
     * @return A name for the store.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The genome reference for the store's variants.
     * </p>
     * 
     * @return The genome reference for the store's variants.
     */
    public final ReferenceItem reference() {
        return reference;
    }

    /**
     * <p>
     * Server-side encryption (SSE) settings for the store.
     * </p>
     * 
     * @return Server-side encryption (SSE) settings for the store.
     */
    public final SseConfig sseConfig() {
        return sseConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags for the store.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags for the store.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(reference());
        hashCode = 31 * hashCode + Objects.hashCode(sseConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVariantStoreRequest)) {
            return false;
        }
        CreateVariantStoreRequest other = (CreateVariantStoreRequest) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(name(), other.name())
                && Objects.equals(reference(), other.reference()) && Objects.equals(sseConfig(), other.sseConfig())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVariantStoreRequest").add("Description", description()).add("Name", name())
                .add("Reference", reference()).add("SseConfig", sseConfig()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "reference":
            return Optional.ofNullable(clazz.cast(reference()));
        case "sseConfig":
            return Optional.ofNullable(clazz.cast(sseConfig()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVariantStoreRequest, T> g) {
        return obj -> g.apply((CreateVariantStoreRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateVariantStoreRequest> {
        /**
         * <p>
         * A description for the store.
         * </p>
         * 
         * @param description
         *        A description for the store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A name for the store.
         * </p>
         * 
         * @param name
         *        A name for the store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The genome reference for the store's variants.
         * </p>
         * 
         * @param reference
         *        The genome reference for the store's variants.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reference(ReferenceItem reference);

        /**
         * <p>
         * The genome reference for the store's variants.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReferenceItem.Builder} avoiding the need
         * to create one manually via {@link ReferenceItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReferenceItem.Builder#build()} is called immediately and its
         * result is passed to {@link #reference(ReferenceItem)}.
         * 
         * @param reference
         *        a consumer that will call methods on {@link ReferenceItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reference(ReferenceItem)
         */
        default Builder reference(Consumer<ReferenceItem.Builder> reference) {
            return reference(ReferenceItem.builder().applyMutation(reference).build());
        }

        /**
         * <p>
         * Server-side encryption (SSE) settings for the store.
         * </p>
         * 
         * @param sseConfig
         *        Server-side encryption (SSE) settings for the store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseConfig(SseConfig sseConfig);

        /**
         * <p>
         * Server-side encryption (SSE) settings for the store.
         * </p>
         * This is a convenience method that creates an instance of the {@link SseConfig.Builder} avoiding the need to
         * create one manually via {@link SseConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SseConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #sseConfig(SseConfig)}.
         * 
         * @param sseConfig
         *        a consumer that will call methods on {@link SseConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sseConfig(SseConfig)
         */
        default Builder sseConfig(Consumer<SseConfig.Builder> sseConfig) {
            return sseConfig(SseConfig.builder().applyMutation(sseConfig).build());
        }

        /**
         * <p>
         * Tags for the store.
         * </p>
         * 
         * @param tags
         *        Tags for the store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private String description;

        private String name;

        private ReferenceItem reference;

        private SseConfig sseConfig;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVariantStoreRequest model) {
            super(model);
            description(model.description);
            name(model.name);
            reference(model.reference);
            sseConfig(model.sseConfig);
            tags(model.tags);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ReferenceItem.Builder getReference() {
            return reference != null ? reference.toBuilder() : null;
        }

        public final void setReference(ReferenceItem.BuilderImpl reference) {
            this.reference = reference != null ? reference.build() : null;
        }

        @Override
        public final Builder reference(ReferenceItem reference) {
            this.reference = reference;
            return this;
        }

        public final SseConfig.Builder getSseConfig() {
            return sseConfig != null ? sseConfig.toBuilder() : null;
        }

        public final void setSseConfig(SseConfig.BuilderImpl sseConfig) {
            this.sseConfig = sseConfig != null ? sseConfig.build() : null;
        }

        @Override
        public final Builder sseConfig(SseConfig sseConfig) {
            this.sseConfig = sseConfig;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVariantStoreRequest build() {
            return new CreateVariantStoreRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
