/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVariantStoresResponse extends OmicsResponse implements
        ToCopyableBuilder<ListVariantStoresResponse.Builder, ListVariantStoresResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListVariantStoresResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<VariantStoreItem>> VARIANT_STORES_FIELD = SdkField
            .<List<VariantStoreItem>> builder(MarshallingType.LIST)
            .memberName("variantStores")
            .getter(getter(ListVariantStoresResponse::variantStores))
            .setter(setter(Builder::variantStores))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variantStores").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VariantStoreItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(VariantStoreItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            VARIANT_STORES_FIELD));

    private final String nextToken;

    private final List<VariantStoreItem> variantStores;

    private ListVariantStoresResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.variantStores = builder.variantStores;
    }

    /**
     * <p>
     * A pagination token that's included if more results are available.
     * </p>
     * 
     * @return A pagination token that's included if more results are available.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the VariantStores property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVariantStores() {
        return variantStores != null && !(variantStores instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of variant stores.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVariantStores} method.
     * </p>
     * 
     * @return A list of variant stores.
     */
    public final List<VariantStoreItem> variantStores() {
        return variantStores;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasVariantStores() ? variantStores() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVariantStoresResponse)) {
            return false;
        }
        ListVariantStoresResponse other = (ListVariantStoresResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasVariantStores() == other.hasVariantStores()
                && Objects.equals(variantStores(), other.variantStores());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListVariantStoresResponse").add("NextToken", nextToken())
                .add("VariantStores", hasVariantStores() ? variantStores() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "variantStores":
            return Optional.ofNullable(clazz.cast(variantStores()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVariantStoresResponse, T> g) {
        return obj -> g.apply((ListVariantStoresResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListVariantStoresResponse> {
        /**
         * <p>
         * A pagination token that's included if more results are available.
         * </p>
         * 
         * @param nextToken
         *        A pagination token that's included if more results are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of variant stores.
         * </p>
         * 
         * @param variantStores
         *        A list of variant stores.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variantStores(Collection<VariantStoreItem> variantStores);

        /**
         * <p>
         * A list of variant stores.
         * </p>
         * 
         * @param variantStores
         *        A list of variant stores.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variantStores(VariantStoreItem... variantStores);

        /**
         * <p>
         * A list of variant stores.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.omics.model.VariantStoreItem.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.omics.model.VariantStoreItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.omics.model.VariantStoreItem.Builder#build()} is called immediately
         * and its result is passed to {@link #variantStores(List<VariantStoreItem>)}.
         * 
         * @param variantStores
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.omics.model.VariantStoreItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #variantStores(java.util.Collection<VariantStoreItem>)
         */
        Builder variantStores(Consumer<VariantStoreItem.Builder>... variantStores);
    }

    static final class BuilderImpl extends OmicsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<VariantStoreItem> variantStores = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVariantStoresResponse model) {
            super(model);
            nextToken(model.nextToken);
            variantStores(model.variantStores);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<VariantStoreItem.Builder> getVariantStores() {
            List<VariantStoreItem.Builder> result = VariantStoreItemsCopier.copyToBuilder(this.variantStores);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariantStores(Collection<VariantStoreItem.BuilderImpl> variantStores) {
            this.variantStores = VariantStoreItemsCopier.copyFromBuilder(variantStores);
        }

        @Override
        public final Builder variantStores(Collection<VariantStoreItem> variantStores) {
            this.variantStores = VariantStoreItemsCopier.copy(variantStores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variantStores(VariantStoreItem... variantStores) {
            variantStores(Arrays.asList(variantStores));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variantStores(Consumer<VariantStoreItem.Builder>... variantStores) {
            variantStores(Stream.of(variantStores).map(c -> VariantStoreItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListVariantStoresResponse build() {
            return new ListVariantStoresResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
