/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A genome reference.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReferenceListItem implements SdkPojo, Serializable,
        ToCopyableBuilder<ReferenceListItem.Builder, ReferenceListItem> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ReferenceListItem::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(ReferenceListItem::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ReferenceListItem::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ReferenceListItem::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> MD5_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("md5")
            .getter(getter(ReferenceListItem::md5)).setter(setter(Builder::md5))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("md5").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ReferenceListItem::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> REFERENCE_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("referenceStoreId").getter(getter(ReferenceListItem::referenceStoreId))
            .setter(setter(Builder::referenceStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceStoreId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ReferenceListItem::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime")
            .getter(getter(ReferenceListItem::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CREATION_TIME_FIELD, DESCRIPTION_FIELD, ID_FIELD, MD5_FIELD, NAME_FIELD, REFERENCE_STORE_ID_FIELD, STATUS_FIELD,
            UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant creationTime;

    private final String description;

    private final String id;

    private final String md5;

    private final String name;

    private final String referenceStoreId;

    private final String status;

    private final Instant updateTime;

    private ReferenceListItem(BuilderImpl builder) {
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.id = builder.id;
        this.md5 = builder.md5;
        this.name = builder.name;
        this.referenceStoreId = builder.referenceStoreId;
        this.status = builder.status;
        this.updateTime = builder.updateTime;
    }

    /**
     * <p>
     * The reference's ARN.
     * </p>
     * 
     * @return The reference's ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * When the reference was created.
     * </p>
     * 
     * @return When the reference was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The reference's description.
     * </p>
     * 
     * @return The reference's description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The reference's ID.
     * </p>
     * 
     * @return The reference's ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The reference's MD5 checksum.
     * </p>
     * 
     * @return The reference's MD5 checksum.
     */
    public final String md5() {
        return md5;
    }

    /**
     * <p>
     * The reference's name.
     * </p>
     * 
     * @return The reference's name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The reference's store ID.
     * </p>
     * 
     * @return The reference's store ID.
     */
    public final String referenceStoreId() {
        return referenceStoreId;
    }

    /**
     * <p>
     * The reference's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReferenceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The reference's status.
     * @see ReferenceStatus
     */
    public final ReferenceStatus status() {
        return ReferenceStatus.fromValue(status);
    }

    /**
     * <p>
     * The reference's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReferenceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The reference's status.
     * @see ReferenceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * When the reference was updated.
     * </p>
     * 
     * @return When the reference was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(md5());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(referenceStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceListItem)) {
            return false;
        }
        ReferenceListItem other = (ReferenceListItem) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(description(), other.description()) && Objects.equals(id(), other.id())
                && Objects.equals(md5(), other.md5()) && Objects.equals(name(), other.name())
                && Objects.equals(referenceStoreId(), other.referenceStoreId())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(updateTime(), other.updateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReferenceListItem").add("Arn", arn()).add("CreationTime", creationTime())
                .add("Description", description()).add("Id", id()).add("Md5", md5()).add("Name", name())
                .add("ReferenceStoreId", referenceStoreId()).add("Status", statusAsString()).add("UpdateTime", updateTime())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "md5":
            return Optional.ofNullable(clazz.cast(md5()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "referenceStoreId":
            return Optional.ofNullable(clazz.cast(referenceStoreId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReferenceListItem, T> g) {
        return obj -> g.apply((ReferenceListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReferenceListItem> {
        /**
         * <p>
         * The reference's ARN.
         * </p>
         * 
         * @param arn
         *        The reference's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * When the reference was created.
         * </p>
         * 
         * @param creationTime
         *        When the reference was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The reference's description.
         * </p>
         * 
         * @param description
         *        The reference's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The reference's ID.
         * </p>
         * 
         * @param id
         *        The reference's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The reference's MD5 checksum.
         * </p>
         * 
         * @param md5
         *        The reference's MD5 checksum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder md5(String md5);

        /**
         * <p>
         * The reference's name.
         * </p>
         * 
         * @param name
         *        The reference's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The reference's store ID.
         * </p>
         * 
         * @param referenceStoreId
         *        The reference's store ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceStoreId(String referenceStoreId);

        /**
         * <p>
         * The reference's status.
         * </p>
         * 
         * @param status
         *        The reference's status.
         * @see ReferenceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReferenceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The reference's status.
         * </p>
         * 
         * @param status
         *        The reference's status.
         * @see ReferenceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReferenceStatus
         */
        Builder status(ReferenceStatus status);

        /**
         * <p>
         * When the reference was updated.
         * </p>
         * 
         * @param updateTime
         *        When the reference was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant creationTime;

        private String description;

        private String id;

        private String md5;

        private String name;

        private String referenceStoreId;

        private String status;

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceListItem model) {
            arn(model.arn);
            creationTime(model.creationTime);
            description(model.description);
            id(model.id);
            md5(model.md5);
            name(model.name);
            referenceStoreId(model.referenceStoreId);
            status(model.status);
            updateTime(model.updateTime);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getMd5() {
            return md5;
        }

        public final void setMd5(String md5) {
            this.md5 = md5;
        }

        @Override
        public final Builder md5(String md5) {
            this.md5 = md5;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getReferenceStoreId() {
            return referenceStoreId;
        }

        public final void setReferenceStoreId(String referenceStoreId) {
            this.referenceStoreId = referenceStoreId;
        }

        @Override
        public final Builder referenceStoreId(String referenceStoreId) {
            this.referenceStoreId = referenceStoreId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReferenceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public ReferenceListItem build() {
            return new ReferenceListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
