/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A run group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RunGroupListItem implements SdkPojo, Serializable,
        ToCopyableBuilder<RunGroupListItem.Builder, RunGroupListItem> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(RunGroupListItem::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(RunGroupListItem::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(RunGroupListItem::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Integer> MAX_CPUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxCpus").getter(getter(RunGroupListItem::maxCpus)).setter(setter(Builder::maxCpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxCpus").build()).build();

    private static final SdkField<Integer> MAX_DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxDuration").getter(getter(RunGroupListItem::maxDuration)).setter(setter(Builder::maxDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxDuration").build()).build();

    private static final SdkField<Integer> MAX_RUNS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxRuns").getter(getter(RunGroupListItem::maxRuns)).setter(setter(Builder::maxRuns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxRuns").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(RunGroupListItem::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CREATION_TIME_FIELD, ID_FIELD, MAX_CPUS_FIELD, MAX_DURATION_FIELD, MAX_RUNS_FIELD, NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant creationTime;

    private final String id;

    private final Integer maxCpus;

    private final Integer maxDuration;

    private final Integer maxRuns;

    private final String name;

    private RunGroupListItem(BuilderImpl builder) {
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.id = builder.id;
        this.maxCpus = builder.maxCpus;
        this.maxDuration = builder.maxDuration;
        this.maxRuns = builder.maxRuns;
        this.name = builder.name;
    }

    /**
     * <p>
     * The group's ARN.
     * </p>
     * 
     * @return The group's ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * When the group was created.
     * </p>
     * 
     * @return When the group was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The group's ID.
     * </p>
     * 
     * @return The group's ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The group's maximum CPU count setting.
     * </p>
     * 
     * @return The group's maximum CPU count setting.
     */
    public final Integer maxCpus() {
        return maxCpus;
    }

    /**
     * <p>
     * The group's maximum duration setting in minutes.
     * </p>
     * 
     * @return The group's maximum duration setting in minutes.
     */
    public final Integer maxDuration() {
        return maxDuration;
    }

    /**
     * <p>
     * The group's maximum concurrent run setting.
     * </p>
     * 
     * @return The group's maximum concurrent run setting.
     */
    public final Integer maxRuns() {
        return maxRuns;
    }

    /**
     * <p>
     * The group's name.
     * </p>
     * 
     * @return The group's name.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(maxCpus());
        hashCode = 31 * hashCode + Objects.hashCode(maxDuration());
        hashCode = 31 * hashCode + Objects.hashCode(maxRuns());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunGroupListItem)) {
            return false;
        }
        RunGroupListItem other = (RunGroupListItem) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(id(), other.id()) && Objects.equals(maxCpus(), other.maxCpus())
                && Objects.equals(maxDuration(), other.maxDuration()) && Objects.equals(maxRuns(), other.maxRuns())
                && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RunGroupListItem").add("Arn", arn()).add("CreationTime", creationTime()).add("Id", id())
                .add("MaxCpus", maxCpus()).add("MaxDuration", maxDuration()).add("MaxRuns", maxRuns()).add("Name", name())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "maxCpus":
            return Optional.ofNullable(clazz.cast(maxCpus()));
        case "maxDuration":
            return Optional.ofNullable(clazz.cast(maxDuration()));
        case "maxRuns":
            return Optional.ofNullable(clazz.cast(maxRuns()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RunGroupListItem, T> g) {
        return obj -> g.apply((RunGroupListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RunGroupListItem> {
        /**
         * <p>
         * The group's ARN.
         * </p>
         * 
         * @param arn
         *        The group's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * When the group was created.
         * </p>
         * 
         * @param creationTime
         *        When the group was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The group's ID.
         * </p>
         * 
         * @param id
         *        The group's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The group's maximum CPU count setting.
         * </p>
         * 
         * @param maxCpus
         *        The group's maximum CPU count setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCpus(Integer maxCpus);

        /**
         * <p>
         * The group's maximum duration setting in minutes.
         * </p>
         * 
         * @param maxDuration
         *        The group's maximum duration setting in minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxDuration(Integer maxDuration);

        /**
         * <p>
         * The group's maximum concurrent run setting.
         * </p>
         * 
         * @param maxRuns
         *        The group's maximum concurrent run setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRuns(Integer maxRuns);

        /**
         * <p>
         * The group's name.
         * </p>
         * 
         * @param name
         *        The group's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant creationTime;

        private String id;

        private Integer maxCpus;

        private Integer maxDuration;

        private Integer maxRuns;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(RunGroupListItem model) {
            arn(model.arn);
            creationTime(model.creationTime);
            id(model.id);
            maxCpus(model.maxCpus);
            maxDuration(model.maxDuration);
            maxRuns(model.maxRuns);
            name(model.name);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Integer getMaxCpus() {
            return maxCpus;
        }

        public final void setMaxCpus(Integer maxCpus) {
            this.maxCpus = maxCpus;
        }

        @Override
        public final Builder maxCpus(Integer maxCpus) {
            this.maxCpus = maxCpus;
            return this;
        }

        public final Integer getMaxDuration() {
            return maxDuration;
        }

        public final void setMaxDuration(Integer maxDuration) {
            this.maxDuration = maxDuration;
        }

        @Override
        public final Builder maxDuration(Integer maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        public final Integer getMaxRuns() {
            return maxRuns;
        }

        public final void setMaxRuns(Integer maxRuns) {
            this.maxRuns = maxRuns;
        }

        @Override
        public final Builder maxRuns(Integer maxRuns) {
            this.maxRuns = maxRuns;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public RunGroupListItem build() {
            return new RunGroupListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
