/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A source for a read set import job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartReadSetImportJobSourceItem implements SdkPojo, Serializable,
        ToCopyableBuilder<StartReadSetImportJobSourceItem.Builder, StartReadSetImportJobSourceItem> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(StartReadSetImportJobSourceItem::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> GENERATED_FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("generatedFrom").getter(getter(StartReadSetImportJobSourceItem::generatedFrom))
            .setter(setter(Builder::generatedFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedFrom").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(StartReadSetImportJobSourceItem::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> REFERENCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("referenceArn").getter(getter(StartReadSetImportJobSourceItem::referenceArn))
            .setter(setter(Builder::referenceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceArn").build()).build();

    private static final SdkField<String> SAMPLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sampleId").getter(getter(StartReadSetImportJobSourceItem::sampleId)).setter(setter(Builder::sampleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleId").build()).build();

    private static final SdkField<String> SOURCE_FILE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceFileType").getter(getter(StartReadSetImportJobSourceItem::sourceFileTypeAsString))
            .setter(setter(Builder::sourceFileType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFileType").build()).build();

    private static final SdkField<SourceFiles> SOURCE_FILES_FIELD = SdkField.<SourceFiles> builder(MarshallingType.SDK_POJO)
            .memberName("sourceFiles").getter(getter(StartReadSetImportJobSourceItem::sourceFiles))
            .setter(setter(Builder::sourceFiles)).constructor(SourceFiles::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFiles").build()).build();

    private static final SdkField<String> SUBJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subjectId").getter(getter(StartReadSetImportJobSourceItem::subjectId))
            .setter(setter(Builder::subjectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subjectId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(StartReadSetImportJobSourceItem::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            GENERATED_FROM_FIELD, NAME_FIELD, REFERENCE_ARN_FIELD, SAMPLE_ID_FIELD, SOURCE_FILE_TYPE_FIELD, SOURCE_FILES_FIELD,
            SUBJECT_ID_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final String generatedFrom;

    private final String name;

    private final String referenceArn;

    private final String sampleId;

    private final String sourceFileType;

    private final SourceFiles sourceFiles;

    private final String subjectId;

    private final Map<String, String> tags;

    private StartReadSetImportJobSourceItem(BuilderImpl builder) {
        this.description = builder.description;
        this.generatedFrom = builder.generatedFrom;
        this.name = builder.name;
        this.referenceArn = builder.referenceArn;
        this.sampleId = builder.sampleId;
        this.sourceFileType = builder.sourceFileType;
        this.sourceFiles = builder.sourceFiles;
        this.subjectId = builder.subjectId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The source's description.
     * </p>
     * 
     * @return The source's description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Where the source originated.
     * </p>
     * 
     * @return Where the source originated.
     */
    public final String generatedFrom() {
        return generatedFrom;
    }

    /**
     * <p>
     * The source's name.
     * </p>
     * 
     * @return The source's name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The source's reference ARN.
     * </p>
     * 
     * @return The source's reference ARN.
     */
    public final String referenceArn() {
        return referenceArn;
    }

    /**
     * <p>
     * The source's sample ID.
     * </p>
     * 
     * @return The source's sample ID.
     */
    public final String sampleId() {
        return sampleId;
    }

    /**
     * <p>
     * The source's file type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceFileType}
     * will return {@link FileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceFileTypeAsString}.
     * </p>
     * 
     * @return The source's file type.
     * @see FileType
     */
    public final FileType sourceFileType() {
        return FileType.fromValue(sourceFileType);
    }

    /**
     * <p>
     * The source's file type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceFileType}
     * will return {@link FileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceFileTypeAsString}.
     * </p>
     * 
     * @return The source's file type.
     * @see FileType
     */
    public final String sourceFileTypeAsString() {
        return sourceFileType;
    }

    /**
     * <p>
     * The source files' location in Amazon S3.
     * </p>
     * 
     * @return The source files' location in Amazon S3.
     */
    public final SourceFiles sourceFiles() {
        return sourceFiles;
    }

    /**
     * <p>
     * The source's subject ID.
     * </p>
     * 
     * @return The source's subject ID.
     */
    public final String subjectId() {
        return subjectId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The source's tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The source's tags.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(generatedFrom());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(referenceArn());
        hashCode = 31 * hashCode + Objects.hashCode(sampleId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceFileTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceFiles());
        hashCode = 31 * hashCode + Objects.hashCode(subjectId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartReadSetImportJobSourceItem)) {
            return false;
        }
        StartReadSetImportJobSourceItem other = (StartReadSetImportJobSourceItem) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(generatedFrom(), other.generatedFrom())
                && Objects.equals(name(), other.name()) && Objects.equals(referenceArn(), other.referenceArn())
                && Objects.equals(sampleId(), other.sampleId())
                && Objects.equals(sourceFileTypeAsString(), other.sourceFileTypeAsString())
                && Objects.equals(sourceFiles(), other.sourceFiles()) && Objects.equals(subjectId(), other.subjectId())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartReadSetImportJobSourceItem").add("Description", description())
                .add("GeneratedFrom", generatedFrom()).add("Name", name()).add("ReferenceArn", referenceArn())
                .add("SampleId", sampleId()).add("SourceFileType", sourceFileTypeAsString()).add("SourceFiles", sourceFiles())
                .add("SubjectId", subjectId()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "generatedFrom":
            return Optional.ofNullable(clazz.cast(generatedFrom()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "referenceArn":
            return Optional.ofNullable(clazz.cast(referenceArn()));
        case "sampleId":
            return Optional.ofNullable(clazz.cast(sampleId()));
        case "sourceFileType":
            return Optional.ofNullable(clazz.cast(sourceFileTypeAsString()));
        case "sourceFiles":
            return Optional.ofNullable(clazz.cast(sourceFiles()));
        case "subjectId":
            return Optional.ofNullable(clazz.cast(subjectId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartReadSetImportJobSourceItem, T> g) {
        return obj -> g.apply((StartReadSetImportJobSourceItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StartReadSetImportJobSourceItem> {
        /**
         * <p>
         * The source's description.
         * </p>
         * 
         * @param description
         *        The source's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Where the source originated.
         * </p>
         * 
         * @param generatedFrom
         *        Where the source originated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedFrom(String generatedFrom);

        /**
         * <p>
         * The source's name.
         * </p>
         * 
         * @param name
         *        The source's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The source's reference ARN.
         * </p>
         * 
         * @param referenceArn
         *        The source's reference ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceArn(String referenceArn);

        /**
         * <p>
         * The source's sample ID.
         * </p>
         * 
         * @param sampleId
         *        The source's sample ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleId(String sampleId);

        /**
         * <p>
         * The source's file type.
         * </p>
         * 
         * @param sourceFileType
         *        The source's file type.
         * @see FileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileType
         */
        Builder sourceFileType(String sourceFileType);

        /**
         * <p>
         * The source's file type.
         * </p>
         * 
         * @param sourceFileType
         *        The source's file type.
         * @see FileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileType
         */
        Builder sourceFileType(FileType sourceFileType);

        /**
         * <p>
         * The source files' location in Amazon S3.
         * </p>
         * 
         * @param sourceFiles
         *        The source files' location in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceFiles(SourceFiles sourceFiles);

        /**
         * <p>
         * The source files' location in Amazon S3.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceFiles.Builder} avoiding the need to
         * create one manually via {@link SourceFiles#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceFiles.Builder#build()} is called immediately and its result
         * is passed to {@link #sourceFiles(SourceFiles)}.
         * 
         * @param sourceFiles
         *        a consumer that will call methods on {@link SourceFiles.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceFiles(SourceFiles)
         */
        default Builder sourceFiles(Consumer<SourceFiles.Builder> sourceFiles) {
            return sourceFiles(SourceFiles.builder().applyMutation(sourceFiles).build());
        }

        /**
         * <p>
         * The source's subject ID.
         * </p>
         * 
         * @param subjectId
         *        The source's subject ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectId(String subjectId);

        /**
         * <p>
         * The source's tags.
         * </p>
         * 
         * @param tags
         *        The source's tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String generatedFrom;

        private String name;

        private String referenceArn;

        private String sampleId;

        private String sourceFileType;

        private SourceFiles sourceFiles;

        private String subjectId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartReadSetImportJobSourceItem model) {
            description(model.description);
            generatedFrom(model.generatedFrom);
            name(model.name);
            referenceArn(model.referenceArn);
            sampleId(model.sampleId);
            sourceFileType(model.sourceFileType);
            sourceFiles(model.sourceFiles);
            subjectId(model.subjectId);
            tags(model.tags);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getGeneratedFrom() {
            return generatedFrom;
        }

        public final void setGeneratedFrom(String generatedFrom) {
            this.generatedFrom = generatedFrom;
        }

        @Override
        public final Builder generatedFrom(String generatedFrom) {
            this.generatedFrom = generatedFrom;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getReferenceArn() {
            return referenceArn;
        }

        public final void setReferenceArn(String referenceArn) {
            this.referenceArn = referenceArn;
        }

        @Override
        public final Builder referenceArn(String referenceArn) {
            this.referenceArn = referenceArn;
            return this;
        }

        public final String getSampleId() {
            return sampleId;
        }

        public final void setSampleId(String sampleId) {
            this.sampleId = sampleId;
        }

        @Override
        public final Builder sampleId(String sampleId) {
            this.sampleId = sampleId;
            return this;
        }

        public final String getSourceFileType() {
            return sourceFileType;
        }

        public final void setSourceFileType(String sourceFileType) {
            this.sourceFileType = sourceFileType;
        }

        @Override
        public final Builder sourceFileType(String sourceFileType) {
            this.sourceFileType = sourceFileType;
            return this;
        }

        @Override
        public final Builder sourceFileType(FileType sourceFileType) {
            this.sourceFileType(sourceFileType == null ? null : sourceFileType.toString());
            return this;
        }

        public final SourceFiles.Builder getSourceFiles() {
            return sourceFiles != null ? sourceFiles.toBuilder() : null;
        }

        public final void setSourceFiles(SourceFiles.BuilderImpl sourceFiles) {
            this.sourceFiles = sourceFiles != null ? sourceFiles.build() : null;
        }

        @Override
        public final Builder sourceFiles(SourceFiles sourceFiles) {
            this.sourceFiles = sourceFiles;
            return this;
        }

        public final String getSubjectId() {
            return subjectId;
        }

        public final void setSubjectId(String subjectId) {
            this.subjectId = subjectId;
        }

        @Override
        public final Builder subjectId(String subjectId) {
            this.subjectId = subjectId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public StartReadSetImportJobSourceItem build() {
            return new StartReadSetImportJobSourceItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
