/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartRunRequest extends OmicsRequest implements ToCopyableBuilder<StartRunRequest.Builder, StartRunRequest> {
    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logLevel").getter(getter(StartRunRequest::logLevelAsString)).setter(setter(Builder::logLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logLevel").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(StartRunRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OUTPUT_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputUri").getter(getter(StartRunRequest::outputUri)).setter(setter(Builder::outputUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputUri").build()).build();

    private static final SdkField<Document> PARAMETERS_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("parameters").getter(getter(StartRunRequest::parameters)).setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("priority").getter(getter(StartRunRequest::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("requestId")
            .getter(getter(StartRunRequest::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(StartRunRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> RUN_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("runGroupId").getter(getter(StartRunRequest::runGroupId)).setter(setter(Builder::runGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runGroupId").build()).build();

    private static final SdkField<String> RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("runId")
            .getter(getter(StartRunRequest::runId)).setter(setter(Builder::runId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runId").build()).build();

    private static final SdkField<Integer> STORAGE_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("storageCapacity").getter(getter(StartRunRequest::storageCapacity))
            .setter(setter(Builder::storageCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageCapacity").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(StartRunRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowId").getter(getter(StartRunRequest::workflowId)).setter(setter(Builder::workflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowId").build()).build();

    private static final SdkField<String> WORKFLOW_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowType").getter(getter(StartRunRequest::workflowTypeAsString))
            .setter(setter(Builder::workflowType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_LEVEL_FIELD, NAME_FIELD,
            OUTPUT_URI_FIELD, PARAMETERS_FIELD, PRIORITY_FIELD, REQUEST_ID_FIELD, ROLE_ARN_FIELD, RUN_GROUP_ID_FIELD,
            RUN_ID_FIELD, STORAGE_CAPACITY_FIELD, TAGS_FIELD, WORKFLOW_ID_FIELD, WORKFLOW_TYPE_FIELD));

    private final String logLevel;

    private final String name;

    private final String outputUri;

    private final Document parameters;

    private final Integer priority;

    private final String requestIdValue;

    private final String roleArn;

    private final String runGroupId;

    private final String runId;

    private final Integer storageCapacity;

    private final Map<String, String> tags;

    private final String workflowId;

    private final String workflowType;

    private StartRunRequest(BuilderImpl builder) {
        super(builder);
        this.logLevel = builder.logLevel;
        this.name = builder.name;
        this.outputUri = builder.outputUri;
        this.parameters = builder.parameters;
        this.priority = builder.priority;
        this.requestIdValue = builder.requestIdValue;
        this.roleArn = builder.roleArn;
        this.runGroupId = builder.runGroupId;
        this.runId = builder.runId;
        this.storageCapacity = builder.storageCapacity;
        this.tags = builder.tags;
        this.workflowId = builder.workflowId;
        this.workflowType = builder.workflowType;
    }

    /**
     * <p>
     * A log level for the run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link RunLogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return A log level for the run.
     * @see RunLogLevel
     */
    public final RunLogLevel logLevel() {
        return RunLogLevel.fromValue(logLevel);
    }

    /**
     * <p>
     * A log level for the run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link RunLogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return A log level for the run.
     * @see RunLogLevel
     */
    public final String logLevelAsString() {
        return logLevel;
    }

    /**
     * <p>
     * A name for the run.
     * </p>
     * 
     * @return A name for the run.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * An output URI for the run.
     * </p>
     * 
     * @return An output URI for the run.
     */
    public final String outputUri() {
        return outputUri;
    }

    /**
     * <p>
     * Parameters for the run.
     * </p>
     * 
     * @return Parameters for the run.
     */
    public final Document parameters() {
        return parameters;
    }

    /**
     * <p>
     * A priority for the run.
     * </p>
     * 
     * @return A priority for the run.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * To ensure that requests don't run multiple times, specify a unique ID for each request.
     * </p>
     * 
     * @return To ensure that requests don't run multiple times, specify a unique ID for each request.
     */
    public final String requestId() {
        return requestIdValue;
    }

    /**
     * <p>
     * A service role for the run.
     * </p>
     * 
     * @return A service role for the run.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The run's group ID.
     * </p>
     * 
     * @return The run's group ID.
     */
    public final String runGroupId() {
        return runGroupId;
    }

    /**
     * <p>
     * The run's ID.
     * </p>
     * 
     * @return The run's ID.
     */
    public final String runId() {
        return runId;
    }

    /**
     * <p>
     * A storage capacity for the run in gigabytes.
     * </p>
     * 
     * @return A storage capacity for the run in gigabytes.
     */
    public final Integer storageCapacity() {
        return storageCapacity;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags for the run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags for the run.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The run's workflow ID.
     * </p>
     * 
     * @return The run's workflow ID.
     */
    public final String workflowId() {
        return workflowId;
    }

    /**
     * <p>
     * The run's workflows type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workflowType} will
     * return {@link WorkflowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workflowTypeAsString}.
     * </p>
     * 
     * @return The run's workflows type.
     * @see WorkflowType
     */
    public final WorkflowType workflowType() {
        return WorkflowType.fromValue(workflowType);
    }

    /**
     * <p>
     * The run's workflows type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workflowType} will
     * return {@link WorkflowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workflowTypeAsString}.
     * </p>
     * 
     * @return The run's workflows type.
     * @see WorkflowType
     */
    public final String workflowTypeAsString() {
        return workflowType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(logLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(outputUri());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(runGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(runId());
        hashCode = 31 * hashCode + Objects.hashCode(storageCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(workflowTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartRunRequest)) {
            return false;
        }
        StartRunRequest other = (StartRunRequest) obj;
        return Objects.equals(logLevelAsString(), other.logLevelAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(outputUri(), other.outputUri()) && Objects.equals(parameters(), other.parameters())
                && Objects.equals(priority(), other.priority()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(runGroupId(), other.runGroupId())
                && Objects.equals(runId(), other.runId()) && Objects.equals(storageCapacity(), other.storageCapacity())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(workflowId(), other.workflowId())
                && Objects.equals(workflowTypeAsString(), other.workflowTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartRunRequest").add("LogLevel", logLevelAsString()).add("Name", name())
                .add("OutputUri", outputUri()).add("Parameters", parameters()).add("Priority", priority())
                .add("RequestId", requestId()).add("RoleArn", roleArn()).add("RunGroupId", runGroupId()).add("RunId", runId())
                .add("StorageCapacity", storageCapacity()).add("Tags", hasTags() ? tags() : null).add("WorkflowId", workflowId())
                .add("WorkflowType", workflowTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logLevel":
            return Optional.ofNullable(clazz.cast(logLevelAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "outputUri":
            return Optional.ofNullable(clazz.cast(outputUri()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "requestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "runGroupId":
            return Optional.ofNullable(clazz.cast(runGroupId()));
        case "runId":
            return Optional.ofNullable(clazz.cast(runId()));
        case "storageCapacity":
            return Optional.ofNullable(clazz.cast(storageCapacity()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "workflowId":
            return Optional.ofNullable(clazz.cast(workflowId()));
        case "workflowType":
            return Optional.ofNullable(clazz.cast(workflowTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartRunRequest, T> g) {
        return obj -> g.apply((StartRunRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartRunRequest> {
        /**
         * <p>
         * A log level for the run.
         * </p>
         * 
         * @param logLevel
         *        A log level for the run.
         * @see RunLogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunLogLevel
         */
        Builder logLevel(String logLevel);

        /**
         * <p>
         * A log level for the run.
         * </p>
         * 
         * @param logLevel
         *        A log level for the run.
         * @see RunLogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunLogLevel
         */
        Builder logLevel(RunLogLevel logLevel);

        /**
         * <p>
         * A name for the run.
         * </p>
         * 
         * @param name
         *        A name for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An output URI for the run.
         * </p>
         * 
         * @param outputUri
         *        An output URI for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputUri(String outputUri);

        /**
         * <p>
         * Parameters for the run.
         * </p>
         * 
         * @param parameters
         *        Parameters for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Document parameters);

        /**
         * <p>
         * A priority for the run.
         * </p>
         * 
         * @param priority
         *        A priority for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * To ensure that requests don't run multiple times, specify a unique ID for each request.
         * </p>
         * 
         * @param requestIdValue
         *        To ensure that requests don't run multiple times, specify a unique ID for each request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestIdValue);

        /**
         * <p>
         * A service role for the run.
         * </p>
         * 
         * @param roleArn
         *        A service role for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The run's group ID.
         * </p>
         * 
         * @param runGroupId
         *        The run's group ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runGroupId(String runGroupId);

        /**
         * <p>
         * The run's ID.
         * </p>
         * 
         * @param runId
         *        The run's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);

        /**
         * <p>
         * A storage capacity for the run in gigabytes.
         * </p>
         * 
         * @param storageCapacity
         *        A storage capacity for the run in gigabytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageCapacity(Integer storageCapacity);

        /**
         * <p>
         * Tags for the run.
         * </p>
         * 
         * @param tags
         *        Tags for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The run's workflow ID.
         * </p>
         * 
         * @param workflowId
         *        The run's workflow ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);

        /**
         * <p>
         * The run's workflows type.
         * </p>
         * 
         * @param workflowType
         *        The run's workflows type.
         * @see WorkflowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowType
         */
        Builder workflowType(String workflowType);

        /**
         * <p>
         * The run's workflows type.
         * </p>
         * 
         * @param workflowType
         *        The run's workflows type.
         * @see WorkflowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowType
         */
        Builder workflowType(WorkflowType workflowType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private String logLevel;

        private String name;

        private String outputUri;

        private Document parameters;

        private Integer priority;

        private String requestIdValue;

        private String roleArn;

        private String runGroupId;

        private String runId;

        private Integer storageCapacity;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String workflowId;

        private String workflowType;

        private BuilderImpl() {
        }

        private BuilderImpl(StartRunRequest model) {
            super(model);
            logLevel(model.logLevel);
            name(model.name);
            outputUri(model.outputUri);
            parameters(model.parameters);
            priority(model.priority);
            requestId(model.requestIdValue);
            roleArn(model.roleArn);
            runGroupId(model.runGroupId);
            runId(model.runId);
            storageCapacity(model.storageCapacity);
            tags(model.tags);
            workflowId(model.workflowId);
            workflowType(model.workflowType);
        }

        public final String getLogLevel() {
            return logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(RunLogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOutputUri() {
            return outputUri;
        }

        public final void setOutputUri(String outputUri) {
            this.outputUri = outputUri;
        }

        @Override
        public final Builder outputUri(String outputUri) {
            this.outputUri = outputUri;
            return this;
        }

        public final Document getParameters() {
            return parameters;
        }

        public final void setParameters(Document parameters) {
            this.parameters = parameters;
        }

        @Override
        public final Builder parameters(Document parameters) {
            this.parameters = parameters;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getRequestId() {
            return requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getRunGroupId() {
            return runGroupId;
        }

        public final void setRunGroupId(String runGroupId) {
            this.runGroupId = runGroupId;
        }

        @Override
        public final Builder runGroupId(String runGroupId) {
            this.runGroupId = runGroupId;
            return this;
        }

        public final String getRunId() {
            return runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final Integer getStorageCapacity() {
            return storageCapacity;
        }

        public final void setStorageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
        }

        @Override
        public final Builder storageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getWorkflowType() {
            return workflowType;
        }

        public final void setWorkflowType(String workflowType) {
            this.workflowType = workflowType;
        }

        @Override
        public final Builder workflowType(String workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType(workflowType == null ? null : workflowType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartRunRequest build() {
            return new StartRunRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
