/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartVariantImportJobRequest extends OmicsRequest implements
        ToCopyableBuilder<StartVariantImportJobRequest.Builder, StartVariantImportJobRequest> {
    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationName").getter(getter(StartVariantImportJobRequest::destinationName))
            .setter(setter(Builder::destinationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationName").build()).build();

    private static final SdkField<List<VariantImportItemSource>> ITEMS_FIELD = SdkField
            .<List<VariantImportItemSource>> builder(MarshallingType.LIST)
            .memberName("items")
            .getter(getter(StartVariantImportJobRequest::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VariantImportItemSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(VariantImportItemSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(StartVariantImportJobRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Boolean> RUN_LEFT_NORMALIZATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("runLeftNormalization").getter(getter(StartVariantImportJobRequest::runLeftNormalization))
            .setter(setter(Builder::runLeftNormalization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runLeftNormalization").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_NAME_FIELD,
            ITEMS_FIELD, ROLE_ARN_FIELD, RUN_LEFT_NORMALIZATION_FIELD));

    private final String destinationName;

    private final List<VariantImportItemSource> items;

    private final String roleArn;

    private final Boolean runLeftNormalization;

    private StartVariantImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.destinationName = builder.destinationName;
        this.items = builder.items;
        this.roleArn = builder.roleArn;
        this.runLeftNormalization = builder.runLeftNormalization;
    }

    /**
     * <p>
     * The destination variant store for the job.
     * </p>
     * 
     * @return The destination variant store for the job.
     */
    public final String destinationName() {
        return destinationName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Items to import.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return Items to import.
     */
    public final List<VariantImportItemSource> items() {
        return items;
    }

    /**
     * <p>
     * A service role for the job.
     * </p>
     * 
     * @return A service role for the job.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The job's left normalization setting.
     * </p>
     * 
     * @return The job's left normalization setting.
     */
    public final Boolean runLeftNormalization() {
        return runLeftNormalization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(runLeftNormalization());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartVariantImportJobRequest)) {
            return false;
        }
        StartVariantImportJobRequest other = (StartVariantImportJobRequest) obj;
        return Objects.equals(destinationName(), other.destinationName()) && hasItems() == other.hasItems()
                && Objects.equals(items(), other.items()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(runLeftNormalization(), other.runLeftNormalization());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartVariantImportJobRequest").add("DestinationName", destinationName())
                .add("Items", hasItems() ? items() : null).add("RoleArn", roleArn())
                .add("RunLeftNormalization", runLeftNormalization()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "destinationName":
            return Optional.ofNullable(clazz.cast(destinationName()));
        case "items":
            return Optional.ofNullable(clazz.cast(items()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "runLeftNormalization":
            return Optional.ofNullable(clazz.cast(runLeftNormalization()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartVariantImportJobRequest, T> g) {
        return obj -> g.apply((StartVariantImportJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartVariantImportJobRequest> {
        /**
         * <p>
         * The destination variant store for the job.
         * </p>
         * 
         * @param destinationName
         *        The destination variant store for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationName(String destinationName);

        /**
         * <p>
         * Items to import.
         * </p>
         * 
         * @param items
         *        Items to import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<VariantImportItemSource> items);

        /**
         * <p>
         * Items to import.
         * </p>
         * 
         * @param items
         *        Items to import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(VariantImportItemSource... items);

        /**
         * <p>
         * Items to import.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.omics.model.VariantImportItemSource.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.omics.model.VariantImportItemSource#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.omics.model.VariantImportItemSource.Builder#build()} is called
         * immediately and its result is passed to {@link #items(List<VariantImportItemSource>)}.
         * 
         * @param items
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.omics.model.VariantImportItemSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(java.util.Collection<VariantImportItemSource>)
         */
        Builder items(Consumer<VariantImportItemSource.Builder>... items);

        /**
         * <p>
         * A service role for the job.
         * </p>
         * 
         * @param roleArn
         *        A service role for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The job's left normalization setting.
         * </p>
         * 
         * @param runLeftNormalization
         *        The job's left normalization setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runLeftNormalization(Boolean runLeftNormalization);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private String destinationName;

        private List<VariantImportItemSource> items = DefaultSdkAutoConstructList.getInstance();

        private String roleArn;

        private Boolean runLeftNormalization;

        private BuilderImpl() {
        }

        private BuilderImpl(StartVariantImportJobRequest model) {
            super(model);
            destinationName(model.destinationName);
            items(model.items);
            roleArn(model.roleArn);
            runLeftNormalization(model.runLeftNormalization);
        }

        public final String getDestinationName() {
            return destinationName;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final List<VariantImportItemSource.Builder> getItems() {
            List<VariantImportItemSource.Builder> result = VariantImportItemSourcesCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<VariantImportItemSource.BuilderImpl> items) {
            this.items = VariantImportItemSourcesCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<VariantImportItemSource> items) {
            this.items = VariantImportItemSourcesCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(VariantImportItemSource... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<VariantImportItemSource.Builder>... items) {
            items(Stream.of(items).map(c -> VariantImportItemSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Boolean getRunLeftNormalization() {
            return runLeftNormalization;
        }

        public final void setRunLeftNormalization(Boolean runLeftNormalization) {
            this.runLeftNormalization = runLeftNormalization;
        }

        @Override
        public final Builder runLeftNormalization(Boolean runLeftNormalization) {
            this.runLeftNormalization = runLeftNormalization;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartVariantImportJobRequest build() {
            return new StartVariantImportJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
