/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A read set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReadSetListItem implements SdkPojo, Serializable, ToCopyableBuilder<ReadSetListItem.Builder, ReadSetListItem> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ReadSetListItem::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ReadSetListItem::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> SEQUENCE_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sequenceStoreId").getter(getter(ReadSetListItem::sequenceStoreId))
            .setter(setter(Builder::sequenceStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sequenceStoreId").build()).build();

    private static final SdkField<String> SUBJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subjectId").getter(getter(ReadSetListItem::subjectId)).setter(setter(Builder::subjectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subjectId").build()).build();

    private static final SdkField<String> SAMPLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sampleId").getter(getter(ReadSetListItem::sampleId)).setter(setter(Builder::sampleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ReadSetListItem::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ReadSetListItem::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ReadSetListItem::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> REFERENCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("referenceArn").getter(getter(ReadSetListItem::referenceArn)).setter(setter(Builder::referenceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceArn").build()).build();

    private static final SdkField<String> FILE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileType").getter(getter(ReadSetListItem::fileTypeAsString)).setter(setter(Builder::fileType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileType").build()).build();

    private static final SdkField<SequenceInformation> SEQUENCE_INFORMATION_FIELD = SdkField
            .<SequenceInformation> builder(MarshallingType.SDK_POJO).memberName("sequenceInformation")
            .getter(getter(ReadSetListItem::sequenceInformation)).setter(setter(Builder::sequenceInformation))
            .constructor(SequenceInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sequenceInformation").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(ReadSetListItem::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(ReadSetListItem::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            SEQUENCE_STORE_ID_FIELD, SUBJECT_ID_FIELD, SAMPLE_ID_FIELD, STATUS_FIELD, NAME_FIELD, DESCRIPTION_FIELD,
            REFERENCE_ARN_FIELD, FILE_TYPE_FIELD, SEQUENCE_INFORMATION_FIELD, CREATION_TIME_FIELD, STATUS_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String sequenceStoreId;

    private final String subjectId;

    private final String sampleId;

    private final String status;

    private final String name;

    private final String description;

    private final String referenceArn;

    private final String fileType;

    private final SequenceInformation sequenceInformation;

    private final Instant creationTime;

    private final String statusMessage;

    private ReadSetListItem(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.sequenceStoreId = builder.sequenceStoreId;
        this.subjectId = builder.subjectId;
        this.sampleId = builder.sampleId;
        this.status = builder.status;
        this.name = builder.name;
        this.description = builder.description;
        this.referenceArn = builder.referenceArn;
        this.fileType = builder.fileType;
        this.sequenceInformation = builder.sequenceInformation;
        this.creationTime = builder.creationTime;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The read set's ID.
     * </p>
     * 
     * @return The read set's ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The read set's ARN.
     * </p>
     * 
     * @return The read set's ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The read set's sequence store ID.
     * </p>
     * 
     * @return The read set's sequence store ID.
     */
    public final String sequenceStoreId() {
        return sequenceStoreId;
    }

    /**
     * <p>
     * The read set's subject ID.
     * </p>
     * 
     * @return The read set's subject ID.
     */
    public final String subjectId() {
        return subjectId;
    }

    /**
     * <p>
     * The read set's sample ID.
     * </p>
     * 
     * @return The read set's sample ID.
     */
    public final String sampleId() {
        return sampleId;
    }

    /**
     * <p>
     * The read set's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReadSetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The read set's status.
     * @see ReadSetStatus
     */
    public final ReadSetStatus status() {
        return ReadSetStatus.fromValue(status);
    }

    /**
     * <p>
     * The read set's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReadSetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The read set's status.
     * @see ReadSetStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The read set's name.
     * </p>
     * 
     * @return The read set's name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The read set's description.
     * </p>
     * 
     * @return The read set's description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The read set's genome reference ARN.
     * </p>
     * 
     * @return The read set's genome reference ARN.
     */
    public final String referenceArn() {
        return referenceArn;
    }

    /**
     * <p>
     * The read set's file type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileType} will
     * return {@link FileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileTypeAsString}.
     * </p>
     * 
     * @return The read set's file type.
     * @see FileType
     */
    public final FileType fileType() {
        return FileType.fromValue(fileType);
    }

    /**
     * <p>
     * The read set's file type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileType} will
     * return {@link FileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileTypeAsString}.
     * </p>
     * 
     * @return The read set's file type.
     * @see FileType
     */
    public final String fileTypeAsString() {
        return fileType;
    }

    /**
     * Returns the value of the SequenceInformation property for this object.
     * 
     * @return The value of the SequenceInformation property for this object.
     */
    public final SequenceInformation sequenceInformation() {
        return sequenceInformation;
    }

    /**
     * <p>
     * When the read set was created.
     * </p>
     * 
     * @return When the read set was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The status for a read set. It provides more detail as to why the read set has a status.
     * </p>
     * 
     * @return The status for a read set. It provides more detail as to why the read set has a status.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(sequenceStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(subjectId());
        hashCode = 31 * hashCode + Objects.hashCode(sampleId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(referenceArn());
        hashCode = 31 * hashCode + Objects.hashCode(fileTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sequenceInformation());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReadSetListItem)) {
            return false;
        }
        ReadSetListItem other = (ReadSetListItem) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(sequenceStoreId(), other.sequenceStoreId()) && Objects.equals(subjectId(), other.subjectId())
                && Objects.equals(sampleId(), other.sampleId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(referenceArn(), other.referenceArn())
                && Objects.equals(fileTypeAsString(), other.fileTypeAsString())
                && Objects.equals(sequenceInformation(), other.sequenceInformation())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReadSetListItem").add("Id", id()).add("Arn", arn()).add("SequenceStoreId", sequenceStoreId())
                .add("SubjectId", subjectId()).add("SampleId", sampleId()).add("Status", statusAsString()).add("Name", name())
                .add("Description", description()).add("ReferenceArn", referenceArn()).add("FileType", fileTypeAsString())
                .add("SequenceInformation", sequenceInformation()).add("CreationTime", creationTime())
                .add("StatusMessage", statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "sequenceStoreId":
            return Optional.ofNullable(clazz.cast(sequenceStoreId()));
        case "subjectId":
            return Optional.ofNullable(clazz.cast(subjectId()));
        case "sampleId":
            return Optional.ofNullable(clazz.cast(sampleId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "referenceArn":
            return Optional.ofNullable(clazz.cast(referenceArn()));
        case "fileType":
            return Optional.ofNullable(clazz.cast(fileTypeAsString()));
        case "sequenceInformation":
            return Optional.ofNullable(clazz.cast(sequenceInformation()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReadSetListItem, T> g) {
        return obj -> g.apply((ReadSetListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReadSetListItem> {
        /**
         * <p>
         * The read set's ID.
         * </p>
         * 
         * @param id
         *        The read set's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The read set's ARN.
         * </p>
         * 
         * @param arn
         *        The read set's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The read set's sequence store ID.
         * </p>
         * 
         * @param sequenceStoreId
         *        The read set's sequence store ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceStoreId(String sequenceStoreId);

        /**
         * <p>
         * The read set's subject ID.
         * </p>
         * 
         * @param subjectId
         *        The read set's subject ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectId(String subjectId);

        /**
         * <p>
         * The read set's sample ID.
         * </p>
         * 
         * @param sampleId
         *        The read set's sample ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleId(String sampleId);

        /**
         * <p>
         * The read set's status.
         * </p>
         * 
         * @param status
         *        The read set's status.
         * @see ReadSetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReadSetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The read set's status.
         * </p>
         * 
         * @param status
         *        The read set's status.
         * @see ReadSetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReadSetStatus
         */
        Builder status(ReadSetStatus status);

        /**
         * <p>
         * The read set's name.
         * </p>
         * 
         * @param name
         *        The read set's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The read set's description.
         * </p>
         * 
         * @param description
         *        The read set's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The read set's genome reference ARN.
         * </p>
         * 
         * @param referenceArn
         *        The read set's genome reference ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceArn(String referenceArn);

        /**
         * <p>
         * The read set's file type.
         * </p>
         * 
         * @param fileType
         *        The read set's file type.
         * @see FileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileType
         */
        Builder fileType(String fileType);

        /**
         * <p>
         * The read set's file type.
         * </p>
         * 
         * @param fileType
         *        The read set's file type.
         * @see FileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileType
         */
        Builder fileType(FileType fileType);

        /**
         * Sets the value of the SequenceInformation property for this object.
         *
         * @param sequenceInformation
         *        The new value for the SequenceInformation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceInformation(SequenceInformation sequenceInformation);

        /**
         * Sets the value of the SequenceInformation property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SequenceInformation.Builder} avoiding the
         * need to create one manually via {@link SequenceInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SequenceInformation.Builder#build()} is called immediately and
         * its result is passed to {@link #sequenceInformation(SequenceInformation)}.
         * 
         * @param sequenceInformation
         *        a consumer that will call methods on {@link SequenceInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sequenceInformation(SequenceInformation)
         */
        default Builder sequenceInformation(Consumer<SequenceInformation.Builder> sequenceInformation) {
            return sequenceInformation(SequenceInformation.builder().applyMutation(sequenceInformation).build());
        }

        /**
         * <p>
         * When the read set was created.
         * </p>
         * 
         * @param creationTime
         *        When the read set was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The status for a read set. It provides more detail as to why the read set has a status.
         * </p>
         * 
         * @param statusMessage
         *        The status for a read set. It provides more detail as to why the read set has a status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String sequenceStoreId;

        private String subjectId;

        private String sampleId;

        private String status;

        private String name;

        private String description;

        private String referenceArn;

        private String fileType;

        private SequenceInformation sequenceInformation;

        private Instant creationTime;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ReadSetListItem model) {
            id(model.id);
            arn(model.arn);
            sequenceStoreId(model.sequenceStoreId);
            subjectId(model.subjectId);
            sampleId(model.sampleId);
            status(model.status);
            name(model.name);
            description(model.description);
            referenceArn(model.referenceArn);
            fileType(model.fileType);
            sequenceInformation(model.sequenceInformation);
            creationTime(model.creationTime);
            statusMessage(model.statusMessage);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getSequenceStoreId() {
            return sequenceStoreId;
        }

        public final void setSequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
        }

        @Override
        public final Builder sequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
            return this;
        }

        public final String getSubjectId() {
            return subjectId;
        }

        public final void setSubjectId(String subjectId) {
            this.subjectId = subjectId;
        }

        @Override
        public final Builder subjectId(String subjectId) {
            this.subjectId = subjectId;
            return this;
        }

        public final String getSampleId() {
            return sampleId;
        }

        public final void setSampleId(String sampleId) {
            this.sampleId = sampleId;
        }

        @Override
        public final Builder sampleId(String sampleId) {
            this.sampleId = sampleId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReadSetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getReferenceArn() {
            return referenceArn;
        }

        public final void setReferenceArn(String referenceArn) {
            this.referenceArn = referenceArn;
        }

        @Override
        public final Builder referenceArn(String referenceArn) {
            this.referenceArn = referenceArn;
            return this;
        }

        public final String getFileType() {
            return fileType;
        }

        public final void setFileType(String fileType) {
            this.fileType = fileType;
        }

        @Override
        public final Builder fileType(String fileType) {
            this.fileType = fileType;
            return this;
        }

        @Override
        public final Builder fileType(FileType fileType) {
            this.fileType(fileType == null ? null : fileType.toString());
            return this;
        }

        public final SequenceInformation.Builder getSequenceInformation() {
            return sequenceInformation != null ? sequenceInformation.toBuilder() : null;
        }

        public final void setSequenceInformation(SequenceInformation.BuilderImpl sequenceInformation) {
            this.sequenceInformation = sequenceInformation != null ? sequenceInformation.build() : null;
        }

        @Override
        public final Builder sequenceInformation(SequenceInformation sequenceInformation) {
            this.sequenceInformation = sequenceInformation;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public ReadSetListItem build() {
            return new ReadSetListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
