/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.waiters;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.omics.OmicsClient;
import software.amazon.awssdk.services.omics.model.GetAnnotationImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetAnnotationImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreRequest;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetActivationJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetActivationJobResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetExportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetExportJobResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetReferenceImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReferenceImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetRunRequest;
import software.amazon.awssdk.services.omics.model.GetRunResponse;
import software.amazon.awssdk.services.omics.model.GetRunTaskRequest;
import software.amazon.awssdk.services.omics.model.GetRunTaskResponse;
import software.amazon.awssdk.services.omics.model.GetVariantImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetVariantImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetVariantStoreRequest;
import software.amazon.awssdk.services.omics.model.GetVariantStoreResponse;
import software.amazon.awssdk.services.omics.model.GetWorkflowRequest;
import software.amazon.awssdk.services.omics.model.GetWorkflowResponse;
import software.amazon.awssdk.utils.SdkAutoCloseable;

/**
 * Waiter utility class that polls a resource until a desired state is reached or until it is determined that the
 * resource will never enter into the desired state. This can be created using the static {@link #builder()} method
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public interface OmicsWaiter extends SdkAutoCloseable {
    /**
     * Polls {@link OmicsClient#getAnnotationImportJob} API until the desired condition
     * {@code AnnotationImportJobCreated} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param getAnnotationImportJobRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetAnnotationImportJobResponse> waitUntilAnnotationImportJobCreated(
            GetAnnotationImportJobRequest getAnnotationImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link OmicsClient#getAnnotationImportJob} API until the desired condition
     * {@code AnnotationImportJobCreated} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetAnnotationImportJobRequest#builder()}
     *
     * @param getAnnotationImportJobRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetAnnotationImportJobResponse> waitUntilAnnotationImportJobCreated(
            Consumer<GetAnnotationImportJobRequest.Builder> getAnnotationImportJobRequest) {
        return waitUntilAnnotationImportJobCreated(GetAnnotationImportJobRequest.builder()
                .applyMutation(getAnnotationImportJobRequest).build());
    }

    /**
     * Polls {@link OmicsClient#getAnnotationImportJob} API until the desired condition
     * {@code AnnotationImportJobCreated} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param getAnnotationImportJobRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetAnnotationImportJobResponse> waitUntilAnnotationImportJobCreated(
            GetAnnotationImportJobRequest getAnnotationImportJobRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link OmicsClient#getAnnotationImportJob} API until the desired condition
     * {@code AnnotationImportJobCreated} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getAnnotationImportJobRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetAnnotationImportJobResponse> waitUntilAnnotationImportJobCreated(
            Consumer<GetAnnotationImportJobRequest.Builder> getAnnotationImportJobRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilAnnotationImportJobCreated(
                GetAnnotationImportJobRequest.builder().applyMutation(getAnnotationImportJobRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link OmicsClient#getAnnotationStore} API until the desired condition {@code AnnotationStoreCreated} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param getAnnotationStoreRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetAnnotationStoreResponse> waitUntilAnnotationStoreCreated(
            GetAnnotationStoreRequest getAnnotationStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link OmicsClient#getAnnotationStore} API until the desired condition {@code AnnotationStoreCreated} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetAnnotationStoreRequest#builder()}
     *
     * @param getAnnotationStoreRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetAnnotationStoreResponse> waitUntilAnnotationStoreCreated(
            Consumer<GetAnnotationStoreRequest.Builder> getAnnotationStoreRequest) {
        return waitUntilAnnotationStoreCreated(GetAnnotationStoreRequest.builder().applyMutation(getAnnotationStoreRequest)
                .build());
    }

    /**
     * Polls {@link OmicsClient#getAnnotationStore} API until the desired condition {@code AnnotationStoreCreated} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param getAnnotationStoreRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetAnnotationStoreResponse> waitUntilAnnotationStoreCreated(
            GetAnnotationStoreRequest getAnnotationStoreRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link OmicsClient#getAnnotationStore} API until the desired condition {@code AnnotationStoreCreated} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getAnnotationStoreRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetAnnotationStoreResponse> waitUntilAnnotationStoreCreated(
            Consumer<GetAnnotationStoreRequest.Builder> getAnnotationStoreRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilAnnotationStoreCreated(GetAnnotationStoreRequest.builder().applyMutation(getAnnotationStoreRequest)
                .build(), WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link OmicsClient#getAnnotationStore} API until the desired condition {@code AnnotationStoreDeleted} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param getAnnotationStoreRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetAnnotationStoreResponse> waitUntilAnnotationStoreDeleted(
            GetAnnotationStoreRequest getAnnotationStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link OmicsClient#getAnnotationStore} API until the desired condition {@code AnnotationStoreDeleted} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetAnnotationStoreRequest#builder()}
     *
     * @param getAnnotationStoreRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetAnnotationStoreResponse> waitUntilAnnotationStoreDeleted(
            Consumer<GetAnnotationStoreRequest.Builder> getAnnotationStoreRequest) {
        return waitUntilAnnotationStoreDeleted(GetAnnotationStoreRequest.builder().applyMutation(getAnnotationStoreRequest)
                .build());
    }

    /**
     * Polls {@link OmicsClient#getAnnotationStore} API until the desired condition {@code AnnotationStoreDeleted} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param getAnnotationStoreRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetAnnotationStoreResponse> waitUntilAnnotationStoreDeleted(
            GetAnnotationStoreRequest getAnnotationStoreRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link OmicsClient#getAnnotationStore} API until the desired condition {@code AnnotationStoreDeleted} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getAnnotationStoreRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetAnnotationStoreResponse> waitUntilAnnotationStoreDeleted(
            Consumer<GetAnnotationStoreRequest.Builder> getAnnotationStoreRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilAnnotationStoreDeleted(GetAnnotationStoreRequest.builder().applyMutation(getAnnotationStoreRequest)
                .build(), WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link OmicsClient#getReadSetActivationJob} API until the desired condition
     * {@code ReadSetActivationJobCompleted} is met, or until it is determined that the resource will never enter into
     * the desired state
     *
     * @param getReadSetActivationJobRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetReadSetActivationJobResponse> waitUntilReadSetActivationJobCompleted(
            GetReadSetActivationJobRequest getReadSetActivationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link OmicsClient#getReadSetActivationJob} API until the desired condition
     * {@code ReadSetActivationJobCompleted} is met, or until it is determined that the resource will never enter into
     * the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetReadSetActivationJobRequest#builder()}
     *
     * @param getReadSetActivationJobRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetReadSetActivationJobResponse> waitUntilReadSetActivationJobCompleted(
            Consumer<GetReadSetActivationJobRequest.Builder> getReadSetActivationJobRequest) {
        return waitUntilReadSetActivationJobCompleted(GetReadSetActivationJobRequest.builder()
                .applyMutation(getReadSetActivationJobRequest).build());
    }

    /**
     * Polls {@link OmicsClient#getReadSetActivationJob} API until the desired condition
     * {@code ReadSetActivationJobCompleted} is met, or until it is determined that the resource will never enter into
     * the desired state
     *
     * @param getReadSetActivationJobRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetReadSetActivationJobResponse> waitUntilReadSetActivationJobCompleted(
            GetReadSetActivationJobRequest getReadSetActivationJobRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link OmicsClient#getReadSetActivationJob} API until the desired condition
     * {@code ReadSetActivationJobCompleted} is met, or until it is determined that the resource will never enter into
     * the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getReadSetActivationJobRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetReadSetActivationJobResponse> waitUntilReadSetActivationJobCompleted(
            Consumer<GetReadSetActivationJobRequest.Builder> getReadSetActivationJobRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilReadSetActivationJobCompleted(
                GetReadSetActivationJobRequest.builder().applyMutation(getReadSetActivationJobRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link OmicsClient#getReadSetExportJob} API until the desired condition {@code ReadSetExportJobCompleted}
     * is met, or until it is determined that the resource will never enter into the desired state
     *
     * @param getReadSetExportJobRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetReadSetExportJobResponse> waitUntilReadSetExportJobCompleted(
            GetReadSetExportJobRequest getReadSetExportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link OmicsClient#getReadSetExportJob} API until the desired condition {@code ReadSetExportJobCompleted}
     * is met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetReadSetExportJobRequest#builder()}
     *
     * @param getReadSetExportJobRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetReadSetExportJobResponse> waitUntilReadSetExportJobCompleted(
            Consumer<GetReadSetExportJobRequest.Builder> getReadSetExportJobRequest) {
        return waitUntilReadSetExportJobCompleted(GetReadSetExportJobRequest.builder().applyMutation(getReadSetExportJobRequest)
                .build());
    }

    /**
     * Polls {@link OmicsClient#getReadSetExportJob} API until the desired condition {@code ReadSetExportJobCompleted}
     * is met, or until it is determined that the resource will never enter into the desired state
     *
     * @param getReadSetExportJobRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetReadSetExportJobResponse> waitUntilReadSetExportJobCompleted(
            GetReadSetExportJobRequest getReadSetExportJobRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link OmicsClient#getReadSetExportJob} API until the desired condition {@code ReadSetExportJobCompleted}
     * is met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getReadSetExportJobRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetReadSetExportJobResponse> waitUntilReadSetExportJobCompleted(
            Consumer<GetReadSetExportJobRequest.Builder> getReadSetExportJobRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilReadSetExportJobCompleted(GetReadSetExportJobRequest.builder().applyMutation(getReadSetExportJobRequest)
                .build(), WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link OmicsClient#getReadSetImportJob} API until the desired condition {@code ReadSetImportJobCompleted}
     * is met, or until it is determined that the resource will never enter into the desired state
     *
     * @param getReadSetImportJobRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetReadSetImportJobResponse> waitUntilReadSetImportJobCompleted(
            GetReadSetImportJobRequest getReadSetImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link OmicsClient#getReadSetImportJob} API until the desired condition {@code ReadSetImportJobCompleted}
     * is met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetReadSetImportJobRequest#builder()}
     *
     * @param getReadSetImportJobRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetReadSetImportJobResponse> waitUntilReadSetImportJobCompleted(
            Consumer<GetReadSetImportJobRequest.Builder> getReadSetImportJobRequest) {
        return waitUntilReadSetImportJobCompleted(GetReadSetImportJobRequest.builder().applyMutation(getReadSetImportJobRequest)
                .build());
    }

    /**
     * Polls {@link OmicsClient#getReadSetImportJob} API until the desired condition {@code ReadSetImportJobCompleted}
     * is met, or until it is determined that the resource will never enter into the desired state
     *
     * @param getReadSetImportJobRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetReadSetImportJobResponse> waitUntilReadSetImportJobCompleted(
            GetReadSetImportJobRequest getReadSetImportJobRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link OmicsClient#getReadSetImportJob} API until the desired condition {@code ReadSetImportJobCompleted}
     * is met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getReadSetImportJobRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetReadSetImportJobResponse> waitUntilReadSetImportJobCompleted(
            Consumer<GetReadSetImportJobRequest.Builder> getReadSetImportJobRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilReadSetImportJobCompleted(GetReadSetImportJobRequest.builder().applyMutation(getReadSetImportJobRequest)
                .build(), WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link OmicsClient#getReferenceImportJob} API until the desired condition
     * {@code ReferenceImportJobCompleted} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param getReferenceImportJobRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetReferenceImportJobResponse> waitUntilReferenceImportJobCompleted(
            GetReferenceImportJobRequest getReferenceImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link OmicsClient#getReferenceImportJob} API until the desired condition
     * {@code ReferenceImportJobCompleted} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetReferenceImportJobRequest#builder()}
     *
     * @param getReferenceImportJobRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetReferenceImportJobResponse> waitUntilReferenceImportJobCompleted(
            Consumer<GetReferenceImportJobRequest.Builder> getReferenceImportJobRequest) {
        return waitUntilReferenceImportJobCompleted(GetReferenceImportJobRequest.builder()
                .applyMutation(getReferenceImportJobRequest).build());
    }

    /**
     * Polls {@link OmicsClient#getReferenceImportJob} API until the desired condition
     * {@code ReferenceImportJobCompleted} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param getReferenceImportJobRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetReferenceImportJobResponse> waitUntilReferenceImportJobCompleted(
            GetReferenceImportJobRequest getReferenceImportJobRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link OmicsClient#getReferenceImportJob} API until the desired condition
     * {@code ReferenceImportJobCompleted} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getReferenceImportJobRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetReferenceImportJobResponse> waitUntilReferenceImportJobCompleted(
            Consumer<GetReferenceImportJobRequest.Builder> getReferenceImportJobRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilReferenceImportJobCompleted(
                GetReferenceImportJobRequest.builder().applyMutation(getReferenceImportJobRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link OmicsClient#getRun} API until the desired condition {@code RunCompleted} is met, or until it is
     * determined that the resource will never enter into the desired state
     *
     * @param getRunRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetRunResponse> waitUntilRunCompleted(GetRunRequest getRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link OmicsClient#getRun} API until the desired condition {@code RunCompleted} is met, or until it is
     * determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetRunRequest#builder()}
     *
     * @param getRunRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetRunResponse> waitUntilRunCompleted(Consumer<GetRunRequest.Builder> getRunRequest) {
        return waitUntilRunCompleted(GetRunRequest.builder().applyMutation(getRunRequest).build());
    }

    /**
     * Polls {@link OmicsClient#getRun} API until the desired condition {@code RunCompleted} is met, or until it is
     * determined that the resource will never enter into the desired state
     *
     * @param getRunRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetRunResponse> waitUntilRunCompleted(GetRunRequest getRunRequest,
            WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link OmicsClient#getRun} API until the desired condition {@code RunCompleted} is met, or until it is
     * determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getRunRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetRunResponse> waitUntilRunCompleted(Consumer<GetRunRequest.Builder> getRunRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilRunCompleted(GetRunRequest.builder().applyMutation(getRunRequest).build(), WaiterOverrideConfiguration
                .builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link OmicsClient#getRun} API until the desired condition {@code RunRunning} is met, or until it is
     * determined that the resource will never enter into the desired state
     *
     * @param getRunRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetRunResponse> waitUntilRunRunning(GetRunRequest getRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link OmicsClient#getRun} API until the desired condition {@code RunRunning} is met, or until it is
     * determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetRunRequest#builder()}
     *
     * @param getRunRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetRunResponse> waitUntilRunRunning(Consumer<GetRunRequest.Builder> getRunRequest) {
        return waitUntilRunRunning(GetRunRequest.builder().applyMutation(getRunRequest).build());
    }

    /**
     * Polls {@link OmicsClient#getRun} API until the desired condition {@code RunRunning} is met, or until it is
     * determined that the resource will never enter into the desired state
     *
     * @param getRunRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetRunResponse> waitUntilRunRunning(GetRunRequest getRunRequest,
            WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link OmicsClient#getRun} API until the desired condition {@code RunRunning} is met, or until it is
     * determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getRunRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetRunResponse> waitUntilRunRunning(Consumer<GetRunRequest.Builder> getRunRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilRunRunning(GetRunRequest.builder().applyMutation(getRunRequest).build(), WaiterOverrideConfiguration
                .builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link OmicsClient#getRunTask} API until the desired condition {@code TaskCompleted} is met, or until it is
     * determined that the resource will never enter into the desired state
     *
     * @param getRunTaskRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetRunTaskResponse> waitUntilTaskCompleted(GetRunTaskRequest getRunTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link OmicsClient#getRunTask} API until the desired condition {@code TaskCompleted} is met, or until it is
     * determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetRunTaskRequest#builder()}
     *
     * @param getRunTaskRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetRunTaskResponse> waitUntilTaskCompleted(Consumer<GetRunTaskRequest.Builder> getRunTaskRequest) {
        return waitUntilTaskCompleted(GetRunTaskRequest.builder().applyMutation(getRunTaskRequest).build());
    }

    /**
     * Polls {@link OmicsClient#getRunTask} API until the desired condition {@code TaskCompleted} is met, or until it is
     * determined that the resource will never enter into the desired state
     *
     * @param getRunTaskRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetRunTaskResponse> waitUntilTaskCompleted(GetRunTaskRequest getRunTaskRequest,
            WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link OmicsClient#getRunTask} API until the desired condition {@code TaskCompleted} is met, or until it is
     * determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getRunTaskRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetRunTaskResponse> waitUntilTaskCompleted(Consumer<GetRunTaskRequest.Builder> getRunTaskRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilTaskCompleted(GetRunTaskRequest.builder().applyMutation(getRunTaskRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link OmicsClient#getRunTask} API until the desired condition {@code TaskRunning} is met, or until it is
     * determined that the resource will never enter into the desired state
     *
     * @param getRunTaskRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetRunTaskResponse> waitUntilTaskRunning(GetRunTaskRequest getRunTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link OmicsClient#getRunTask} API until the desired condition {@code TaskRunning} is met, or until it is
     * determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetRunTaskRequest#builder()}
     *
     * @param getRunTaskRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetRunTaskResponse> waitUntilTaskRunning(Consumer<GetRunTaskRequest.Builder> getRunTaskRequest) {
        return waitUntilTaskRunning(GetRunTaskRequest.builder().applyMutation(getRunTaskRequest).build());
    }

    /**
     * Polls {@link OmicsClient#getRunTask} API until the desired condition {@code TaskRunning} is met, or until it is
     * determined that the resource will never enter into the desired state
     *
     * @param getRunTaskRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetRunTaskResponse> waitUntilTaskRunning(GetRunTaskRequest getRunTaskRequest,
            WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link OmicsClient#getRunTask} API until the desired condition {@code TaskRunning} is met, or until it is
     * determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getRunTaskRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetRunTaskResponse> waitUntilTaskRunning(Consumer<GetRunTaskRequest.Builder> getRunTaskRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilTaskRunning(GetRunTaskRequest.builder().applyMutation(getRunTaskRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link OmicsClient#getVariantImportJob} API until the desired condition {@code VariantImportJobCreated} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param getVariantImportJobRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetVariantImportJobResponse> waitUntilVariantImportJobCreated(
            GetVariantImportJobRequest getVariantImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link OmicsClient#getVariantImportJob} API until the desired condition {@code VariantImportJobCreated} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetVariantImportJobRequest#builder()}
     *
     * @param getVariantImportJobRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetVariantImportJobResponse> waitUntilVariantImportJobCreated(
            Consumer<GetVariantImportJobRequest.Builder> getVariantImportJobRequest) {
        return waitUntilVariantImportJobCreated(GetVariantImportJobRequest.builder().applyMutation(getVariantImportJobRequest)
                .build());
    }

    /**
     * Polls {@link OmicsClient#getVariantImportJob} API until the desired condition {@code VariantImportJobCreated} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param getVariantImportJobRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetVariantImportJobResponse> waitUntilVariantImportJobCreated(
            GetVariantImportJobRequest getVariantImportJobRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link OmicsClient#getVariantImportJob} API until the desired condition {@code VariantImportJobCreated} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getVariantImportJobRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetVariantImportJobResponse> waitUntilVariantImportJobCreated(
            Consumer<GetVariantImportJobRequest.Builder> getVariantImportJobRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilVariantImportJobCreated(GetVariantImportJobRequest.builder().applyMutation(getVariantImportJobRequest)
                .build(), WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link OmicsClient#getVariantStore} API until the desired condition {@code VariantStoreCreated} is met, or
     * until it is determined that the resource will never enter into the desired state
     *
     * @param getVariantStoreRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetVariantStoreResponse> waitUntilVariantStoreCreated(GetVariantStoreRequest getVariantStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link OmicsClient#getVariantStore} API until the desired condition {@code VariantStoreCreated} is met, or
     * until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetVariantStoreRequest#builder()}
     *
     * @param getVariantStoreRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetVariantStoreResponse> waitUntilVariantStoreCreated(
            Consumer<GetVariantStoreRequest.Builder> getVariantStoreRequest) {
        return waitUntilVariantStoreCreated(GetVariantStoreRequest.builder().applyMutation(getVariantStoreRequest).build());
    }

    /**
     * Polls {@link OmicsClient#getVariantStore} API until the desired condition {@code VariantStoreCreated} is met, or
     * until it is determined that the resource will never enter into the desired state
     *
     * @param getVariantStoreRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetVariantStoreResponse> waitUntilVariantStoreCreated(GetVariantStoreRequest getVariantStoreRequest,
            WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link OmicsClient#getVariantStore} API until the desired condition {@code VariantStoreCreated} is met, or
     * until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getVariantStoreRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetVariantStoreResponse> waitUntilVariantStoreCreated(
            Consumer<GetVariantStoreRequest.Builder> getVariantStoreRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilVariantStoreCreated(GetVariantStoreRequest.builder().applyMutation(getVariantStoreRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link OmicsClient#getVariantStore} API until the desired condition {@code VariantStoreDeleted} is met, or
     * until it is determined that the resource will never enter into the desired state
     *
     * @param getVariantStoreRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetVariantStoreResponse> waitUntilVariantStoreDeleted(GetVariantStoreRequest getVariantStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link OmicsClient#getVariantStore} API until the desired condition {@code VariantStoreDeleted} is met, or
     * until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetVariantStoreRequest#builder()}
     *
     * @param getVariantStoreRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetVariantStoreResponse> waitUntilVariantStoreDeleted(
            Consumer<GetVariantStoreRequest.Builder> getVariantStoreRequest) {
        return waitUntilVariantStoreDeleted(GetVariantStoreRequest.builder().applyMutation(getVariantStoreRequest).build());
    }

    /**
     * Polls {@link OmicsClient#getVariantStore} API until the desired condition {@code VariantStoreDeleted} is met, or
     * until it is determined that the resource will never enter into the desired state
     *
     * @param getVariantStoreRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetVariantStoreResponse> waitUntilVariantStoreDeleted(GetVariantStoreRequest getVariantStoreRequest,
            WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link OmicsClient#getVariantStore} API until the desired condition {@code VariantStoreDeleted} is met, or
     * until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getVariantStoreRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetVariantStoreResponse> waitUntilVariantStoreDeleted(
            Consumer<GetVariantStoreRequest.Builder> getVariantStoreRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilVariantStoreDeleted(GetVariantStoreRequest.builder().applyMutation(getVariantStoreRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link OmicsClient#getWorkflow} API until the desired condition {@code WorkflowActive} is met, or until it
     * is determined that the resource will never enter into the desired state
     *
     * @param getWorkflowRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetWorkflowResponse> waitUntilWorkflowActive(GetWorkflowRequest getWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link OmicsClient#getWorkflow} API until the desired condition {@code WorkflowActive} is met, or until it
     * is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetWorkflowRequest#builder()}
     *
     * @param getWorkflowRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetWorkflowResponse> waitUntilWorkflowActive(Consumer<GetWorkflowRequest.Builder> getWorkflowRequest) {
        return waitUntilWorkflowActive(GetWorkflowRequest.builder().applyMutation(getWorkflowRequest).build());
    }

    /**
     * Polls {@link OmicsClient#getWorkflow} API until the desired condition {@code WorkflowActive} is met, or until it
     * is determined that the resource will never enter into the desired state
     *
     * @param getWorkflowRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetWorkflowResponse> waitUntilWorkflowActive(GetWorkflowRequest getWorkflowRequest,
            WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link OmicsClient#getWorkflow} API until the desired condition {@code WorkflowActive} is met, or until it
     * is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getWorkflowRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetWorkflowResponse> waitUntilWorkflowActive(Consumer<GetWorkflowRequest.Builder> getWorkflowRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilWorkflowActive(GetWorkflowRequest.builder().applyMutation(getWorkflowRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Create a builder that can be used to configure and create a {@link OmicsWaiter}.
     *
     * @return a builder
     */
    static Builder builder() {
        return DefaultOmicsWaiter.builder();
    }

    /**
     * Create an instance of {@link OmicsWaiter} with the default configuration.
     * <p>
     * <b>A default {@link OmicsClient} will be created to poll resources. It is recommended to share a single instance
     * of the waiter created via this method. If it is not desirable to share a waiter instance, invoke {@link #close()}
     * to release the resources once the waiter is not needed.</b>
     *
     * @return an instance of {@link OmicsWaiter}
     */
    static OmicsWaiter create() {
        return DefaultOmicsWaiter.builder().build();
    }

    interface Builder {
        /**
         * Defines overrides to the default SDK waiter configuration that should be used for waiters created from this
         * builder
         *
         * @param overrideConfiguration
         *        the override configuration to set
         * @return a reference to this object so that method calls can be chained together.
         */
        Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration);

        /**
         * This is a convenient method to pass the override configuration without the need to create an instance
         * manually via {@link WaiterOverrideConfiguration#builder()}
         *
         * @param overrideConfiguration
         *        The consumer that will configure the overrideConfiguration
         * @return a reference to this object so that method calls can be chained together.
         * @see #overrideConfiguration(WaiterOverrideConfiguration)
         */
        default Builder overrideConfiguration(Consumer<WaiterOverrideConfiguration.Builder> overrideConfiguration) {
            WaiterOverrideConfiguration.Builder builder = WaiterOverrideConfiguration.builder();
            overrideConfiguration.accept(builder);
            return overrideConfiguration(builder.build());
        }

        /**
         * Sets a custom {@link OmicsClient} that will be used to poll the resource
         * <p>
         * This SDK client must be closed by the caller when it is ready to be disposed. The SDK will not close the
         * client when the waiter is closed
         *
         * @param client
         *        the client to send the request
         * @return a reference to this object so that method calls can be chained together.
         */
        Builder client(OmicsClient client);

        /**
         * Builds an instance of {@link OmicsWaiter} based on the configurations supplied to this builder
         *
         * @return An initialized {@link OmicsWaiter}
         */
        OmicsWaiter build();
    }
}
