/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.ReadSetActivationJobItemStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActivateReadSetSourceItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActivateReadSetSourceItem> {
    private static final SdkField<String> READ_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("readSetId").getter(ActivateReadSetSourceItem.getter(ActivateReadSetSourceItem::readSetId)).setter(ActivateReadSetSourceItem.setter(Builder::readSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readSetId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ActivateReadSetSourceItem.getter(ActivateReadSetSourceItem::statusAsString)).setter(ActivateReadSetSourceItem.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(ActivateReadSetSourceItem.getter(ActivateReadSetSourceItem::statusMessage)).setter(ActivateReadSetSourceItem.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(READ_SET_ID_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String readSetId;
    private final String status;
    private final String statusMessage;

    private ActivateReadSetSourceItem(BuilderImpl builder) {
        this.readSetId = builder.readSetId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    public final String readSetId() {
        return this.readSetId;
    }

    public final ReadSetActivationJobItemStatus status() {
        return ReadSetActivationJobItemStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.readSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivateReadSetSourceItem)) {
            return false;
        }
        ActivateReadSetSourceItem other = (ActivateReadSetSourceItem)obj;
        return Objects.equals(this.readSetId(), other.readSetId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"ActivateReadSetSourceItem").add("ReadSetId", (Object)this.readSetId()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "readSetId": {
                return Optional.ofNullable(clazz.cast(this.readSetId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActivateReadSetSourceItem, T> g) {
        return obj -> g.apply((ActivateReadSetSourceItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String readSetId;
        private String status;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivateReadSetSourceItem model) {
            this.readSetId(model.readSetId);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
        }

        public final String getReadSetId() {
            return this.readSetId;
        }

        public final void setReadSetId(String readSetId) {
            this.readSetId = readSetId;
        }

        @Override
        public final Builder readSetId(String readSetId) {
            this.readSetId = readSetId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReadSetActivationJobItemStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public ActivateReadSetSourceItem build() {
            return new ActivateReadSetSourceItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActivateReadSetSourceItem> {
        public Builder readSetId(String var1);

        public Builder status(String var1);

        public Builder status(ReadSetActivationJobItemStatus var1);

        public Builder statusMessage(String var1);
    }
}

