/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.StreamingRequestMarshaller;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.omics.internal.OmicsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.omics.model.AbortMultipartReadSetUploadRequest;
import software.amazon.awssdk.services.omics.model.AbortMultipartReadSetUploadResponse;
import software.amazon.awssdk.services.omics.model.AcceptShareRequest;
import software.amazon.awssdk.services.omics.model.AcceptShareResponse;
import software.amazon.awssdk.services.omics.model.AccessDeniedException;
import software.amazon.awssdk.services.omics.model.BatchDeleteReadSetRequest;
import software.amazon.awssdk.services.omics.model.BatchDeleteReadSetResponse;
import software.amazon.awssdk.services.omics.model.CancelAnnotationImportJobRequest;
import software.amazon.awssdk.services.omics.model.CancelAnnotationImportJobResponse;
import software.amazon.awssdk.services.omics.model.CancelRunRequest;
import software.amazon.awssdk.services.omics.model.CancelRunResponse;
import software.amazon.awssdk.services.omics.model.CancelVariantImportJobRequest;
import software.amazon.awssdk.services.omics.model.CancelVariantImportJobResponse;
import software.amazon.awssdk.services.omics.model.CompleteMultipartReadSetUploadRequest;
import software.amazon.awssdk.services.omics.model.CompleteMultipartReadSetUploadResponse;
import software.amazon.awssdk.services.omics.model.ConflictException;
import software.amazon.awssdk.services.omics.model.CreateAnnotationStoreRequest;
import software.amazon.awssdk.services.omics.model.CreateAnnotationStoreResponse;
import software.amazon.awssdk.services.omics.model.CreateAnnotationStoreVersionRequest;
import software.amazon.awssdk.services.omics.model.CreateAnnotationStoreVersionResponse;
import software.amazon.awssdk.services.omics.model.CreateMultipartReadSetUploadRequest;
import software.amazon.awssdk.services.omics.model.CreateMultipartReadSetUploadResponse;
import software.amazon.awssdk.services.omics.model.CreateReferenceStoreRequest;
import software.amazon.awssdk.services.omics.model.CreateReferenceStoreResponse;
import software.amazon.awssdk.services.omics.model.CreateRunGroupRequest;
import software.amazon.awssdk.services.omics.model.CreateRunGroupResponse;
import software.amazon.awssdk.services.omics.model.CreateSequenceStoreRequest;
import software.amazon.awssdk.services.omics.model.CreateSequenceStoreResponse;
import software.amazon.awssdk.services.omics.model.CreateShareRequest;
import software.amazon.awssdk.services.omics.model.CreateShareResponse;
import software.amazon.awssdk.services.omics.model.CreateVariantStoreRequest;
import software.amazon.awssdk.services.omics.model.CreateVariantStoreResponse;
import software.amazon.awssdk.services.omics.model.CreateWorkflowRequest;
import software.amazon.awssdk.services.omics.model.CreateWorkflowResponse;
import software.amazon.awssdk.services.omics.model.DeleteAnnotationStoreRequest;
import software.amazon.awssdk.services.omics.model.DeleteAnnotationStoreResponse;
import software.amazon.awssdk.services.omics.model.DeleteAnnotationStoreVersionsRequest;
import software.amazon.awssdk.services.omics.model.DeleteAnnotationStoreVersionsResponse;
import software.amazon.awssdk.services.omics.model.DeleteReferenceRequest;
import software.amazon.awssdk.services.omics.model.DeleteReferenceResponse;
import software.amazon.awssdk.services.omics.model.DeleteReferenceStoreRequest;
import software.amazon.awssdk.services.omics.model.DeleteReferenceStoreResponse;
import software.amazon.awssdk.services.omics.model.DeleteRunGroupRequest;
import software.amazon.awssdk.services.omics.model.DeleteRunGroupResponse;
import software.amazon.awssdk.services.omics.model.DeleteRunRequest;
import software.amazon.awssdk.services.omics.model.DeleteRunResponse;
import software.amazon.awssdk.services.omics.model.DeleteSequenceStoreRequest;
import software.amazon.awssdk.services.omics.model.DeleteSequenceStoreResponse;
import software.amazon.awssdk.services.omics.model.DeleteShareRequest;
import software.amazon.awssdk.services.omics.model.DeleteShareResponse;
import software.amazon.awssdk.services.omics.model.DeleteVariantStoreRequest;
import software.amazon.awssdk.services.omics.model.DeleteVariantStoreResponse;
import software.amazon.awssdk.services.omics.model.DeleteWorkflowRequest;
import software.amazon.awssdk.services.omics.model.DeleteWorkflowResponse;
import software.amazon.awssdk.services.omics.model.GetAnnotationImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetAnnotationImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreRequest;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreResponse;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreVersionRequest;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreVersionResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetActivationJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetActivationJobResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetExportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetExportJobResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetMetadataRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetMetadataResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetResponse;
import software.amazon.awssdk.services.omics.model.GetReferenceImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReferenceImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetReferenceMetadataRequest;
import software.amazon.awssdk.services.omics.model.GetReferenceMetadataResponse;
import software.amazon.awssdk.services.omics.model.GetReferenceRequest;
import software.amazon.awssdk.services.omics.model.GetReferenceResponse;
import software.amazon.awssdk.services.omics.model.GetReferenceStoreRequest;
import software.amazon.awssdk.services.omics.model.GetReferenceStoreResponse;
import software.amazon.awssdk.services.omics.model.GetRunGroupRequest;
import software.amazon.awssdk.services.omics.model.GetRunGroupResponse;
import software.amazon.awssdk.services.omics.model.GetRunRequest;
import software.amazon.awssdk.services.omics.model.GetRunResponse;
import software.amazon.awssdk.services.omics.model.GetRunTaskRequest;
import software.amazon.awssdk.services.omics.model.GetRunTaskResponse;
import software.amazon.awssdk.services.omics.model.GetSequenceStoreRequest;
import software.amazon.awssdk.services.omics.model.GetSequenceStoreResponse;
import software.amazon.awssdk.services.omics.model.GetShareRequest;
import software.amazon.awssdk.services.omics.model.GetShareResponse;
import software.amazon.awssdk.services.omics.model.GetVariantImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetVariantImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetVariantStoreRequest;
import software.amazon.awssdk.services.omics.model.GetVariantStoreResponse;
import software.amazon.awssdk.services.omics.model.GetWorkflowRequest;
import software.amazon.awssdk.services.omics.model.GetWorkflowResponse;
import software.amazon.awssdk.services.omics.model.InternalServerException;
import software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsResponse;
import software.amazon.awssdk.services.omics.model.ListAnnotationStoreVersionsRequest;
import software.amazon.awssdk.services.omics.model.ListAnnotationStoreVersionsResponse;
import software.amazon.awssdk.services.omics.model.ListAnnotationStoresRequest;
import software.amazon.awssdk.services.omics.model.ListAnnotationStoresResponse;
import software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsRequest;
import software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsResponse;
import software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsResponse;
import software.amazon.awssdk.services.omics.model.ListReadSetExportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetExportJobsResponse;
import software.amazon.awssdk.services.omics.model.ListReadSetImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetImportJobsResponse;
import software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsResponse;
import software.amazon.awssdk.services.omics.model.ListReadSetsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetsResponse;
import software.amazon.awssdk.services.omics.model.ListReferenceImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReferenceImportJobsResponse;
import software.amazon.awssdk.services.omics.model.ListReferenceStoresRequest;
import software.amazon.awssdk.services.omics.model.ListReferenceStoresResponse;
import software.amazon.awssdk.services.omics.model.ListReferencesRequest;
import software.amazon.awssdk.services.omics.model.ListReferencesResponse;
import software.amazon.awssdk.services.omics.model.ListRunGroupsRequest;
import software.amazon.awssdk.services.omics.model.ListRunGroupsResponse;
import software.amazon.awssdk.services.omics.model.ListRunTasksRequest;
import software.amazon.awssdk.services.omics.model.ListRunTasksResponse;
import software.amazon.awssdk.services.omics.model.ListRunsRequest;
import software.amazon.awssdk.services.omics.model.ListRunsResponse;
import software.amazon.awssdk.services.omics.model.ListSequenceStoresRequest;
import software.amazon.awssdk.services.omics.model.ListSequenceStoresResponse;
import software.amazon.awssdk.services.omics.model.ListSharesRequest;
import software.amazon.awssdk.services.omics.model.ListSharesResponse;
import software.amazon.awssdk.services.omics.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.omics.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.omics.model.ListVariantImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListVariantImportJobsResponse;
import software.amazon.awssdk.services.omics.model.ListVariantStoresRequest;
import software.amazon.awssdk.services.omics.model.ListVariantStoresResponse;
import software.amazon.awssdk.services.omics.model.ListWorkflowsRequest;
import software.amazon.awssdk.services.omics.model.ListWorkflowsResponse;
import software.amazon.awssdk.services.omics.model.NotSupportedOperationException;
import software.amazon.awssdk.services.omics.model.OmicsException;
import software.amazon.awssdk.services.omics.model.RangeNotSatisfiableException;
import software.amazon.awssdk.services.omics.model.RequestTimeoutException;
import software.amazon.awssdk.services.omics.model.ResourceNotFoundException;
import software.amazon.awssdk.services.omics.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.omics.model.StartAnnotationImportJobRequest;
import software.amazon.awssdk.services.omics.model.StartAnnotationImportJobResponse;
import software.amazon.awssdk.services.omics.model.StartReadSetActivationJobRequest;
import software.amazon.awssdk.services.omics.model.StartReadSetActivationJobResponse;
import software.amazon.awssdk.services.omics.model.StartReadSetExportJobRequest;
import software.amazon.awssdk.services.omics.model.StartReadSetExportJobResponse;
import software.amazon.awssdk.services.omics.model.StartReadSetImportJobRequest;
import software.amazon.awssdk.services.omics.model.StartReadSetImportJobResponse;
import software.amazon.awssdk.services.omics.model.StartReferenceImportJobRequest;
import software.amazon.awssdk.services.omics.model.StartReferenceImportJobResponse;
import software.amazon.awssdk.services.omics.model.StartRunRequest;
import software.amazon.awssdk.services.omics.model.StartRunResponse;
import software.amazon.awssdk.services.omics.model.StartVariantImportJobRequest;
import software.amazon.awssdk.services.omics.model.StartVariantImportJobResponse;
import software.amazon.awssdk.services.omics.model.TagResourceRequest;
import software.amazon.awssdk.services.omics.model.TagResourceResponse;
import software.amazon.awssdk.services.omics.model.ThrottlingException;
import software.amazon.awssdk.services.omics.model.UntagResourceRequest;
import software.amazon.awssdk.services.omics.model.UntagResourceResponse;
import software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreRequest;
import software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreResponse;
import software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreVersionRequest;
import software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreVersionResponse;
import software.amazon.awssdk.services.omics.model.UpdateRunGroupRequest;
import software.amazon.awssdk.services.omics.model.UpdateRunGroupResponse;
import software.amazon.awssdk.services.omics.model.UpdateVariantStoreRequest;
import software.amazon.awssdk.services.omics.model.UpdateVariantStoreResponse;
import software.amazon.awssdk.services.omics.model.UpdateWorkflowRequest;
import software.amazon.awssdk.services.omics.model.UpdateWorkflowResponse;
import software.amazon.awssdk.services.omics.model.UploadReadSetPartRequest;
import software.amazon.awssdk.services.omics.model.UploadReadSetPartResponse;
import software.amazon.awssdk.services.omics.model.ValidationException;
import software.amazon.awssdk.services.omics.transform.AbortMultipartReadSetUploadRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.AcceptShareRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.BatchDeleteReadSetRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CancelAnnotationImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CancelRunRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CancelVariantImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CompleteMultipartReadSetUploadRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateAnnotationStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateAnnotationStoreVersionRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateMultipartReadSetUploadRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateReferenceStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateRunGroupRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateSequenceStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateShareRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateVariantStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateWorkflowRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteAnnotationStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteAnnotationStoreVersionsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteReferenceRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteReferenceStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteRunGroupRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteRunRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteSequenceStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteShareRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteVariantStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteWorkflowRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetAnnotationImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetAnnotationStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetAnnotationStoreVersionRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReadSetActivationJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReadSetExportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReadSetImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReadSetMetadataRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReadSetRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReferenceImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReferenceMetadataRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReferenceRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReferenceStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetRunGroupRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetRunRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetRunTaskRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetSequenceStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetShareRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetVariantImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetVariantStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetWorkflowRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListAnnotationImportJobsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListAnnotationStoreVersionsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListAnnotationStoresRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListMultipartReadSetUploadsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReadSetActivationJobsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReadSetExportJobsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReadSetImportJobsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReadSetUploadPartsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReadSetsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReferenceImportJobsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReferenceStoresRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReferencesRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListRunGroupsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListRunTasksRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListRunsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListSequenceStoresRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListSharesRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListVariantImportJobsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListVariantStoresRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListWorkflowsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.StartAnnotationImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.StartReadSetActivationJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.StartReadSetExportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.StartReadSetImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.StartReferenceImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.StartRunRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.StartVariantImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UpdateAnnotationStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UpdateAnnotationStoreVersionRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UpdateRunGroupRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UpdateVariantStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UpdateWorkflowRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UploadReadSetPartRequestMarshaller;
import software.amazon.awssdk.services.omics.waiters.OmicsWaiter;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link OmicsClient}.
 *
 * @see OmicsClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultOmicsClient implements OmicsClient {
    private static final Logger log = Logger.loggerFor(DefaultOmicsClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultOmicsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Stops a multipart upload.
     * </p>
     *
     * @param abortMultipartReadSetUploadRequest
     * @return Result of the AbortMultipartReadSetUpload operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws NotSupportedOperationException
     *         The operation is not supported by Amazon Omics, or the API does not exist.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.AbortMultipartReadSetUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/AbortMultipartReadSetUpload"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AbortMultipartReadSetUploadResponse abortMultipartReadSetUpload(
            AbortMultipartReadSetUploadRequest abortMultipartReadSetUploadRequest) throws InternalServerException,
            NotSupportedOperationException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AbortMultipartReadSetUploadResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AbortMultipartReadSetUploadResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(abortMultipartReadSetUploadRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, abortMultipartReadSetUploadRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AbortMultipartReadSetUpload");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler
                    .execute(new ClientExecutionParams<AbortMultipartReadSetUploadRequest, AbortMultipartReadSetUploadResponse>()
                            .withOperationName("AbortMultipartReadSetUpload").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(abortMultipartReadSetUploadRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AbortMultipartReadSetUploadRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Accepts a share for an analytics store.
     * </p>
     *
     * @param acceptShareRequest
     * @return Result of the AcceptShare operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.AcceptShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/AcceptShare" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AcceptShareResponse acceptShare(AcceptShareRequest acceptShareRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AcceptShareResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AcceptShareResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptShareRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, acceptShareRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptShare");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<AcceptShareRequest, AcceptShareResponse>()
                    .withOperationName("AcceptShare").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(acceptShareRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AcceptShareRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes one or more read sets.
     * </p>
     *
     * @param batchDeleteReadSetRequest
     * @return Result of the BatchDeleteReadSet operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.BatchDeleteReadSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/BatchDeleteReadSet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchDeleteReadSetResponse batchDeleteReadSet(BatchDeleteReadSetRequest batchDeleteReadSetRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchDeleteReadSetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchDeleteReadSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDeleteReadSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDeleteReadSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDeleteReadSet");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<BatchDeleteReadSetRequest, BatchDeleteReadSetResponse>()
                    .withOperationName("BatchDeleteReadSet").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(batchDeleteReadSetRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchDeleteReadSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels an annotation import job.
     * </p>
     *
     * @param cancelAnnotationImportJobRequest
     * @return Result of the CancelAnnotationImportJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.CancelAnnotationImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CancelAnnotationImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CancelAnnotationImportJobResponse cancelAnnotationImportJob(
            CancelAnnotationImportJobRequest cancelAnnotationImportJobRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelAnnotationImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelAnnotationImportJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelAnnotationImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelAnnotationImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelAnnotationImportJob");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler
                    .execute(new ClientExecutionParams<CancelAnnotationImportJobRequest, CancelAnnotationImportJobResponse>()
                            .withOperationName("CancelAnnotationImportJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(cancelAnnotationImportJobRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelAnnotationImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels a run.
     * </p>
     *
     * @param cancelRunRequest
     * @return Result of the CancelRun operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.CancelRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CancelRun" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CancelRunResponse cancelRun(CancelRunRequest cancelRunRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelRunResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CancelRunResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelRunRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelRunRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelRun");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<CancelRunRequest, CancelRunResponse>()
                    .withOperationName("CancelRun").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(cancelRunRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new CancelRunRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels a variant import job.
     * </p>
     *
     * @param cancelVariantImportJobRequest
     * @return Result of the CancelVariantImportJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.CancelVariantImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CancelVariantImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CancelVariantImportJobResponse cancelVariantImportJob(CancelVariantImportJobRequest cancelVariantImportJobRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelVariantImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelVariantImportJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelVariantImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelVariantImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelVariantImportJob");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler
                    .execute(new ClientExecutionParams<CancelVariantImportJobRequest, CancelVariantImportJobResponse>()
                            .withOperationName("CancelVariantImportJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(cancelVariantImportJobRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelVariantImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Concludes a multipart upload once you have uploaded all the components.
     * </p>
     *
     * @param completeMultipartReadSetUploadRequest
     * @return Result of the CompleteMultipartReadSetUpload operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws NotSupportedOperationException
     *         The operation is not supported by Amazon Omics, or the API does not exist.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.CompleteMultipartReadSetUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CompleteMultipartReadSetUpload"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompleteMultipartReadSetUploadResponse completeMultipartReadSetUpload(
            CompleteMultipartReadSetUploadRequest completeMultipartReadSetUploadRequest) throws InternalServerException,
            NotSupportedOperationException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CompleteMultipartReadSetUploadResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CompleteMultipartReadSetUploadResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(completeMultipartReadSetUploadRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                completeMultipartReadSetUploadRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CompleteMultipartReadSetUpload");
            String hostPrefix = "storage-";
            String resolvedHostExpression = "storage-";

            return clientHandler
                    .execute(new ClientExecutionParams<CompleteMultipartReadSetUploadRequest, CompleteMultipartReadSetUploadResponse>()
                            .withOperationName("CompleteMultipartReadSetUpload").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(completeMultipartReadSetUploadRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CompleteMultipartReadSetUploadRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an annotation store.
     * </p>
     *
     * @param createAnnotationStoreRequest
     * @return Result of the CreateAnnotationStore operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.CreateAnnotationStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateAnnotationStore" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateAnnotationStoreResponse createAnnotationStore(CreateAnnotationStoreRequest createAnnotationStoreRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            ConflictException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAnnotationStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAnnotationStoreResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAnnotationStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAnnotationStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAnnotationStore");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<CreateAnnotationStoreRequest, CreateAnnotationStoreResponse>()
                    .withOperationName("CreateAnnotationStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(createAnnotationStoreRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAnnotationStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new version of an annotation store.
     * </p>
     *
     * @param createAnnotationStoreVersionRequest
     * @return Result of the CreateAnnotationStoreVersion operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.CreateAnnotationStoreVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateAnnotationStoreVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateAnnotationStoreVersionResponse createAnnotationStoreVersion(
            CreateAnnotationStoreVersionRequest createAnnotationStoreVersionRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAnnotationStoreVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAnnotationStoreVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAnnotationStoreVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAnnotationStoreVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAnnotationStoreVersion");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler
                    .execute(new ClientExecutionParams<CreateAnnotationStoreVersionRequest, CreateAnnotationStoreVersionResponse>()
                            .withOperationName("CreateAnnotationStoreVersion").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(createAnnotationStoreVersionRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateAnnotationStoreVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Begins a multipart read set upload.
     * </p>
     *
     * @param createMultipartReadSetUploadRequest
     * @return Result of the CreateMultipartReadSetUpload operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws NotSupportedOperationException
     *         The operation is not supported by Amazon Omics, or the API does not exist.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.CreateMultipartReadSetUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateMultipartReadSetUpload"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateMultipartReadSetUploadResponse createMultipartReadSetUpload(
            CreateMultipartReadSetUploadRequest createMultipartReadSetUploadRequest) throws InternalServerException,
            NotSupportedOperationException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateMultipartReadSetUploadResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateMultipartReadSetUploadResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMultipartReadSetUploadRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMultipartReadSetUploadRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMultipartReadSetUpload");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler
                    .execute(new ClientExecutionParams<CreateMultipartReadSetUploadRequest, CreateMultipartReadSetUploadResponse>()
                            .withOperationName("CreateMultipartReadSetUpload").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(createMultipartReadSetUploadRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateMultipartReadSetUploadRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a reference store.
     * </p>
     *
     * @param createReferenceStoreRequest
     * @return Result of the CreateReferenceStore operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.CreateReferenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateReferenceStore" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateReferenceStoreResponse createReferenceStore(CreateReferenceStoreRequest createReferenceStoreRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateReferenceStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateReferenceStoreResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createReferenceStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createReferenceStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateReferenceStore");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<CreateReferenceStoreRequest, CreateReferenceStoreResponse>()
                    .withOperationName("CreateReferenceStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(createReferenceStoreRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateReferenceStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a run group.
     * </p>
     *
     * @param createRunGroupRequest
     * @return Result of the CreateRunGroup operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.CreateRunGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateRunGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateRunGroupResponse createRunGroup(CreateRunGroupRequest createRunGroupRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateRunGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateRunGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRunGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRunGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRunGroup");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<CreateRunGroupRequest, CreateRunGroupResponse>()
                    .withOperationName("CreateRunGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(createRunGroupRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateRunGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a sequence store.
     * </p>
     *
     * @param createSequenceStoreRequest
     * @return Result of the CreateSequenceStore operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.CreateSequenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateSequenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateSequenceStoreResponse createSequenceStore(CreateSequenceStoreRequest createSequenceStoreRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSequenceStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateSequenceStoreResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSequenceStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSequenceStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSequenceStore");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<CreateSequenceStoreRequest, CreateSequenceStoreResponse>()
                    .withOperationName("CreateSequenceStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(createSequenceStoreRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSequenceStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a share offer that can be accepted outside the account by a subscriber. The share is created by the owner
     * and accepted by the principal subscriber.
     * </p>
     *
     * @param createShareRequest
     * @return Result of the CreateShare operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.CreateShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateShare" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateShareResponse createShare(CreateShareRequest createShareRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateShareResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateShareResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createShareRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createShareRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateShare");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<CreateShareRequest, CreateShareResponse>()
                    .withOperationName("CreateShare").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(createShareRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateShareRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a variant store.
     * </p>
     *
     * @param createVariantStoreRequest
     * @return Result of the CreateVariantStore operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.CreateVariantStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateVariantStore" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateVariantStoreResponse createVariantStore(CreateVariantStoreRequest createVariantStoreRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            ConflictException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateVariantStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateVariantStoreResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVariantStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVariantStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVariantStore");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<CreateVariantStoreRequest, CreateVariantStoreResponse>()
                    .withOperationName("CreateVariantStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(createVariantStoreRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateVariantStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a workflow.
     * </p>
     *
     * @param createWorkflowRequest
     * @return Result of the CreateWorkflow operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.CreateWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateWorkflowResponse createWorkflow(CreateWorkflowRequest createWorkflowRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateWorkflowResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWorkflowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkflow");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<CreateWorkflowRequest, CreateWorkflowResponse>()
                    .withOperationName("CreateWorkflow").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(createWorkflowRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateWorkflowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an annotation store.
     * </p>
     *
     * @param deleteAnnotationStoreRequest
     * @return Result of the DeleteAnnotationStore operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.DeleteAnnotationStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteAnnotationStore" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteAnnotationStoreResponse deleteAnnotationStore(DeleteAnnotationStoreRequest deleteAnnotationStoreRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAnnotationStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAnnotationStoreResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAnnotationStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAnnotationStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAnnotationStore");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<DeleteAnnotationStoreRequest, DeleteAnnotationStoreResponse>()
                    .withOperationName("DeleteAnnotationStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteAnnotationStoreRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAnnotationStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes one or multiple versions of an annotation store.
     * </p>
     *
     * @param deleteAnnotationStoreVersionsRequest
     * @return Result of the DeleteAnnotationStoreVersions operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.DeleteAnnotationStoreVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteAnnotationStoreVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAnnotationStoreVersionsResponse deleteAnnotationStoreVersions(
            DeleteAnnotationStoreVersionsRequest deleteAnnotationStoreVersionsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAnnotationStoreVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAnnotationStoreVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAnnotationStoreVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteAnnotationStoreVersionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAnnotationStoreVersions");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteAnnotationStoreVersionsRequest, DeleteAnnotationStoreVersionsResponse>()
                            .withOperationName("DeleteAnnotationStoreVersions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(deleteAnnotationStoreVersionsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteAnnotationStoreVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a genome reference.
     * </p>
     *
     * @param deleteReferenceRequest
     * @return Result of the DeleteReference operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.DeleteReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteReference" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteReferenceResponse deleteReference(DeleteReferenceRequest deleteReferenceRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException,
            RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteReferenceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteReferenceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteReferenceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteReferenceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteReference");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<DeleteReferenceRequest, DeleteReferenceResponse>()
                    .withOperationName("DeleteReference").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteReferenceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteReferenceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a genome reference store.
     * </p>
     *
     * @param deleteReferenceStoreRequest
     * @return Result of the DeleteReferenceStore operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.DeleteReferenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteReferenceStore" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteReferenceStoreResponse deleteReferenceStore(DeleteReferenceStoreRequest deleteReferenceStoreRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteReferenceStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteReferenceStoreResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteReferenceStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteReferenceStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteReferenceStore");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<DeleteReferenceStoreRequest, DeleteReferenceStoreResponse>()
                    .withOperationName("DeleteReferenceStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteReferenceStoreRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteReferenceStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a workflow run.
     * </p>
     *
     * @param deleteRunRequest
     * @return Result of the DeleteRun operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.DeleteRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteRun" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteRunResponse deleteRun(DeleteRunRequest deleteRunRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRunResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteRunResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRunRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRunRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRun");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<DeleteRunRequest, DeleteRunResponse>()
                    .withOperationName("DeleteRun").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteRunRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new DeleteRunRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a workflow run group.
     * </p>
     *
     * @param deleteRunGroupRequest
     * @return Result of the DeleteRunGroup operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.DeleteRunGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteRunGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteRunGroupResponse deleteRunGroup(DeleteRunGroupRequest deleteRunGroupRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRunGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteRunGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRunGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRunGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRunGroup");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<DeleteRunGroupRequest, DeleteRunGroupResponse>()
                    .withOperationName("DeleteRunGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteRunGroupRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteRunGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a sequence store.
     * </p>
     *
     * @param deleteSequenceStoreRequest
     * @return Result of the DeleteSequenceStore operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.DeleteSequenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteSequenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteSequenceStoreResponse deleteSequenceStore(DeleteSequenceStoreRequest deleteSequenceStoreRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSequenceStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteSequenceStoreResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSequenceStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSequenceStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSequenceStore");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<DeleteSequenceStoreRequest, DeleteSequenceStoreResponse>()
                    .withOperationName("DeleteSequenceStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteSequenceStoreRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteSequenceStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a share of an analytics store.
     * </p>
     *
     * @param deleteShareRequest
     * @return Result of the DeleteShare operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.DeleteShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteShare" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteShareResponse deleteShare(DeleteShareRequest deleteShareRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteShareResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteShareResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteShareRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteShareRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteShare");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<DeleteShareRequest, DeleteShareResponse>()
                    .withOperationName("DeleteShare").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteShareRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteShareRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a variant store.
     * </p>
     *
     * @param deleteVariantStoreRequest
     * @return Result of the DeleteVariantStore operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.DeleteVariantStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteVariantStore" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteVariantStoreResponse deleteVariantStore(DeleteVariantStoreRequest deleteVariantStoreRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteVariantStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteVariantStoreResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVariantStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVariantStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVariantStore");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<DeleteVariantStoreRequest, DeleteVariantStoreResponse>()
                    .withOperationName("DeleteVariantStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteVariantStoreRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteVariantStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a workflow.
     * </p>
     *
     * @param deleteWorkflowRequest
     * @return Result of the DeleteWorkflow operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.DeleteWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteWorkflowResponse deleteWorkflow(DeleteWorkflowRequest deleteWorkflowRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteWorkflowResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWorkflowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWorkflow");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<DeleteWorkflowRequest, DeleteWorkflowResponse>()
                    .withOperationName("DeleteWorkflow").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteWorkflowRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteWorkflowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about an annotation import job.
     * </p>
     *
     * @param getAnnotationImportJobRequest
     * @return Result of the GetAnnotationImportJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetAnnotationImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetAnnotationImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetAnnotationImportJobResponse getAnnotationImportJob(GetAnnotationImportJobRequest getAnnotationImportJobRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAnnotationImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetAnnotationImportJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAnnotationImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAnnotationImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAnnotationImportJob");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler
                    .execute(new ClientExecutionParams<GetAnnotationImportJobRequest, GetAnnotationImportJobResponse>()
                            .withOperationName("GetAnnotationImportJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(getAnnotationImportJobRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetAnnotationImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about an annotation store.
     * </p>
     *
     * @param getAnnotationStoreRequest
     * @return Result of the GetAnnotationStore operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetAnnotationStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetAnnotationStore" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetAnnotationStoreResponse getAnnotationStore(GetAnnotationStoreRequest getAnnotationStoreRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAnnotationStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetAnnotationStoreResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAnnotationStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAnnotationStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAnnotationStore");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<GetAnnotationStoreRequest, GetAnnotationStoreResponse>()
                    .withOperationName("GetAnnotationStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(getAnnotationStoreRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetAnnotationStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the metadata for an annotation store version.
     * </p>
     *
     * @param getAnnotationStoreVersionRequest
     * @return Result of the GetAnnotationStoreVersion operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetAnnotationStoreVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetAnnotationStoreVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetAnnotationStoreVersionResponse getAnnotationStoreVersion(
            GetAnnotationStoreVersionRequest getAnnotationStoreVersionRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAnnotationStoreVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetAnnotationStoreVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAnnotationStoreVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAnnotationStoreVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAnnotationStoreVersion");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler
                    .execute(new ClientExecutionParams<GetAnnotationStoreVersionRequest, GetAnnotationStoreVersionResponse>()
                            .withOperationName("GetAnnotationStoreVersion").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(getAnnotationStoreVersionRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetAnnotationStoreVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a file from a read set.
     * </p>
     *
     * @param getReadSetRequest
     * @param responseTransformer
     *        Functional interface for processing the streamed response content. The unmarshalled GetReadSetResponse and
     *        an InputStream to the response content are provided as parameters to the callback. The callback may return
     *        a transformed type which will be the return value of this method. See
     *        {@link software.amazon.awssdk.core.sync.ResponseTransformer} for details on implementing this interface
     *        and for links to pre-canned implementations for common scenarios like downloading to a file. The service
     *        documentation for the response content is as follows '
     *        <p>
     *        The read set file payload.
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws RangeNotSatisfiableException
     *         The ranges specified in the request are not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetReadSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public <ReturnT> ReturnT getReadSet(GetReadSetRequest getReadSetRequest,
            ResponseTransformer<GetReadSetResponse, ReturnT> responseTransformer) throws InternalServerException,
            RangeNotSatisfiableException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(true)
                .isPayloadJson(false).build();

        HttpResponseHandler<GetReadSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetReadSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReadSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReadSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReadSet");
            String hostPrefix = "storage-";
            String resolvedHostExpression = "storage-";

            return clientHandler.execute(
                    new ClientExecutionParams<GetReadSetRequest, GetReadSetResponse>().withOperationName("GetReadSet")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withRequestConfiguration(clientConfiguration).withInput(getReadSetRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetReadSetRequestMarshaller(protocolFactory)), responseTransformer);
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a read set activation job.
     * </p>
     *
     * @param getReadSetActivationJobRequest
     * @return Result of the GetReadSetActivationJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetReadSetActivationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetActivationJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetReadSetActivationJobResponse getReadSetActivationJob(GetReadSetActivationJobRequest getReadSetActivationJobRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetReadSetActivationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetReadSetActivationJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReadSetActivationJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReadSetActivationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReadSetActivationJob");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler
                    .execute(new ClientExecutionParams<GetReadSetActivationJobRequest, GetReadSetActivationJobResponse>()
                            .withOperationName("GetReadSetActivationJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(getReadSetActivationJobRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetReadSetActivationJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a read set export job.
     * </p>
     *
     * @param getReadSetExportJobRequest
     * @return Result of the GetReadSetExportJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetReadSetExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetReadSetExportJobResponse getReadSetExportJob(GetReadSetExportJobRequest getReadSetExportJobRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetReadSetExportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetReadSetExportJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReadSetExportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReadSetExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReadSetExportJob");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<GetReadSetExportJobRequest, GetReadSetExportJobResponse>()
                    .withOperationName("GetReadSetExportJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(getReadSetExportJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetReadSetExportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a read set import job.
     * </p>
     *
     * @param getReadSetImportJobRequest
     * @return Result of the GetReadSetImportJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetReadSetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetReadSetImportJobResponse getReadSetImportJob(GetReadSetImportJobRequest getReadSetImportJobRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetReadSetImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetReadSetImportJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReadSetImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReadSetImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReadSetImportJob");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<GetReadSetImportJobRequest, GetReadSetImportJobResponse>()
                    .withOperationName("GetReadSetImportJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(getReadSetImportJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetReadSetImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets details about a read set.
     * </p>
     *
     * @param getReadSetMetadataRequest
     * @return Result of the GetReadSetMetadata operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetReadSetMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetReadSetMetadataResponse getReadSetMetadata(GetReadSetMetadataRequest getReadSetMetadataRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetReadSetMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetReadSetMetadataResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReadSetMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReadSetMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReadSetMetadata");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<GetReadSetMetadataRequest, GetReadSetMetadataResponse>()
                    .withOperationName("GetReadSetMetadata").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(getReadSetMetadataRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetReadSetMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a reference file.
     * </p>
     *
     * @param getReferenceRequest
     * @param responseTransformer
     *        Functional interface for processing the streamed response content. The unmarshalled GetReferenceResponse
     *        and an InputStream to the response content are provided as parameters to the callback. The callback may
     *        return a transformed type which will be the return value of this method. See
     *        {@link software.amazon.awssdk.core.sync.ResponseTransformer} for details on implementing this interface
     *        and for links to pre-canned implementations for common scenarios like downloading to a file. The service
     *        documentation for the response content is as follows '
     *        <p>
     *        The reference file payload.
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws RangeNotSatisfiableException
     *         The ranges specified in the request are not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReference" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public <ReturnT> ReturnT getReference(GetReferenceRequest getReferenceRequest,
            ResponseTransformer<GetReferenceResponse, ReturnT> responseTransformer) throws InternalServerException,
            RangeNotSatisfiableException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(true)
                .isPayloadJson(false).build();

        HttpResponseHandler<GetReferenceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetReferenceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReferenceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReferenceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReference");
            String hostPrefix = "storage-";
            String resolvedHostExpression = "storage-";

            return clientHandler.execute(
                    new ClientExecutionParams<GetReferenceRequest, GetReferenceResponse>().withOperationName("GetReference")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withRequestConfiguration(clientConfiguration).withInput(getReferenceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetReferenceRequestMarshaller(protocolFactory)), responseTransformer);
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a reference import job.
     * </p>
     *
     * @param getReferenceImportJobRequest
     * @return Result of the GetReferenceImportJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetReferenceImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReferenceImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetReferenceImportJobResponse getReferenceImportJob(GetReferenceImportJobRequest getReferenceImportJobRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetReferenceImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetReferenceImportJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReferenceImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReferenceImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReferenceImportJob");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<GetReferenceImportJobRequest, GetReferenceImportJobResponse>()
                    .withOperationName("GetReferenceImportJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(getReferenceImportJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetReferenceImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a genome reference's metadata.
     * </p>
     *
     * @param getReferenceMetadataRequest
     * @return Result of the GetReferenceMetadata operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetReferenceMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReferenceMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetReferenceMetadataResponse getReferenceMetadata(GetReferenceMetadataRequest getReferenceMetadataRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetReferenceMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetReferenceMetadataResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReferenceMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReferenceMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReferenceMetadata");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<GetReferenceMetadataRequest, GetReferenceMetadataResponse>()
                    .withOperationName("GetReferenceMetadata").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(getReferenceMetadataRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetReferenceMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a reference store.
     * </p>
     *
     * @param getReferenceStoreRequest
     * @return Result of the GetReferenceStore operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetReferenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReferenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetReferenceStoreResponse getReferenceStore(GetReferenceStoreRequest getReferenceStoreRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetReferenceStoreResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetReferenceStoreResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReferenceStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReferenceStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReferenceStore");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<GetReferenceStoreRequest, GetReferenceStoreResponse>()
                    .withOperationName("GetReferenceStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(getReferenceStoreRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetReferenceStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a workflow run.
     * </p>
     *
     * @param getRunRequest
     * @return Result of the GetRun operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetRun" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetRunResponse getRun(GetRunRequest getRunRequest) throws InternalServerException, ServiceQuotaExceededException,
            ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException,
            RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRunResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetRunResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRunRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRunRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRun");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<GetRunRequest, GetRunResponse>().withOperationName("GetRun")
                    .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(getRunRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetRunRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a workflow run group.
     * </p>
     *
     * @param getRunGroupRequest
     * @return Result of the GetRunGroup operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetRunGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetRunGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetRunGroupResponse getRunGroup(GetRunGroupRequest getRunGroupRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRunGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetRunGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRunGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRunGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRunGroup");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<GetRunGroupRequest, GetRunGroupResponse>()
                    .withOperationName("GetRunGroup").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(getRunGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetRunGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a workflow run task.
     * </p>
     *
     * @param getRunTaskRequest
     * @return Result of the GetRunTask operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetRunTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetRunTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetRunTaskResponse getRunTask(GetRunTaskRequest getRunTaskRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRunTaskResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetRunTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRunTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRunTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRunTask");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler
                    .execute(new ClientExecutionParams<GetRunTaskRequest, GetRunTaskResponse>().withOperationName("GetRunTask")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withRequestConfiguration(clientConfiguration).withInput(getRunTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetRunTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a sequence store.
     * </p>
     *
     * @param getSequenceStoreRequest
     * @return Result of the GetSequenceStore operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetSequenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetSequenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetSequenceStoreResponse getSequenceStore(GetSequenceStoreRequest getSequenceStoreRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSequenceStoreResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSequenceStoreResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSequenceStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSequenceStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSequenceStore");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<GetSequenceStoreRequest, GetSequenceStoreResponse>()
                    .withOperationName("GetSequenceStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(getSequenceStoreRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSequenceStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the metadata for a share.
     * </p>
     *
     * @param getShareRequest
     * @return Result of the GetShare operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetShare" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetShareResponse getShare(GetShareRequest getShareRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetShareResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetShareResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getShareRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getShareRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetShare");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<GetShareRequest, GetShareResponse>()
                    .withOperationName("GetShare").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(getShareRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetShareRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a variant import job.
     * </p>
     *
     * @param getVariantImportJobRequest
     * @return Result of the GetVariantImportJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetVariantImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetVariantImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetVariantImportJobResponse getVariantImportJob(GetVariantImportJobRequest getVariantImportJobRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetVariantImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetVariantImportJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getVariantImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVariantImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVariantImportJob");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<GetVariantImportJobRequest, GetVariantImportJobResponse>()
                    .withOperationName("GetVariantImportJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(getVariantImportJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetVariantImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a variant store.
     * </p>
     *
     * @param getVariantStoreRequest
     * @return Result of the GetVariantStore operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetVariantStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetVariantStore" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetVariantStoreResponse getVariantStore(GetVariantStoreRequest getVariantStoreRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetVariantStoreResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetVariantStoreResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getVariantStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVariantStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVariantStore");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<GetVariantStoreRequest, GetVariantStoreResponse>()
                    .withOperationName("GetVariantStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(getVariantStoreRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetVariantStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a workflow.
     * </p>
     *
     * @param getWorkflowRequest
     * @return Result of the GetWorkflow operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetWorkflowResponse getWorkflow(GetWorkflowRequest getWorkflowRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetWorkflowResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWorkflowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWorkflow");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<GetWorkflowRequest, GetWorkflowResponse>()
                    .withOperationName("GetWorkflow").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(getWorkflowRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetWorkflowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of annotation import jobs.
     * </p>
     *
     * @param listAnnotationImportJobsRequest
     * @return Result of the ListAnnotationImportJobs operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListAnnotationImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAnnotationImportJobsResponse listAnnotationImportJobs(
            ListAnnotationImportJobsRequest listAnnotationImportJobsRequest) throws InternalServerException, ThrottlingException,
            ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAnnotationImportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAnnotationImportJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAnnotationImportJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAnnotationImportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAnnotationImportJobs");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler
                    .execute(new ClientExecutionParams<ListAnnotationImportJobsRequest, ListAnnotationImportJobsResponse>()
                            .withOperationName("ListAnnotationImportJobs").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(listAnnotationImportJobsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAnnotationImportJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the versions of an annotation store.
     * </p>
     *
     * @param listAnnotationStoreVersionsRequest
     * @return Result of the ListAnnotationStoreVersions operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListAnnotationStoreVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationStoreVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAnnotationStoreVersionsResponse listAnnotationStoreVersions(
            ListAnnotationStoreVersionsRequest listAnnotationStoreVersionsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAnnotationStoreVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAnnotationStoreVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAnnotationStoreVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAnnotationStoreVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAnnotationStoreVersions");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler
                    .execute(new ClientExecutionParams<ListAnnotationStoreVersionsRequest, ListAnnotationStoreVersionsResponse>()
                            .withOperationName("ListAnnotationStoreVersions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(listAnnotationStoreVersionsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAnnotationStoreVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of annotation stores.
     * </p>
     *
     * @param listAnnotationStoresRequest
     * @return Result of the ListAnnotationStores operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListAnnotationStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationStores" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListAnnotationStoresResponse listAnnotationStores(ListAnnotationStoresRequest listAnnotationStoresRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAnnotationStoresResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAnnotationStoresResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAnnotationStoresRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAnnotationStoresRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAnnotationStores");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<ListAnnotationStoresRequest, ListAnnotationStoresResponse>()
                    .withOperationName("ListAnnotationStores").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listAnnotationStoresRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAnnotationStoresRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists multipart read set uploads and for in progress uploads. Once the upload is completed, a read set is created
     * and the upload will no longer be returned in the respone.
     * </p>
     *
     * @param listMultipartReadSetUploadsRequest
     * @return Result of the ListMultipartReadSetUploads operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws NotSupportedOperationException
     *         The operation is not supported by Amazon Omics, or the API does not exist.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListMultipartReadSetUploads
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListMultipartReadSetUploads"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListMultipartReadSetUploadsResponse listMultipartReadSetUploads(
            ListMultipartReadSetUploadsRequest listMultipartReadSetUploadsRequest) throws InternalServerException,
            NotSupportedOperationException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMultipartReadSetUploadsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListMultipartReadSetUploadsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMultipartReadSetUploadsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMultipartReadSetUploadsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMultipartReadSetUploads");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler
                    .execute(new ClientExecutionParams<ListMultipartReadSetUploadsRequest, ListMultipartReadSetUploadsResponse>()
                            .withOperationName("ListMultipartReadSetUploads").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(listMultipartReadSetUploadsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListMultipartReadSetUploadsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of read set activation jobs.
     * </p>
     *
     * @param listReadSetActivationJobsRequest
     * @return Result of the ListReadSetActivationJobs operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListReadSetActivationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetActivationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListReadSetActivationJobsResponse listReadSetActivationJobs(
            ListReadSetActivationJobsRequest listReadSetActivationJobsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException,
            AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListReadSetActivationJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListReadSetActivationJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReadSetActivationJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReadSetActivationJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReadSetActivationJobs");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler
                    .execute(new ClientExecutionParams<ListReadSetActivationJobsRequest, ListReadSetActivationJobsResponse>()
                            .withOperationName("ListReadSetActivationJobs").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(listReadSetActivationJobsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListReadSetActivationJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of read set export jobs.
     * </p>
     *
     * @param listReadSetExportJobsRequest
     * @return Result of the ListReadSetExportJobs operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListReadSetExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListReadSetExportJobsResponse listReadSetExportJobs(ListReadSetExportJobsRequest listReadSetExportJobsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListReadSetExportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListReadSetExportJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReadSetExportJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReadSetExportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReadSetExportJobs");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<ListReadSetExportJobsRequest, ListReadSetExportJobsResponse>()
                    .withOperationName("ListReadSetExportJobs").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listReadSetExportJobsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListReadSetExportJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of read set import jobs.
     * </p>
     *
     * @param listReadSetImportJobsRequest
     * @return Result of the ListReadSetImportJobs operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListReadSetImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListReadSetImportJobsResponse listReadSetImportJobs(ListReadSetImportJobsRequest listReadSetImportJobsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListReadSetImportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListReadSetImportJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReadSetImportJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReadSetImportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReadSetImportJobs");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<ListReadSetImportJobsRequest, ListReadSetImportJobsResponse>()
                    .withOperationName("ListReadSetImportJobs").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listReadSetImportJobsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListReadSetImportJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This operation will list all parts in a requested multipart upload for a sequence store.
     * </p>
     *
     * @param listReadSetUploadPartsRequest
     * @return Result of the ListReadSetUploadParts operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws NotSupportedOperationException
     *         The operation is not supported by Amazon Omics, or the API does not exist.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListReadSetUploadParts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetUploadParts" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListReadSetUploadPartsResponse listReadSetUploadParts(ListReadSetUploadPartsRequest listReadSetUploadPartsRequest)
            throws InternalServerException, NotSupportedOperationException, ServiceQuotaExceededException, ThrottlingException,
            ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException,
            SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListReadSetUploadPartsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListReadSetUploadPartsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReadSetUploadPartsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReadSetUploadPartsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReadSetUploadParts");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler
                    .execute(new ClientExecutionParams<ListReadSetUploadPartsRequest, ListReadSetUploadPartsResponse>()
                            .withOperationName("ListReadSetUploadParts").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(listReadSetUploadPartsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListReadSetUploadPartsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of read sets.
     * </p>
     *
     * @param listReadSetsRequest
     * @return Result of the ListReadSets operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListReadSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListReadSetsResponse listReadSets(ListReadSetsRequest listReadSetsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException,
            AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListReadSetsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListReadSetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReadSetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReadSetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReadSets");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<ListReadSetsRequest, ListReadSetsResponse>()
                    .withOperationName("ListReadSets").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listReadSetsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListReadSetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of reference import jobs.
     * </p>
     *
     * @param listReferenceImportJobsRequest
     * @return Result of the ListReferenceImportJobs operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListReferenceImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferenceImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListReferenceImportJobsResponse listReferenceImportJobs(ListReferenceImportJobsRequest listReferenceImportJobsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListReferenceImportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListReferenceImportJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReferenceImportJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReferenceImportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReferenceImportJobs");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler
                    .execute(new ClientExecutionParams<ListReferenceImportJobsRequest, ListReferenceImportJobsResponse>()
                            .withOperationName("ListReferenceImportJobs").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(listReferenceImportJobsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListReferenceImportJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of reference stores.
     * </p>
     *
     * @param listReferenceStoresRequest
     * @return Result of the ListReferenceStores operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListReferenceStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferenceStores" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListReferenceStoresResponse listReferenceStores(ListReferenceStoresRequest listReferenceStoresRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException,
            RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListReferenceStoresResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListReferenceStoresResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReferenceStoresRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReferenceStoresRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReferenceStores");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<ListReferenceStoresRequest, ListReferenceStoresResponse>()
                    .withOperationName("ListReferenceStores").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listReferenceStoresRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListReferenceStoresRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of references.
     * </p>
     *
     * @param listReferencesRequest
     * @return Result of the ListReferences operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListReferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferences" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListReferencesResponse listReferences(ListReferencesRequest listReferencesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException,
            AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListReferencesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListReferencesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReferencesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReferencesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReferences");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<ListReferencesRequest, ListReferencesResponse>()
                    .withOperationName("ListReferences").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listReferencesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListReferencesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of run groups.
     * </p>
     *
     * @param listRunGroupsRequest
     * @return Result of the ListRunGroups operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListRunGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListRunGroupsResponse listRunGroups(ListRunGroupsRequest listRunGroupsRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRunGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListRunGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRunGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRunGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRunGroups");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<ListRunGroupsRequest, ListRunGroupsResponse>()
                    .withOperationName("ListRunGroups").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listRunGroupsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListRunGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of tasks for a run.
     * </p>
     *
     * @param listRunTasksRequest
     * @return Result of the ListRunTasks operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListRunTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunTasks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListRunTasksResponse listRunTasks(ListRunTasksRequest listRunTasksRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRunTasksResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListRunTasksResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRunTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRunTasksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRunTasks");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<ListRunTasksRequest, ListRunTasksResponse>()
                    .withOperationName("ListRunTasks").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listRunTasksRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListRunTasksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of runs.
     * </p>
     *
     * @param listRunsRequest
     * @return Result of the ListRuns operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRuns" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListRunsResponse listRuns(ListRunsRequest listRunsRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRunsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListRunsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRunsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRunsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRuns");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<ListRunsRequest, ListRunsResponse>()
                    .withOperationName("ListRuns").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(listRunsRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new ListRunsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of sequence stores.
     * </p>
     *
     * @param listSequenceStoresRequest
     * @return Result of the ListSequenceStores operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListSequenceStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListSequenceStores" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListSequenceStoresResponse listSequenceStores(ListSequenceStoresRequest listSequenceStoresRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException,
            RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSequenceStoresResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListSequenceStoresResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSequenceStoresRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSequenceStoresRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSequenceStores");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<ListSequenceStoresRequest, ListSequenceStoresResponse>()
                    .withOperationName("ListSequenceStores").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listSequenceStoresRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListSequenceStoresRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all shares associated with an account.
     * </p>
     *
     * @param listSharesRequest
     * @return Result of the ListShares operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListShares" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListSharesResponse listShares(ListSharesRequest listSharesRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSharesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListSharesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSharesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSharesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListShares");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler
                    .execute(new ClientExecutionParams<ListSharesRequest, ListSharesResponse>().withOperationName("ListShares")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withRequestConfiguration(clientConfiguration).withInput(listSharesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListSharesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException,
            SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            String hostPrefix = "tags-";
            String resolvedHostExpression = "tags-";

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listTagsForResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of variant import jobs.
     * </p>
     *
     * @param listVariantImportJobsRequest
     * @return Result of the ListVariantImportJobs operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListVariantImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListVariantImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListVariantImportJobsResponse listVariantImportJobs(ListVariantImportJobsRequest listVariantImportJobsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListVariantImportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListVariantImportJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listVariantImportJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVariantImportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVariantImportJobs");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<ListVariantImportJobsRequest, ListVariantImportJobsResponse>()
                    .withOperationName("ListVariantImportJobs").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listVariantImportJobsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListVariantImportJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of variant stores.
     * </p>
     *
     * @param listVariantStoresRequest
     * @return Result of the ListVariantStores operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListVariantStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListVariantStores" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListVariantStoresResponse listVariantStores(ListVariantStoresRequest listVariantStoresRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListVariantStoresResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListVariantStoresResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listVariantStoresRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVariantStoresRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVariantStores");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<ListVariantStoresRequest, ListVariantStoresResponse>()
                    .withOperationName("ListVariantStores").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listVariantStoresRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListVariantStoresRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of workflows.
     * </p>
     *
     * @param listWorkflowsRequest
     * @return Result of the ListWorkflows operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListWorkflows" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListWorkflowsResponse listWorkflows(ListWorkflowsRequest listWorkflowsRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListWorkflowsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListWorkflowsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWorkflowsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWorkflowsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorkflows");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<ListWorkflowsRequest, ListWorkflowsResponse>()
                    .withOperationName("ListWorkflows").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listWorkflowsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListWorkflowsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts an annotation import job.
     * </p>
     *
     * @param startAnnotationImportJobRequest
     * @return Result of the StartAnnotationImportJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.StartAnnotationImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartAnnotationImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartAnnotationImportJobResponse startAnnotationImportJob(
            StartAnnotationImportJobRequest startAnnotationImportJobRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartAnnotationImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartAnnotationImportJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startAnnotationImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startAnnotationImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartAnnotationImportJob");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler
                    .execute(new ClientExecutionParams<StartAnnotationImportJobRequest, StartAnnotationImportJobResponse>()
                            .withOperationName("StartAnnotationImportJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(startAnnotationImportJobRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartAnnotationImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Activates an archived read set. To reduce storage charges, Amazon Omics archives unused read sets after 30 days.
     * </p>
     *
     * @param startReadSetActivationJobRequest
     * @return Result of the StartReadSetActivationJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.StartReadSetActivationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReadSetActivationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartReadSetActivationJobResponse startReadSetActivationJob(
            StartReadSetActivationJobRequest startReadSetActivationJobRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartReadSetActivationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartReadSetActivationJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startReadSetActivationJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startReadSetActivationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartReadSetActivationJob");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler
                    .execute(new ClientExecutionParams<StartReadSetActivationJobRequest, StartReadSetActivationJobResponse>()
                            .withOperationName("StartReadSetActivationJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(startReadSetActivationJobRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartReadSetActivationJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Exports a read set to Amazon S3.
     * </p>
     *
     * @param startReadSetExportJobRequest
     * @return Result of the StartReadSetExportJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.StartReadSetExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReadSetExportJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StartReadSetExportJobResponse startReadSetExportJob(StartReadSetExportJobRequest startReadSetExportJobRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartReadSetExportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartReadSetExportJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startReadSetExportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startReadSetExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartReadSetExportJob");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<StartReadSetExportJobRequest, StartReadSetExportJobResponse>()
                    .withOperationName("StartReadSetExportJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(startReadSetExportJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartReadSetExportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a read set import job.
     * </p>
     *
     * @param startReadSetImportJobRequest
     * @return Result of the StartReadSetImportJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.StartReadSetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReadSetImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StartReadSetImportJobResponse startReadSetImportJob(StartReadSetImportJobRequest startReadSetImportJobRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartReadSetImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartReadSetImportJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startReadSetImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startReadSetImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartReadSetImportJob");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<StartReadSetImportJobRequest, StartReadSetImportJobResponse>()
                    .withOperationName("StartReadSetImportJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(startReadSetImportJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartReadSetImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a reference import job.
     * </p>
     *
     * @param startReferenceImportJobRequest
     * @return Result of the StartReferenceImportJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.StartReferenceImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReferenceImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StartReferenceImportJobResponse startReferenceImportJob(StartReferenceImportJobRequest startReferenceImportJobRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartReferenceImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartReferenceImportJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startReferenceImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startReferenceImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartReferenceImportJob");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler
                    .execute(new ClientExecutionParams<StartReferenceImportJobRequest, StartReferenceImportJobResponse>()
                            .withOperationName("StartReferenceImportJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(startReferenceImportJobRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartReferenceImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a workflow run. To duplicate a run, specify the run's ID and a role ARN. The remaining parameters are
     * copied from the previous run.
     * </p>
     * <p>
     * The total number of runs in your account is subject to a quota per Region. To avoid needing to delete runs
     * manually, you can set the retention mode to <code>REMOVE</code>. Runs with this setting are deleted automatically
     * when the run quoata is exceeded.
     * </p>
     *
     * @param startRunRequest
     * @return Result of the StartRun operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.StartRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartRun" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartRunResponse startRun(StartRunRequest startRunRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartRunResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartRunResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startRunRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startRunRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartRun");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<StartRunRequest, StartRunResponse>()
                    .withOperationName("StartRun").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(startRunRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new StartRunRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a variant import job.
     * </p>
     *
     * @param startVariantImportJobRequest
     * @return Result of the StartVariantImportJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.StartVariantImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartVariantImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StartVariantImportJobResponse startVariantImportJob(StartVariantImportJobRequest startVariantImportJobRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartVariantImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartVariantImportJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startVariantImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startVariantImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartVariantImportJob");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<StartVariantImportJobRequest, StartVariantImportJobResponse>()
                    .withOperationName("StartVariantImportJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(startVariantImportJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartVariantImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Tags a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            String hostPrefix = "tags-";
            String resolvedHostExpression = "tags-";

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(tagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            String hostPrefix = "tags-";
            String resolvedHostExpression = "tags-";

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(untagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an annotation store.
     * </p>
     *
     * @param updateAnnotationStoreRequest
     * @return Result of the UpdateAnnotationStore operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.UpdateAnnotationStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateAnnotationStore" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateAnnotationStoreResponse updateAnnotationStore(UpdateAnnotationStoreRequest updateAnnotationStoreRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAnnotationStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateAnnotationStoreResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAnnotationStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAnnotationStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAnnotationStore");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<UpdateAnnotationStoreRequest, UpdateAnnotationStoreResponse>()
                    .withOperationName("UpdateAnnotationStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(updateAnnotationStoreRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAnnotationStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the description of an annotation store version.
     * </p>
     *
     * @param updateAnnotationStoreVersionRequest
     * @return Result of the UpdateAnnotationStoreVersion operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.UpdateAnnotationStoreVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateAnnotationStoreVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateAnnotationStoreVersionResponse updateAnnotationStoreVersion(
            UpdateAnnotationStoreVersionRequest updateAnnotationStoreVersionRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAnnotationStoreVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateAnnotationStoreVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAnnotationStoreVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAnnotationStoreVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAnnotationStoreVersion");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateAnnotationStoreVersionRequest, UpdateAnnotationStoreVersionResponse>()
                            .withOperationName("UpdateAnnotationStoreVersion").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(updateAnnotationStoreVersionRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateAnnotationStoreVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a run group.
     * </p>
     *
     * @param updateRunGroupRequest
     * @return Result of the UpdateRunGroup operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.UpdateRunGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateRunGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateRunGroupResponse updateRunGroup(UpdateRunGroupRequest updateRunGroupRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateRunGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateRunGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRunGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRunGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRunGroup");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<UpdateRunGroupRequest, UpdateRunGroupResponse>()
                    .withOperationName("UpdateRunGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(updateRunGroupRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateRunGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a variant store.
     * </p>
     *
     * @param updateVariantStoreRequest
     * @return Result of the UpdateVariantStore operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.UpdateVariantStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateVariantStore" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateVariantStoreResponse updateVariantStore(UpdateVariantStoreRequest updateVariantStoreRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateVariantStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateVariantStoreResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateVariantStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateVariantStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateVariantStore");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<UpdateVariantStoreRequest, UpdateVariantStoreResponse>()
                    .withOperationName("UpdateVariantStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(updateVariantStoreRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateVariantStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a workflow.
     * </p>
     *
     * @param updateWorkflowRequest
     * @return Result of the UpdateWorkflow operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.UpdateWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateWorkflowResponse updateWorkflow(UpdateWorkflowRequest updateWorkflowRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateWorkflowResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateWorkflowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWorkflow");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<UpdateWorkflowRequest, UpdateWorkflowResponse>()
                    .withOperationName("UpdateWorkflow").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(updateWorkflowRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateWorkflowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This operation uploads a specific part of a read set. If you upload a new part using a previously used part
     * number, the previously uploaded part will be overwritten.
     * </p>
     *
     * @param uploadReadSetPartRequest
     * @param requestBody
     *        The content to send to the service. A {@link RequestBody} can be created using one of several factory
     *        methods for various sources of data. For example, to create a request body from a file you can do the
     *        following.
     * 
     *        <pre>
     * {@code RequestBody.fromFile(new File("myfile.txt"))}
     * </pre>
     * 
     *        See documentation in {@link RequestBody} for additional details and which sources of data are supported.
     *        The service documentation for the request content is as follows '
     *        <p>
     *        The read set data to upload for a part.
     *        </p>
     *        '
     * @return Result of the UploadReadSetPart operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws NotSupportedOperationException
     *         The operation is not supported by Amazon Omics, or the API does not exist.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.UploadReadSetPart
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UploadReadSetPart" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UploadReadSetPartResponse uploadReadSetPart(UploadReadSetPartRequest uploadReadSetPartRequest, RequestBody requestBody)
            throws InternalServerException, NotSupportedOperationException, ServiceQuotaExceededException, ThrottlingException,
            ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException,
            SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UploadReadSetPartResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UploadReadSetPartResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(uploadReadSetPartRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, uploadReadSetPartRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UploadReadSetPart");
            String hostPrefix = "storage-";
            String resolvedHostExpression = "storage-";

            return clientHandler.execute(new ClientExecutionParams<UploadReadSetPartRequest, UploadReadSetPartResponse>()
                    .withOperationName("UploadReadSetPart")
                    .withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration)
                    .withInput(uploadReadSetPartRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withRequestBody(requestBody)
                    .withMarshaller(
                            StreamingRequestMarshaller.builder()
                                    .delegateMarshaller(new UploadReadSetPartRequestMarshaller(protocolFactory))
                                    .requestBody(requestBody).requiresLength(true).transferEncoding(true).build()));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Create an instance of {@link OmicsWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link OmicsWaiter}
     */
    @Override
    public OmicsWaiter waiter() {
        return OmicsWaiter.builder().client(this).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        OmicsServiceClientConfigurationBuilder serviceConfigBuilder = new OmicsServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(OmicsException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException")
                                .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).httpStatusCode(416).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RequestTimeoutException")
                                .exceptionBuilderSupplier(RequestTimeoutException::builder).httpStatusCode(408).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                                .exceptionBuilderSupplier(NotSupportedOperationException::builder).httpStatusCode(405).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build());
    }

    @Override
    public final OmicsServiceClientConfiguration serviceClientConfiguration() {
        return new OmicsServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
