/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMultipartReadSetUploadResponse extends OmicsResponse implements
        ToCopyableBuilder<CreateMultipartReadSetUploadResponse.Builder, CreateMultipartReadSetUploadResponse> {
    private static final SdkField<String> SEQUENCE_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sequenceStoreId").getter(getter(CreateMultipartReadSetUploadResponse::sequenceStoreId))
            .setter(setter(Builder::sequenceStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sequenceStoreId").build()).build();

    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("uploadId").getter(getter(CreateMultipartReadSetUploadResponse::uploadId))
            .setter(setter(Builder::uploadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadId").build()).build();

    private static final SdkField<String> SOURCE_FILE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceFileType").getter(getter(CreateMultipartReadSetUploadResponse::sourceFileTypeAsString))
            .setter(setter(Builder::sourceFileType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFileType").build()).build();

    private static final SdkField<String> SUBJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subjectId").getter(getter(CreateMultipartReadSetUploadResponse::subjectId))
            .setter(setter(Builder::subjectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subjectId").build()).build();

    private static final SdkField<String> SAMPLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sampleId").getter(getter(CreateMultipartReadSetUploadResponse::sampleId))
            .setter(setter(Builder::sampleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleId").build()).build();

    private static final SdkField<String> GENERATED_FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("generatedFrom").getter(getter(CreateMultipartReadSetUploadResponse::generatedFrom))
            .setter(setter(Builder::generatedFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedFrom").build()).build();

    private static final SdkField<String> REFERENCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("referenceArn").getter(getter(CreateMultipartReadSetUploadResponse::referenceArn))
            .setter(setter(Builder::referenceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateMultipartReadSetUploadResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateMultipartReadSetUploadResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateMultipartReadSetUploadResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(CreateMultipartReadSetUploadResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEQUENCE_STORE_ID_FIELD,
            UPLOAD_ID_FIELD, SOURCE_FILE_TYPE_FIELD, SUBJECT_ID_FIELD, SAMPLE_ID_FIELD, GENERATED_FROM_FIELD,
            REFERENCE_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, CREATION_TIME_FIELD));

    private final String sequenceStoreId;

    private final String uploadId;

    private final String sourceFileType;

    private final String subjectId;

    private final String sampleId;

    private final String generatedFrom;

    private final String referenceArn;

    private final String name;

    private final String description;

    private final Map<String, String> tags;

    private final Instant creationTime;

    private CreateMultipartReadSetUploadResponse(BuilderImpl builder) {
        super(builder);
        this.sequenceStoreId = builder.sequenceStoreId;
        this.uploadId = builder.uploadId;
        this.sourceFileType = builder.sourceFileType;
        this.subjectId = builder.subjectId;
        this.sampleId = builder.sampleId;
        this.generatedFrom = builder.generatedFrom;
        this.referenceArn = builder.referenceArn;
        this.name = builder.name;
        this.description = builder.description;
        this.tags = builder.tags;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The sequence store ID for the store that the read set will be created in.
     * </p>
     * 
     * @return The sequence store ID for the store that the read set will be created in.
     */
    public final String sequenceStoreId() {
        return sequenceStoreId;
    }

    /**
     * <p>
     * The ID for the initiated multipart upload.
     * </p>
     * 
     * @return The ID for the initiated multipart upload.
     */
    public final String uploadId() {
        return uploadId;
    }

    /**
     * <p>
     * The file type of the read set source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceFileType}
     * will return {@link FileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceFileTypeAsString}.
     * </p>
     * 
     * @return The file type of the read set source.
     * @see FileType
     */
    public final FileType sourceFileType() {
        return FileType.fromValue(sourceFileType);
    }

    /**
     * <p>
     * The file type of the read set source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceFileType}
     * will return {@link FileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceFileTypeAsString}.
     * </p>
     * 
     * @return The file type of the read set source.
     * @see FileType
     */
    public final String sourceFileTypeAsString() {
        return sourceFileType;
    }

    /**
     * <p>
     * The source's subject ID.
     * </p>
     * 
     * @return The source's subject ID.
     */
    public final String subjectId() {
        return subjectId;
    }

    /**
     * <p>
     * The source's sample ID.
     * </p>
     * 
     * @return The source's sample ID.
     */
    public final String sampleId() {
        return sampleId;
    }

    /**
     * <p>
     * The source of the read set.
     * </p>
     * 
     * @return The source of the read set.
     */
    public final String generatedFrom() {
        return generatedFrom;
    }

    /**
     * <p>
     * The read set source's reference ARN.
     * </p>
     * 
     * @return The read set source's reference ARN.
     */
    public final String referenceArn() {
        return referenceArn;
    }

    /**
     * <p>
     * The name of the read set.
     * </p>
     * 
     * @return The name of the read set.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the read set.
     * </p>
     * 
     * @return The description of the read set.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to add to the read set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to add to the read set.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The creation time of the multipart upload.
     * </p>
     * 
     * @return The creation time of the multipart upload.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sequenceStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceFileTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subjectId());
        hashCode = 31 * hashCode + Objects.hashCode(sampleId());
        hashCode = 31 * hashCode + Objects.hashCode(generatedFrom());
        hashCode = 31 * hashCode + Objects.hashCode(referenceArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMultipartReadSetUploadResponse)) {
            return false;
        }
        CreateMultipartReadSetUploadResponse other = (CreateMultipartReadSetUploadResponse) obj;
        return Objects.equals(sequenceStoreId(), other.sequenceStoreId()) && Objects.equals(uploadId(), other.uploadId())
                && Objects.equals(sourceFileTypeAsString(), other.sourceFileTypeAsString())
                && Objects.equals(subjectId(), other.subjectId()) && Objects.equals(sampleId(), other.sampleId())
                && Objects.equals(generatedFrom(), other.generatedFrom()) && Objects.equals(referenceArn(), other.referenceArn())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMultipartReadSetUploadResponse").add("SequenceStoreId", sequenceStoreId())
                .add("UploadId", uploadId()).add("SourceFileType", sourceFileTypeAsString()).add("SubjectId", subjectId())
                .add("SampleId", sampleId()).add("GeneratedFrom", generatedFrom()).add("ReferenceArn", referenceArn())
                .add("Name", name()).add("Description", description()).add("Tags", hasTags() ? tags() : null)
                .add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sequenceStoreId":
            return Optional.ofNullable(clazz.cast(sequenceStoreId()));
        case "uploadId":
            return Optional.ofNullable(clazz.cast(uploadId()));
        case "sourceFileType":
            return Optional.ofNullable(clazz.cast(sourceFileTypeAsString()));
        case "subjectId":
            return Optional.ofNullable(clazz.cast(subjectId()));
        case "sampleId":
            return Optional.ofNullable(clazz.cast(sampleId()));
        case "generatedFrom":
            return Optional.ofNullable(clazz.cast(generatedFrom()));
        case "referenceArn":
            return Optional.ofNullable(clazz.cast(referenceArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMultipartReadSetUploadResponse, T> g) {
        return obj -> g.apply((CreateMultipartReadSetUploadResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMultipartReadSetUploadResponse> {
        /**
         * <p>
         * The sequence store ID for the store that the read set will be created in.
         * </p>
         * 
         * @param sequenceStoreId
         *        The sequence store ID for the store that the read set will be created in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceStoreId(String sequenceStoreId);

        /**
         * <p>
         * The ID for the initiated multipart upload.
         * </p>
         * 
         * @param uploadId
         *        The ID for the initiated multipart upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadId(String uploadId);

        /**
         * <p>
         * The file type of the read set source.
         * </p>
         * 
         * @param sourceFileType
         *        The file type of the read set source.
         * @see FileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileType
         */
        Builder sourceFileType(String sourceFileType);

        /**
         * <p>
         * The file type of the read set source.
         * </p>
         * 
         * @param sourceFileType
         *        The file type of the read set source.
         * @see FileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileType
         */
        Builder sourceFileType(FileType sourceFileType);

        /**
         * <p>
         * The source's subject ID.
         * </p>
         * 
         * @param subjectId
         *        The source's subject ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectId(String subjectId);

        /**
         * <p>
         * The source's sample ID.
         * </p>
         * 
         * @param sampleId
         *        The source's sample ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleId(String sampleId);

        /**
         * <p>
         * The source of the read set.
         * </p>
         * 
         * @param generatedFrom
         *        The source of the read set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedFrom(String generatedFrom);

        /**
         * <p>
         * The read set source's reference ARN.
         * </p>
         * 
         * @param referenceArn
         *        The read set source's reference ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceArn(String referenceArn);

        /**
         * <p>
         * The name of the read set.
         * </p>
         * 
         * @param name
         *        The name of the read set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the read set.
         * </p>
         * 
         * @param description
         *        The description of the read set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The tags to add to the read set.
         * </p>
         * 
         * @param tags
         *        The tags to add to the read set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The creation time of the multipart upload.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the multipart upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl extends OmicsResponse.BuilderImpl implements Builder {
        private String sequenceStoreId;

        private String uploadId;

        private String sourceFileType;

        private String subjectId;

        private String sampleId;

        private String generatedFrom;

        private String referenceArn;

        private String name;

        private String description;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMultipartReadSetUploadResponse model) {
            super(model);
            sequenceStoreId(model.sequenceStoreId);
            uploadId(model.uploadId);
            sourceFileType(model.sourceFileType);
            subjectId(model.subjectId);
            sampleId(model.sampleId);
            generatedFrom(model.generatedFrom);
            referenceArn(model.referenceArn);
            name(model.name);
            description(model.description);
            tags(model.tags);
            creationTime(model.creationTime);
        }

        public final String getSequenceStoreId() {
            return sequenceStoreId;
        }

        public final void setSequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
        }

        @Override
        public final Builder sequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
            return this;
        }

        public final String getUploadId() {
            return uploadId;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final String getSourceFileType() {
            return sourceFileType;
        }

        public final void setSourceFileType(String sourceFileType) {
            this.sourceFileType = sourceFileType;
        }

        @Override
        public final Builder sourceFileType(String sourceFileType) {
            this.sourceFileType = sourceFileType;
            return this;
        }

        @Override
        public final Builder sourceFileType(FileType sourceFileType) {
            this.sourceFileType(sourceFileType == null ? null : sourceFileType.toString());
            return this;
        }

        public final String getSubjectId() {
            return subjectId;
        }

        public final void setSubjectId(String subjectId) {
            this.subjectId = subjectId;
        }

        @Override
        public final Builder subjectId(String subjectId) {
            this.subjectId = subjectId;
            return this;
        }

        public final String getSampleId() {
            return sampleId;
        }

        public final void setSampleId(String sampleId) {
            this.sampleId = sampleId;
        }

        @Override
        public final Builder sampleId(String sampleId) {
            this.sampleId = sampleId;
            return this;
        }

        public final String getGeneratedFrom() {
            return generatedFrom;
        }

        public final void setGeneratedFrom(String generatedFrom) {
            this.generatedFrom = generatedFrom;
        }

        @Override
        public final Builder generatedFrom(String generatedFrom) {
            this.generatedFrom = generatedFrom;
            return this;
        }

        public final String getReferenceArn() {
            return referenceArn;
        }

        public final void setReferenceArn(String referenceArn) {
            this.referenceArn = referenceArn;
        }

        @Override
        public final Builder referenceArn(String referenceArn) {
            this.referenceArn = referenceArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public CreateMultipartReadSetUploadResponse build() {
            return new CreateMultipartReadSetUploadResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
