/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRunResponse extends OmicsResponse implements ToCopyableBuilder<GetRunResponse.Builder, GetRunResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetRunResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetRunResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetRunResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowId").getter(getter(GetRunResponse::workflowId)).setter(setter(Builder::workflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowId").build()).build();

    private static final SdkField<String> WORKFLOW_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowType").getter(getter(GetRunResponse::workflowTypeAsString))
            .setter(setter(Builder::workflowType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowType").build()).build();

    private static final SdkField<String> RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("runId")
            .getter(getter(GetRunResponse::runId)).setter(setter(Builder::runId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runId").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(GetRunResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetRunResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> RUN_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("runGroupId").getter(getter(GetRunResponse::runGroupId)).setter(setter(Builder::runGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runGroupId").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("priority").getter(getter(GetRunResponse::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final SdkField<String> DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("definition").getter(getter(GetRunResponse::definition)).setter(setter(Builder::definition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final SdkField<String> DIGEST_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("digest")
            .getter(getter(GetRunResponse::digest)).setter(setter(Builder::digest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("digest").build()).build();

    private static final SdkField<Document> PARAMETERS_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("parameters").getter(getter(GetRunResponse::parameters)).setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build()).build();

    private static final SdkField<Integer> STORAGE_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("storageCapacity").getter(getter(GetRunResponse::storageCapacity))
            .setter(setter(Builder::storageCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageCapacity").build()).build();

    private static final SdkField<String> OUTPUT_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputUri").getter(getter(GetRunResponse::outputUri)).setter(setter(Builder::outputUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputUri").build()).build();

    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logLevel").getter(getter(GetRunResponse::logLevelAsString)).setter(setter(Builder::logLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logLevel").build()).build();

    private static final SdkField<Map<String, String>> RESOURCE_DIGESTS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("resourceDigests")
            .getter(getter(GetRunResponse::resourceDigests))
            .setter(setter(Builder::resourceDigests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceDigests").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> STARTED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startedBy").getter(getter(GetRunResponse::startedBy)).setter(setter(Builder::startedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedBy").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(GetRunResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime")
            .getter(getter(GetRunResponse::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> STOP_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("stopTime")
            .getter(getter(GetRunResponse::stopTime))
            .setter(setter(Builder::stopTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(GetRunResponse::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetRunResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ACCELERATORS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accelerators").getter(getter(GetRunResponse::acceleratorsAsString))
            .setter(setter(Builder::accelerators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accelerators").build()).build();

    private static final SdkField<String> RETENTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("retentionMode").getter(getter(GetRunResponse::retentionModeAsString))
            .setter(setter(Builder::retentionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionMode").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(GetRunResponse::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<RunLogLocation> LOG_LOCATION_FIELD = SdkField
            .<RunLogLocation> builder(MarshallingType.SDK_POJO).memberName("logLocation")
            .getter(getter(GetRunResponse::logLocation)).setter(setter(Builder::logLocation))
            .constructor(RunLogLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logLocation").build()).build();

    private static final SdkField<String> UUID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("uuid")
            .getter(getter(GetRunResponse::uuid)).setter(setter(Builder::uuid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uuid").build()).build();

    private static final SdkField<String> RUN_OUTPUT_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("runOutputUri").getter(getter(GetRunResponse::runOutputUri)).setter(setter(Builder::runOutputUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runOutputUri").build()).build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storageType").getter(getter(GetRunResponse::storageTypeAsString)).setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageType").build()).build();

    private static final SdkField<String> WORKFLOW_OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowOwnerId").getter(getter(GetRunResponse::workflowOwnerId))
            .setter(setter(Builder::workflowOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowOwnerId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            STATUS_FIELD, WORKFLOW_ID_FIELD, WORKFLOW_TYPE_FIELD, RUN_ID_FIELD, ROLE_ARN_FIELD, NAME_FIELD, RUN_GROUP_ID_FIELD,
            PRIORITY_FIELD, DEFINITION_FIELD, DIGEST_FIELD, PARAMETERS_FIELD, STORAGE_CAPACITY_FIELD, OUTPUT_URI_FIELD,
            LOG_LEVEL_FIELD, RESOURCE_DIGESTS_FIELD, STARTED_BY_FIELD, CREATION_TIME_FIELD, START_TIME_FIELD, STOP_TIME_FIELD,
            STATUS_MESSAGE_FIELD, TAGS_FIELD, ACCELERATORS_FIELD, RETENTION_MODE_FIELD, FAILURE_REASON_FIELD, LOG_LOCATION_FIELD,
            UUID_FIELD, RUN_OUTPUT_URI_FIELD, STORAGE_TYPE_FIELD, WORKFLOW_OWNER_ID_FIELD));

    private final String arn;

    private final String id;

    private final String status;

    private final String workflowId;

    private final String workflowType;

    private final String runId;

    private final String roleArn;

    private final String name;

    private final String runGroupId;

    private final Integer priority;

    private final String definition;

    private final String digest;

    private final Document parameters;

    private final Integer storageCapacity;

    private final String outputUri;

    private final String logLevel;

    private final Map<String, String> resourceDigests;

    private final String startedBy;

    private final Instant creationTime;

    private final Instant startTime;

    private final Instant stopTime;

    private final String statusMessage;

    private final Map<String, String> tags;

    private final String accelerators;

    private final String retentionMode;

    private final String failureReason;

    private final RunLogLocation logLocation;

    private final String uuid;

    private final String runOutputUri;

    private final String storageType;

    private final String workflowOwnerId;

    private GetRunResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.status = builder.status;
        this.workflowId = builder.workflowId;
        this.workflowType = builder.workflowType;
        this.runId = builder.runId;
        this.roleArn = builder.roleArn;
        this.name = builder.name;
        this.runGroupId = builder.runGroupId;
        this.priority = builder.priority;
        this.definition = builder.definition;
        this.digest = builder.digest;
        this.parameters = builder.parameters;
        this.storageCapacity = builder.storageCapacity;
        this.outputUri = builder.outputUri;
        this.logLevel = builder.logLevel;
        this.resourceDigests = builder.resourceDigests;
        this.startedBy = builder.startedBy;
        this.creationTime = builder.creationTime;
        this.startTime = builder.startTime;
        this.stopTime = builder.stopTime;
        this.statusMessage = builder.statusMessage;
        this.tags = builder.tags;
        this.accelerators = builder.accelerators;
        this.retentionMode = builder.retentionMode;
        this.failureReason = builder.failureReason;
        this.logLocation = builder.logLocation;
        this.uuid = builder.uuid;
        this.runOutputUri = builder.runOutputUri;
        this.storageType = builder.storageType;
        this.workflowOwnerId = builder.workflowOwnerId;
    }

    /**
     * <p>
     * The run's ARN.
     * </p>
     * 
     * @return The run's ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The run's ID.
     * </p>
     * 
     * @return The run's ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The run's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The run's status.
     * @see RunStatus
     */
    public final RunStatus status() {
        return RunStatus.fromValue(status);
    }

    /**
     * <p>
     * The run's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The run's status.
     * @see RunStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The run's workflow ID.
     * </p>
     * 
     * @return The run's workflow ID.
     */
    public final String workflowId() {
        return workflowId;
    }

    /**
     * <p>
     * The run's workflow type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workflowType} will
     * return {@link WorkflowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workflowTypeAsString}.
     * </p>
     * 
     * @return The run's workflow type.
     * @see WorkflowType
     */
    public final WorkflowType workflowType() {
        return WorkflowType.fromValue(workflowType);
    }

    /**
     * <p>
     * The run's workflow type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workflowType} will
     * return {@link WorkflowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workflowTypeAsString}.
     * </p>
     * 
     * @return The run's workflow type.
     * @see WorkflowType
     */
    public final String workflowTypeAsString() {
        return workflowType;
    }

    /**
     * <p>
     * The run's ID.
     * </p>
     * 
     * @return The run's ID.
     */
    public final String runId() {
        return runId;
    }

    /**
     * <p>
     * The run's service role ARN.
     * </p>
     * 
     * @return The run's service role ARN.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The run's name.
     * </p>
     * 
     * @return The run's name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The run's group ID.
     * </p>
     * 
     * @return The run's group ID.
     */
    public final String runGroupId() {
        return runGroupId;
    }

    /**
     * <p>
     * The run's priority.
     * </p>
     * 
     * @return The run's priority.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The run's definition.
     * </p>
     * 
     * @return The run's definition.
     */
    public final String definition() {
        return definition;
    }

    /**
     * <p>
     * The run's digest.
     * </p>
     * 
     * @return The run's digest.
     */
    public final String digest() {
        return digest;
    }

    /**
     * <p>
     * The run's parameters.
     * </p>
     * 
     * @return The run's parameters.
     */
    public final Document parameters() {
        return parameters;
    }

    /**
     * <p>
     * The run's storage capacity in gibibytes. For dynamic storage, after the run has completed, this value is the
     * maximum amount of storage used during the run.
     * </p>
     * 
     * @return The run's storage capacity in gibibytes. For dynamic storage, after the run has completed, this value is
     *         the maximum amount of storage used during the run.
     */
    public final Integer storageCapacity() {
        return storageCapacity;
    }

    /**
     * <p>
     * The run's output URI.
     * </p>
     * 
     * @return The run's output URI.
     */
    public final String outputUri() {
        return outputUri;
    }

    /**
     * <p>
     * The run's log level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link RunLogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return The run's log level.
     * @see RunLogLevel
     */
    public final RunLogLevel logLevel() {
        return RunLogLevel.fromValue(logLevel);
    }

    /**
     * <p>
     * The run's log level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link RunLogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return The run's log level.
     * @see RunLogLevel
     */
    public final String logLevelAsString() {
        return logLevel;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceDigests property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceDigests() {
        return resourceDigests != null && !(resourceDigests instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The run's resource digests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceDigests} method.
     * </p>
     * 
     * @return The run's resource digests.
     */
    public final Map<String, String> resourceDigests() {
        return resourceDigests;
    }

    /**
     * <p>
     * Who started the run.
     * </p>
     * 
     * @return Who started the run.
     */
    public final String startedBy() {
        return startedBy;
    }

    /**
     * <p>
     * When the run was created.
     * </p>
     * 
     * @return When the run was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * When the run started.
     * </p>
     * 
     * @return When the run started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The run's stop time.
     * </p>
     * 
     * @return The run's stop time.
     */
    public final Instant stopTime() {
        return stopTime;
    }

    /**
     * <p>
     * The run's status message.
     * </p>
     * 
     * @return The run's status message.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The run's tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The run's tags.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The computational accelerator used to run the workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accelerators} will
     * return {@link Accelerators#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #acceleratorsAsString}.
     * </p>
     * 
     * @return The computational accelerator used to run the workflow.
     * @see Accelerators
     */
    public final Accelerators accelerators() {
        return Accelerators.fromValue(accelerators);
    }

    /**
     * <p>
     * The computational accelerator used to run the workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accelerators} will
     * return {@link Accelerators#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #acceleratorsAsString}.
     * </p>
     * 
     * @return The computational accelerator used to run the workflow.
     * @see Accelerators
     */
    public final String acceleratorsAsString() {
        return accelerators;
    }

    /**
     * <p>
     * The run's retention mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #retentionMode}
     * will return {@link RunRetentionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #retentionModeAsString}.
     * </p>
     * 
     * @return The run's retention mode.
     * @see RunRetentionMode
     */
    public final RunRetentionMode retentionMode() {
        return RunRetentionMode.fromValue(retentionMode);
    }

    /**
     * <p>
     * The run's retention mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #retentionMode}
     * will return {@link RunRetentionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #retentionModeAsString}.
     * </p>
     * 
     * @return The run's retention mode.
     * @see RunRetentionMode
     */
    public final String retentionModeAsString() {
        return retentionMode;
    }

    /**
     * <p>
     * The reason a run has failed.
     * </p>
     * 
     * @return The reason a run has failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The location of the run log.
     * </p>
     * 
     * @return The location of the run log.
     */
    public final RunLogLocation logLocation() {
        return logLocation;
    }

    /**
     * <p>
     * The universally unique identifier for a run.
     * </p>
     * 
     * @return The universally unique identifier for a run.
     */
    public final String uuid() {
        return uuid;
    }

    /**
     * <p>
     * The destination for workflow outputs.
     * </p>
     * 
     * @return The destination for workflow outputs.
     */
    public final String runOutputUri() {
        return runOutputUri;
    }

    /**
     * <p>
     * The run's storage type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link StorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return The run's storage type.
     * @see StorageType
     */
    public final StorageType storageType() {
        return StorageType.fromValue(storageType);
    }

    /**
     * <p>
     * The run's storage type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link StorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return The run's storage type.
     * @see StorageType
     */
    public final String storageTypeAsString() {
        return storageType;
    }

    /**
     * <p>
     * The ID of the workflow owner.
     * </p>
     * 
     * @return The ID of the workflow owner.
     */
    public final String workflowOwnerId() {
        return workflowOwnerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(workflowTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(runId());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(runGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(digest());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(storageCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(outputUri());
        hashCode = 31 * hashCode + Objects.hashCode(logLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceDigests() ? resourceDigests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startedBy());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(stopTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(acceleratorsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(retentionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(logLocation());
        hashCode = 31 * hashCode + Objects.hashCode(uuid());
        hashCode = 31 * hashCode + Objects.hashCode(runOutputUri());
        hashCode = 31 * hashCode + Objects.hashCode(storageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(workflowOwnerId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRunResponse)) {
            return false;
        }
        GetRunResponse other = (GetRunResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(workflowId(), other.workflowId())
                && Objects.equals(workflowTypeAsString(), other.workflowTypeAsString()) && Objects.equals(runId(), other.runId())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(name(), other.name())
                && Objects.equals(runGroupId(), other.runGroupId()) && Objects.equals(priority(), other.priority())
                && Objects.equals(definition(), other.definition()) && Objects.equals(digest(), other.digest())
                && Objects.equals(parameters(), other.parameters()) && Objects.equals(storageCapacity(), other.storageCapacity())
                && Objects.equals(outputUri(), other.outputUri()) && Objects.equals(logLevelAsString(), other.logLevelAsString())
                && hasResourceDigests() == other.hasResourceDigests()
                && Objects.equals(resourceDigests(), other.resourceDigests()) && Objects.equals(startedBy(), other.startedBy())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(stopTime(), other.stopTime()) && Objects.equals(statusMessage(), other.statusMessage())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(acceleratorsAsString(), other.acceleratorsAsString())
                && Objects.equals(retentionModeAsString(), other.retentionModeAsString())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(logLocation(), other.logLocation())
                && Objects.equals(uuid(), other.uuid()) && Objects.equals(runOutputUri(), other.runOutputUri())
                && Objects.equals(storageTypeAsString(), other.storageTypeAsString())
                && Objects.equals(workflowOwnerId(), other.workflowOwnerId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRunResponse").add("Arn", arn()).add("Id", id()).add("Status", statusAsString())
                .add("WorkflowId", workflowId()).add("WorkflowType", workflowTypeAsString()).add("RunId", runId())
                .add("RoleArn", roleArn()).add("Name", name()).add("RunGroupId", runGroupId()).add("Priority", priority())
                .add("Definition", definition()).add("Digest", digest()).add("Parameters", parameters())
                .add("StorageCapacity", storageCapacity()).add("OutputUri", outputUri()).add("LogLevel", logLevelAsString())
                .add("ResourceDigests", hasResourceDigests() ? resourceDigests() : null).add("StartedBy", startedBy())
                .add("CreationTime", creationTime()).add("StartTime", startTime()).add("StopTime", stopTime())
                .add("StatusMessage", statusMessage()).add("Tags", hasTags() ? tags() : null)
                .add("Accelerators", acceleratorsAsString()).add("RetentionMode", retentionModeAsString())
                .add("FailureReason", failureReason()).add("LogLocation", logLocation()).add("Uuid", uuid())
                .add("RunOutputUri", runOutputUri()).add("StorageType", storageTypeAsString())
                .add("WorkflowOwnerId", workflowOwnerId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "workflowId":
            return Optional.ofNullable(clazz.cast(workflowId()));
        case "workflowType":
            return Optional.ofNullable(clazz.cast(workflowTypeAsString()));
        case "runId":
            return Optional.ofNullable(clazz.cast(runId()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "runGroupId":
            return Optional.ofNullable(clazz.cast(runGroupId()));
        case "priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "digest":
            return Optional.ofNullable(clazz.cast(digest()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "storageCapacity":
            return Optional.ofNullable(clazz.cast(storageCapacity()));
        case "outputUri":
            return Optional.ofNullable(clazz.cast(outputUri()));
        case "logLevel":
            return Optional.ofNullable(clazz.cast(logLevelAsString()));
        case "resourceDigests":
            return Optional.ofNullable(clazz.cast(resourceDigests()));
        case "startedBy":
            return Optional.ofNullable(clazz.cast(startedBy()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "stopTime":
            return Optional.ofNullable(clazz.cast(stopTime()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "accelerators":
            return Optional.ofNullable(clazz.cast(acceleratorsAsString()));
        case "retentionMode":
            return Optional.ofNullable(clazz.cast(retentionModeAsString()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "logLocation":
            return Optional.ofNullable(clazz.cast(logLocation()));
        case "uuid":
            return Optional.ofNullable(clazz.cast(uuid()));
        case "runOutputUri":
            return Optional.ofNullable(clazz.cast(runOutputUri()));
        case "storageType":
            return Optional.ofNullable(clazz.cast(storageTypeAsString()));
        case "workflowOwnerId":
            return Optional.ofNullable(clazz.cast(workflowOwnerId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRunResponse, T> g) {
        return obj -> g.apply((GetRunResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRunResponse> {
        /**
         * <p>
         * The run's ARN.
         * </p>
         * 
         * @param arn
         *        The run's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The run's ID.
         * </p>
         * 
         * @param id
         *        The run's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The run's status.
         * </p>
         * 
         * @param status
         *        The run's status.
         * @see RunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The run's status.
         * </p>
         * 
         * @param status
         *        The run's status.
         * @see RunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunStatus
         */
        Builder status(RunStatus status);

        /**
         * <p>
         * The run's workflow ID.
         * </p>
         * 
         * @param workflowId
         *        The run's workflow ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);

        /**
         * <p>
         * The run's workflow type.
         * </p>
         * 
         * @param workflowType
         *        The run's workflow type.
         * @see WorkflowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowType
         */
        Builder workflowType(String workflowType);

        /**
         * <p>
         * The run's workflow type.
         * </p>
         * 
         * @param workflowType
         *        The run's workflow type.
         * @see WorkflowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowType
         */
        Builder workflowType(WorkflowType workflowType);

        /**
         * <p>
         * The run's ID.
         * </p>
         * 
         * @param runId
         *        The run's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);

        /**
         * <p>
         * The run's service role ARN.
         * </p>
         * 
         * @param roleArn
         *        The run's service role ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The run's name.
         * </p>
         * 
         * @param name
         *        The run's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The run's group ID.
         * </p>
         * 
         * @param runGroupId
         *        The run's group ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runGroupId(String runGroupId);

        /**
         * <p>
         * The run's priority.
         * </p>
         * 
         * @param priority
         *        The run's priority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The run's definition.
         * </p>
         * 
         * @param definition
         *        The run's definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(String definition);

        /**
         * <p>
         * The run's digest.
         * </p>
         * 
         * @param digest
         *        The run's digest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder digest(String digest);

        /**
         * <p>
         * The run's parameters.
         * </p>
         * 
         * @param parameters
         *        The run's parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Document parameters);

        /**
         * <p>
         * The run's storage capacity in gibibytes. For dynamic storage, after the run has completed, this value is the
         * maximum amount of storage used during the run.
         * </p>
         * 
         * @param storageCapacity
         *        The run's storage capacity in gibibytes. For dynamic storage, after the run has completed, this value
         *        is the maximum amount of storage used during the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageCapacity(Integer storageCapacity);

        /**
         * <p>
         * The run's output URI.
         * </p>
         * 
         * @param outputUri
         *        The run's output URI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputUri(String outputUri);

        /**
         * <p>
         * The run's log level.
         * </p>
         * 
         * @param logLevel
         *        The run's log level.
         * @see RunLogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunLogLevel
         */
        Builder logLevel(String logLevel);

        /**
         * <p>
         * The run's log level.
         * </p>
         * 
         * @param logLevel
         *        The run's log level.
         * @see RunLogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunLogLevel
         */
        Builder logLevel(RunLogLevel logLevel);

        /**
         * <p>
         * The run's resource digests.
         * </p>
         * 
         * @param resourceDigests
         *        The run's resource digests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceDigests(Map<String, String> resourceDigests);

        /**
         * <p>
         * Who started the run.
         * </p>
         * 
         * @param startedBy
         *        Who started the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedBy(String startedBy);

        /**
         * <p>
         * When the run was created.
         * </p>
         * 
         * @param creationTime
         *        When the run was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * When the run started.
         * </p>
         * 
         * @param startTime
         *        When the run started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The run's stop time.
         * </p>
         * 
         * @param stopTime
         *        The run's stop time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopTime(Instant stopTime);

        /**
         * <p>
         * The run's status message.
         * </p>
         * 
         * @param statusMessage
         *        The run's status message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The run's tags.
         * </p>
         * 
         * @param tags
         *        The run's tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The computational accelerator used to run the workflow.
         * </p>
         * 
         * @param accelerators
         *        The computational accelerator used to run the workflow.
         * @see Accelerators
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Accelerators
         */
        Builder accelerators(String accelerators);

        /**
         * <p>
         * The computational accelerator used to run the workflow.
         * </p>
         * 
         * @param accelerators
         *        The computational accelerator used to run the workflow.
         * @see Accelerators
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Accelerators
         */
        Builder accelerators(Accelerators accelerators);

        /**
         * <p>
         * The run's retention mode.
         * </p>
         * 
         * @param retentionMode
         *        The run's retention mode.
         * @see RunRetentionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunRetentionMode
         */
        Builder retentionMode(String retentionMode);

        /**
         * <p>
         * The run's retention mode.
         * </p>
         * 
         * @param retentionMode
         *        The run's retention mode.
         * @see RunRetentionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunRetentionMode
         */
        Builder retentionMode(RunRetentionMode retentionMode);

        /**
         * <p>
         * The reason a run has failed.
         * </p>
         * 
         * @param failureReason
         *        The reason a run has failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The location of the run log.
         * </p>
         * 
         * @param logLocation
         *        The location of the run log.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logLocation(RunLogLocation logLocation);

        /**
         * <p>
         * The location of the run log.
         * </p>
         * This is a convenience method that creates an instance of the {@link RunLogLocation.Builder} avoiding the need
         * to create one manually via {@link RunLogLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RunLogLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #logLocation(RunLogLocation)}.
         * 
         * @param logLocation
         *        a consumer that will call methods on {@link RunLogLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logLocation(RunLogLocation)
         */
        default Builder logLocation(Consumer<RunLogLocation.Builder> logLocation) {
            return logLocation(RunLogLocation.builder().applyMutation(logLocation).build());
        }

        /**
         * <p>
         * The universally unique identifier for a run.
         * </p>
         * 
         * @param uuid
         *        The universally unique identifier for a run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uuid(String uuid);

        /**
         * <p>
         * The destination for workflow outputs.
         * </p>
         * 
         * @param runOutputUri
         *        The destination for workflow outputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runOutputUri(String runOutputUri);

        /**
         * <p>
         * The run's storage type.
         * </p>
         * 
         * @param storageType
         *        The run's storage type.
         * @see StorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageType
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * The run's storage type.
         * </p>
         * 
         * @param storageType
         *        The run's storage type.
         * @see StorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageType
         */
        Builder storageType(StorageType storageType);

        /**
         * <p>
         * The ID of the workflow owner.
         * </p>
         * 
         * @param workflowOwnerId
         *        The ID of the workflow owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowOwnerId(String workflowOwnerId);
    }

    static final class BuilderImpl extends OmicsResponse.BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String status;

        private String workflowId;

        private String workflowType;

        private String runId;

        private String roleArn;

        private String name;

        private String runGroupId;

        private Integer priority;

        private String definition;

        private String digest;

        private Document parameters;

        private Integer storageCapacity;

        private String outputUri;

        private String logLevel;

        private Map<String, String> resourceDigests = DefaultSdkAutoConstructMap.getInstance();

        private String startedBy;

        private Instant creationTime;

        private Instant startTime;

        private Instant stopTime;

        private String statusMessage;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String accelerators;

        private String retentionMode;

        private String failureReason;

        private RunLogLocation logLocation;

        private String uuid;

        private String runOutputUri;

        private String storageType;

        private String workflowOwnerId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRunResponse model) {
            super(model);
            arn(model.arn);
            id(model.id);
            status(model.status);
            workflowId(model.workflowId);
            workflowType(model.workflowType);
            runId(model.runId);
            roleArn(model.roleArn);
            name(model.name);
            runGroupId(model.runGroupId);
            priority(model.priority);
            definition(model.definition);
            digest(model.digest);
            parameters(model.parameters);
            storageCapacity(model.storageCapacity);
            outputUri(model.outputUri);
            logLevel(model.logLevel);
            resourceDigests(model.resourceDigests);
            startedBy(model.startedBy);
            creationTime(model.creationTime);
            startTime(model.startTime);
            stopTime(model.stopTime);
            statusMessage(model.statusMessage);
            tags(model.tags);
            accelerators(model.accelerators);
            retentionMode(model.retentionMode);
            failureReason(model.failureReason);
            logLocation(model.logLocation);
            uuid(model.uuid);
            runOutputUri(model.runOutputUri);
            storageType(model.storageType);
            workflowOwnerId(model.workflowOwnerId);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getWorkflowType() {
            return workflowType;
        }

        public final void setWorkflowType(String workflowType) {
            this.workflowType = workflowType;
        }

        @Override
        public final Builder workflowType(String workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType(workflowType == null ? null : workflowType.toString());
            return this;
        }

        public final String getRunId() {
            return runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRunGroupId() {
            return runGroupId;
        }

        public final void setRunGroupId(String runGroupId) {
            this.runGroupId = runGroupId;
        }

        @Override
        public final Builder runGroupId(String runGroupId) {
            this.runGroupId = runGroupId;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getDefinition() {
            return definition;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final String getDigest() {
            return digest;
        }

        public final void setDigest(String digest) {
            this.digest = digest;
        }

        @Override
        public final Builder digest(String digest) {
            this.digest = digest;
            return this;
        }

        public final Document getParameters() {
            return parameters;
        }

        public final void setParameters(Document parameters) {
            this.parameters = parameters;
        }

        @Override
        public final Builder parameters(Document parameters) {
            this.parameters = parameters;
            return this;
        }

        public final Integer getStorageCapacity() {
            return storageCapacity;
        }

        public final void setStorageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
        }

        @Override
        public final Builder storageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
            return this;
        }

        public final String getOutputUri() {
            return outputUri;
        }

        public final void setOutputUri(String outputUri) {
            this.outputUri = outputUri;
        }

        @Override
        public final Builder outputUri(String outputUri) {
            this.outputUri = outputUri;
            return this;
        }

        public final String getLogLevel() {
            return logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(RunLogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final Map<String, String> getResourceDigests() {
            if (resourceDigests instanceof SdkAutoConstructMap) {
                return null;
            }
            return resourceDigests;
        }

        public final void setResourceDigests(Map<String, String> resourceDigests) {
            this.resourceDigests = RunResourceDigestsCopier.copy(resourceDigests);
        }

        @Override
        public final Builder resourceDigests(Map<String, String> resourceDigests) {
            this.resourceDigests = RunResourceDigestsCopier.copy(resourceDigests);
            return this;
        }

        public final String getStartedBy() {
            return startedBy;
        }

        public final void setStartedBy(String startedBy) {
            this.startedBy = startedBy;
        }

        @Override
        public final Builder startedBy(String startedBy) {
            this.startedBy = startedBy;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getStopTime() {
            return stopTime;
        }

        public final void setStopTime(Instant stopTime) {
            this.stopTime = stopTime;
        }

        @Override
        public final Builder stopTime(Instant stopTime) {
            this.stopTime = stopTime;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getAccelerators() {
            return accelerators;
        }

        public final void setAccelerators(String accelerators) {
            this.accelerators = accelerators;
        }

        @Override
        public final Builder accelerators(String accelerators) {
            this.accelerators = accelerators;
            return this;
        }

        @Override
        public final Builder accelerators(Accelerators accelerators) {
            this.accelerators(accelerators == null ? null : accelerators.toString());
            return this;
        }

        public final String getRetentionMode() {
            return retentionMode;
        }

        public final void setRetentionMode(String retentionMode) {
            this.retentionMode = retentionMode;
        }

        @Override
        public final Builder retentionMode(String retentionMode) {
            this.retentionMode = retentionMode;
            return this;
        }

        @Override
        public final Builder retentionMode(RunRetentionMode retentionMode) {
            this.retentionMode(retentionMode == null ? null : retentionMode.toString());
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final RunLogLocation.Builder getLogLocation() {
            return logLocation != null ? logLocation.toBuilder() : null;
        }

        public final void setLogLocation(RunLogLocation.BuilderImpl logLocation) {
            this.logLocation = logLocation != null ? logLocation.build() : null;
        }

        @Override
        public final Builder logLocation(RunLogLocation logLocation) {
            this.logLocation = logLocation;
            return this;
        }

        public final String getUuid() {
            return uuid;
        }

        public final void setUuid(String uuid) {
            this.uuid = uuid;
        }

        @Override
        public final Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public final String getRunOutputUri() {
            return runOutputUri;
        }

        public final void setRunOutputUri(String runOutputUri) {
            this.runOutputUri = runOutputUri;
        }

        @Override
        public final Builder runOutputUri(String runOutputUri) {
            this.runOutputUri = runOutputUri;
            return this;
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public final Builder storageType(StorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public final String getWorkflowOwnerId() {
            return workflowOwnerId;
        }

        public final void setWorkflowOwnerId(String workflowOwnerId) {
            this.workflowOwnerId = workflowOwnerId;
        }

        @Override
        public final Builder workflowOwnerId(String workflowOwnerId) {
            this.workflowOwnerId = workflowOwnerId;
            return this;
        }

        @Override
        public GetRunResponse build() {
            return new GetRunResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
