/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWorkflowRequest extends OmicsRequest implements
        ToCopyableBuilder<GetWorkflowRequest.Builder, GetWorkflowRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetWorkflowRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(GetWorkflowRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("type").build()).build();

    private static final SdkField<List<String>> EXPORT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("export")
            .getter(getter(GetWorkflowRequest::exportAsStrings))
            .setter(setter(Builder::exportWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("export").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> WORKFLOW_OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowOwnerId").getter(getter(GetWorkflowRequest::workflowOwnerId))
            .setter(setter(Builder::workflowOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("workflowOwnerId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD,
            EXPORT_FIELD, WORKFLOW_OWNER_ID_FIELD));

    private final String id;

    private final String type;

    private final List<String> export;

    private final String workflowOwnerId;

    private GetWorkflowRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.type = builder.type;
        this.export = builder.export;
        this.workflowOwnerId = builder.workflowOwnerId;
    }

    /**
     * <p>
     * The workflow's ID.
     * </p>
     * 
     * @return The workflow's ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The workflow's type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link WorkflowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The workflow's type.
     * @see WorkflowType
     */
    public final WorkflowType type() {
        return WorkflowType.fromValue(type);
    }

    /**
     * <p>
     * The workflow's type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link WorkflowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The workflow's type.
     * @see WorkflowType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The export format for the workflow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExport} method.
     * </p>
     * 
     * @return The export format for the workflow.
     */
    public final List<WorkflowExport> export() {
        return WorkflowExportListCopier.copyStringToEnum(export);
    }

    /**
     * For responses, this returns true if the service returned a value for the Export property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasExport() {
        return export != null && !(export instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The export format for the workflow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExport} method.
     * </p>
     * 
     * @return The export format for the workflow.
     */
    public final List<String> exportAsStrings() {
        return export;
    }

    /**
     * <p>
     * The ID of the workflow owner.
     * </p>
     * 
     * @return The ID of the workflow owner.
     */
    public final String workflowOwnerId() {
        return workflowOwnerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasExport() ? exportAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workflowOwnerId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowRequest)) {
            return false;
        }
        GetWorkflowRequest other = (GetWorkflowRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(typeAsString(), other.typeAsString())
                && hasExport() == other.hasExport() && Objects.equals(exportAsStrings(), other.exportAsStrings())
                && Objects.equals(workflowOwnerId(), other.workflowOwnerId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWorkflowRequest").add("Id", id()).add("Type", typeAsString())
                .add("Export", hasExport() ? exportAsStrings() : null).add("WorkflowOwnerId", workflowOwnerId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "export":
            return Optional.ofNullable(clazz.cast(exportAsStrings()));
        case "workflowOwnerId":
            return Optional.ofNullable(clazz.cast(workflowOwnerId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowRequest, T> g) {
        return obj -> g.apply((GetWorkflowRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetWorkflowRequest> {
        /**
         * <p>
         * The workflow's ID.
         * </p>
         * 
         * @param id
         *        The workflow's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The workflow's type.
         * </p>
         * 
         * @param type
         *        The workflow's type.
         * @see WorkflowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowType
         */
        Builder type(String type);

        /**
         * <p>
         * The workflow's type.
         * </p>
         * 
         * @param type
         *        The workflow's type.
         * @see WorkflowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowType
         */
        Builder type(WorkflowType type);

        /**
         * <p>
         * The export format for the workflow.
         * </p>
         * 
         * @param export
         *        The export format for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportWithStrings(Collection<String> export);

        /**
         * <p>
         * The export format for the workflow.
         * </p>
         * 
         * @param export
         *        The export format for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportWithStrings(String... export);

        /**
         * <p>
         * The export format for the workflow.
         * </p>
         * 
         * @param export
         *        The export format for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder export(Collection<WorkflowExport> export);

        /**
         * <p>
         * The export format for the workflow.
         * </p>
         * 
         * @param export
         *        The export format for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder export(WorkflowExport... export);

        /**
         * <p>
         * The ID of the workflow owner.
         * </p>
         * 
         * @param workflowOwnerId
         *        The ID of the workflow owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowOwnerId(String workflowOwnerId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private String id;

        private String type;

        private List<String> export = DefaultSdkAutoConstructList.getInstance();

        private String workflowOwnerId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowRequest model) {
            super(model);
            id(model.id);
            type(model.type);
            exportWithStrings(model.export);
            workflowOwnerId(model.workflowOwnerId);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(WorkflowType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Collection<String> getExport() {
            if (export instanceof SdkAutoConstructList) {
                return null;
            }
            return export;
        }

        public final void setExport(Collection<String> export) {
            this.export = WorkflowExportListCopier.copy(export);
        }

        @Override
        public final Builder exportWithStrings(Collection<String> export) {
            this.export = WorkflowExportListCopier.copy(export);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportWithStrings(String... export) {
            exportWithStrings(Arrays.asList(export));
            return this;
        }

        @Override
        public final Builder export(Collection<WorkflowExport> export) {
            this.export = WorkflowExportListCopier.copyEnumToString(export);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder export(WorkflowExport... export) {
            export(Arrays.asList(export));
            return this;
        }

        public final String getWorkflowOwnerId() {
            return workflowOwnerId;
        }

        public final void setWorkflowOwnerId(String workflowOwnerId) {
            this.workflowOwnerId = workflowOwnerId;
        }

        @Override
        public final Builder workflowOwnerId(String workflowOwnerId) {
            this.workflowOwnerId = workflowOwnerId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetWorkflowRequest build() {
            return new GetWorkflowRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
