/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSharesResponse extends OmicsResponse implements
        ToCopyableBuilder<ListSharesResponse.Builder, ListSharesResponse> {
    private static final SdkField<List<ShareDetails>> SHARES_FIELD = SdkField
            .<List<ShareDetails>> builder(MarshallingType.LIST)
            .memberName("shares")
            .getter(getter(ListSharesResponse::shares))
            .setter(setter(Builder::shares))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shares").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ShareDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(ShareDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSharesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SHARES_FIELD, NEXT_TOKEN_FIELD));

    private final List<ShareDetails> shares;

    private final String nextToken;

    private ListSharesResponse(BuilderImpl builder) {
        super(builder);
        this.shares = builder.shares;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Shares property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasShares() {
        return shares != null && !(shares instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The shares available and their metadata details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasShares} method.
     * </p>
     * 
     * @return The shares available and their metadata details.
     */
    public final List<ShareDetails> shares() {
        return shares;
    }

    /**
     * <p>
     * Next token returned in the response of a previous ListSharesResponse call. Used to get the next page of results.
     * </p>
     * 
     * @return Next token returned in the response of a previous ListSharesResponse call. Used to get the next page of
     *         results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasShares() ? shares() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSharesResponse)) {
            return false;
        }
        ListSharesResponse other = (ListSharesResponse) obj;
        return hasShares() == other.hasShares() && Objects.equals(shares(), other.shares())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSharesResponse").add("Shares", hasShares() ? shares() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "shares":
            return Optional.ofNullable(clazz.cast(shares()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSharesResponse, T> g) {
        return obj -> g.apply((ListSharesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSharesResponse> {
        /**
         * <p>
         * The shares available and their metadata details.
         * </p>
         * 
         * @param shares
         *        The shares available and their metadata details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shares(Collection<ShareDetails> shares);

        /**
         * <p>
         * The shares available and their metadata details.
         * </p>
         * 
         * @param shares
         *        The shares available and their metadata details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shares(ShareDetails... shares);

        /**
         * <p>
         * The shares available and their metadata details.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.omics.model.ShareDetails.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.omics.model.ShareDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.omics.model.ShareDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #shares(List<ShareDetails>)}.
         * 
         * @param shares
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.omics.model.ShareDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shares(java.util.Collection<ShareDetails>)
         */
        Builder shares(Consumer<ShareDetails.Builder>... shares);

        /**
         * <p>
         * Next token returned in the response of a previous ListSharesResponse call. Used to get the next page of
         * results.
         * </p>
         * 
         * @param nextToken
         *        Next token returned in the response of a previous ListSharesResponse call. Used to get the next page
         *        of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends OmicsResponse.BuilderImpl implements Builder {
        private List<ShareDetails> shares = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSharesResponse model) {
            super(model);
            shares(model.shares);
            nextToken(model.nextToken);
        }

        public final List<ShareDetails.Builder> getShares() {
            List<ShareDetails.Builder> result = ShareDetailsListCopier.copyToBuilder(this.shares);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setShares(Collection<ShareDetails.BuilderImpl> shares) {
            this.shares = ShareDetailsListCopier.copyFromBuilder(shares);
        }

        @Override
        public final Builder shares(Collection<ShareDetails> shares) {
            this.shares = ShareDetailsListCopier.copy(shares);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shares(ShareDetails... shares) {
            shares(Arrays.asList(shares));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shares(Consumer<ShareDetails.Builder>... shares) {
            shares(Stream.of(shares).map(c -> ShareDetails.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSharesResponse build() {
            return new ListSharesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
