/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The S3 access metadata of the sequence store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SequenceStoreS3Access implements SdkPojo, Serializable,
        ToCopyableBuilder<SequenceStoreS3Access.Builder, SequenceStoreS3Access> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("s3Uri")
            .getter(getter(SequenceStoreS3Access::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Uri").build()).build();

    private static final SdkField<String> S3_ACCESS_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3AccessPointArn").getter(getter(SequenceStoreS3Access::s3AccessPointArn))
            .setter(setter(Builder::s3AccessPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3AccessPointArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD,
            S3_ACCESS_POINT_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3Uri;

    private final String s3AccessPointArn;

    private SequenceStoreS3Access(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.s3AccessPointArn = builder.s3AccessPointArn;
    }

    /**
     * <p>
     * The S3 URI of the sequence store.
     * </p>
     * 
     * @return The S3 URI of the sequence store.
     */
    public final String s3Uri() {
        return s3Uri;
    }

    /**
     * <p>
     * This is ARN of the access point associated with the S3 bucket storing read sets.
     * </p>
     * 
     * @return This is ARN of the access point associated with the S3 bucket storing read sets.
     */
    public final String s3AccessPointArn() {
        return s3AccessPointArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(s3AccessPointArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SequenceStoreS3Access)) {
            return false;
        }
        SequenceStoreS3Access other = (SequenceStoreS3Access) obj;
        return Objects.equals(s3Uri(), other.s3Uri()) && Objects.equals(s3AccessPointArn(), other.s3AccessPointArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SequenceStoreS3Access").add("S3Uri", s3Uri()).add("S3AccessPointArn", s3AccessPointArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        case "s3AccessPointArn":
            return Optional.ofNullable(clazz.cast(s3AccessPointArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SequenceStoreS3Access, T> g) {
        return obj -> g.apply((SequenceStoreS3Access) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SequenceStoreS3Access> {
        /**
         * <p>
         * The S3 URI of the sequence store.
         * </p>
         * 
         * @param s3Uri
         *        The S3 URI of the sequence store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);

        /**
         * <p>
         * This is ARN of the access point associated with the S3 bucket storing read sets.
         * </p>
         * 
         * @param s3AccessPointArn
         *        This is ARN of the access point associated with the S3 bucket storing read sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3AccessPointArn(String s3AccessPointArn);
    }

    static final class BuilderImpl implements Builder {
        private String s3Uri;

        private String s3AccessPointArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SequenceStoreS3Access model) {
            s3Uri(model.s3Uri);
            s3AccessPointArn(model.s3AccessPointArn);
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final String getS3AccessPointArn() {
            return s3AccessPointArn;
        }

        public final void setS3AccessPointArn(String s3AccessPointArn) {
            this.s3AccessPointArn = s3AccessPointArn;
        }

        @Override
        public final Builder s3AccessPointArn(String s3AccessPointArn) {
            this.s3AccessPointArn = s3AccessPointArn;
            return this;
        }

        @Override
        public SequenceStoreS3Access build() {
            return new SequenceStoreS3Access(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
