/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a resource share.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ShareDetails implements SdkPojo, Serializable, ToCopyableBuilder<ShareDetails.Builder, ShareDetails> {
    private static final SdkField<String> SHARE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shareId").getter(getter(ShareDetails::shareId)).setter(setter(Builder::shareId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shareId").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(ShareDetails::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceId").getter(getter(ShareDetails::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()).build();

    private static final SdkField<String> PRINCIPAL_SUBSCRIBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principalSubscriber").getter(getter(ShareDetails::principalSubscriber))
            .setter(setter(Builder::principalSubscriber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalSubscriber").build())
            .build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ownerId").getter(getter(ShareDetails::ownerId)).setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ShareDetails::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(ShareDetails::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<String> SHARE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shareName").getter(getter(ShareDetails::shareName)).setter(setter(Builder::shareName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shareName").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(ShareDetails::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime")
            .getter(getter(ShareDetails::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARE_ID_FIELD,
            RESOURCE_ARN_FIELD, RESOURCE_ID_FIELD, PRINCIPAL_SUBSCRIBER_FIELD, OWNER_ID_FIELD, STATUS_FIELD,
            STATUS_MESSAGE_FIELD, SHARE_NAME_FIELD, CREATION_TIME_FIELD, UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String shareId;

    private final String resourceArn;

    private final String resourceId;

    private final String principalSubscriber;

    private final String ownerId;

    private final String status;

    private final String statusMessage;

    private final String shareName;

    private final Instant creationTime;

    private final Instant updateTime;

    private ShareDetails(BuilderImpl builder) {
        this.shareId = builder.shareId;
        this.resourceArn = builder.resourceArn;
        this.resourceId = builder.resourceId;
        this.principalSubscriber = builder.principalSubscriber;
        this.ownerId = builder.ownerId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.shareName = builder.shareName;
        this.creationTime = builder.creationTime;
        this.updateTime = builder.updateTime;
    }

    /**
     * <p>
     * The ID of the resource share.
     * </p>
     * 
     * @return The ID of the resource share.
     */
    public final String shareId() {
        return shareId;
    }

    /**
     * <p>
     * The Arn of the shared resource.
     * </p>
     * 
     * @return The Arn of the shared resource.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The ID of the shared resource.
     * </p>
     * 
     * @return The ID of the shared resource.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The principal subscriber is the account that is sharing the resource.
     * </p>
     * 
     * @return The principal subscriber is the account that is sharing the resource.
     */
    public final String principalSubscriber() {
        return principalSubscriber;
    }

    /**
     * <p>
     * The account ID for the data owner. The owner creates the resource share.
     * </p>
     * 
     * @return The account ID for the data owner. The owner creates the resource share.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The status of the share.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the share.
     * @see ShareStatus
     */
    public final ShareStatus status() {
        return ShareStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the share.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the share.
     * @see ShareStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status message for a resource share. It provides additional details about the share status.
     * </p>
     * 
     * @return The status message for a resource share. It provides additional details about the share status.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The name of the resource share.
     * </p>
     * 
     * @return The name of the resource share.
     */
    public final String shareName() {
        return shareName;
    }

    /**
     * <p>
     * The timestamp of when the resource share was created.
     * </p>
     * 
     * @return The timestamp of when the resource share was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The timestamp of the resource share update.
     * </p>
     * 
     * @return The timestamp of the resource share update.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(shareId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(principalSubscriber());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(shareName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShareDetails)) {
            return false;
        }
        ShareDetails other = (ShareDetails) obj;
        return Objects.equals(shareId(), other.shareId()) && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(principalSubscriber(), other.principalSubscriber())
                && Objects.equals(ownerId(), other.ownerId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(shareName(), other.shareName())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(updateTime(), other.updateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ShareDetails").add("ShareId", shareId()).add("ResourceArn", resourceArn())
                .add("ResourceId", resourceId()).add("PrincipalSubscriber", principalSubscriber()).add("OwnerId", ownerId())
                .add("Status", statusAsString()).add("StatusMessage", statusMessage()).add("ShareName", shareName())
                .add("CreationTime", creationTime()).add("UpdateTime", updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "shareId":
            return Optional.ofNullable(clazz.cast(shareId()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "principalSubscriber":
            return Optional.ofNullable(clazz.cast(principalSubscriber()));
        case "ownerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "shareName":
            return Optional.ofNullable(clazz.cast(shareName()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ShareDetails, T> g) {
        return obj -> g.apply((ShareDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ShareDetails> {
        /**
         * <p>
         * The ID of the resource share.
         * </p>
         * 
         * @param shareId
         *        The ID of the resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareId(String shareId);

        /**
         * <p>
         * The Arn of the shared resource.
         * </p>
         * 
         * @param resourceArn
         *        The Arn of the shared resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The ID of the shared resource.
         * </p>
         * 
         * @param resourceId
         *        The ID of the shared resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The principal subscriber is the account that is sharing the resource.
         * </p>
         * 
         * @param principalSubscriber
         *        The principal subscriber is the account that is sharing the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalSubscriber(String principalSubscriber);

        /**
         * <p>
         * The account ID for the data owner. The owner creates the resource share.
         * </p>
         * 
         * @param ownerId
         *        The account ID for the data owner. The owner creates the resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The status of the share.
         * </p>
         * 
         * @param status
         *        The status of the share.
         * @see ShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the share.
         * </p>
         * 
         * @param status
         *        The status of the share.
         * @see ShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareStatus
         */
        Builder status(ShareStatus status);

        /**
         * <p>
         * The status message for a resource share. It provides additional details about the share status.
         * </p>
         * 
         * @param statusMessage
         *        The status message for a resource share. It provides additional details about the share status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The name of the resource share.
         * </p>
         * 
         * @param shareName
         *        The name of the resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareName(String shareName);

        /**
         * <p>
         * The timestamp of when the resource share was created.
         * </p>
         * 
         * @param creationTime
         *        The timestamp of when the resource share was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The timestamp of the resource share update.
         * </p>
         * 
         * @param updateTime
         *        The timestamp of the resource share update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl implements Builder {
        private String shareId;

        private String resourceArn;

        private String resourceId;

        private String principalSubscriber;

        private String ownerId;

        private String status;

        private String statusMessage;

        private String shareName;

        private Instant creationTime;

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ShareDetails model) {
            shareId(model.shareId);
            resourceArn(model.resourceArn);
            resourceId(model.resourceId);
            principalSubscriber(model.principalSubscriber);
            ownerId(model.ownerId);
            status(model.status);
            statusMessage(model.statusMessage);
            shareName(model.shareName);
            creationTime(model.creationTime);
            updateTime(model.updateTime);
        }

        public final String getShareId() {
            return shareId;
        }

        public final void setShareId(String shareId) {
            this.shareId = shareId;
        }

        @Override
        public final Builder shareId(String shareId) {
            this.shareId = shareId;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getPrincipalSubscriber() {
            return principalSubscriber;
        }

        public final void setPrincipalSubscriber(String principalSubscriber) {
            this.principalSubscriber = principalSubscriber;
        }

        @Override
        public final Builder principalSubscriber(String principalSubscriber) {
            this.principalSubscriber = principalSubscriber;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ShareStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getShareName() {
            return shareName;
        }

        public final void setShareName(String shareName) {
            this.shareName = shareName;
        }

        @Override
        public final Builder shareName(String shareName) {
            this.shareName = shareName;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public ShareDetails build() {
            return new ShareDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
