/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.omics.OmicsAsyncClient;
import software.amazon.awssdk.services.omics.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.omics.model.GetAnnotationImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetAnnotationImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreRequest;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreResponse;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreVersionRequest;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreVersionResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetActivationJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetActivationJobResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetExportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetExportJobResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetReferenceImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReferenceImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetRunRequest;
import software.amazon.awssdk.services.omics.model.GetRunResponse;
import software.amazon.awssdk.services.omics.model.GetRunTaskRequest;
import software.amazon.awssdk.services.omics.model.GetRunTaskResponse;
import software.amazon.awssdk.services.omics.model.GetVariantImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetVariantImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetVariantStoreRequest;
import software.amazon.awssdk.services.omics.model.GetVariantStoreResponse;
import software.amazon.awssdk.services.omics.model.GetWorkflowRequest;
import software.amazon.awssdk.services.omics.model.GetWorkflowResponse;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.services.omics.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
@ThreadSafe
final class DefaultOmicsAsyncWaiter implements OmicsAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute<>(SdkAutoCloseable.class);

    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute<>(
            ScheduledExecutorService.class);

    private final OmicsAsyncClient client;

    private final AttributeMap managedResources;

    private final AsyncWaiter<GetAnnotationImportJobResponse> annotationImportJobCreatedWaiter;

    private final AsyncWaiter<GetAnnotationStoreResponse> annotationStoreCreatedWaiter;

    private final AsyncWaiter<GetAnnotationStoreResponse> annotationStoreDeletedWaiter;

    private final AsyncWaiter<GetAnnotationStoreVersionResponse> annotationStoreVersionCreatedWaiter;

    private final AsyncWaiter<GetAnnotationStoreVersionResponse> annotationStoreVersionDeletedWaiter;

    private final AsyncWaiter<GetReadSetActivationJobResponse> readSetActivationJobCompletedWaiter;

    private final AsyncWaiter<GetReadSetExportJobResponse> readSetExportJobCompletedWaiter;

    private final AsyncWaiter<GetReadSetImportJobResponse> readSetImportJobCompletedWaiter;

    private final AsyncWaiter<GetReferenceImportJobResponse> referenceImportJobCompletedWaiter;

    private final AsyncWaiter<GetRunResponse> runCompletedWaiter;

    private final AsyncWaiter<GetRunResponse> runRunningWaiter;

    private final AsyncWaiter<GetRunTaskResponse> taskCompletedWaiter;

    private final AsyncWaiter<GetRunTaskResponse> taskRunningWaiter;

    private final AsyncWaiter<GetVariantImportJobResponse> variantImportJobCreatedWaiter;

    private final AsyncWaiter<GetVariantStoreResponse> variantStoreCreatedWaiter;

    private final AsyncWaiter<GetVariantStoreResponse> variantStoreDeletedWaiter;

    private final AsyncWaiter<GetWorkflowResponse> workflowActiveWaiter;

    private final ScheduledExecutorService executorService;

    private DefaultOmicsAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = OmicsAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1,
                    new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        managedResources = attributeMapBuilder.build();
        this.annotationImportJobCreatedWaiter = AsyncWaiter.builder(GetAnnotationImportJobResponse.class)
                .acceptors(annotationImportJobCreatedWaiterAcceptors())
                .overrideConfiguration(annotationImportJobCreatedWaiterConfig(builder.overrideConfiguration))
                .scheduledExecutorService(executorService).build();
        this.annotationStoreCreatedWaiter = AsyncWaiter.builder(GetAnnotationStoreResponse.class)
                .acceptors(annotationStoreCreatedWaiterAcceptors())
                .overrideConfiguration(annotationStoreCreatedWaiterConfig(builder.overrideConfiguration))
                .scheduledExecutorService(executorService).build();
        this.annotationStoreDeletedWaiter = AsyncWaiter.builder(GetAnnotationStoreResponse.class)
                .acceptors(annotationStoreDeletedWaiterAcceptors())
                .overrideConfiguration(annotationStoreDeletedWaiterConfig(builder.overrideConfiguration))
                .scheduledExecutorService(executorService).build();
        this.annotationStoreVersionCreatedWaiter = AsyncWaiter.builder(GetAnnotationStoreVersionResponse.class)
                .acceptors(annotationStoreVersionCreatedWaiterAcceptors())
                .overrideConfiguration(annotationStoreVersionCreatedWaiterConfig(builder.overrideConfiguration))
                .scheduledExecutorService(executorService).build();
        this.annotationStoreVersionDeletedWaiter = AsyncWaiter.builder(GetAnnotationStoreVersionResponse.class)
                .acceptors(annotationStoreVersionDeletedWaiterAcceptors())
                .overrideConfiguration(annotationStoreVersionDeletedWaiterConfig(builder.overrideConfiguration))
                .scheduledExecutorService(executorService).build();
        this.readSetActivationJobCompletedWaiter = AsyncWaiter.builder(GetReadSetActivationJobResponse.class)
                .acceptors(readSetActivationJobCompletedWaiterAcceptors())
                .overrideConfiguration(readSetActivationJobCompletedWaiterConfig(builder.overrideConfiguration))
                .scheduledExecutorService(executorService).build();
        this.readSetExportJobCompletedWaiter = AsyncWaiter.builder(GetReadSetExportJobResponse.class)
                .acceptors(readSetExportJobCompletedWaiterAcceptors())
                .overrideConfiguration(readSetExportJobCompletedWaiterConfig(builder.overrideConfiguration))
                .scheduledExecutorService(executorService).build();
        this.readSetImportJobCompletedWaiter = AsyncWaiter.builder(GetReadSetImportJobResponse.class)
                .acceptors(readSetImportJobCompletedWaiterAcceptors())
                .overrideConfiguration(readSetImportJobCompletedWaiterConfig(builder.overrideConfiguration))
                .scheduledExecutorService(executorService).build();
        this.referenceImportJobCompletedWaiter = AsyncWaiter.builder(GetReferenceImportJobResponse.class)
                .acceptors(referenceImportJobCompletedWaiterAcceptors())
                .overrideConfiguration(referenceImportJobCompletedWaiterConfig(builder.overrideConfiguration))
                .scheduledExecutorService(executorService).build();
        this.runCompletedWaiter = AsyncWaiter.builder(GetRunResponse.class).acceptors(runCompletedWaiterAcceptors())
                .overrideConfiguration(runCompletedWaiterConfig(builder.overrideConfiguration))
                .scheduledExecutorService(executorService).build();
        this.runRunningWaiter = AsyncWaiter.builder(GetRunResponse.class).acceptors(runRunningWaiterAcceptors())
                .overrideConfiguration(runRunningWaiterConfig(builder.overrideConfiguration))
                .scheduledExecutorService(executorService).build();
        this.taskCompletedWaiter = AsyncWaiter.builder(GetRunTaskResponse.class).acceptors(taskCompletedWaiterAcceptors())
                .overrideConfiguration(taskCompletedWaiterConfig(builder.overrideConfiguration))
                .scheduledExecutorService(executorService).build();
        this.taskRunningWaiter = AsyncWaiter.builder(GetRunTaskResponse.class).acceptors(taskRunningWaiterAcceptors())
                .overrideConfiguration(taskRunningWaiterConfig(builder.overrideConfiguration))
                .scheduledExecutorService(executorService).build();
        this.variantImportJobCreatedWaiter = AsyncWaiter.builder(GetVariantImportJobResponse.class)
                .acceptors(variantImportJobCreatedWaiterAcceptors())
                .overrideConfiguration(variantImportJobCreatedWaiterConfig(builder.overrideConfiguration))
                .scheduledExecutorService(executorService).build();
        this.variantStoreCreatedWaiter = AsyncWaiter.builder(GetVariantStoreResponse.class)
                .acceptors(variantStoreCreatedWaiterAcceptors())
                .overrideConfiguration(variantStoreCreatedWaiterConfig(builder.overrideConfiguration))
                .scheduledExecutorService(executorService).build();
        this.variantStoreDeletedWaiter = AsyncWaiter.builder(GetVariantStoreResponse.class)
                .acceptors(variantStoreDeletedWaiterAcceptors())
                .overrideConfiguration(variantStoreDeletedWaiterConfig(builder.overrideConfiguration))
                .scheduledExecutorService(executorService).build();
        this.workflowActiveWaiter = AsyncWaiter.builder(GetWorkflowResponse.class).acceptors(workflowActiveWaiterAcceptors())
                .overrideConfiguration(workflowActiveWaiterConfig(builder.overrideConfiguration))
                .scheduledExecutorService(executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException) error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<GetAnnotationImportJobResponse>> waitUntilAnnotationImportJobCreated(
            GetAnnotationImportJobRequest getAnnotationImportJobRequest) {
        return annotationImportJobCreatedWaiter.runAsync(() -> client
                .getAnnotationImportJob(applyWaitersUserAgent(getAnnotationImportJobRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetAnnotationImportJobResponse>> waitUntilAnnotationImportJobCreated(
            GetAnnotationImportJobRequest getAnnotationImportJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return annotationImportJobCreatedWaiter.runAsync(
                () -> client.getAnnotationImportJob(applyWaitersUserAgent(getAnnotationImportJobRequest)),
                annotationImportJobCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetAnnotationStoreResponse>> waitUntilAnnotationStoreCreated(
            GetAnnotationStoreRequest getAnnotationStoreRequest) {
        return annotationStoreCreatedWaiter.runAsync(() -> client
                .getAnnotationStore(applyWaitersUserAgent(getAnnotationStoreRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetAnnotationStoreResponse>> waitUntilAnnotationStoreCreated(
            GetAnnotationStoreRequest getAnnotationStoreRequest, WaiterOverrideConfiguration overrideConfig) {
        return annotationStoreCreatedWaiter.runAsync(
                () -> client.getAnnotationStore(applyWaitersUserAgent(getAnnotationStoreRequest)),
                annotationStoreCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetAnnotationStoreResponse>> waitUntilAnnotationStoreDeleted(
            GetAnnotationStoreRequest getAnnotationStoreRequest) {
        return annotationStoreDeletedWaiter.runAsync(() -> client
                .getAnnotationStore(applyWaitersUserAgent(getAnnotationStoreRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetAnnotationStoreResponse>> waitUntilAnnotationStoreDeleted(
            GetAnnotationStoreRequest getAnnotationStoreRequest, WaiterOverrideConfiguration overrideConfig) {
        return annotationStoreDeletedWaiter.runAsync(
                () -> client.getAnnotationStore(applyWaitersUserAgent(getAnnotationStoreRequest)),
                annotationStoreDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetAnnotationStoreVersionResponse>> waitUntilAnnotationStoreVersionCreated(
            GetAnnotationStoreVersionRequest getAnnotationStoreVersionRequest) {
        return annotationStoreVersionCreatedWaiter.runAsync(() -> client
                .getAnnotationStoreVersion(applyWaitersUserAgent(getAnnotationStoreVersionRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetAnnotationStoreVersionResponse>> waitUntilAnnotationStoreVersionCreated(
            GetAnnotationStoreVersionRequest getAnnotationStoreVersionRequest, WaiterOverrideConfiguration overrideConfig) {
        return annotationStoreVersionCreatedWaiter.runAsync(
                () -> client.getAnnotationStoreVersion(applyWaitersUserAgent(getAnnotationStoreVersionRequest)),
                annotationStoreVersionCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetAnnotationStoreVersionResponse>> waitUntilAnnotationStoreVersionDeleted(
            GetAnnotationStoreVersionRequest getAnnotationStoreVersionRequest) {
        return annotationStoreVersionDeletedWaiter.runAsync(() -> client
                .getAnnotationStoreVersion(applyWaitersUserAgent(getAnnotationStoreVersionRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetAnnotationStoreVersionResponse>> waitUntilAnnotationStoreVersionDeleted(
            GetAnnotationStoreVersionRequest getAnnotationStoreVersionRequest, WaiterOverrideConfiguration overrideConfig) {
        return annotationStoreVersionDeletedWaiter.runAsync(
                () -> client.getAnnotationStoreVersion(applyWaitersUserAgent(getAnnotationStoreVersionRequest)),
                annotationStoreVersionDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetReadSetActivationJobResponse>> waitUntilReadSetActivationJobCompleted(
            GetReadSetActivationJobRequest getReadSetActivationJobRequest) {
        return readSetActivationJobCompletedWaiter.runAsync(() -> client
                .getReadSetActivationJob(applyWaitersUserAgent(getReadSetActivationJobRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetReadSetActivationJobResponse>> waitUntilReadSetActivationJobCompleted(
            GetReadSetActivationJobRequest getReadSetActivationJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return readSetActivationJobCompletedWaiter.runAsync(
                () -> client.getReadSetActivationJob(applyWaitersUserAgent(getReadSetActivationJobRequest)),
                readSetActivationJobCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetReadSetExportJobResponse>> waitUntilReadSetExportJobCompleted(
            GetReadSetExportJobRequest getReadSetExportJobRequest) {
        return readSetExportJobCompletedWaiter.runAsync(() -> client
                .getReadSetExportJob(applyWaitersUserAgent(getReadSetExportJobRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetReadSetExportJobResponse>> waitUntilReadSetExportJobCompleted(
            GetReadSetExportJobRequest getReadSetExportJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return readSetExportJobCompletedWaiter.runAsync(
                () -> client.getReadSetExportJob(applyWaitersUserAgent(getReadSetExportJobRequest)),
                readSetExportJobCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetReadSetImportJobResponse>> waitUntilReadSetImportJobCompleted(
            GetReadSetImportJobRequest getReadSetImportJobRequest) {
        return readSetImportJobCompletedWaiter.runAsync(() -> client
                .getReadSetImportJob(applyWaitersUserAgent(getReadSetImportJobRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetReadSetImportJobResponse>> waitUntilReadSetImportJobCompleted(
            GetReadSetImportJobRequest getReadSetImportJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return readSetImportJobCompletedWaiter.runAsync(
                () -> client.getReadSetImportJob(applyWaitersUserAgent(getReadSetImportJobRequest)),
                readSetImportJobCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetReferenceImportJobResponse>> waitUntilReferenceImportJobCompleted(
            GetReferenceImportJobRequest getReferenceImportJobRequest) {
        return referenceImportJobCompletedWaiter.runAsync(() -> client
                .getReferenceImportJob(applyWaitersUserAgent(getReferenceImportJobRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetReferenceImportJobResponse>> waitUntilReferenceImportJobCompleted(
            GetReferenceImportJobRequest getReferenceImportJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return referenceImportJobCompletedWaiter.runAsync(
                () -> client.getReferenceImportJob(applyWaitersUserAgent(getReferenceImportJobRequest)),
                referenceImportJobCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRunResponse>> waitUntilRunCompleted(GetRunRequest getRunRequest) {
        return runCompletedWaiter.runAsync(() -> client.getRun(applyWaitersUserAgent(getRunRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRunResponse>> waitUntilRunCompleted(GetRunRequest getRunRequest,
            WaiterOverrideConfiguration overrideConfig) {
        return runCompletedWaiter.runAsync(() -> client.getRun(applyWaitersUserAgent(getRunRequest)),
                runCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRunResponse>> waitUntilRunRunning(GetRunRequest getRunRequest) {
        return runRunningWaiter.runAsync(() -> client.getRun(applyWaitersUserAgent(getRunRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRunResponse>> waitUntilRunRunning(GetRunRequest getRunRequest,
            WaiterOverrideConfiguration overrideConfig) {
        return runRunningWaiter.runAsync(() -> client.getRun(applyWaitersUserAgent(getRunRequest)),
                runRunningWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRunTaskResponse>> waitUntilTaskCompleted(GetRunTaskRequest getRunTaskRequest) {
        return taskCompletedWaiter.runAsync(() -> client.getRunTask(applyWaitersUserAgent(getRunTaskRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRunTaskResponse>> waitUntilTaskCompleted(GetRunTaskRequest getRunTaskRequest,
            WaiterOverrideConfiguration overrideConfig) {
        return taskCompletedWaiter.runAsync(() -> client.getRunTask(applyWaitersUserAgent(getRunTaskRequest)),
                taskCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRunTaskResponse>> waitUntilTaskRunning(GetRunTaskRequest getRunTaskRequest) {
        return taskRunningWaiter.runAsync(() -> client.getRunTask(applyWaitersUserAgent(getRunTaskRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRunTaskResponse>> waitUntilTaskRunning(GetRunTaskRequest getRunTaskRequest,
            WaiterOverrideConfiguration overrideConfig) {
        return taskRunningWaiter.runAsync(() -> client.getRunTask(applyWaitersUserAgent(getRunTaskRequest)),
                taskRunningWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetVariantImportJobResponse>> waitUntilVariantImportJobCreated(
            GetVariantImportJobRequest getVariantImportJobRequest) {
        return variantImportJobCreatedWaiter.runAsync(() -> client
                .getVariantImportJob(applyWaitersUserAgent(getVariantImportJobRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetVariantImportJobResponse>> waitUntilVariantImportJobCreated(
            GetVariantImportJobRequest getVariantImportJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return variantImportJobCreatedWaiter.runAsync(
                () -> client.getVariantImportJob(applyWaitersUserAgent(getVariantImportJobRequest)),
                variantImportJobCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetVariantStoreResponse>> waitUntilVariantStoreCreated(
            GetVariantStoreRequest getVariantStoreRequest) {
        return variantStoreCreatedWaiter.runAsync(() -> client.getVariantStore(applyWaitersUserAgent(getVariantStoreRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetVariantStoreResponse>> waitUntilVariantStoreCreated(
            GetVariantStoreRequest getVariantStoreRequest, WaiterOverrideConfiguration overrideConfig) {
        return variantStoreCreatedWaiter.runAsync(() -> client.getVariantStore(applyWaitersUserAgent(getVariantStoreRequest)),
                variantStoreCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetVariantStoreResponse>> waitUntilVariantStoreDeleted(
            GetVariantStoreRequest getVariantStoreRequest) {
        return variantStoreDeletedWaiter.runAsync(() -> client.getVariantStore(applyWaitersUserAgent(getVariantStoreRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetVariantStoreResponse>> waitUntilVariantStoreDeleted(
            GetVariantStoreRequest getVariantStoreRequest, WaiterOverrideConfiguration overrideConfig) {
        return variantStoreDeletedWaiter.runAsync(() -> client.getVariantStore(applyWaitersUserAgent(getVariantStoreRequest)),
                variantStoreDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetWorkflowResponse>> waitUntilWorkflowActive(GetWorkflowRequest getWorkflowRequest) {
        return workflowActiveWaiter.runAsync(() -> client.getWorkflow(applyWaitersUserAgent(getWorkflowRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetWorkflowResponse>> waitUntilWorkflowActive(GetWorkflowRequest getWorkflowRequest,
            WaiterOverrideConfiguration overrideConfig) {
        return workflowActiveWaiter.runAsync(() -> client.getWorkflow(applyWaitersUserAgent(getWorkflowRequest)),
                workflowActiveWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetAnnotationImportJobResponse>> annotationImportJobCreatedWaiterAcceptors() {
        List<WaiterAcceptor<? super GetAnnotationImportJobResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "SUBMITTED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLED");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetAnnotationStoreResponse>> annotationStoreCreatedWaiterAcceptors() {
        List<WaiterAcceptor<? super GetAnnotationStoreResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CREATING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "UPDATING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetAnnotationStoreResponse>> annotationStoreDeletedWaiterAcceptors() {
        List<WaiterAcceptor<? super GetAnnotationStoreResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(errorCode(error),
                "ResourceNotFoundException")));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETING");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetAnnotationStoreVersionResponse>> annotationStoreVersionCreatedWaiterAcceptors() {
        List<WaiterAcceptor<? super GetAnnotationStoreVersionResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CREATING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "UPDATING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetAnnotationStoreVersionResponse>> annotationStoreVersionDeletedWaiterAcceptors() {
        List<WaiterAcceptor<? super GetAnnotationStoreVersionResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(errorCode(error),
                "ResourceNotFoundException")));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETING");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetReadSetActivationJobResponse>> readSetActivationJobCompletedWaiterAcceptors() {
        List<WaiterAcceptor<? super GetReadSetActivationJobResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "SUBMITTED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "CANCELLED");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=CANCELLED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "COMPLETED_WITH_FAILURES");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=COMPLETED_WITH_FAILURES) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetReadSetExportJobResponse>> readSetExportJobCompletedWaiterAcceptors() {
        List<WaiterAcceptor<? super GetReadSetExportJobResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "SUBMITTED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "CANCELLED");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=CANCELLED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "COMPLETED_WITH_FAILURES");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=COMPLETED_WITH_FAILURES) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetReadSetImportJobResponse>> readSetImportJobCompletedWaiterAcceptors() {
        List<WaiterAcceptor<? super GetReadSetImportJobResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "SUBMITTED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "CANCELLED");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=CANCELLED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "COMPLETED_WITH_FAILURES");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=COMPLETED_WITH_FAILURES) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetReferenceImportJobResponse>> referenceImportJobCompletedWaiterAcceptors() {
        List<WaiterAcceptor<? super GetReferenceImportJobResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "SUBMITTED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "CANCELLED");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=CANCELLED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "COMPLETED_WITH_FAILURES");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=COMPLETED_WITH_FAILURES) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRunResponse>> runCompletedWaiterAcceptors() {
        List<WaiterAcceptor<? super GetRunResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "PENDING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "STARTING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "RUNNING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "STOPPING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRunResponse>> runRunningWaiterAcceptors() {
        List<WaiterAcceptor<? super GetRunResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "RUNNING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "PENDING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "STARTING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "CANCELLED");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=CANCELLED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRunTaskResponse>> taskCompletedWaiterAcceptors() {
        List<WaiterAcceptor<? super GetRunTaskResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "PENDING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "STARTING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "RUNNING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "STOPPING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRunTaskResponse>> taskRunningWaiterAcceptors() {
        List<WaiterAcceptor<? super GetRunTaskResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "RUNNING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "PENDING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "STARTING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "CANCELLED");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=CANCELLED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetVariantImportJobResponse>> variantImportJobCreatedWaiterAcceptors() {
        List<WaiterAcceptor<? super GetVariantImportJobResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "SUBMITTED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLED");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetVariantStoreResponse>> variantStoreCreatedWaiterAcceptors() {
        List<WaiterAcceptor<? super GetVariantStoreResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CREATING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "UPDATING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetVariantStoreResponse>> variantStoreDeletedWaiterAcceptors() {
        List<WaiterAcceptor<? super GetVariantStoreResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(errorCode(error),
                "ResourceNotFoundException")));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETING");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetWorkflowResponse>> workflowActiveWaiterAcceptors() {
        List<WaiterAcceptor<? super GetWorkflowResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CREATING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "UPDATING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration annotationImportJobCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration annotationStoreCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration annotationStoreDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration annotationStoreVersionCreatedWaiterConfig(
            WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration annotationStoreVersionDeletedWaiterConfig(
            WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration readSetActivationJobCompletedWaiterConfig(
            WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration readSetExportJobCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration readSetImportJobCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration referenceImportJobCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration runCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration runRunningWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration taskCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration taskRunningWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration variantImportJobCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration variantStoreCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration variantStoreDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration workflowActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(10);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(3)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    @Override
    public void close() {
        managedResources.close();
    }

    public static OmicsAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends OmicsRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    public static final class DefaultBuilder implements OmicsAsyncWaiter.Builder {
        private OmicsAsyncClient client;

        private WaiterOverrideConfiguration overrideConfiguration;

        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public OmicsAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public OmicsAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public OmicsAsyncWaiter.Builder client(OmicsAsyncClient client) {
            this.client = client;
            return this;
        }

        public OmicsAsyncWaiter build() {
            return new DefaultOmicsAsyncWaiter(this);
        }
    }
}
