/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAnnotationStoreRequest extends OmicsRequest implements
        ToCopyableBuilder<CreateAnnotationStoreRequest.Builder, CreateAnnotationStoreRequest> {
    private static final SdkField<ReferenceItem> REFERENCE_FIELD = SdkField.<ReferenceItem> builder(MarshallingType.SDK_POJO)
            .memberName("reference").getter(getter(CreateAnnotationStoreRequest::reference)).setter(setter(Builder::reference))
            .constructor(ReferenceItem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reference").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateAnnotationStoreRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateAnnotationStoreRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateAnnotationStoreRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionName").getter(getter(CreateAnnotationStoreRequest::versionName))
            .setter(setter(Builder::versionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionName").build()).build();

    private static final SdkField<SseConfig> SSE_CONFIG_FIELD = SdkField.<SseConfig> builder(MarshallingType.SDK_POJO)
            .memberName("sseConfig").getter(getter(CreateAnnotationStoreRequest::sseConfig)).setter(setter(Builder::sseConfig))
            .constructor(SseConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sseConfig").build()).build();

    private static final SdkField<String> STORE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storeFormat").getter(getter(CreateAnnotationStoreRequest::storeFormatAsString))
            .setter(setter(Builder::storeFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeFormat").build()).build();

    private static final SdkField<StoreOptions> STORE_OPTIONS_FIELD = SdkField.<StoreOptions> builder(MarshallingType.SDK_POJO)
            .memberName("storeOptions").getter(getter(CreateAnnotationStoreRequest::storeOptions))
            .setter(setter(Builder::storeOptions)).constructor(StoreOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERENCE_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, TAGS_FIELD, VERSION_NAME_FIELD, SSE_CONFIG_FIELD, STORE_FORMAT_FIELD, STORE_OPTIONS_FIELD));

    private final ReferenceItem reference;

    private final String name;

    private final String description;

    private final Map<String, String> tags;

    private final String versionName;

    private final SseConfig sseConfig;

    private final String storeFormat;

    private final StoreOptions storeOptions;

    private CreateAnnotationStoreRequest(BuilderImpl builder) {
        super(builder);
        this.reference = builder.reference;
        this.name = builder.name;
        this.description = builder.description;
        this.tags = builder.tags;
        this.versionName = builder.versionName;
        this.sseConfig = builder.sseConfig;
        this.storeFormat = builder.storeFormat;
        this.storeOptions = builder.storeOptions;
    }

    /**
     * <p>
     * The genome reference for the store's annotations.
     * </p>
     * 
     * @return The genome reference for the store's annotations.
     */
    public final ReferenceItem reference() {
        return reference;
    }

    /**
     * <p>
     * A name for the store.
     * </p>
     * 
     * @return A name for the store.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description for the store.
     * </p>
     * 
     * @return A description for the store.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags for the store.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags for the store.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The name given to an annotation store version to distinguish it from other versions.
     * </p>
     * 
     * @return The name given to an annotation store version to distinguish it from other versions.
     */
    public final String versionName() {
        return versionName;
    }

    /**
     * <p>
     * Server-side encryption (SSE) settings for the store.
     * </p>
     * 
     * @return Server-side encryption (SSE) settings for the store.
     */
    public final SseConfig sseConfig() {
        return sseConfig;
    }

    /**
     * <p>
     * The annotation file format of the store.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storeFormat} will
     * return {@link StoreFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storeFormatAsString}.
     * </p>
     * 
     * @return The annotation file format of the store.
     * @see StoreFormat
     */
    public final StoreFormat storeFormat() {
        return StoreFormat.fromValue(storeFormat);
    }

    /**
     * <p>
     * The annotation file format of the store.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storeFormat} will
     * return {@link StoreFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storeFormatAsString}.
     * </p>
     * 
     * @return The annotation file format of the store.
     * @see StoreFormat
     */
    public final String storeFormatAsString() {
        return storeFormat;
    }

    /**
     * <p>
     * File parsing options for the annotation store.
     * </p>
     * 
     * @return File parsing options for the annotation store.
     */
    public final StoreOptions storeOptions() {
        return storeOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reference());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(versionName());
        hashCode = 31 * hashCode + Objects.hashCode(sseConfig());
        hashCode = 31 * hashCode + Objects.hashCode(storeFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(storeOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnnotationStoreRequest)) {
            return false;
        }
        CreateAnnotationStoreRequest other = (CreateAnnotationStoreRequest) obj;
        return Objects.equals(reference(), other.reference()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(versionName(), other.versionName())
                && Objects.equals(sseConfig(), other.sseConfig())
                && Objects.equals(storeFormatAsString(), other.storeFormatAsString())
                && Objects.equals(storeOptions(), other.storeOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAnnotationStoreRequest").add("Reference", reference()).add("Name", name())
                .add("Description", description()).add("Tags", hasTags() ? tags() : null).add("VersionName", versionName())
                .add("SseConfig", sseConfig()).add("StoreFormat", storeFormatAsString()).add("StoreOptions", storeOptions())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "reference":
            return Optional.ofNullable(clazz.cast(reference()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "versionName":
            return Optional.ofNullable(clazz.cast(versionName()));
        case "sseConfig":
            return Optional.ofNullable(clazz.cast(sseConfig()));
        case "storeFormat":
            return Optional.ofNullable(clazz.cast(storeFormatAsString()));
        case "storeOptions":
            return Optional.ofNullable(clazz.cast(storeOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAnnotationStoreRequest, T> g) {
        return obj -> g.apply((CreateAnnotationStoreRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAnnotationStoreRequest> {
        /**
         * <p>
         * The genome reference for the store's annotations.
         * </p>
         * 
         * @param reference
         *        The genome reference for the store's annotations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reference(ReferenceItem reference);

        /**
         * <p>
         * The genome reference for the store's annotations.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReferenceItem.Builder} avoiding the need
         * to create one manually via {@link ReferenceItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReferenceItem.Builder#build()} is called immediately and its
         * result is passed to {@link #reference(ReferenceItem)}.
         * 
         * @param reference
         *        a consumer that will call methods on {@link ReferenceItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reference(ReferenceItem)
         */
        default Builder reference(Consumer<ReferenceItem.Builder> reference) {
            return reference(ReferenceItem.builder().applyMutation(reference).build());
        }

        /**
         * <p>
         * A name for the store.
         * </p>
         * 
         * @param name
         *        A name for the store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description for the store.
         * </p>
         * 
         * @param description
         *        A description for the store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Tags for the store.
         * </p>
         * 
         * @param tags
         *        Tags for the store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The name given to an annotation store version to distinguish it from other versions.
         * </p>
         * 
         * @param versionName
         *        The name given to an annotation store version to distinguish it from other versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionName(String versionName);

        /**
         * <p>
         * Server-side encryption (SSE) settings for the store.
         * </p>
         * 
         * @param sseConfig
         *        Server-side encryption (SSE) settings for the store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseConfig(SseConfig sseConfig);

        /**
         * <p>
         * Server-side encryption (SSE) settings for the store.
         * </p>
         * This is a convenience method that creates an instance of the {@link SseConfig.Builder} avoiding the need to
         * create one manually via {@link SseConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SseConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #sseConfig(SseConfig)}.
         * 
         * @param sseConfig
         *        a consumer that will call methods on {@link SseConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sseConfig(SseConfig)
         */
        default Builder sseConfig(Consumer<SseConfig.Builder> sseConfig) {
            return sseConfig(SseConfig.builder().applyMutation(sseConfig).build());
        }

        /**
         * <p>
         * The annotation file format of the store.
         * </p>
         * 
         * @param storeFormat
         *        The annotation file format of the store.
         * @see StoreFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StoreFormat
         */
        Builder storeFormat(String storeFormat);

        /**
         * <p>
         * The annotation file format of the store.
         * </p>
         * 
         * @param storeFormat
         *        The annotation file format of the store.
         * @see StoreFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StoreFormat
         */
        Builder storeFormat(StoreFormat storeFormat);

        /**
         * <p>
         * File parsing options for the annotation store.
         * </p>
         * 
         * @param storeOptions
         *        File parsing options for the annotation store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storeOptions(StoreOptions storeOptions);

        /**
         * <p>
         * File parsing options for the annotation store.
         * </p>
         * This is a convenience method that creates an instance of the {@link StoreOptions.Builder} avoiding the need
         * to create one manually via {@link StoreOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StoreOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #storeOptions(StoreOptions)}.
         * 
         * @param storeOptions
         *        a consumer that will call methods on {@link StoreOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storeOptions(StoreOptions)
         */
        default Builder storeOptions(Consumer<StoreOptions.Builder> storeOptions) {
            return storeOptions(StoreOptions.builder().applyMutation(storeOptions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private ReferenceItem reference;

        private String name;

        private String description;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String versionName;

        private SseConfig sseConfig;

        private String storeFormat;

        private StoreOptions storeOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAnnotationStoreRequest model) {
            super(model);
            reference(model.reference);
            name(model.name);
            description(model.description);
            tags(model.tags);
            versionName(model.versionName);
            sseConfig(model.sseConfig);
            storeFormat(model.storeFormat);
            storeOptions(model.storeOptions);
        }

        public final ReferenceItem.Builder getReference() {
            return reference != null ? reference.toBuilder() : null;
        }

        public final void setReference(ReferenceItem.BuilderImpl reference) {
            this.reference = reference != null ? reference.build() : null;
        }

        @Override
        public final Builder reference(ReferenceItem reference) {
            this.reference = reference;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getVersionName() {
            return versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final SseConfig.Builder getSseConfig() {
            return sseConfig != null ? sseConfig.toBuilder() : null;
        }

        public final void setSseConfig(SseConfig.BuilderImpl sseConfig) {
            this.sseConfig = sseConfig != null ? sseConfig.build() : null;
        }

        @Override
        public final Builder sseConfig(SseConfig sseConfig) {
            this.sseConfig = sseConfig;
            return this;
        }

        public final String getStoreFormat() {
            return storeFormat;
        }

        public final void setStoreFormat(String storeFormat) {
            this.storeFormat = storeFormat;
        }

        @Override
        public final Builder storeFormat(String storeFormat) {
            this.storeFormat = storeFormat;
            return this;
        }

        @Override
        public final Builder storeFormat(StoreFormat storeFormat) {
            this.storeFormat(storeFormat == null ? null : storeFormat.toString());
            return this;
        }

        public final StoreOptions.Builder getStoreOptions() {
            return storeOptions != null ? storeOptions.toBuilder() : null;
        }

        public final void setStoreOptions(StoreOptions.BuilderImpl storeOptions) {
            this.storeOptions = storeOptions != null ? storeOptions.build() : null;
        }

        @Override
        public final Builder storeOptions(StoreOptions storeOptions) {
            this.storeOptions = storeOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAnnotationStoreRequest build() {
            return new CreateAnnotationStoreRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
