/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An annotation import job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnnotationImportJobItem implements SdkPojo, Serializable,
        ToCopyableBuilder<AnnotationImportJobItem.Builder, AnnotationImportJobItem> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AnnotationImportJobItem::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationName").getter(getter(AnnotationImportJobItem::destinationName))
            .setter(setter(Builder::destinationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationName").build()).build();

    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionName").getter(getter(AnnotationImportJobItem::versionName)).setter(setter(Builder::versionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionName").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(AnnotationImportJobItem::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AnnotationImportJobItem::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(AnnotationImportJobItem::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime")
            .getter(getter(AnnotationImportJobItem::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("completionTime")
            .getter(getter(AnnotationImportJobItem::completionTime))
            .setter(setter(Builder::completionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completionTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Boolean> RUN_LEFT_NORMALIZATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("runLeftNormalization").getter(getter(AnnotationImportJobItem::runLeftNormalization))
            .setter(setter(Builder::runLeftNormalization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runLeftNormalization").build())
            .build();

    private static final SdkField<Map<String, String>> ANNOTATION_FIELDS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("annotationFields")
            .getter(getter(AnnotationImportJobItem::annotationFields))
            .setter(setter(Builder::annotationFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("annotationFields").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            DESTINATION_NAME_FIELD, VERSION_NAME_FIELD, ROLE_ARN_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, UPDATE_TIME_FIELD,
            COMPLETION_TIME_FIELD, RUN_LEFT_NORMALIZATION_FIELD, ANNOTATION_FIELDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String destinationName;

    private final String versionName;

    private final String roleArn;

    private final String status;

    private final Instant creationTime;

    private final Instant updateTime;

    private final Instant completionTime;

    private final Boolean runLeftNormalization;

    private final Map<String, String> annotationFields;

    private AnnotationImportJobItem(BuilderImpl builder) {
        this.id = builder.id;
        this.destinationName = builder.destinationName;
        this.versionName = builder.versionName;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.updateTime = builder.updateTime;
        this.completionTime = builder.completionTime;
        this.runLeftNormalization = builder.runLeftNormalization;
        this.annotationFields = builder.annotationFields;
    }

    /**
     * <p>
     * The job's ID.
     * </p>
     * 
     * @return The job's ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The job's destination annotation store.
     * </p>
     * 
     * @return The job's destination annotation store.
     */
    public final String destinationName() {
        return destinationName;
    }

    /**
     * <p>
     * The name of the annotation store version.
     * </p>
     * 
     * @return The name of the annotation store version.
     */
    public final String versionName() {
        return versionName;
    }

    /**
     * <p>
     * The job's service role ARN.
     * </p>
     * 
     * @return The job's service role ARN.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The job's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The job's status.
     * @see JobStatus
     */
    public final JobStatus status() {
        return JobStatus.fromValue(status);
    }

    /**
     * <p>
     * The job's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The job's status.
     * @see JobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * When the job was created.
     * </p>
     * 
     * @return When the job was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * When the job was updated.
     * </p>
     * 
     * @return When the job was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * When the job completed.
     * </p>
     * 
     * @return When the job completed.
     */
    public final Instant completionTime() {
        return completionTime;
    }

    /**
     * <p>
     * The job's left normalization setting.
     * </p>
     * 
     * @return The job's left normalization setting.
     */
    public final Boolean runLeftNormalization() {
        return runLeftNormalization;
    }

    /**
     * For responses, this returns true if the service returned a value for the AnnotationFields property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAnnotationFields() {
        return annotationFields != null && !(annotationFields instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The annotation schema generated by the parsed annotation data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnnotationFields} method.
     * </p>
     * 
     * @return The annotation schema generated by the parsed annotation data.
     */
    public final Map<String, String> annotationFields() {
        return annotationFields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(versionName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(runLeftNormalization());
        hashCode = 31 * hashCode + Objects.hashCode(hasAnnotationFields() ? annotationFields() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnnotationImportJobItem)) {
            return false;
        }
        AnnotationImportJobItem other = (AnnotationImportJobItem) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(destinationName(), other.destinationName())
                && Objects.equals(versionName(), other.versionName()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(completionTime(), other.completionTime())
                && Objects.equals(runLeftNormalization(), other.runLeftNormalization())
                && hasAnnotationFields() == other.hasAnnotationFields()
                && Objects.equals(annotationFields(), other.annotationFields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnnotationImportJobItem").add("Id", id()).add("DestinationName", destinationName())
                .add("VersionName", versionName()).add("RoleArn", roleArn()).add("Status", statusAsString())
                .add("CreationTime", creationTime()).add("UpdateTime", updateTime()).add("CompletionTime", completionTime())
                .add("RunLeftNormalization", runLeftNormalization())
                .add("AnnotationFields", hasAnnotationFields() ? annotationFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "destinationName":
            return Optional.ofNullable(clazz.cast(destinationName()));
        case "versionName":
            return Optional.ofNullable(clazz.cast(versionName()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "completionTime":
            return Optional.ofNullable(clazz.cast(completionTime()));
        case "runLeftNormalization":
            return Optional.ofNullable(clazz.cast(runLeftNormalization()));
        case "annotationFields":
            return Optional.ofNullable(clazz.cast(annotationFields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("destinationName", DESTINATION_NAME_FIELD);
        map.put("versionName", VERSION_NAME_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("completionTime", COMPLETION_TIME_FIELD);
        map.put("runLeftNormalization", RUN_LEFT_NORMALIZATION_FIELD);
        map.put("annotationFields", ANNOTATION_FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnnotationImportJobItem, T> g) {
        return obj -> g.apply((AnnotationImportJobItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnnotationImportJobItem> {
        /**
         * <p>
         * The job's ID.
         * </p>
         * 
         * @param id
         *        The job's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The job's destination annotation store.
         * </p>
         * 
         * @param destinationName
         *        The job's destination annotation store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationName(String destinationName);

        /**
         * <p>
         * The name of the annotation store version.
         * </p>
         * 
         * @param versionName
         *        The name of the annotation store version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionName(String versionName);

        /**
         * <p>
         * The job's service role ARN.
         * </p>
         * 
         * @param roleArn
         *        The job's service role ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The job's status.
         * </p>
         * 
         * @param status
         *        The job's status.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The job's status.
         * </p>
         * 
         * @param status
         *        The job's status.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(JobStatus status);

        /**
         * <p>
         * When the job was created.
         * </p>
         * 
         * @param creationTime
         *        When the job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * When the job was updated.
         * </p>
         * 
         * @param updateTime
         *        When the job was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * When the job completed.
         * </p>
         * 
         * @param completionTime
         *        When the job completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTime(Instant completionTime);

        /**
         * <p>
         * The job's left normalization setting.
         * </p>
         * 
         * @param runLeftNormalization
         *        The job's left normalization setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runLeftNormalization(Boolean runLeftNormalization);

        /**
         * <p>
         * The annotation schema generated by the parsed annotation data.
         * </p>
         * 
         * @param annotationFields
         *        The annotation schema generated by the parsed annotation data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotationFields(Map<String, String> annotationFields);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String destinationName;

        private String versionName;

        private String roleArn;

        private String status;

        private Instant creationTime;

        private Instant updateTime;

        private Instant completionTime;

        private Boolean runLeftNormalization;

        private Map<String, String> annotationFields = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnnotationImportJobItem model) {
            id(model.id);
            destinationName(model.destinationName);
            versionName(model.versionName);
            roleArn(model.roleArn);
            status(model.status);
            creationTime(model.creationTime);
            updateTime(model.updateTime);
            completionTime(model.completionTime);
            runLeftNormalization(model.runLeftNormalization);
            annotationFields(model.annotationFields);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDestinationName() {
            return destinationName;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final String getVersionName() {
            return versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final Boolean getRunLeftNormalization() {
            return runLeftNormalization;
        }

        public final void setRunLeftNormalization(Boolean runLeftNormalization) {
            this.runLeftNormalization = runLeftNormalization;
        }

        @Override
        public final Builder runLeftNormalization(Boolean runLeftNormalization) {
            this.runLeftNormalization = runLeftNormalization;
            return this;
        }

        public final Map<String, String> getAnnotationFields() {
            if (annotationFields instanceof SdkAutoConstructMap) {
                return null;
            }
            return annotationFields;
        }

        public final void setAnnotationFields(Map<String, String> annotationFields) {
            this.annotationFields = AnnotationFieldMapCopier.copy(annotationFields);
        }

        @Override
        public final Builder annotationFields(Map<String, String> annotationFields) {
            this.annotationFields = AnnotationFieldMapCopier.copy(annotationFields);
            return this;
        }

        @Override
        public AnnotationImportJobItem build() {
            return new AnnotationImportJobItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
