/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An annotation store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnnotationStoreItem implements SdkPojo, Serializable,
        ToCopyableBuilder<AnnotationStoreItem.Builder, AnnotationStoreItem> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AnnotationStoreItem::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<ReferenceItem> REFERENCE_FIELD = SdkField.<ReferenceItem> builder(MarshallingType.SDK_POJO)
            .memberName("reference").getter(getter(AnnotationStoreItem::reference)).setter(setter(Builder::reference))
            .constructor(ReferenceItem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reference").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AnnotationStoreItem::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STORE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storeArn").getter(getter(AnnotationStoreItem::storeArn)).setter(setter(Builder::storeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AnnotationStoreItem::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STORE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storeFormat").getter(getter(AnnotationStoreItem::storeFormatAsString))
            .setter(setter(Builder::storeFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeFormat").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AnnotationStoreItem::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<SseConfig> SSE_CONFIG_FIELD = SdkField.<SseConfig> builder(MarshallingType.SDK_POJO)
            .memberName("sseConfig").getter(getter(AnnotationStoreItem::sseConfig)).setter(setter(Builder::sseConfig))
            .constructor(SseConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sseConfig").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(AnnotationStoreItem::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime")
            .getter(getter(AnnotationStoreItem::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(AnnotationStoreItem::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<Long> STORE_SIZE_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("storeSizeBytes").getter(getter(AnnotationStoreItem::storeSizeBytes))
            .setter(setter(Builder::storeSizeBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeSizeBytes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, REFERENCE_FIELD,
            STATUS_FIELD, STORE_ARN_FIELD, NAME_FIELD, STORE_FORMAT_FIELD, DESCRIPTION_FIELD, SSE_CONFIG_FIELD,
            CREATION_TIME_FIELD, UPDATE_TIME_FIELD, STATUS_MESSAGE_FIELD, STORE_SIZE_BYTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final ReferenceItem reference;

    private final String status;

    private final String storeArn;

    private final String name;

    private final String storeFormat;

    private final String description;

    private final SseConfig sseConfig;

    private final Instant creationTime;

    private final Instant updateTime;

    private final String statusMessage;

    private final Long storeSizeBytes;

    private AnnotationStoreItem(BuilderImpl builder) {
        this.id = builder.id;
        this.reference = builder.reference;
        this.status = builder.status;
        this.storeArn = builder.storeArn;
        this.name = builder.name;
        this.storeFormat = builder.storeFormat;
        this.description = builder.description;
        this.sseConfig = builder.sseConfig;
        this.creationTime = builder.creationTime;
        this.updateTime = builder.updateTime;
        this.statusMessage = builder.statusMessage;
        this.storeSizeBytes = builder.storeSizeBytes;
    }

    /**
     * <p>
     * The store's ID.
     * </p>
     * 
     * @return The store's ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The store's genome reference.
     * </p>
     * 
     * @return The store's genome reference.
     */
    public final ReferenceItem reference() {
        return reference;
    }

    /**
     * <p>
     * The store's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StoreStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The store's status.
     * @see StoreStatus
     */
    public final StoreStatus status() {
        return StoreStatus.fromValue(status);
    }

    /**
     * <p>
     * The store's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StoreStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The store's status.
     * @see StoreStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The store's ARN.
     * </p>
     * 
     * @return The store's ARN.
     */
    public final String storeArn() {
        return storeArn;
    }

    /**
     * <p>
     * The store's name.
     * </p>
     * 
     * @return The store's name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The store's file format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storeFormat} will
     * return {@link StoreFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storeFormatAsString}.
     * </p>
     * 
     * @return The store's file format.
     * @see StoreFormat
     */
    public final StoreFormat storeFormat() {
        return StoreFormat.fromValue(storeFormat);
    }

    /**
     * <p>
     * The store's file format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storeFormat} will
     * return {@link StoreFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storeFormatAsString}.
     * </p>
     * 
     * @return The store's file format.
     * @see StoreFormat
     */
    public final String storeFormatAsString() {
        return storeFormat;
    }

    /**
     * <p>
     * The store's description.
     * </p>
     * 
     * @return The store's description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The store's server-side encryption (SSE) settings.
     * </p>
     * 
     * @return The store's server-side encryption (SSE) settings.
     */
    public final SseConfig sseConfig() {
        return sseConfig;
    }

    /**
     * <p>
     * The store's creation time.
     * </p>
     * 
     * @return The store's creation time.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * When the store was updated.
     * </p>
     * 
     * @return When the store was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The store's status message.
     * </p>
     * 
     * @return The store's status message.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The store's size in bytes.
     * </p>
     * 
     * @return The store's size in bytes.
     */
    public final Long storeSizeBytes() {
        return storeSizeBytes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(reference());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(storeArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(storeFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(sseConfig());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(storeSizeBytes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnnotationStoreItem)) {
            return false;
        }
        AnnotationStoreItem other = (AnnotationStoreItem) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(reference(), other.reference())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(storeArn(), other.storeArn())
                && Objects.equals(name(), other.name()) && Objects.equals(storeFormatAsString(), other.storeFormatAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(sseConfig(), other.sseConfig())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(storeSizeBytes(), other.storeSizeBytes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnnotationStoreItem").add("Id", id()).add("Reference", reference())
                .add("Status", statusAsString()).add("StoreArn", storeArn()).add("Name", name())
                .add("StoreFormat", storeFormatAsString()).add("Description", description()).add("SseConfig", sseConfig())
                .add("CreationTime", creationTime()).add("UpdateTime", updateTime()).add("StatusMessage", statusMessage())
                .add("StoreSizeBytes", storeSizeBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "reference":
            return Optional.ofNullable(clazz.cast(reference()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "storeArn":
            return Optional.ofNullable(clazz.cast(storeArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "storeFormat":
            return Optional.ofNullable(clazz.cast(storeFormatAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "sseConfig":
            return Optional.ofNullable(clazz.cast(sseConfig()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "storeSizeBytes":
            return Optional.ofNullable(clazz.cast(storeSizeBytes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("reference", REFERENCE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("storeArn", STORE_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("storeFormat", STORE_FORMAT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("sseConfig", SSE_CONFIG_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        map.put("storeSizeBytes", STORE_SIZE_BYTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnnotationStoreItem, T> g) {
        return obj -> g.apply((AnnotationStoreItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnnotationStoreItem> {
        /**
         * <p>
         * The store's ID.
         * </p>
         * 
         * @param id
         *        The store's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The store's genome reference.
         * </p>
         * 
         * @param reference
         *        The store's genome reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reference(ReferenceItem reference);

        /**
         * <p>
         * The store's genome reference.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReferenceItem.Builder} avoiding the need
         * to create one manually via {@link ReferenceItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReferenceItem.Builder#build()} is called immediately and its
         * result is passed to {@link #reference(ReferenceItem)}.
         * 
         * @param reference
         *        a consumer that will call methods on {@link ReferenceItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reference(ReferenceItem)
         */
        default Builder reference(Consumer<ReferenceItem.Builder> reference) {
            return reference(ReferenceItem.builder().applyMutation(reference).build());
        }

        /**
         * <p>
         * The store's status.
         * </p>
         * 
         * @param status
         *        The store's status.
         * @see StoreStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StoreStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The store's status.
         * </p>
         * 
         * @param status
         *        The store's status.
         * @see StoreStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StoreStatus
         */
        Builder status(StoreStatus status);

        /**
         * <p>
         * The store's ARN.
         * </p>
         * 
         * @param storeArn
         *        The store's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storeArn(String storeArn);

        /**
         * <p>
         * The store's name.
         * </p>
         * 
         * @param name
         *        The store's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The store's file format.
         * </p>
         * 
         * @param storeFormat
         *        The store's file format.
         * @see StoreFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StoreFormat
         */
        Builder storeFormat(String storeFormat);

        /**
         * <p>
         * The store's file format.
         * </p>
         * 
         * @param storeFormat
         *        The store's file format.
         * @see StoreFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StoreFormat
         */
        Builder storeFormat(StoreFormat storeFormat);

        /**
         * <p>
         * The store's description.
         * </p>
         * 
         * @param description
         *        The store's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The store's server-side encryption (SSE) settings.
         * </p>
         * 
         * @param sseConfig
         *        The store's server-side encryption (SSE) settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseConfig(SseConfig sseConfig);

        /**
         * <p>
         * The store's server-side encryption (SSE) settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link SseConfig.Builder} avoiding the need to
         * create one manually via {@link SseConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SseConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #sseConfig(SseConfig)}.
         * 
         * @param sseConfig
         *        a consumer that will call methods on {@link SseConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sseConfig(SseConfig)
         */
        default Builder sseConfig(Consumer<SseConfig.Builder> sseConfig) {
            return sseConfig(SseConfig.builder().applyMutation(sseConfig).build());
        }

        /**
         * <p>
         * The store's creation time.
         * </p>
         * 
         * @param creationTime
         *        The store's creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * When the store was updated.
         * </p>
         * 
         * @param updateTime
         *        When the store was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The store's status message.
         * </p>
         * 
         * @param statusMessage
         *        The store's status message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The store's size in bytes.
         * </p>
         * 
         * @param storeSizeBytes
         *        The store's size in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storeSizeBytes(Long storeSizeBytes);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private ReferenceItem reference;

        private String status;

        private String storeArn;

        private String name;

        private String storeFormat;

        private String description;

        private SseConfig sseConfig;

        private Instant creationTime;

        private Instant updateTime;

        private String statusMessage;

        private Long storeSizeBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(AnnotationStoreItem model) {
            id(model.id);
            reference(model.reference);
            status(model.status);
            storeArn(model.storeArn);
            name(model.name);
            storeFormat(model.storeFormat);
            description(model.description);
            sseConfig(model.sseConfig);
            creationTime(model.creationTime);
            updateTime(model.updateTime);
            statusMessage(model.statusMessage);
            storeSizeBytes(model.storeSizeBytes);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final ReferenceItem.Builder getReference() {
            return reference != null ? reference.toBuilder() : null;
        }

        public final void setReference(ReferenceItem.BuilderImpl reference) {
            this.reference = reference != null ? reference.build() : null;
        }

        @Override
        public final Builder reference(ReferenceItem reference) {
            this.reference = reference;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StoreStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStoreArn() {
            return storeArn;
        }

        public final void setStoreArn(String storeArn) {
            this.storeArn = storeArn;
        }

        @Override
        public final Builder storeArn(String storeArn) {
            this.storeArn = storeArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStoreFormat() {
            return storeFormat;
        }

        public final void setStoreFormat(String storeFormat) {
            this.storeFormat = storeFormat;
        }

        @Override
        public final Builder storeFormat(String storeFormat) {
            this.storeFormat = storeFormat;
            return this;
        }

        @Override
        public final Builder storeFormat(StoreFormat storeFormat) {
            this.storeFormat(storeFormat == null ? null : storeFormat.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final SseConfig.Builder getSseConfig() {
            return sseConfig != null ? sseConfig.toBuilder() : null;
        }

        public final void setSseConfig(SseConfig.BuilderImpl sseConfig) {
            this.sseConfig = sseConfig != null ? sseConfig.build() : null;
        }

        @Override
        public final Builder sseConfig(SseConfig sseConfig) {
            this.sseConfig = sseConfig;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Long getStoreSizeBytes() {
            return storeSizeBytes;
        }

        public final void setStoreSizeBytes(Long storeSizeBytes) {
            this.storeSizeBytes = storeSizeBytes;
        }

        @Override
        public final Builder storeSizeBytes(Long storeSizeBytes) {
            this.storeSizeBytes = storeSizeBytes;
            return this;
        }

        @Override
        public AnnotationStoreItem build() {
            return new AnnotationStoreItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
