/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompleteMultipartReadSetUploadRequest extends OmicsRequest implements
        ToCopyableBuilder<CompleteMultipartReadSetUploadRequest.Builder, CompleteMultipartReadSetUploadRequest> {
    private static final SdkField<String> SEQUENCE_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sequenceStoreId").getter(getter(CompleteMultipartReadSetUploadRequest::sequenceStoreId))
            .setter(setter(Builder::sequenceStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sequenceStoreId").build()).build();

    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("uploadId").getter(getter(CompleteMultipartReadSetUploadRequest::uploadId))
            .setter(setter(Builder::uploadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("uploadId").build()).build();

    private static final SdkField<List<CompleteReadSetUploadPartListItem>> PARTS_FIELD = SdkField
            .<List<CompleteReadSetUploadPartListItem>> builder(MarshallingType.LIST)
            .memberName("parts")
            .getter(getter(CompleteMultipartReadSetUploadRequest::parts))
            .setter(setter(Builder::parts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CompleteReadSetUploadPartListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(CompleteReadSetUploadPartListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEQUENCE_STORE_ID_FIELD,
            UPLOAD_ID_FIELD, PARTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sequenceStoreId;

    private final String uploadId;

    private final List<CompleteReadSetUploadPartListItem> parts;

    private CompleteMultipartReadSetUploadRequest(BuilderImpl builder) {
        super(builder);
        this.sequenceStoreId = builder.sequenceStoreId;
        this.uploadId = builder.uploadId;
        this.parts = builder.parts;
    }

    /**
     * <p>
     * The sequence store ID for the store involved in the multipart upload.
     * </p>
     * 
     * @return The sequence store ID for the store involved in the multipart upload.
     */
    public final String sequenceStoreId() {
        return sequenceStoreId;
    }

    /**
     * <p>
     * The ID for the multipart upload.
     * </p>
     * 
     * @return The ID for the multipart upload.
     */
    public final String uploadId() {
        return uploadId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parts property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasParts() {
        return parts != null && !(parts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The individual uploads or parts of a multipart upload.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParts} method.
     * </p>
     * 
     * @return The individual uploads or parts of a multipart upload.
     */
    public final List<CompleteReadSetUploadPartListItem> parts() {
        return parts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sequenceStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(hasParts() ? parts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompleteMultipartReadSetUploadRequest)) {
            return false;
        }
        CompleteMultipartReadSetUploadRequest other = (CompleteMultipartReadSetUploadRequest) obj;
        return Objects.equals(sequenceStoreId(), other.sequenceStoreId()) && Objects.equals(uploadId(), other.uploadId())
                && hasParts() == other.hasParts() && Objects.equals(parts(), other.parts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CompleteMultipartReadSetUploadRequest").add("SequenceStoreId", sequenceStoreId())
                .add("UploadId", uploadId()).add("Parts", hasParts() ? parts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sequenceStoreId":
            return Optional.ofNullable(clazz.cast(sequenceStoreId()));
        case "uploadId":
            return Optional.ofNullable(clazz.cast(uploadId()));
        case "parts":
            return Optional.ofNullable(clazz.cast(parts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sequenceStoreId", SEQUENCE_STORE_ID_FIELD);
        map.put("uploadId", UPLOAD_ID_FIELD);
        map.put("parts", PARTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CompleteMultipartReadSetUploadRequest, T> g) {
        return obj -> g.apply((CompleteMultipartReadSetUploadRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CompleteMultipartReadSetUploadRequest> {
        /**
         * <p>
         * The sequence store ID for the store involved in the multipart upload.
         * </p>
         * 
         * @param sequenceStoreId
         *        The sequence store ID for the store involved in the multipart upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceStoreId(String sequenceStoreId);

        /**
         * <p>
         * The ID for the multipart upload.
         * </p>
         * 
         * @param uploadId
         *        The ID for the multipart upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadId(String uploadId);

        /**
         * <p>
         * The individual uploads or parts of a multipart upload.
         * </p>
         * 
         * @param parts
         *        The individual uploads or parts of a multipart upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parts(Collection<CompleteReadSetUploadPartListItem> parts);

        /**
         * <p>
         * The individual uploads or parts of a multipart upload.
         * </p>
         * 
         * @param parts
         *        The individual uploads or parts of a multipart upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parts(CompleteReadSetUploadPartListItem... parts);

        /**
         * <p>
         * The individual uploads or parts of a multipart upload.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.omics.model.CompleteReadSetUploadPartListItem.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.omics.model.CompleteReadSetUploadPartListItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.omics.model.CompleteReadSetUploadPartListItem.Builder#build()} is
         * called immediately and its result is passed to {@link #parts(List<CompleteReadSetUploadPartListItem>)}.
         * 
         * @param parts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.omics.model.CompleteReadSetUploadPartListItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parts(java.util.Collection<CompleteReadSetUploadPartListItem>)
         */
        Builder parts(Consumer<CompleteReadSetUploadPartListItem.Builder>... parts);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private String sequenceStoreId;

        private String uploadId;

        private List<CompleteReadSetUploadPartListItem> parts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CompleteMultipartReadSetUploadRequest model) {
            super(model);
            sequenceStoreId(model.sequenceStoreId);
            uploadId(model.uploadId);
            parts(model.parts);
        }

        public final String getSequenceStoreId() {
            return sequenceStoreId;
        }

        public final void setSequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
        }

        @Override
        public final Builder sequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
            return this;
        }

        public final String getUploadId() {
            return uploadId;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final List<CompleteReadSetUploadPartListItem.Builder> getParts() {
            List<CompleteReadSetUploadPartListItem.Builder> result = CompleteReadSetUploadPartListCopier
                    .copyToBuilder(this.parts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParts(Collection<CompleteReadSetUploadPartListItem.BuilderImpl> parts) {
            this.parts = CompleteReadSetUploadPartListCopier.copyFromBuilder(parts);
        }

        @Override
        public final Builder parts(Collection<CompleteReadSetUploadPartListItem> parts) {
            this.parts = CompleteReadSetUploadPartListCopier.copy(parts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parts(CompleteReadSetUploadPartListItem... parts) {
            parts(Arrays.asList(parts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parts(Consumer<CompleteReadSetUploadPartListItem.Builder>... parts) {
            parts(Stream.of(parts).map(c -> CompleteReadSetUploadPartListItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CompleteMultipartReadSetUploadRequest build() {
            return new CompleteMultipartReadSetUploadRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
