/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMultipartReadSetUploadRequest extends OmicsRequest implements
        ToCopyableBuilder<CreateMultipartReadSetUploadRequest.Builder, CreateMultipartReadSetUploadRequest> {
    private static final SdkField<String> SEQUENCE_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sequenceStoreId").getter(getter(CreateMultipartReadSetUploadRequest::sequenceStoreId))
            .setter(setter(Builder::sequenceStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sequenceStoreId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientToken").getter(getter(CreateMultipartReadSetUploadRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final SdkField<String> SOURCE_FILE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceFileType").getter(getter(CreateMultipartReadSetUploadRequest::sourceFileTypeAsString))
            .setter(setter(Builder::sourceFileType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFileType").build()).build();

    private static final SdkField<String> SUBJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subjectId").getter(getter(CreateMultipartReadSetUploadRequest::subjectId))
            .setter(setter(Builder::subjectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subjectId").build()).build();

    private static final SdkField<String> SAMPLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sampleId").getter(getter(CreateMultipartReadSetUploadRequest::sampleId))
            .setter(setter(Builder::sampleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleId").build()).build();

    private static final SdkField<String> GENERATED_FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("generatedFrom").getter(getter(CreateMultipartReadSetUploadRequest::generatedFrom))
            .setter(setter(Builder::generatedFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedFrom").build()).build();

    private static final SdkField<String> REFERENCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("referenceArn").getter(getter(CreateMultipartReadSetUploadRequest::referenceArn))
            .setter(setter(Builder::referenceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateMultipartReadSetUploadRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateMultipartReadSetUploadRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateMultipartReadSetUploadRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEQUENCE_STORE_ID_FIELD,
            CLIENT_TOKEN_FIELD, SOURCE_FILE_TYPE_FIELD, SUBJECT_ID_FIELD, SAMPLE_ID_FIELD, GENERATED_FROM_FIELD,
            REFERENCE_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sequenceStoreId;

    private final String clientToken;

    private final String sourceFileType;

    private final String subjectId;

    private final String sampleId;

    private final String generatedFrom;

    private final String referenceArn;

    private final String name;

    private final String description;

    private final Map<String, String> tags;

    private CreateMultipartReadSetUploadRequest(BuilderImpl builder) {
        super(builder);
        this.sequenceStoreId = builder.sequenceStoreId;
        this.clientToken = builder.clientToken;
        this.sourceFileType = builder.sourceFileType;
        this.subjectId = builder.subjectId;
        this.sampleId = builder.sampleId;
        this.generatedFrom = builder.generatedFrom;
        this.referenceArn = builder.referenceArn;
        this.name = builder.name;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The sequence store ID for the store that is the destination of the multipart uploads.
     * </p>
     * 
     * @return The sequence store ID for the store that is the destination of the multipart uploads.
     */
    public final String sequenceStoreId() {
        return sequenceStoreId;
    }

    /**
     * <p>
     * An idempotency token that can be used to avoid triggering multiple multipart uploads.
     * </p>
     * 
     * @return An idempotency token that can be used to avoid triggering multiple multipart uploads.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The type of file being uploaded.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceFileType}
     * will return {@link FileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceFileTypeAsString}.
     * </p>
     * 
     * @return The type of file being uploaded.
     * @see FileType
     */
    public final FileType sourceFileType() {
        return FileType.fromValue(sourceFileType);
    }

    /**
     * <p>
     * The type of file being uploaded.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceFileType}
     * will return {@link FileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceFileTypeAsString}.
     * </p>
     * 
     * @return The type of file being uploaded.
     * @see FileType
     */
    public final String sourceFileTypeAsString() {
        return sourceFileType;
    }

    /**
     * <p>
     * The source's subject ID.
     * </p>
     * 
     * @return The source's subject ID.
     */
    public final String subjectId() {
        return subjectId;
    }

    /**
     * <p>
     * The source's sample ID.
     * </p>
     * 
     * @return The source's sample ID.
     */
    public final String sampleId() {
        return sampleId;
    }

    /**
     * <p>
     * Where the source originated.
     * </p>
     * 
     * @return Where the source originated.
     */
    public final String generatedFrom() {
        return generatedFrom;
    }

    /**
     * <p>
     * The ARN of the reference.
     * </p>
     * 
     * @return The ARN of the reference.
     */
    public final String referenceArn() {
        return referenceArn;
    }

    /**
     * <p>
     * The name of the read set.
     * </p>
     * 
     * @return The name of the read set.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the read set.
     * </p>
     * 
     * @return The description of the read set.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Any tags to add to the read set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Any tags to add to the read set.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sequenceStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(sourceFileTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subjectId());
        hashCode = 31 * hashCode + Objects.hashCode(sampleId());
        hashCode = 31 * hashCode + Objects.hashCode(generatedFrom());
        hashCode = 31 * hashCode + Objects.hashCode(referenceArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMultipartReadSetUploadRequest)) {
            return false;
        }
        CreateMultipartReadSetUploadRequest other = (CreateMultipartReadSetUploadRequest) obj;
        return Objects.equals(sequenceStoreId(), other.sequenceStoreId()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(sourceFileTypeAsString(), other.sourceFileTypeAsString())
                && Objects.equals(subjectId(), other.subjectId()) && Objects.equals(sampleId(), other.sampleId())
                && Objects.equals(generatedFrom(), other.generatedFrom()) && Objects.equals(referenceArn(), other.referenceArn())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMultipartReadSetUploadRequest").add("SequenceStoreId", sequenceStoreId())
                .add("ClientToken", clientToken()).add("SourceFileType", sourceFileTypeAsString()).add("SubjectId", subjectId())
                .add("SampleId", sampleId()).add("GeneratedFrom", generatedFrom()).add("ReferenceArn", referenceArn())
                .add("Name", name()).add("Description", description()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sequenceStoreId":
            return Optional.ofNullable(clazz.cast(sequenceStoreId()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "sourceFileType":
            return Optional.ofNullable(clazz.cast(sourceFileTypeAsString()));
        case "subjectId":
            return Optional.ofNullable(clazz.cast(subjectId()));
        case "sampleId":
            return Optional.ofNullable(clazz.cast(sampleId()));
        case "generatedFrom":
            return Optional.ofNullable(clazz.cast(generatedFrom()));
        case "referenceArn":
            return Optional.ofNullable(clazz.cast(referenceArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sequenceStoreId", SEQUENCE_STORE_ID_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("sourceFileType", SOURCE_FILE_TYPE_FIELD);
        map.put("subjectId", SUBJECT_ID_FIELD);
        map.put("sampleId", SAMPLE_ID_FIELD);
        map.put("generatedFrom", GENERATED_FROM_FIELD);
        map.put("referenceArn", REFERENCE_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMultipartReadSetUploadRequest, T> g) {
        return obj -> g.apply((CreateMultipartReadSetUploadRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateMultipartReadSetUploadRequest> {
        /**
         * <p>
         * The sequence store ID for the store that is the destination of the multipart uploads.
         * </p>
         * 
         * @param sequenceStoreId
         *        The sequence store ID for the store that is the destination of the multipart uploads.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceStoreId(String sequenceStoreId);

        /**
         * <p>
         * An idempotency token that can be used to avoid triggering multiple multipart uploads.
         * </p>
         * 
         * @param clientToken
         *        An idempotency token that can be used to avoid triggering multiple multipart uploads.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The type of file being uploaded.
         * </p>
         * 
         * @param sourceFileType
         *        The type of file being uploaded.
         * @see FileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileType
         */
        Builder sourceFileType(String sourceFileType);

        /**
         * <p>
         * The type of file being uploaded.
         * </p>
         * 
         * @param sourceFileType
         *        The type of file being uploaded.
         * @see FileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileType
         */
        Builder sourceFileType(FileType sourceFileType);

        /**
         * <p>
         * The source's subject ID.
         * </p>
         * 
         * @param subjectId
         *        The source's subject ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectId(String subjectId);

        /**
         * <p>
         * The source's sample ID.
         * </p>
         * 
         * @param sampleId
         *        The source's sample ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleId(String sampleId);

        /**
         * <p>
         * Where the source originated.
         * </p>
         * 
         * @param generatedFrom
         *        Where the source originated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedFrom(String generatedFrom);

        /**
         * <p>
         * The ARN of the reference.
         * </p>
         * 
         * @param referenceArn
         *        The ARN of the reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceArn(String referenceArn);

        /**
         * <p>
         * The name of the read set.
         * </p>
         * 
         * @param name
         *        The name of the read set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the read set.
         * </p>
         * 
         * @param description
         *        The description of the read set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Any tags to add to the read set.
         * </p>
         * 
         * @param tags
         *        Any tags to add to the read set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private String sequenceStoreId;

        private String clientToken;

        private String sourceFileType;

        private String subjectId;

        private String sampleId;

        private String generatedFrom;

        private String referenceArn;

        private String name;

        private String description;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMultipartReadSetUploadRequest model) {
            super(model);
            sequenceStoreId(model.sequenceStoreId);
            clientToken(model.clientToken);
            sourceFileType(model.sourceFileType);
            subjectId(model.subjectId);
            sampleId(model.sampleId);
            generatedFrom(model.generatedFrom);
            referenceArn(model.referenceArn);
            name(model.name);
            description(model.description);
            tags(model.tags);
        }

        public final String getSequenceStoreId() {
            return sequenceStoreId;
        }

        public final void setSequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
        }

        @Override
        public final Builder sequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getSourceFileType() {
            return sourceFileType;
        }

        public final void setSourceFileType(String sourceFileType) {
            this.sourceFileType = sourceFileType;
        }

        @Override
        public final Builder sourceFileType(String sourceFileType) {
            this.sourceFileType = sourceFileType;
            return this;
        }

        @Override
        public final Builder sourceFileType(FileType sourceFileType) {
            this.sourceFileType(sourceFileType == null ? null : sourceFileType.toString());
            return this;
        }

        public final String getSubjectId() {
            return subjectId;
        }

        public final void setSubjectId(String subjectId) {
            this.subjectId = subjectId;
        }

        @Override
        public final Builder subjectId(String subjectId) {
            this.subjectId = subjectId;
            return this;
        }

        public final String getSampleId() {
            return sampleId;
        }

        public final void setSampleId(String sampleId) {
            this.sampleId = sampleId;
        }

        @Override
        public final Builder sampleId(String sampleId) {
            this.sampleId = sampleId;
            return this;
        }

        public final String getGeneratedFrom() {
            return generatedFrom;
        }

        public final void setGeneratedFrom(String generatedFrom) {
            this.generatedFrom = generatedFrom;
        }

        @Override
        public final Builder generatedFrom(String generatedFrom) {
            this.generatedFrom = generatedFrom;
            return this;
        }

        public final String getReferenceArn() {
            return referenceArn;
        }

        public final void setReferenceArn(String referenceArn) {
            this.referenceArn = referenceArn;
        }

        @Override
        public final Builder referenceArn(String referenceArn) {
            this.referenceArn = referenceArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMultipartReadSetUploadRequest build() {
            return new CreateMultipartReadSetUploadRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
