/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRunGroupRequest extends OmicsRequest implements
        ToCopyableBuilder<CreateRunGroupRequest.Builder, CreateRunGroupRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateRunGroupRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> MAX_CPUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxCpus").getter(getter(CreateRunGroupRequest::maxCpus)).setter(setter(Builder::maxCpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxCpus").build()).build();

    private static final SdkField<Integer> MAX_RUNS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxRuns").getter(getter(CreateRunGroupRequest::maxRuns)).setter(setter(Builder::maxRuns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxRuns").build()).build();

    private static final SdkField<Integer> MAX_DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxDuration").getter(getter(CreateRunGroupRequest::maxDuration)).setter(setter(Builder::maxDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxDuration").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateRunGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("requestId")
            .getter(getter(CreateRunGroupRequest::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Integer> MAX_GPUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxGpus").getter(getter(CreateRunGroupRequest::maxGpus)).setter(setter(Builder::maxGpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxGpus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MAX_CPUS_FIELD,
            MAX_RUNS_FIELD, MAX_DURATION_FIELD, TAGS_FIELD, REQUEST_ID_FIELD, MAX_GPUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final Integer maxCpus;

    private final Integer maxRuns;

    private final Integer maxDuration;

    private final Map<String, String> tags;

    private final String requestIdValue;

    private final Integer maxGpus;

    private CreateRunGroupRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.maxCpus = builder.maxCpus;
        this.maxRuns = builder.maxRuns;
        this.maxDuration = builder.maxDuration;
        this.tags = builder.tags;
        this.requestIdValue = builder.requestIdValue;
        this.maxGpus = builder.maxGpus;
    }

    /**
     * <p>
     * A name for the group.
     * </p>
     * 
     * @return A name for the group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The maximum number of CPUs that can run concurrently across all active runs in the run group.
     * </p>
     * 
     * @return The maximum number of CPUs that can run concurrently across all active runs in the run group.
     */
    public final Integer maxCpus() {
        return maxCpus;
    }

    /**
     * <p>
     * The maximum number of runs that can be running at the same time.
     * </p>
     * 
     * @return The maximum number of runs that can be running at the same time.
     */
    public final Integer maxRuns() {
        return maxRuns;
    }

    /**
     * <p>
     * The maximum time for each run (in minutes). If a run exceeds the maximum run time, the run fails automatically.
     * </p>
     * 
     * @return The maximum time for each run (in minutes). If a run exceeds the maximum run time, the run fails
     *         automatically.
     */
    public final Integer maxDuration() {
        return maxDuration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags for the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags for the group.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * To ensure that requests don't run multiple times, specify a unique ID for each request.
     * </p>
     * 
     * @return To ensure that requests don't run multiple times, specify a unique ID for each request.
     */
    public final String requestId() {
        return requestIdValue;
    }

    /**
     * <p>
     * The maximum number of GPUs that can run concurrently across all active runs in the run group.
     * </p>
     * 
     * @return The maximum number of GPUs that can run concurrently across all active runs in the run group.
     */
    public final Integer maxGpus() {
        return maxGpus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(maxCpus());
        hashCode = 31 * hashCode + Objects.hashCode(maxRuns());
        hashCode = 31 * hashCode + Objects.hashCode(maxDuration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(maxGpus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRunGroupRequest)) {
            return false;
        }
        CreateRunGroupRequest other = (CreateRunGroupRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(maxCpus(), other.maxCpus())
                && Objects.equals(maxRuns(), other.maxRuns()) && Objects.equals(maxDuration(), other.maxDuration())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(requestId(), other.requestId()) && Objects.equals(maxGpus(), other.maxGpus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRunGroupRequest").add("Name", name()).add("MaxCpus", maxCpus()).add("MaxRuns", maxRuns())
                .add("MaxDuration", maxDuration()).add("Tags", hasTags() ? tags() : null).add("RequestId", requestId())
                .add("MaxGpus", maxGpus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "maxCpus":
            return Optional.ofNullable(clazz.cast(maxCpus()));
        case "maxRuns":
            return Optional.ofNullable(clazz.cast(maxRuns()));
        case "maxDuration":
            return Optional.ofNullable(clazz.cast(maxDuration()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "requestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "maxGpus":
            return Optional.ofNullable(clazz.cast(maxGpus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("maxCpus", MAX_CPUS_FIELD);
        map.put("maxRuns", MAX_RUNS_FIELD);
        map.put("maxDuration", MAX_DURATION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("requestId", REQUEST_ID_FIELD);
        map.put("maxGpus", MAX_GPUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRunGroupRequest, T> g) {
        return obj -> g.apply((CreateRunGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRunGroupRequest> {
        /**
         * <p>
         * A name for the group.
         * </p>
         * 
         * @param name
         *        A name for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The maximum number of CPUs that can run concurrently across all active runs in the run group.
         * </p>
         * 
         * @param maxCpus
         *        The maximum number of CPUs that can run concurrently across all active runs in the run group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCpus(Integer maxCpus);

        /**
         * <p>
         * The maximum number of runs that can be running at the same time.
         * </p>
         * 
         * @param maxRuns
         *        The maximum number of runs that can be running at the same time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRuns(Integer maxRuns);

        /**
         * <p>
         * The maximum time for each run (in minutes). If a run exceeds the maximum run time, the run fails
         * automatically.
         * </p>
         * 
         * @param maxDuration
         *        The maximum time for each run (in minutes). If a run exceeds the maximum run time, the run fails
         *        automatically.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxDuration(Integer maxDuration);

        /**
         * <p>
         * Tags for the group.
         * </p>
         * 
         * @param tags
         *        Tags for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * To ensure that requests don't run multiple times, specify a unique ID for each request.
         * </p>
         * 
         * @param requestIdValue
         *        To ensure that requests don't run multiple times, specify a unique ID for each request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestIdValue);

        /**
         * <p>
         * The maximum number of GPUs that can run concurrently across all active runs in the run group.
         * </p>
         * 
         * @param maxGpus
         *        The maximum number of GPUs that can run concurrently across all active runs in the run group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxGpus(Integer maxGpus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private String name;

        private Integer maxCpus;

        private Integer maxRuns;

        private Integer maxDuration;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String requestIdValue;

        private Integer maxGpus;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRunGroupRequest model) {
            super(model);
            name(model.name);
            maxCpus(model.maxCpus);
            maxRuns(model.maxRuns);
            maxDuration(model.maxDuration);
            tags(model.tags);
            requestId(model.requestIdValue);
            maxGpus(model.maxGpus);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getMaxCpus() {
            return maxCpus;
        }

        public final void setMaxCpus(Integer maxCpus) {
            this.maxCpus = maxCpus;
        }

        @Override
        public final Builder maxCpus(Integer maxCpus) {
            this.maxCpus = maxCpus;
            return this;
        }

        public final Integer getMaxRuns() {
            return maxRuns;
        }

        public final void setMaxRuns(Integer maxRuns) {
            this.maxRuns = maxRuns;
        }

        @Override
        public final Builder maxRuns(Integer maxRuns) {
            this.maxRuns = maxRuns;
            return this;
        }

        public final Integer getMaxDuration() {
            return maxDuration;
        }

        public final void setMaxDuration(Integer maxDuration) {
            this.maxDuration = maxDuration;
        }

        @Override
        public final Builder maxDuration(Integer maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getRequestId() {
            return requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final Integer getMaxGpus() {
            return maxGpus;
        }

        public final void setMaxGpus(Integer maxGpus) {
            this.maxGpus = maxGpus;
        }

        @Override
        public final Builder maxGpus(Integer maxGpus) {
            this.maxGpus = maxGpus;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRunGroupRequest build() {
            return new CreateRunGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
