/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRunCacheResponse extends OmicsResponse implements
        ToCopyableBuilder<GetRunCacheResponse.Builder, GetRunCacheResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetRunCacheResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CACHE_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cacheBehavior").getter(getter(GetRunCacheResponse::cacheBehaviorAsString))
            .setter(setter(Builder::cacheBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheBehavior").build()).build();

    private static final SdkField<String> CACHE_BUCKET_OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cacheBucketOwnerId").getter(getter(GetRunCacheResponse::cacheBucketOwnerId))
            .setter(setter(Builder::cacheBucketOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheBucketOwnerId").build())
            .build();

    private static final SdkField<String> CACHE_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cacheS3Uri").getter(getter(GetRunCacheResponse::cacheS3Uri)).setter(setter(Builder::cacheS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheS3Uri").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(GetRunCacheResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetRunCacheResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetRunCacheResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetRunCacheResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetRunCacheResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetRunCacheResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CACHE_BEHAVIOR_FIELD, CACHE_BUCKET_OWNER_ID_FIELD, CACHE_S3_URI_FIELD, CREATION_TIME_FIELD, DESCRIPTION_FIELD,
            ID_FIELD, NAME_FIELD, STATUS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String cacheBehavior;

    private final String cacheBucketOwnerId;

    private final String cacheS3Uri;

    private final Instant creationTime;

    private final String description;

    private final String id;

    private final String name;

    private final String status;

    private final Map<String, String> tags;

    private GetRunCacheResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.cacheBehavior = builder.cacheBehavior;
        this.cacheBucketOwnerId = builder.cacheBucketOwnerId;
        this.cacheS3Uri = builder.cacheS3Uri;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Unique resource identifier for the run cache.
     * </p>
     * 
     * @return Unique resource identifier for the run cache.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The default cache behavior for runs using this cache.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cacheBehavior}
     * will return {@link CacheBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #cacheBehaviorAsString}.
     * </p>
     * 
     * @return The default cache behavior for runs using this cache.
     * @see CacheBehavior
     */
    public final CacheBehavior cacheBehavior() {
        return CacheBehavior.fromValue(cacheBehavior);
    }

    /**
     * <p>
     * The default cache behavior for runs using this cache.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cacheBehavior}
     * will return {@link CacheBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #cacheBehaviorAsString}.
     * </p>
     * 
     * @return The default cache behavior for runs using this cache.
     * @see CacheBehavior
     */
    public final String cacheBehaviorAsString() {
        return cacheBehavior;
    }

    /**
     * <p>
     * The identifier of the bucket owner.
     * </p>
     * 
     * @return The identifier of the bucket owner.
     */
    public final String cacheBucketOwnerId() {
        return cacheBucketOwnerId;
    }

    /**
     * <p>
     * The S3 URI where the cache data is stored.
     * </p>
     * 
     * @return The S3 URI where the cache data is stored.
     */
    public final String cacheS3Uri() {
        return cacheS3Uri;
    }

    /**
     * <p>
     * Creation time of the run cache (an ISO 8601 formatted string).
     * </p>
     * 
     * @return Creation time of the run cache (an ISO 8601 formatted string).
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The run cache description.
     * </p>
     * 
     * @return The run cache description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The run cache ID.
     * </p>
     * 
     * @return The run cache ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The run cache name.
     * </p>
     * 
     * @return The run cache name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The run cache status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RunCacheStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The run cache status.
     * @see RunCacheStatus
     */
    public final RunCacheStatus status() {
        return RunCacheStatus.fromValue(status);
    }

    /**
     * <p>
     * The run cache status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RunCacheStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The run cache status.
     * @see RunCacheStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags associated with the run cache.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the run cache.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(cacheBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cacheBucketOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(cacheS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRunCacheResponse)) {
            return false;
        }
        GetRunCacheResponse other = (GetRunCacheResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(cacheBehaviorAsString(), other.cacheBehaviorAsString())
                && Objects.equals(cacheBucketOwnerId(), other.cacheBucketOwnerId())
                && Objects.equals(cacheS3Uri(), other.cacheS3Uri()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(description(), other.description()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRunCacheResponse").add("Arn", arn()).add("CacheBehavior", cacheBehaviorAsString())
                .add("CacheBucketOwnerId", cacheBucketOwnerId()).add("CacheS3Uri", cacheS3Uri())
                .add("CreationTime", creationTime()).add("Description", description()).add("Id", id()).add("Name", name())
                .add("Status", statusAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "cacheBehavior":
            return Optional.ofNullable(clazz.cast(cacheBehaviorAsString()));
        case "cacheBucketOwnerId":
            return Optional.ofNullable(clazz.cast(cacheBucketOwnerId()));
        case "cacheS3Uri":
            return Optional.ofNullable(clazz.cast(cacheS3Uri()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("cacheBehavior", CACHE_BEHAVIOR_FIELD);
        map.put("cacheBucketOwnerId", CACHE_BUCKET_OWNER_ID_FIELD);
        map.put("cacheS3Uri", CACHE_S3_URI_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRunCacheResponse, T> g) {
        return obj -> g.apply((GetRunCacheResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRunCacheResponse> {
        /**
         * <p>
         * Unique resource identifier for the run cache.
         * </p>
         * 
         * @param arn
         *        Unique resource identifier for the run cache.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The default cache behavior for runs using this cache.
         * </p>
         * 
         * @param cacheBehavior
         *        The default cache behavior for runs using this cache.
         * @see CacheBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CacheBehavior
         */
        Builder cacheBehavior(String cacheBehavior);

        /**
         * <p>
         * The default cache behavior for runs using this cache.
         * </p>
         * 
         * @param cacheBehavior
         *        The default cache behavior for runs using this cache.
         * @see CacheBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CacheBehavior
         */
        Builder cacheBehavior(CacheBehavior cacheBehavior);

        /**
         * <p>
         * The identifier of the bucket owner.
         * </p>
         * 
         * @param cacheBucketOwnerId
         *        The identifier of the bucket owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheBucketOwnerId(String cacheBucketOwnerId);

        /**
         * <p>
         * The S3 URI where the cache data is stored.
         * </p>
         * 
         * @param cacheS3Uri
         *        The S3 URI where the cache data is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheS3Uri(String cacheS3Uri);

        /**
         * <p>
         * Creation time of the run cache (an ISO 8601 formatted string).
         * </p>
         * 
         * @param creationTime
         *        Creation time of the run cache (an ISO 8601 formatted string).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The run cache description.
         * </p>
         * 
         * @param description
         *        The run cache description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The run cache ID.
         * </p>
         * 
         * @param id
         *        The run cache ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The run cache name.
         * </p>
         * 
         * @param name
         *        The run cache name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The run cache status.
         * </p>
         * 
         * @param status
         *        The run cache status.
         * @see RunCacheStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunCacheStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The run cache status.
         * </p>
         * 
         * @param status
         *        The run cache status.
         * @see RunCacheStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunCacheStatus
         */
        Builder status(RunCacheStatus status);

        /**
         * <p>
         * The tags associated with the run cache.
         * </p>
         * 
         * @param tags
         *        The tags associated with the run cache.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends OmicsResponse.BuilderImpl implements Builder {
        private String arn;

        private String cacheBehavior;

        private String cacheBucketOwnerId;

        private String cacheS3Uri;

        private Instant creationTime;

        private String description;

        private String id;

        private String name;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRunCacheResponse model) {
            super(model);
            arn(model.arn);
            cacheBehavior(model.cacheBehavior);
            cacheBucketOwnerId(model.cacheBucketOwnerId);
            cacheS3Uri(model.cacheS3Uri);
            creationTime(model.creationTime);
            description(model.description);
            id(model.id);
            name(model.name);
            status(model.status);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCacheBehavior() {
            return cacheBehavior;
        }

        public final void setCacheBehavior(String cacheBehavior) {
            this.cacheBehavior = cacheBehavior;
        }

        @Override
        public final Builder cacheBehavior(String cacheBehavior) {
            this.cacheBehavior = cacheBehavior;
            return this;
        }

        @Override
        public final Builder cacheBehavior(CacheBehavior cacheBehavior) {
            this.cacheBehavior(cacheBehavior == null ? null : cacheBehavior.toString());
            return this;
        }

        public final String getCacheBucketOwnerId() {
            return cacheBucketOwnerId;
        }

        public final void setCacheBucketOwnerId(String cacheBucketOwnerId) {
            this.cacheBucketOwnerId = cacheBucketOwnerId;
        }

        @Override
        public final Builder cacheBucketOwnerId(String cacheBucketOwnerId) {
            this.cacheBucketOwnerId = cacheBucketOwnerId;
            return this;
        }

        public final String getCacheS3Uri() {
            return cacheS3Uri;
        }

        public final void setCacheS3Uri(String cacheS3Uri) {
            this.cacheS3Uri = cacheS3Uri;
        }

        @Override
        public final Builder cacheS3Uri(String cacheS3Uri) {
            this.cacheS3Uri = cacheS3Uri;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RunCacheStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetRunCacheResponse build() {
            return new GetRunCacheResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
