/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRunTaskResponse extends OmicsResponse implements
        ToCopyableBuilder<GetRunTaskResponse.Builder, GetRunTaskResponse> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("taskId")
            .getter(getter(GetRunTaskResponse::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetRunTaskResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetRunTaskResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> CPUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("cpus")
            .getter(getter(GetRunTaskResponse::cpus)).setter(setter(Builder::cpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpus").build()).build();

    private static final SdkField<Boolean> CACHE_HIT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("cacheHit").getter(getter(GetRunTaskResponse::cacheHit)).setter(setter(Builder::cacheHit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheHit").build()).build();

    private static final SdkField<String> CACHE_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cacheS3Uri").getter(getter(GetRunTaskResponse::cacheS3Uri)).setter(setter(Builder::cacheS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheS3Uri").build()).build();

    private static final SdkField<Integer> MEMORY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("memory").getter(getter(GetRunTaskResponse::memory)).setter(setter(Builder::memory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(GetRunTaskResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime")
            .getter(getter(GetRunTaskResponse::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> STOP_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("stopTime")
            .getter(getter(GetRunTaskResponse::stopTime))
            .setter(setter(Builder::stopTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(GetRunTaskResponse::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<String> LOG_STREAM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logStream").getter(getter(GetRunTaskResponse::logStream)).setter(setter(Builder::logStream))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStream").build()).build();

    private static final SdkField<Integer> GPUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("gpus")
            .getter(getter(GetRunTaskResponse::gpus)).setter(setter(Builder::gpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gpus").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceType").getter(getter(GetRunTaskResponse::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(GetRunTaskResponse::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, STATUS_FIELD,
            NAME_FIELD, CPUS_FIELD, CACHE_HIT_FIELD, CACHE_S3_URI_FIELD, MEMORY_FIELD, CREATION_TIME_FIELD, START_TIME_FIELD,
            STOP_TIME_FIELD, STATUS_MESSAGE_FIELD, LOG_STREAM_FIELD, GPUS_FIELD, INSTANCE_TYPE_FIELD, FAILURE_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String taskId;

    private final String status;

    private final String name;

    private final Integer cpus;

    private final Boolean cacheHit;

    private final String cacheS3Uri;

    private final Integer memory;

    private final Instant creationTime;

    private final Instant startTime;

    private final Instant stopTime;

    private final String statusMessage;

    private final String logStream;

    private final Integer gpus;

    private final String instanceType;

    private final String failureReason;

    private GetRunTaskResponse(BuilderImpl builder) {
        super(builder);
        this.taskId = builder.taskId;
        this.status = builder.status;
        this.name = builder.name;
        this.cpus = builder.cpus;
        this.cacheHit = builder.cacheHit;
        this.cacheS3Uri = builder.cacheS3Uri;
        this.memory = builder.memory;
        this.creationTime = builder.creationTime;
        this.startTime = builder.startTime;
        this.stopTime = builder.stopTime;
        this.statusMessage = builder.statusMessage;
        this.logStream = builder.logStream;
        this.gpus = builder.gpus;
        this.instanceType = builder.instanceType;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * The task's ID.
     * </p>
     * 
     * @return The task's ID.
     */
    public final String taskId() {
        return taskId;
    }

    /**
     * <p>
     * The task's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The task's status.
     * @see TaskStatus
     */
    public final TaskStatus status() {
        return TaskStatus.fromValue(status);
    }

    /**
     * <p>
     * The task's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The task's status.
     * @see TaskStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The task's name.
     * </p>
     * 
     * @return The task's name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The task's CPU usage.
     * </p>
     * 
     * @return The task's CPU usage.
     */
    public final Integer cpus() {
        return cpus;
    }

    /**
     * <p>
     * Set to true if AWS HealthOmics found a matching entry in the run cache for this task.
     * </p>
     * 
     * @return Set to true if AWS HealthOmics found a matching entry in the run cache for this task.
     */
    public final Boolean cacheHit() {
        return cacheHit;
    }

    /**
     * <p>
     * The S3 URI of the cache location.
     * </p>
     * 
     * @return The S3 URI of the cache location.
     */
    public final String cacheS3Uri() {
        return cacheS3Uri;
    }

    /**
     * <p>
     * The task's memory use in gigabytes.
     * </p>
     * 
     * @return The task's memory use in gigabytes.
     */
    public final Integer memory() {
        return memory;
    }

    /**
     * <p>
     * When the task was created.
     * </p>
     * 
     * @return When the task was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The task's start time.
     * </p>
     * 
     * @return The task's start time.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The task's stop time.
     * </p>
     * 
     * @return The task's stop time.
     */
    public final Instant stopTime() {
        return stopTime;
    }

    /**
     * <p>
     * The task's status message.
     * </p>
     * 
     * @return The task's status message.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The task's log stream.
     * </p>
     * 
     * @return The task's log stream.
     */
    public final String logStream() {
        return logStream;
    }

    /**
     * <p>
     * The number of Graphics Processing Units (GPU) specified in the task.
     * </p>
     * 
     * @return The number of Graphics Processing Units (GPU) specified in the task.
     */
    public final Integer gpus() {
        return gpus;
    }

    /**
     * <p>
     * The instance type for a task.
     * </p>
     * 
     * @return The instance type for a task.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The reason a task has failed.
     * </p>
     * 
     * @return The reason a task has failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(cpus());
        hashCode = 31 * hashCode + Objects.hashCode(cacheHit());
        hashCode = 31 * hashCode + Objects.hashCode(cacheS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(memory());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(stopTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(logStream());
        hashCode = 31 * hashCode + Objects.hashCode(gpus());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRunTaskResponse)) {
            return false;
        }
        GetRunTaskResponse other = (GetRunTaskResponse) obj;
        return Objects.equals(taskId(), other.taskId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(name(), other.name()) && Objects.equals(cpus(), other.cpus())
                && Objects.equals(cacheHit(), other.cacheHit()) && Objects.equals(cacheS3Uri(), other.cacheS3Uri())
                && Objects.equals(memory(), other.memory()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(stopTime(), other.stopTime())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(logStream(), other.logStream())
                && Objects.equals(gpus(), other.gpus()) && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRunTaskResponse").add("TaskId", taskId()).add("Status", statusAsString()).add("Name", name())
                .add("Cpus", cpus()).add("CacheHit", cacheHit()).add("CacheS3Uri", cacheS3Uri()).add("Memory", memory())
                .add("CreationTime", creationTime()).add("StartTime", startTime()).add("StopTime", stopTime())
                .add("StatusMessage", statusMessage()).add("LogStream", logStream()).add("Gpus", gpus())
                .add("InstanceType", instanceType()).add("FailureReason", failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "cpus":
            return Optional.ofNullable(clazz.cast(cpus()));
        case "cacheHit":
            return Optional.ofNullable(clazz.cast(cacheHit()));
        case "cacheS3Uri":
            return Optional.ofNullable(clazz.cast(cacheS3Uri()));
        case "memory":
            return Optional.ofNullable(clazz.cast(memory()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "stopTime":
            return Optional.ofNullable(clazz.cast(stopTime()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "logStream":
            return Optional.ofNullable(clazz.cast(logStream()));
        case "gpus":
            return Optional.ofNullable(clazz.cast(gpus()));
        case "instanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("taskId", TASK_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("cpus", CPUS_FIELD);
        map.put("cacheHit", CACHE_HIT_FIELD);
        map.put("cacheS3Uri", CACHE_S3_URI_FIELD);
        map.put("memory", MEMORY_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("stopTime", STOP_TIME_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        map.put("logStream", LOG_STREAM_FIELD);
        map.put("gpus", GPUS_FIELD);
        map.put("instanceType", INSTANCE_TYPE_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRunTaskResponse, T> g) {
        return obj -> g.apply((GetRunTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRunTaskResponse> {
        /**
         * <p>
         * The task's ID.
         * </p>
         * 
         * @param taskId
         *        The task's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * The task's status.
         * </p>
         * 
         * @param status
         *        The task's status.
         * @see TaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The task's status.
         * </p>
         * 
         * @param status
         *        The task's status.
         * @see TaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskStatus
         */
        Builder status(TaskStatus status);

        /**
         * <p>
         * The task's name.
         * </p>
         * 
         * @param name
         *        The task's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The task's CPU usage.
         * </p>
         * 
         * @param cpus
         *        The task's CPU usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpus(Integer cpus);

        /**
         * <p>
         * Set to true if AWS HealthOmics found a matching entry in the run cache for this task.
         * </p>
         * 
         * @param cacheHit
         *        Set to true if AWS HealthOmics found a matching entry in the run cache for this task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheHit(Boolean cacheHit);

        /**
         * <p>
         * The S3 URI of the cache location.
         * </p>
         * 
         * @param cacheS3Uri
         *        The S3 URI of the cache location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheS3Uri(String cacheS3Uri);

        /**
         * <p>
         * The task's memory use in gigabytes.
         * </p>
         * 
         * @param memory
         *        The task's memory use in gigabytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memory(Integer memory);

        /**
         * <p>
         * When the task was created.
         * </p>
         * 
         * @param creationTime
         *        When the task was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The task's start time.
         * </p>
         * 
         * @param startTime
         *        The task's start time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The task's stop time.
         * </p>
         * 
         * @param stopTime
         *        The task's stop time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopTime(Instant stopTime);

        /**
         * <p>
         * The task's status message.
         * </p>
         * 
         * @param statusMessage
         *        The task's status message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The task's log stream.
         * </p>
         * 
         * @param logStream
         *        The task's log stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStream(String logStream);

        /**
         * <p>
         * The number of Graphics Processing Units (GPU) specified in the task.
         * </p>
         * 
         * @param gpus
         *        The number of Graphics Processing Units (GPU) specified in the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gpus(Integer gpus);

        /**
         * <p>
         * The instance type for a task.
         * </p>
         * 
         * @param instanceType
         *        The instance type for a task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The reason a task has failed.
         * </p>
         * 
         * @param failureReason
         *        The reason a task has failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl extends OmicsResponse.BuilderImpl implements Builder {
        private String taskId;

        private String status;

        private String name;

        private Integer cpus;

        private Boolean cacheHit;

        private String cacheS3Uri;

        private Integer memory;

        private Instant creationTime;

        private Instant startTime;

        private Instant stopTime;

        private String statusMessage;

        private String logStream;

        private Integer gpus;

        private String instanceType;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRunTaskResponse model) {
            super(model);
            taskId(model.taskId);
            status(model.status);
            name(model.name);
            cpus(model.cpus);
            cacheHit(model.cacheHit);
            cacheS3Uri(model.cacheS3Uri);
            memory(model.memory);
            creationTime(model.creationTime);
            startTime(model.startTime);
            stopTime(model.stopTime);
            statusMessage(model.statusMessage);
            logStream(model.logStream);
            gpus(model.gpus);
            instanceType(model.instanceType);
            failureReason(model.failureReason);
        }

        public final String getTaskId() {
            return taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getCpus() {
            return cpus;
        }

        public final void setCpus(Integer cpus) {
            this.cpus = cpus;
        }

        @Override
        public final Builder cpus(Integer cpus) {
            this.cpus = cpus;
            return this;
        }

        public final Boolean getCacheHit() {
            return cacheHit;
        }

        public final void setCacheHit(Boolean cacheHit) {
            this.cacheHit = cacheHit;
        }

        @Override
        public final Builder cacheHit(Boolean cacheHit) {
            this.cacheHit = cacheHit;
            return this;
        }

        public final String getCacheS3Uri() {
            return cacheS3Uri;
        }

        public final void setCacheS3Uri(String cacheS3Uri) {
            this.cacheS3Uri = cacheS3Uri;
        }

        @Override
        public final Builder cacheS3Uri(String cacheS3Uri) {
            this.cacheS3Uri = cacheS3Uri;
            return this;
        }

        public final Integer getMemory() {
            return memory;
        }

        public final void setMemory(Integer memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getStopTime() {
            return stopTime;
        }

        public final void setStopTime(Instant stopTime) {
            this.stopTime = stopTime;
        }

        @Override
        public final Builder stopTime(Instant stopTime) {
            this.stopTime = stopTime;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getLogStream() {
            return logStream;
        }

        public final void setLogStream(String logStream) {
            this.logStream = logStream;
        }

        @Override
        public final Builder logStream(String logStream) {
            this.logStream = logStream;
            return this;
        }

        public final Integer getGpus() {
            return gpus;
        }

        public final void setGpus(Integer gpus) {
            this.gpus = gpus;
        }

        @Override
        public final Builder gpus(Integer gpus) {
            this.gpus = gpus;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public GetRunTaskResponse build() {
            return new GetRunTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
