/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetS3AccessPolicyRequest extends OmicsRequest implements
        ToCopyableBuilder<GetS3AccessPolicyRequest.Builder, GetS3AccessPolicyRequest> {
    private static final SdkField<String> S3_ACCESS_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3AccessPointArn").getter(getter(GetS3AccessPolicyRequest::s3AccessPointArn))
            .setter(setter(Builder::s3AccessPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("s3AccessPointArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_ACCESS_POINT_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String s3AccessPointArn;

    private GetS3AccessPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.s3AccessPointArn = builder.s3AccessPointArn;
    }

    /**
     * <p>
     * The S3 access point ARN that has the access policy.
     * </p>
     * 
     * @return The S3 access point ARN that has the access policy.
     */
    public final String s3AccessPointArn() {
        return s3AccessPointArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(s3AccessPointArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetS3AccessPolicyRequest)) {
            return false;
        }
        GetS3AccessPolicyRequest other = (GetS3AccessPolicyRequest) obj;
        return Objects.equals(s3AccessPointArn(), other.s3AccessPointArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetS3AccessPolicyRequest").add("S3AccessPointArn", s3AccessPointArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3AccessPointArn":
            return Optional.ofNullable(clazz.cast(s3AccessPointArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("s3AccessPointArn", S3_ACCESS_POINT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetS3AccessPolicyRequest, T> g) {
        return obj -> g.apply((GetS3AccessPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetS3AccessPolicyRequest> {
        /**
         * <p>
         * The S3 access point ARN that has the access policy.
         * </p>
         * 
         * @param s3AccessPointArn
         *        The S3 access point ARN that has the access policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3AccessPointArn(String s3AccessPointArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private String s3AccessPointArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetS3AccessPolicyRequest model) {
            super(model);
            s3AccessPointArn(model.s3AccessPointArn);
        }

        public final String getS3AccessPointArn() {
            return s3AccessPointArn;
        }

        public final void setS3AccessPointArn(String s3AccessPointArn) {
            this.s3AccessPointArn = s3AccessPointArn;
        }

        @Override
        public final Builder s3AccessPointArn(String s3AccessPointArn) {
            this.s3AccessPointArn = s3AccessPointArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetS3AccessPolicyRequest build() {
            return new GetS3AccessPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
