/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetShareResponse extends OmicsResponse implements
        ToCopyableBuilder<GetShareResponse.Builder, GetShareResponse> {
    private static final SdkField<ShareDetails> SHARE_FIELD = SdkField.<ShareDetails> builder(MarshallingType.SDK_POJO)
            .memberName("share").getter(getter(GetShareResponse::share)).setter(setter(Builder::share))
            .constructor(ShareDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("share").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ShareDetails share;

    private GetShareResponse(BuilderImpl builder) {
        super(builder);
        this.share = builder.share;
    }

    /**
     * <p>
     * A resource share details object. The object includes the status, the resourceArn, and ownerId.
     * </p>
     * 
     * @return A resource share details object. The object includes the status, the resourceArn, and ownerId.
     */
    public final ShareDetails share() {
        return share;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(share());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetShareResponse)) {
            return false;
        }
        GetShareResponse other = (GetShareResponse) obj;
        return Objects.equals(share(), other.share());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetShareResponse").add("Share", share()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "share":
            return Optional.ofNullable(clazz.cast(share()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("share", SHARE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetShareResponse, T> g) {
        return obj -> g.apply((GetShareResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetShareResponse> {
        /**
         * <p>
         * A resource share details object. The object includes the status, the resourceArn, and ownerId.
         * </p>
         * 
         * @param share
         *        A resource share details object. The object includes the status, the resourceArn, and ownerId.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder share(ShareDetails share);

        /**
         * <p>
         * A resource share details object. The object includes the status, the resourceArn, and ownerId.
         * </p>
         * This is a convenience method that creates an instance of the {@link ShareDetails.Builder} avoiding the need
         * to create one manually via {@link ShareDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ShareDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #share(ShareDetails)}.
         * 
         * @param share
         *        a consumer that will call methods on {@link ShareDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #share(ShareDetails)
         */
        default Builder share(Consumer<ShareDetails.Builder> share) {
            return share(ShareDetails.builder().applyMutation(share).build());
        }
    }

    static final class BuilderImpl extends OmicsResponse.BuilderImpl implements Builder {
        private ShareDetails share;

        private BuilderImpl() {
        }

        private BuilderImpl(GetShareResponse model) {
            super(model);
            share(model.share);
        }

        public final ShareDetails.Builder getShare() {
            return share != null ? share.toBuilder() : null;
        }

        public final void setShare(ShareDetails.BuilderImpl share) {
            this.share = share != null ? share.build() : null;
        }

        @Override
        public final Builder share(ShareDetails share) {
            this.share = share;
            return this;
        }

        @Override
        public GetShareResponse build() {
            return new GetShareResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
