/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListReadSetExportJobsResponse extends OmicsResponse implements
        ToCopyableBuilder<ListReadSetExportJobsResponse.Builder, ListReadSetExportJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListReadSetExportJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<ExportReadSetJobDetail>> EXPORT_JOBS_FIELD = SdkField
            .<List<ExportReadSetJobDetail>> builder(MarshallingType.LIST)
            .memberName("exportJobs")
            .getter(getter(ListReadSetExportJobsResponse::exportJobs))
            .setter(setter(Builder::exportJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExportReadSetJobDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExportReadSetJobDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            EXPORT_JOBS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ExportReadSetJobDetail> exportJobs;

    private ListReadSetExportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.exportJobs = builder.exportJobs;
    }

    /**
     * <p>
     * A pagination token that's included if more results are available.
     * </p>
     * 
     * @return A pagination token that's included if more results are available.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExportJobs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasExportJobs() {
        return exportJobs != null && !(exportJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExportJobs} method.
     * </p>
     * 
     * @return A list of jobs.
     */
    public final List<ExportReadSetJobDetail> exportJobs() {
        return exportJobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasExportJobs() ? exportJobs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReadSetExportJobsResponse)) {
            return false;
        }
        ListReadSetExportJobsResponse other = (ListReadSetExportJobsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasExportJobs() == other.hasExportJobs()
                && Objects.equals(exportJobs(), other.exportJobs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListReadSetExportJobsResponse").add("NextToken", nextToken())
                .add("ExportJobs", hasExportJobs() ? exportJobs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "exportJobs":
            return Optional.ofNullable(clazz.cast(exportJobs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("exportJobs", EXPORT_JOBS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListReadSetExportJobsResponse, T> g) {
        return obj -> g.apply((ListReadSetExportJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListReadSetExportJobsResponse> {
        /**
         * <p>
         * A pagination token that's included if more results are available.
         * </p>
         * 
         * @param nextToken
         *        A pagination token that's included if more results are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of jobs.
         * </p>
         * 
         * @param exportJobs
         *        A list of jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportJobs(Collection<ExportReadSetJobDetail> exportJobs);

        /**
         * <p>
         * A list of jobs.
         * </p>
         * 
         * @param exportJobs
         *        A list of jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportJobs(ExportReadSetJobDetail... exportJobs);

        /**
         * <p>
         * A list of jobs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.omics.model.ExportReadSetJobDetail.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.omics.model.ExportReadSetJobDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.omics.model.ExportReadSetJobDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #exportJobs(List<ExportReadSetJobDetail>)}.
         * 
         * @param exportJobs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.omics.model.ExportReadSetJobDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportJobs(java.util.Collection<ExportReadSetJobDetail>)
         */
        Builder exportJobs(Consumer<ExportReadSetJobDetail.Builder>... exportJobs);
    }

    static final class BuilderImpl extends OmicsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ExportReadSetJobDetail> exportJobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListReadSetExportJobsResponse model) {
            super(model);
            nextToken(model.nextToken);
            exportJobs(model.exportJobs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ExportReadSetJobDetail.Builder> getExportJobs() {
            List<ExportReadSetJobDetail.Builder> result = ExportReadSetJobDetailListCopier.copyToBuilder(this.exportJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExportJobs(Collection<ExportReadSetJobDetail.BuilderImpl> exportJobs) {
            this.exportJobs = ExportReadSetJobDetailListCopier.copyFromBuilder(exportJobs);
        }

        @Override
        public final Builder exportJobs(Collection<ExportReadSetJobDetail> exportJobs) {
            this.exportJobs = ExportReadSetJobDetailListCopier.copy(exportJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportJobs(ExportReadSetJobDetail... exportJobs) {
            exportJobs(Arrays.asList(exportJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportJobs(Consumer<ExportReadSetJobDetail.Builder>... exportJobs) {
            exportJobs(Stream.of(exportJobs).map(c -> ExportReadSetJobDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListReadSetExportJobsResponse build() {
            return new ListReadSetExportJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
