/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListReadSetUploadPartsRequest extends OmicsRequest implements
        ToCopyableBuilder<ListReadSetUploadPartsRequest.Builder, ListReadSetUploadPartsRequest> {
    private static final SdkField<String> SEQUENCE_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sequenceStoreId").getter(getter(ListReadSetUploadPartsRequest::sequenceStoreId))
            .setter(setter(Builder::sequenceStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sequenceStoreId").build()).build();

    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("uploadId").getter(getter(ListReadSetUploadPartsRequest::uploadId)).setter(setter(Builder::uploadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("uploadId").build()).build();

    private static final SdkField<String> PART_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("partSource").getter(getter(ListReadSetUploadPartsRequest::partSourceAsString))
            .setter(setter(Builder::partSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partSource").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListReadSetUploadPartsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListReadSetUploadPartsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<ReadSetUploadPartListFilter> FILTER_FIELD = SdkField
            .<ReadSetUploadPartListFilter> builder(MarshallingType.SDK_POJO).memberName("filter")
            .getter(getter(ListReadSetUploadPartsRequest::filter)).setter(setter(Builder::filter))
            .constructor(ReadSetUploadPartListFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEQUENCE_STORE_ID_FIELD,
            UPLOAD_ID_FIELD, PART_SOURCE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sequenceStoreId;

    private final String uploadId;

    private final String partSource;

    private final Integer maxResults;

    private final String nextToken;

    private final ReadSetUploadPartListFilter filter;

    private ListReadSetUploadPartsRequest(BuilderImpl builder) {
        super(builder);
        this.sequenceStoreId = builder.sequenceStoreId;
        this.uploadId = builder.uploadId;
        this.partSource = builder.partSource;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.filter = builder.filter;
    }

    /**
     * <p>
     * The Sequence Store ID used for the multipart uploads.
     * </p>
     * 
     * @return The Sequence Store ID used for the multipart uploads.
     */
    public final String sequenceStoreId() {
        return sequenceStoreId;
    }

    /**
     * <p>
     * The ID for the initiated multipart upload.
     * </p>
     * 
     * @return The ID for the initiated multipart upload.
     */
    public final String uploadId() {
        return uploadId;
    }

    /**
     * <p>
     * The source file for the upload part.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #partSource} will
     * return {@link ReadSetPartSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #partSourceAsString}.
     * </p>
     * 
     * @return The source file for the upload part.
     * @see ReadSetPartSource
     */
    public final ReadSetPartSource partSource() {
        return ReadSetPartSource.fromValue(partSource);
    }

    /**
     * <p>
     * The source file for the upload part.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #partSource} will
     * return {@link ReadSetPartSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #partSourceAsString}.
     * </p>
     * 
     * @return The source file for the upload part.
     * @see ReadSetPartSource
     */
    public final String partSourceAsString() {
        return partSource;
    }

    /**
     * <p>
     * The maximum number of read set upload parts returned in a page.
     * </p>
     * 
     * @return The maximum number of read set upload parts returned in a page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Next token returned in the response of a previous ListReadSetUploadPartsRequest call. Used to get the next page
     * of results.
     * </p>
     * 
     * @return Next token returned in the response of a previous ListReadSetUploadPartsRequest call. Used to get the
     *         next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Attributes used to filter for a specific subset of read set part uploads.
     * </p>
     * 
     * @return Attributes used to filter for a specific subset of read set part uploads.
     */
    public final ReadSetUploadPartListFilter filter() {
        return filter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sequenceStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(partSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReadSetUploadPartsRequest)) {
            return false;
        }
        ListReadSetUploadPartsRequest other = (ListReadSetUploadPartsRequest) obj;
        return Objects.equals(sequenceStoreId(), other.sequenceStoreId()) && Objects.equals(uploadId(), other.uploadId())
                && Objects.equals(partSourceAsString(), other.partSourceAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(filter(), other.filter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListReadSetUploadPartsRequest").add("SequenceStoreId", sequenceStoreId())
                .add("UploadId", uploadId()).add("PartSource", partSourceAsString()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("Filter", filter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sequenceStoreId":
            return Optional.ofNullable(clazz.cast(sequenceStoreId()));
        case "uploadId":
            return Optional.ofNullable(clazz.cast(uploadId()));
        case "partSource":
            return Optional.ofNullable(clazz.cast(partSourceAsString()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sequenceStoreId", SEQUENCE_STORE_ID_FIELD);
        map.put("uploadId", UPLOAD_ID_FIELD);
        map.put("partSource", PART_SOURCE_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("filter", FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListReadSetUploadPartsRequest, T> g) {
        return obj -> g.apply((ListReadSetUploadPartsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListReadSetUploadPartsRequest> {
        /**
         * <p>
         * The Sequence Store ID used for the multipart uploads.
         * </p>
         * 
         * @param sequenceStoreId
         *        The Sequence Store ID used for the multipart uploads.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceStoreId(String sequenceStoreId);

        /**
         * <p>
         * The ID for the initiated multipart upload.
         * </p>
         * 
         * @param uploadId
         *        The ID for the initiated multipart upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadId(String uploadId);

        /**
         * <p>
         * The source file for the upload part.
         * </p>
         * 
         * @param partSource
         *        The source file for the upload part.
         * @see ReadSetPartSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReadSetPartSource
         */
        Builder partSource(String partSource);

        /**
         * <p>
         * The source file for the upload part.
         * </p>
         * 
         * @param partSource
         *        The source file for the upload part.
         * @see ReadSetPartSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReadSetPartSource
         */
        Builder partSource(ReadSetPartSource partSource);

        /**
         * <p>
         * The maximum number of read set upload parts returned in a page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of read set upload parts returned in a page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Next token returned in the response of a previous ListReadSetUploadPartsRequest call. Used to get the next
         * page of results.
         * </p>
         * 
         * @param nextToken
         *        Next token returned in the response of a previous ListReadSetUploadPartsRequest call. Used to get the
         *        next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Attributes used to filter for a specific subset of read set part uploads.
         * </p>
         * 
         * @param filter
         *        Attributes used to filter for a specific subset of read set part uploads.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(ReadSetUploadPartListFilter filter);

        /**
         * <p>
         * Attributes used to filter for a specific subset of read set part uploads.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReadSetUploadPartListFilter.Builder}
         * avoiding the need to create one manually via {@link ReadSetUploadPartListFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReadSetUploadPartListFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #filter(ReadSetUploadPartListFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link ReadSetUploadPartListFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(ReadSetUploadPartListFilter)
         */
        default Builder filter(Consumer<ReadSetUploadPartListFilter.Builder> filter) {
            return filter(ReadSetUploadPartListFilter.builder().applyMutation(filter).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private String sequenceStoreId;

        private String uploadId;

        private String partSource;

        private Integer maxResults;

        private String nextToken;

        private ReadSetUploadPartListFilter filter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReadSetUploadPartsRequest model) {
            super(model);
            sequenceStoreId(model.sequenceStoreId);
            uploadId(model.uploadId);
            partSource(model.partSource);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            filter(model.filter);
        }

        public final String getSequenceStoreId() {
            return sequenceStoreId;
        }

        public final void setSequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
        }

        @Override
        public final Builder sequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
            return this;
        }

        public final String getUploadId() {
            return uploadId;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final String getPartSource() {
            return partSource;
        }

        public final void setPartSource(String partSource) {
            this.partSource = partSource;
        }

        @Override
        public final Builder partSource(String partSource) {
            this.partSource = partSource;
            return this;
        }

        @Override
        public final Builder partSource(ReadSetPartSource partSource) {
            this.partSource(partSource == null ? null : partSource.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final ReadSetUploadPartListFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(ReadSetUploadPartListFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(ReadSetUploadPartListFilter filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListReadSetUploadPartsRequest build() {
            return new ListReadSetUploadPartsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
