/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSharesRequest extends OmicsRequest implements
        ToCopyableBuilder<ListSharesRequest.Builder, ListSharesRequest> {
    private static final SdkField<String> RESOURCE_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceOwner").getter(getter(ListSharesRequest::resourceOwnerAsString))
            .setter(setter(Builder::resourceOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceOwner").build()).build();

    private static final SdkField<Filter> FILTER_FIELD = SdkField.<Filter> builder(MarshallingType.SDK_POJO).memberName("filter")
            .getter(getter(ListSharesRequest::filter)).setter(setter(Builder::filter)).constructor(Filter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSharesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListSharesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_OWNER_FIELD,
            FILTER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceOwner;

    private final Filter filter;

    private final String nextToken;

    private final Integer maxResults;

    private ListSharesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceOwner = builder.resourceOwner;
        this.filter = builder.filter;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The account that owns the resource shares.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceOwner}
     * will return {@link ResourceOwner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceOwnerAsString}.
     * </p>
     * 
     * @return The account that owns the resource shares.
     * @see ResourceOwner
     */
    public final ResourceOwner resourceOwner() {
        return ResourceOwner.fromValue(resourceOwner);
    }

    /**
     * <p>
     * The account that owns the resource shares.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceOwner}
     * will return {@link ResourceOwner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceOwnerAsString}.
     * </p>
     * 
     * @return The account that owns the resource shares.
     * @see ResourceOwner
     */
    public final String resourceOwnerAsString() {
        return resourceOwner;
    }

    /**
     * <p>
     * Attributes that you use to filter for a specific subset of resource shares.
     * </p>
     * 
     * @return Attributes that you use to filter for a specific subset of resource shares.
     */
    public final Filter filter() {
        return filter;
    }

    /**
     * <p>
     * Next token returned in the response of a previous ListReadSetUploadPartsRequest call. Used to get the next page
     * of results.
     * </p>
     * 
     * @return Next token returned in the response of a previous ListReadSetUploadPartsRequest call. Used to get the
     *         next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of shares to return in one page of results.
     * </p>
     * 
     * @return The maximum number of shares to return in one page of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceOwnerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSharesRequest)) {
            return false;
        }
        ListSharesRequest other = (ListSharesRequest) obj;
        return Objects.equals(resourceOwnerAsString(), other.resourceOwnerAsString()) && Objects.equals(filter(), other.filter())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSharesRequest").add("ResourceOwner", resourceOwnerAsString()).add("Filter", filter())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceOwner":
            return Optional.ofNullable(clazz.cast(resourceOwnerAsString()));
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourceOwner", RESOURCE_OWNER_FIELD);
        map.put("filter", FILTER_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSharesRequest, T> g) {
        return obj -> g.apply((ListSharesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListSharesRequest> {
        /**
         * <p>
         * The account that owns the resource shares.
         * </p>
         * 
         * @param resourceOwner
         *        The account that owns the resource shares.
         * @see ResourceOwner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceOwner
         */
        Builder resourceOwner(String resourceOwner);

        /**
         * <p>
         * The account that owns the resource shares.
         * </p>
         * 
         * @param resourceOwner
         *        The account that owns the resource shares.
         * @see ResourceOwner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceOwner
         */
        Builder resourceOwner(ResourceOwner resourceOwner);

        /**
         * <p>
         * Attributes that you use to filter for a specific subset of resource shares.
         * </p>
         * 
         * @param filter
         *        Attributes that you use to filter for a specific subset of resource shares.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Filter filter);

        /**
         * <p>
         * Attributes that you use to filter for a specific subset of resource shares.
         * </p>
         * This is a convenience method that creates an instance of the {@link Filter.Builder} avoiding the need to
         * create one manually via {@link Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Filter.Builder#build()} is called immediately and its result is
         * passed to {@link #filter(Filter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(Filter)
         */
        default Builder filter(Consumer<Filter.Builder> filter) {
            return filter(Filter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * Next token returned in the response of a previous ListReadSetUploadPartsRequest call. Used to get the next
         * page of results.
         * </p>
         * 
         * @param nextToken
         *        Next token returned in the response of a previous ListReadSetUploadPartsRequest call. Used to get the
         *        next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of shares to return in one page of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of shares to return in one page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private String resourceOwner;

        private Filter filter;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSharesRequest model) {
            super(model);
            resourceOwner(model.resourceOwner);
            filter(model.filter);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getResourceOwner() {
            return resourceOwner;
        }

        public final void setResourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
        }

        @Override
        public final Builder resourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
            return this;
        }

        @Override
        public final Builder resourceOwner(ResourceOwner resourceOwner) {
            this.resourceOwner(resourceOwner == null ? null : resourceOwner.toString());
            return this;
        }

        public final Filter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(Filter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(Filter filter) {
            this.filter = filter;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSharesRequest build() {
            return new ListSharesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
