/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutS3AccessPolicyResponse extends OmicsResponse implements
        ToCopyableBuilder<PutS3AccessPolicyResponse.Builder, PutS3AccessPolicyResponse> {
    private static final SdkField<String> S3_ACCESS_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3AccessPointArn").getter(getter(PutS3AccessPolicyResponse::s3AccessPointArn))
            .setter(setter(Builder::s3AccessPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3AccessPointArn").build()).build();

    private static final SdkField<String> STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storeId").getter(getter(PutS3AccessPolicyResponse::storeId)).setter(setter(Builder::storeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeId").build()).build();

    private static final SdkField<String> STORE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storeType").getter(getter(PutS3AccessPolicyResponse::storeTypeAsString))
            .setter(setter(Builder::storeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_ACCESS_POINT_ARN_FIELD,
            STORE_ID_FIELD, STORE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String s3AccessPointArn;

    private final String storeId;

    private final String storeType;

    private PutS3AccessPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.s3AccessPointArn = builder.s3AccessPointArn;
        this.storeId = builder.storeId;
        this.storeType = builder.storeType;
    }

    /**
     * <p>
     * The S3 access point ARN that now has the access policy.
     * </p>
     * 
     * @return The S3 access point ARN that now has the access policy.
     */
    public final String s3AccessPointArn() {
        return s3AccessPointArn;
    }

    /**
     * <p>
     * The AWS-generated Sequence Store or Reference Store ID.
     * </p>
     * 
     * @return The AWS-generated Sequence Store or Reference Store ID.
     */
    public final String storeId() {
        return storeId;
    }

    /**
     * <p>
     * The type of store associated with the access point.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storeType} will
     * return {@link StoreType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storeTypeAsString}.
     * </p>
     * 
     * @return The type of store associated with the access point.
     * @see StoreType
     */
    public final StoreType storeType() {
        return StoreType.fromValue(storeType);
    }

    /**
     * <p>
     * The type of store associated with the access point.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storeType} will
     * return {@link StoreType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storeTypeAsString}.
     * </p>
     * 
     * @return The type of store associated with the access point.
     * @see StoreType
     */
    public final String storeTypeAsString() {
        return storeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(s3AccessPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(storeId());
        hashCode = 31 * hashCode + Objects.hashCode(storeTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutS3AccessPolicyResponse)) {
            return false;
        }
        PutS3AccessPolicyResponse other = (PutS3AccessPolicyResponse) obj;
        return Objects.equals(s3AccessPointArn(), other.s3AccessPointArn()) && Objects.equals(storeId(), other.storeId())
                && Objects.equals(storeTypeAsString(), other.storeTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutS3AccessPolicyResponse").add("S3AccessPointArn", s3AccessPointArn())
                .add("StoreId", storeId()).add("StoreType", storeTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3AccessPointArn":
            return Optional.ofNullable(clazz.cast(s3AccessPointArn()));
        case "storeId":
            return Optional.ofNullable(clazz.cast(storeId()));
        case "storeType":
            return Optional.ofNullable(clazz.cast(storeTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("s3AccessPointArn", S3_ACCESS_POINT_ARN_FIELD);
        map.put("storeId", STORE_ID_FIELD);
        map.put("storeType", STORE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutS3AccessPolicyResponse, T> g) {
        return obj -> g.apply((PutS3AccessPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutS3AccessPolicyResponse> {
        /**
         * <p>
         * The S3 access point ARN that now has the access policy.
         * </p>
         * 
         * @param s3AccessPointArn
         *        The S3 access point ARN that now has the access policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3AccessPointArn(String s3AccessPointArn);

        /**
         * <p>
         * The AWS-generated Sequence Store or Reference Store ID.
         * </p>
         * 
         * @param storeId
         *        The AWS-generated Sequence Store or Reference Store ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storeId(String storeId);

        /**
         * <p>
         * The type of store associated with the access point.
         * </p>
         * 
         * @param storeType
         *        The type of store associated with the access point.
         * @see StoreType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StoreType
         */
        Builder storeType(String storeType);

        /**
         * <p>
         * The type of store associated with the access point.
         * </p>
         * 
         * @param storeType
         *        The type of store associated with the access point.
         * @see StoreType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StoreType
         */
        Builder storeType(StoreType storeType);
    }

    static final class BuilderImpl extends OmicsResponse.BuilderImpl implements Builder {
        private String s3AccessPointArn;

        private String storeId;

        private String storeType;

        private BuilderImpl() {
        }

        private BuilderImpl(PutS3AccessPolicyResponse model) {
            super(model);
            s3AccessPointArn(model.s3AccessPointArn);
            storeId(model.storeId);
            storeType(model.storeType);
        }

        public final String getS3AccessPointArn() {
            return s3AccessPointArn;
        }

        public final void setS3AccessPointArn(String s3AccessPointArn) {
            this.s3AccessPointArn = s3AccessPointArn;
        }

        @Override
        public final Builder s3AccessPointArn(String s3AccessPointArn) {
            this.s3AccessPointArn = s3AccessPointArn;
            return this;
        }

        public final String getStoreId() {
            return storeId;
        }

        public final void setStoreId(String storeId) {
            this.storeId = storeId;
        }

        @Override
        public final Builder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public final String getStoreType() {
            return storeType;
        }

        public final void setStoreType(String storeType) {
            this.storeType = storeType;
        }

        @Override
        public final Builder storeType(String storeType) {
            this.storeType = storeType;
            return this;
        }

        @Override
        public final Builder storeType(StoreType storeType) {
            this.storeType(storeType == null ? null : storeType.toString());
            return this;
        }

        @Override
        public PutS3AccessPolicyResponse build() {
            return new PutS3AccessPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
