/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Read options for an annotation import job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReadOptions implements SdkPojo, Serializable, ToCopyableBuilder<ReadOptions.Builder, ReadOptions> {
    private static final SdkField<String> SEP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sep")
            .getter(getter(ReadOptions::sep)).setter(setter(Builder::sep))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sep").build()).build();

    private static final SdkField<String> ENCODING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("encoding").getter(getter(ReadOptions::encoding)).setter(setter(Builder::encoding))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encoding").build()).build();

    private static final SdkField<String> QUOTE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("quote")
            .getter(getter(ReadOptions::quote)).setter(setter(Builder::quote))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quote").build()).build();

    private static final SdkField<Boolean> QUOTE_ALL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("quoteAll").getter(getter(ReadOptions::quoteAll)).setter(setter(Builder::quoteAll))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quoteAll").build()).build();

    private static final SdkField<String> ESCAPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("escape")
            .getter(getter(ReadOptions::escape)).setter(setter(Builder::escape))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("escape").build()).build();

    private static final SdkField<Boolean> ESCAPE_QUOTES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("escapeQuotes").getter(getter(ReadOptions::escapeQuotes)).setter(setter(Builder::escapeQuotes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("escapeQuotes").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("comment")
            .getter(getter(ReadOptions::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final SdkField<Boolean> HEADER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("header").getter(getter(ReadOptions::header)).setter(setter(Builder::header))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("header").build()).build();

    private static final SdkField<String> LINE_SEP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lineSep").getter(getter(ReadOptions::lineSep)).setter(setter(Builder::lineSep))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lineSep").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEP_FIELD, ENCODING_FIELD,
            QUOTE_FIELD, QUOTE_ALL_FIELD, ESCAPE_FIELD, ESCAPE_QUOTES_FIELD, COMMENT_FIELD, HEADER_FIELD, LINE_SEP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sep;

    private final String encoding;

    private final String quote;

    private final Boolean quoteAll;

    private final String escape;

    private final Boolean escapeQuotes;

    private final String comment;

    private final Boolean header;

    private final String lineSep;

    private ReadOptions(BuilderImpl builder) {
        this.sep = builder.sep;
        this.encoding = builder.encoding;
        this.quote = builder.quote;
        this.quoteAll = builder.quoteAll;
        this.escape = builder.escape;
        this.escapeQuotes = builder.escapeQuotes;
        this.comment = builder.comment;
        this.header = builder.header;
        this.lineSep = builder.lineSep;
    }

    /**
     * <p>
     * The file's field separator.
     * </p>
     * 
     * @return The file's field separator.
     */
    public final String sep() {
        return sep;
    }

    /**
     * <p>
     * The file's encoding.
     * </p>
     * 
     * @return The file's encoding.
     */
    public final String encoding() {
        return encoding;
    }

    /**
     * <p>
     * The file's quote character.
     * </p>
     * 
     * @return The file's quote character.
     */
    public final String quote() {
        return quote;
    }

    /**
     * <p>
     * Whether all values need to be quoted, or just those that contain quotes.
     * </p>
     * 
     * @return Whether all values need to be quoted, or just those that contain quotes.
     */
    public final Boolean quoteAll() {
        return quoteAll;
    }

    /**
     * <p>
     * A character for escaping quotes in the file.
     * </p>
     * 
     * @return A character for escaping quotes in the file.
     */
    public final String escape() {
        return escape;
    }

    /**
     * <p>
     * Whether quotes need to be escaped in the file.
     * </p>
     * 
     * @return Whether quotes need to be escaped in the file.
     */
    public final Boolean escapeQuotes() {
        return escapeQuotes;
    }

    /**
     * <p>
     * The file's comment character.
     * </p>
     * 
     * @return The file's comment character.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * Whether the file has a header row.
     * </p>
     * 
     * @return Whether the file has a header row.
     */
    public final Boolean header() {
        return header;
    }

    /**
     * <p>
     * A line separator for the file.
     * </p>
     * 
     * @return A line separator for the file.
     */
    public final String lineSep() {
        return lineSep;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sep());
        hashCode = 31 * hashCode + Objects.hashCode(encoding());
        hashCode = 31 * hashCode + Objects.hashCode(quote());
        hashCode = 31 * hashCode + Objects.hashCode(quoteAll());
        hashCode = 31 * hashCode + Objects.hashCode(escape());
        hashCode = 31 * hashCode + Objects.hashCode(escapeQuotes());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(header());
        hashCode = 31 * hashCode + Objects.hashCode(lineSep());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReadOptions)) {
            return false;
        }
        ReadOptions other = (ReadOptions) obj;
        return Objects.equals(sep(), other.sep()) && Objects.equals(encoding(), other.encoding())
                && Objects.equals(quote(), other.quote()) && Objects.equals(quoteAll(), other.quoteAll())
                && Objects.equals(escape(), other.escape()) && Objects.equals(escapeQuotes(), other.escapeQuotes())
                && Objects.equals(comment(), other.comment()) && Objects.equals(header(), other.header())
                && Objects.equals(lineSep(), other.lineSep());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReadOptions").add("Sep", sep()).add("Encoding", encoding()).add("Quote", quote())
                .add("QuoteAll", quoteAll()).add("Escape", escape()).add("EscapeQuotes", escapeQuotes())
                .add("Comment", comment()).add("Header", header()).add("LineSep", lineSep()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sep":
            return Optional.ofNullable(clazz.cast(sep()));
        case "encoding":
            return Optional.ofNullable(clazz.cast(encoding()));
        case "quote":
            return Optional.ofNullable(clazz.cast(quote()));
        case "quoteAll":
            return Optional.ofNullable(clazz.cast(quoteAll()));
        case "escape":
            return Optional.ofNullable(clazz.cast(escape()));
        case "escapeQuotes":
            return Optional.ofNullable(clazz.cast(escapeQuotes()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "header":
            return Optional.ofNullable(clazz.cast(header()));
        case "lineSep":
            return Optional.ofNullable(clazz.cast(lineSep()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sep", SEP_FIELD);
        map.put("encoding", ENCODING_FIELD);
        map.put("quote", QUOTE_FIELD);
        map.put("quoteAll", QUOTE_ALL_FIELD);
        map.put("escape", ESCAPE_FIELD);
        map.put("escapeQuotes", ESCAPE_QUOTES_FIELD);
        map.put("comment", COMMENT_FIELD);
        map.put("header", HEADER_FIELD);
        map.put("lineSep", LINE_SEP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReadOptions, T> g) {
        return obj -> g.apply((ReadOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReadOptions> {
        /**
         * <p>
         * The file's field separator.
         * </p>
         * 
         * @param sep
         *        The file's field separator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sep(String sep);

        /**
         * <p>
         * The file's encoding.
         * </p>
         * 
         * @param encoding
         *        The file's encoding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encoding(String encoding);

        /**
         * <p>
         * The file's quote character.
         * </p>
         * 
         * @param quote
         *        The file's quote character.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quote(String quote);

        /**
         * <p>
         * Whether all values need to be quoted, or just those that contain quotes.
         * </p>
         * 
         * @param quoteAll
         *        Whether all values need to be quoted, or just those that contain quotes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quoteAll(Boolean quoteAll);

        /**
         * <p>
         * A character for escaping quotes in the file.
         * </p>
         * 
         * @param escape
         *        A character for escaping quotes in the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder escape(String escape);

        /**
         * <p>
         * Whether quotes need to be escaped in the file.
         * </p>
         * 
         * @param escapeQuotes
         *        Whether quotes need to be escaped in the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder escapeQuotes(Boolean escapeQuotes);

        /**
         * <p>
         * The file's comment character.
         * </p>
         * 
         * @param comment
         *        The file's comment character.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * Whether the file has a header row.
         * </p>
         * 
         * @param header
         *        Whether the file has a header row.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder header(Boolean header);

        /**
         * <p>
         * A line separator for the file.
         * </p>
         * 
         * @param lineSep
         *        A line separator for the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineSep(String lineSep);
    }

    static final class BuilderImpl implements Builder {
        private String sep;

        private String encoding;

        private String quote;

        private Boolean quoteAll;

        private String escape;

        private Boolean escapeQuotes;

        private String comment;

        private Boolean header;

        private String lineSep;

        private BuilderImpl() {
        }

        private BuilderImpl(ReadOptions model) {
            sep(model.sep);
            encoding(model.encoding);
            quote(model.quote);
            quoteAll(model.quoteAll);
            escape(model.escape);
            escapeQuotes(model.escapeQuotes);
            comment(model.comment);
            header(model.header);
            lineSep(model.lineSep);
        }

        public final String getSep() {
            return sep;
        }

        public final void setSep(String sep) {
            this.sep = sep;
        }

        @Override
        public final Builder sep(String sep) {
            this.sep = sep;
            return this;
        }

        public final String getEncoding() {
            return encoding;
        }

        public final void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        @Override
        public final Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public final String getQuote() {
            return quote;
        }

        public final void setQuote(String quote) {
            this.quote = quote;
        }

        @Override
        public final Builder quote(String quote) {
            this.quote = quote;
            return this;
        }

        public final Boolean getQuoteAll() {
            return quoteAll;
        }

        public final void setQuoteAll(Boolean quoteAll) {
            this.quoteAll = quoteAll;
        }

        @Override
        public final Builder quoteAll(Boolean quoteAll) {
            this.quoteAll = quoteAll;
            return this;
        }

        public final String getEscape() {
            return escape;
        }

        public final void setEscape(String escape) {
            this.escape = escape;
        }

        @Override
        public final Builder escape(String escape) {
            this.escape = escape;
            return this;
        }

        public final Boolean getEscapeQuotes() {
            return escapeQuotes;
        }

        public final void setEscapeQuotes(Boolean escapeQuotes) {
            this.escapeQuotes = escapeQuotes;
        }

        @Override
        public final Builder escapeQuotes(Boolean escapeQuotes) {
            this.escapeQuotes = escapeQuotes;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final Boolean getHeader() {
            return header;
        }

        public final void setHeader(Boolean header) {
            this.header = header;
        }

        @Override
        public final Builder header(Boolean header) {
            this.header = header;
            return this;
        }

        public final String getLineSep() {
            return lineSep;
        }

        public final void setLineSep(String lineSep) {
            this.lineSep = lineSep;
        }

        @Override
        public final Builder lineSep(String lineSep) {
            this.lineSep = lineSep;
            return this;
        }

        @Override
        public ReadOptions build() {
            return new ReadOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
