/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of genome reference files.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReferenceFiles implements SdkPojo, Serializable, ToCopyableBuilder<ReferenceFiles.Builder, ReferenceFiles> {
    private static final SdkField<FileInformation> SOURCE_FIELD = SdkField.<FileInformation> builder(MarshallingType.SDK_POJO)
            .memberName("source").getter(getter(ReferenceFiles::source)).setter(setter(Builder::source))
            .constructor(FileInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<FileInformation> INDEX_FIELD = SdkField.<FileInformation> builder(MarshallingType.SDK_POJO)
            .memberName("index").getter(getter(ReferenceFiles::index)).setter(setter(Builder::index))
            .constructor(FileInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("index").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, INDEX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FileInformation source;

    private final FileInformation index;

    private ReferenceFiles(BuilderImpl builder) {
        this.source = builder.source;
        this.index = builder.index;
    }

    /**
     * <p>
     * The source file's location in Amazon S3.
     * </p>
     * 
     * @return The source file's location in Amazon S3.
     */
    public final FileInformation source() {
        return source;
    }

    /**
     * <p>
     * The files' index.
     * </p>
     * 
     * @return The files' index.
     */
    public final FileInformation index() {
        return index;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(index());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceFiles)) {
            return false;
        }
        ReferenceFiles other = (ReferenceFiles) obj;
        return Objects.equals(source(), other.source()) && Objects.equals(index(), other.index());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReferenceFiles").add("Source", source()).add("Index", index()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "index":
            return Optional.ofNullable(clazz.cast(index()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("source", SOURCE_FIELD);
        map.put("index", INDEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReferenceFiles, T> g) {
        return obj -> g.apply((ReferenceFiles) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReferenceFiles> {
        /**
         * <p>
         * The source file's location in Amazon S3.
         * </p>
         * 
         * @param source
         *        The source file's location in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(FileInformation source);

        /**
         * <p>
         * The source file's location in Amazon S3.
         * </p>
         * This is a convenience method that creates an instance of the {@link FileInformation.Builder} avoiding the
         * need to create one manually via {@link FileInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FileInformation.Builder#build()} is called immediately and its
         * result is passed to {@link #source(FileInformation)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link FileInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(FileInformation)
         */
        default Builder source(Consumer<FileInformation.Builder> source) {
            return source(FileInformation.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The files' index.
         * </p>
         * 
         * @param index
         *        The files' index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder index(FileInformation index);

        /**
         * <p>
         * The files' index.
         * </p>
         * This is a convenience method that creates an instance of the {@link FileInformation.Builder} avoiding the
         * need to create one manually via {@link FileInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FileInformation.Builder#build()} is called immediately and its
         * result is passed to {@link #index(FileInformation)}.
         * 
         * @param index
         *        a consumer that will call methods on {@link FileInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #index(FileInformation)
         */
        default Builder index(Consumer<FileInformation.Builder> index) {
            return index(FileInformation.builder().applyMutation(index).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FileInformation source;

        private FileInformation index;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceFiles model) {
            source(model.source);
            index(model.index);
        }

        public final FileInformation.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(FileInformation.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(FileInformation source) {
            this.source = source;
            return this;
        }

        public final FileInformation.Builder getIndex() {
            return index != null ? index.toBuilder() : null;
        }

        public final void setIndex(FileInformation.BuilderImpl index) {
            this.index = index != null ? index.build() : null;
        }

        @Override
        public final Builder index(FileInformation index) {
            this.index = index;
            return this;
        }

        @Override
        public ReferenceFiles build() {
            return new ReferenceFiles(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
