/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter for references.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReferenceFilter implements SdkPojo, Serializable, ToCopyableBuilder<ReferenceFilter.Builder, ReferenceFilter> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ReferenceFilter::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> MD5_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("md5")
            .getter(getter(ReferenceFilter::md5)).setter(setter(Builder::md5))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("md5").build()).build();

    private static final SdkField<Instant> CREATED_AFTER_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAfter")
            .getter(getter(ReferenceFilter::createdAfter))
            .setter(setter(Builder::createdAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAfter").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> CREATED_BEFORE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdBefore")
            .getter(getter(ReferenceFilter::createdBefore))
            .setter(setter(Builder::createdBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBefore").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MD5_FIELD,
            CREATED_AFTER_FIELD, CREATED_BEFORE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String md5;

    private final Instant createdAfter;

    private final Instant createdBefore;

    private ReferenceFilter(BuilderImpl builder) {
        this.name = builder.name;
        this.md5 = builder.md5;
        this.createdAfter = builder.createdAfter;
        this.createdBefore = builder.createdBefore;
    }

    /**
     * <p>
     * A name to filter on.
     * </p>
     * 
     * @return A name to filter on.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * An MD5 checksum to filter on.
     * </p>
     * 
     * @return An MD5 checksum to filter on.
     */
    public final String md5() {
        return md5;
    }

    /**
     * <p>
     * The filter's start date.
     * </p>
     * 
     * @return The filter's start date.
     */
    public final Instant createdAfter() {
        return createdAfter;
    }

    /**
     * <p>
     * The filter's end date.
     * </p>
     * 
     * @return The filter's end date.
     */
    public final Instant createdBefore() {
        return createdBefore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(md5());
        hashCode = 31 * hashCode + Objects.hashCode(createdAfter());
        hashCode = 31 * hashCode + Objects.hashCode(createdBefore());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceFilter)) {
            return false;
        }
        ReferenceFilter other = (ReferenceFilter) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(md5(), other.md5())
                && Objects.equals(createdAfter(), other.createdAfter()) && Objects.equals(createdBefore(), other.createdBefore());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReferenceFilter").add("Name", name()).add("Md5", md5()).add("CreatedAfter", createdAfter())
                .add("CreatedBefore", createdBefore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "md5":
            return Optional.ofNullable(clazz.cast(md5()));
        case "createdAfter":
            return Optional.ofNullable(clazz.cast(createdAfter()));
        case "createdBefore":
            return Optional.ofNullable(clazz.cast(createdBefore()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("md5", MD5_FIELD);
        map.put("createdAfter", CREATED_AFTER_FIELD);
        map.put("createdBefore", CREATED_BEFORE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReferenceFilter, T> g) {
        return obj -> g.apply((ReferenceFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReferenceFilter> {
        /**
         * <p>
         * A name to filter on.
         * </p>
         * 
         * @param name
         *        A name to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An MD5 checksum to filter on.
         * </p>
         * 
         * @param md5
         *        An MD5 checksum to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder md5(String md5);

        /**
         * <p>
         * The filter's start date.
         * </p>
         * 
         * @param createdAfter
         *        The filter's start date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAfter(Instant createdAfter);

        /**
         * <p>
         * The filter's end date.
         * </p>
         * 
         * @param createdBefore
         *        The filter's end date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBefore(Instant createdBefore);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String md5;

        private Instant createdAfter;

        private Instant createdBefore;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceFilter model) {
            name(model.name);
            md5(model.md5);
            createdAfter(model.createdAfter);
            createdBefore(model.createdBefore);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getMd5() {
            return md5;
        }

        public final void setMd5(String md5) {
            this.md5 = md5;
        }

        @Override
        public final Builder md5(String md5) {
            this.md5 = md5;
            return this;
        }

        public final Instant getCreatedAfter() {
            return createdAfter;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public final Instant getCreatedBefore() {
            return createdBefore;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        @Override
        public ReferenceFilter build() {
            return new ReferenceFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
