/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * List entry for one run cache.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RunCacheListItem implements SdkPojo, Serializable,
        ToCopyableBuilder<RunCacheListItem.Builder, RunCacheListItem> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(RunCacheListItem::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CACHE_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cacheBehavior").getter(getter(RunCacheListItem::cacheBehaviorAsString))
            .setter(setter(Builder::cacheBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheBehavior").build()).build();

    private static final SdkField<String> CACHE_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cacheS3Uri").getter(getter(RunCacheListItem::cacheS3Uri)).setter(setter(Builder::cacheS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheS3Uri").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(RunCacheListItem::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(RunCacheListItem::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(RunCacheListItem::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(RunCacheListItem::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CACHE_BEHAVIOR_FIELD, CACHE_S3_URI_FIELD, CREATION_TIME_FIELD, ID_FIELD, NAME_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String cacheBehavior;

    private final String cacheS3Uri;

    private final Instant creationTime;

    private final String id;

    private final String name;

    private final String status;

    private RunCacheListItem(BuilderImpl builder) {
        this.arn = builder.arn;
        this.cacheBehavior = builder.cacheBehavior;
        this.cacheS3Uri = builder.cacheS3Uri;
        this.creationTime = builder.creationTime;
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
    }

    /**
     * <p>
     * Unique resource identifier for the run cache.
     * </p>
     * 
     * @return Unique resource identifier for the run cache.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Default cache behavior for the run cache.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cacheBehavior}
     * will return {@link CacheBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #cacheBehaviorAsString}.
     * </p>
     * 
     * @return Default cache behavior for the run cache.
     * @see CacheBehavior
     */
    public final CacheBehavior cacheBehavior() {
        return CacheBehavior.fromValue(cacheBehavior);
    }

    /**
     * <p>
     * Default cache behavior for the run cache.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cacheBehavior}
     * will return {@link CacheBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #cacheBehaviorAsString}.
     * </p>
     * 
     * @return Default cache behavior for the run cache.
     * @see CacheBehavior
     */
    public final String cacheBehaviorAsString() {
        return cacheBehavior;
    }

    /**
     * <p>
     * The S3 uri for the run cache data.
     * </p>
     * 
     * @return The S3 uri for the run cache data.
     */
    public final String cacheS3Uri() {
        return cacheS3Uri;
    }

    /**
     * <p>
     * The time that this run cache was created (an ISO 8601 formatted string).
     * </p>
     * 
     * @return The time that this run cache was created (an ISO 8601 formatted string).
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The identifier for this run cache.
     * </p>
     * 
     * @return The identifier for this run cache.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the run cache.
     * </p>
     * 
     * @return The name of the run cache.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The run cache status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RunCacheStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The run cache status.
     * @see RunCacheStatus
     */
    public final RunCacheStatus status() {
        return RunCacheStatus.fromValue(status);
    }

    /**
     * <p>
     * The run cache status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RunCacheStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The run cache status.
     * @see RunCacheStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(cacheBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cacheS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunCacheListItem)) {
            return false;
        }
        RunCacheListItem other = (RunCacheListItem) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(cacheBehaviorAsString(), other.cacheBehaviorAsString())
                && Objects.equals(cacheS3Uri(), other.cacheS3Uri()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RunCacheListItem").add("Arn", arn()).add("CacheBehavior", cacheBehaviorAsString())
                .add("CacheS3Uri", cacheS3Uri()).add("CreationTime", creationTime()).add("Id", id()).add("Name", name())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "cacheBehavior":
            return Optional.ofNullable(clazz.cast(cacheBehaviorAsString()));
        case "cacheS3Uri":
            return Optional.ofNullable(clazz.cast(cacheS3Uri()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("cacheBehavior", CACHE_BEHAVIOR_FIELD);
        map.put("cacheS3Uri", CACHE_S3_URI_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RunCacheListItem, T> g) {
        return obj -> g.apply((RunCacheListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RunCacheListItem> {
        /**
         * <p>
         * Unique resource identifier for the run cache.
         * </p>
         * 
         * @param arn
         *        Unique resource identifier for the run cache.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Default cache behavior for the run cache.
         * </p>
         * 
         * @param cacheBehavior
         *        Default cache behavior for the run cache.
         * @see CacheBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CacheBehavior
         */
        Builder cacheBehavior(String cacheBehavior);

        /**
         * <p>
         * Default cache behavior for the run cache.
         * </p>
         * 
         * @param cacheBehavior
         *        Default cache behavior for the run cache.
         * @see CacheBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CacheBehavior
         */
        Builder cacheBehavior(CacheBehavior cacheBehavior);

        /**
         * <p>
         * The S3 uri for the run cache data.
         * </p>
         * 
         * @param cacheS3Uri
         *        The S3 uri for the run cache data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheS3Uri(String cacheS3Uri);

        /**
         * <p>
         * The time that this run cache was created (an ISO 8601 formatted string).
         * </p>
         * 
         * @param creationTime
         *        The time that this run cache was created (an ISO 8601 formatted string).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The identifier for this run cache.
         * </p>
         * 
         * @param id
         *        The identifier for this run cache.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the run cache.
         * </p>
         * 
         * @param name
         *        The name of the run cache.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The run cache status.
         * </p>
         * 
         * @param status
         *        The run cache status.
         * @see RunCacheStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunCacheStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The run cache status.
         * </p>
         * 
         * @param status
         *        The run cache status.
         * @see RunCacheStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunCacheStatus
         */
        Builder status(RunCacheStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String cacheBehavior;

        private String cacheS3Uri;

        private Instant creationTime;

        private String id;

        private String name;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(RunCacheListItem model) {
            arn(model.arn);
            cacheBehavior(model.cacheBehavior);
            cacheS3Uri(model.cacheS3Uri);
            creationTime(model.creationTime);
            id(model.id);
            name(model.name);
            status(model.status);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCacheBehavior() {
            return cacheBehavior;
        }

        public final void setCacheBehavior(String cacheBehavior) {
            this.cacheBehavior = cacheBehavior;
        }

        @Override
        public final Builder cacheBehavior(String cacheBehavior) {
            this.cacheBehavior = cacheBehavior;
            return this;
        }

        @Override
        public final Builder cacheBehavior(CacheBehavior cacheBehavior) {
            this.cacheBehavior(cacheBehavior == null ? null : cacheBehavior.toString());
            return this;
        }

        public final String getCacheS3Uri() {
            return cacheS3Uri;
        }

        public final void setCacheS3Uri(String cacheS3Uri) {
            this.cacheS3Uri = cacheS3Uri;
        }

        @Override
        public final Builder cacheS3Uri(String cacheS3Uri) {
            this.cacheS3Uri = cacheS3Uri;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RunCacheStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public RunCacheListItem build() {
            return new RunCacheListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
